/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.AddAnnotationFix;
import org.jetbrains.kotlin.idea.quickfix.OptInFixesKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgumentList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OptInFixes;", "", "<init>", "()V", "UseOptInAnnotationFix", "ModifyOptInAnnotationFix", "PropagateOptInAnnotationFix", "kotlin.fir.frontend-independent"})
public final class OptInFixes {

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OptInFixes$ModifyOptInAnnotationFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "element", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "argumentClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "priority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/codeInsight/intention/PriorityAction$Priority;)V", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "getFamilyName", "", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.fir.frontend-independent"})
    public static final class ModifyOptInAnnotationFix
    extends PsiUpdateModCommandAction<KtAnnotationEntry> {
        @NotNull
        private final AddAnnotationFix.Kind kind;
        @NotNull
        private final FqName argumentClassFqName;
        @NotNull
        private final PriorityAction.Priority priority;

        public ModifyOptInAnnotationFix(@NotNull KtAnnotationEntry element, @NotNull AddAnnotationFix.Kind kind2, @NotNull FqName argumentClassFqName, @NotNull PriorityAction.Priority priority) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)argumentClassFqName, (String)"argumentClassFqName");
            Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
            super((PsiElement)element);
            this.kind = kind2;
            this.argumentClassFqName = argumentClassFqName;
            this.priority = priority;
        }

        @NotNull
        public Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtAnnotationEntry element) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Presentation presentation = OptInFixesKt.access$getOptInAnnotationFixPresentation((KtElement)element, this.kind, this.argumentClassFqName).withPriority(this.priority);
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"withPriority(...)");
            return presentation;
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"fix.opt_in.annotation.family", (Object[])new Object[0]);
        }

        protected void invoke(@NotNull ActionContext context2, @NotNull KtAnnotationEntry element, @NotNull ModPsiUpdater updater2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            String annotationInnerText = OptInFixesKt.access$asClassLiteral(this.argumentClassFqName);
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            KtValueArgumentList ktValueArgumentList = element.getValueArgumentList();
            PsiElement psiElement = ktValueArgumentList != null && (ktValueArgumentList = ktValueArgumentList.addArgument(psiFactory.createArgument(annotationInnerText))) != null ? (PsiElement)ktValueArgumentList : element.addAfter((PsiElement)psiFactory.createCallArguments("(" + annotationInnerText + ")"), element.getLastChild());
            ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)element);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OptInFixes$PropagateOptInAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix;", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "argumentClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "priority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/codeInsight/intention/PriorityAction$Priority;)V", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getFamilyName", "", "kotlin.fir.frontend-independent"})
    public static final class PropagateOptInAnnotationFix
    extends AddAnnotationFix {
        @NotNull
        private final ClassId annotationClassId;
        @NotNull
        private final AddAnnotationFix.Kind kind;
        @Nullable
        private final FqName argumentClassFqName;
        @NotNull
        private final PriorityAction.Priority priority;

        public PropagateOptInAnnotationFix(@NotNull KtDeclaration element, @NotNull ClassId annotationClassId, @NotNull AddAnnotationFix.Kind kind2, @Nullable FqName argumentClassFqName, @NotNull PriorityAction.Priority priority) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
            Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
            FqName fqName2 = argumentClassFqName;
            super((KtElement)element, annotationClassId, AddAnnotationFix.Kind.Self.INSTANCE, fqName2 != null ? OptInFixesKt.access$asClassLiteral(fqName2) : null);
            this.annotationClassId = annotationClassId;
            this.kind = kind2;
            this.argumentClassFqName = argumentClassFqName;
            this.priority = priority;
        }

        public /* synthetic */ PropagateOptInAnnotationFix(KtDeclaration ktDeclaration, ClassId classId, AddAnnotationFix.Kind kind2, FqName fqName2, PriorityAction.Priority priority, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                fqName2 = null;
            }
            if ((n & 0x10) != 0) {
                priority = PriorityAction.Priority.NORMAL;
            }
            this(ktDeclaration, classId, kind2, fqName2, priority);
        }

        @Override
        @NotNull
        protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtElement element) {
            String string;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String string2 = this.annotationClassId.getShortClassName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            String annotationName = string2;
            String annotationEntry2 = this.argumentClassFqName != null ? "(" + this.argumentClassFqName.shortName().asString() + "::class)" : "";
            String argumentText = annotationName + annotationEntry2;
            if (this.kind instanceof AddAnnotationFix.Kind.Self) {
                var7_6 = new Object[]{argumentText, "?"};
                string = KotlinBundle.message((String)"fix.opt_in.text.propagate.declaration", (Object[])var7_6);
            } else if (this.kind instanceof AddAnnotationFix.Kind.Constructor) {
                var7_6 = new Object[]{argumentText};
                string = KotlinBundle.message((String)"fix.opt_in.text.propagate.constructor", (Object[])var7_6);
            } else if (this.kind instanceof AddAnnotationFix.Kind.Declaration) {
                var7_6 = new Object[2];
                var7_6[0] = argumentText;
                String string3 = ((AddAnnotationFix.Kind.Declaration)this.kind).getName();
                if (string3 == null) {
                    string3 = "?";
                }
                var7_6[1] = string3;
                string = KotlinBundle.message((String)"fix.opt_in.text.propagate.declaration", (Object[])var7_6);
            } else if (this.kind instanceof AddAnnotationFix.Kind.ContainingClass && element instanceof KtObjectDeclaration) {
                var7_6 = new Object[2];
                var7_6[0] = argumentText;
                String string4 = ((AddAnnotationFix.Kind.ContainingClass)this.kind).getName();
                if (string4 == null) {
                    string4 = "?";
                }
                var7_6[1] = string4;
                string = KotlinBundle.message((String)"fix.opt_in.text.propagate.containing.object", (Object[])var7_6);
            } else if (this.kind instanceof AddAnnotationFix.Kind.ContainingClass) {
                var7_6 = new Object[2];
                var7_6[0] = argumentText;
                String string5 = ((AddAnnotationFix.Kind.ContainingClass)this.kind).getName();
                if (string5 == null) {
                    string5 = "?";
                }
                var7_6[1] = string5;
                string = KotlinBundle.message((String)"fix.opt_in.text.propagate.containing.class", (Object[])var7_6);
            } else {
                throw new IllegalStateException("Unexpected kind type".toString());
            }
            String actionName = string;
            Presentation presentation = Presentation.of((String)actionName).withPriority(this.priority);
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"withPriority(...)");
            return presentation;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"fix.opt_in.annotation.family", (Object[])new Object[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OptInFixes$UseOptInAnnotationFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "optInClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;", "argumentClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "priority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationFix$Kind;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/codeInsight/intention/PriorityAction$Priority;)V", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "getFamilyName", "", "kotlin.fir.frontend-independent"})
    public static final class UseOptInAnnotationFix
    extends AddAnnotationFix {
        @NotNull
        private final ClassId optInClassId;
        @NotNull
        private final AddAnnotationFix.Kind kind;
        @NotNull
        private final FqName argumentClassFqName;
        @NotNull
        private final PriorityAction.Priority priority;

        public UseOptInAnnotationFix(@NotNull KtElement element, @NotNull ClassId optInClassId, @NotNull AddAnnotationFix.Kind kind2, @NotNull FqName argumentClassFqName, @NotNull PriorityAction.Priority priority) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)optInClassId, (String)"optInClassId");
            Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)argumentClassFqName, (String)"argumentClassFqName");
            Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
            super(element, optInClassId, AddAnnotationFix.Kind.Self.INSTANCE, OptInFixesKt.access$asClassLiteral(argumentClassFqName));
            this.optInClassId = optInClassId;
            this.kind = kind2;
            this.argumentClassFqName = argumentClassFqName;
            this.priority = priority;
        }

        @Override
        @NotNull
        public Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtElement element) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Presentation presentation = OptInFixesKt.access$getOptInAnnotationFixPresentation(element, this.kind, this.argumentClassFqName).withPriority(this.priority);
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"withPriority(...)");
            return presentation;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"fix.opt_in.annotation.family", (Object[])new Object[0]);
        }
    }
}

