/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.hints;

import com.intellij.codeInsight.codeVision.CodeVisionRelativeOrdering;
import com.intellij.codeInsight.hints.codeVision.CodeVisionProviderBase;
import com.intellij.codeInsight.hints.codeVision.RenameAwareReferencesCodeVisionProvider;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.k2.codeinsight.hints.KotlinUsagesCountManager;
import org.jetbrains.kotlin.idea.statistics.KotlinCodeVisionUsagesCollector;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016R\u0014\u0010\u0012\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/hints/KotlinReferencesCodeVisionProvider;", "Lcom/intellij/codeInsight/hints/codeVision/RenameAwareReferencesCodeVisionProvider;", "<init>", "()V", "acceptsFile", "", "file", "Lcom/intellij/psi/PsiFile;", "acceptsElement", "element", "Lcom/intellij/psi/PsiElement;", "getVisionInfo", "Lcom/intellij/codeInsight/hints/codeVision/CodeVisionProviderBase$CodeVisionInfo;", "getHint", "", "logClickToFUS", "", "hint", "name", "getName", "()Ljava/lang/String;", "relativeOrderings", "", "Lcom/intellij/codeInsight/codeVision/CodeVisionRelativeOrdering;", "getRelativeOrderings", "()Ljava/util/List;", "id", "getId", "Companion", "intellij.kotlin.codeInsight"})
public final class KotlinReferencesCodeVisionProvider
extends RenameAwareReferencesCodeVisionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "kotlin.references";

    public boolean acceptsFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Registry.Companion.is("enable.kotlin.code.vision.inlay") && Intrinsics.areEqual((Object)file.getLanguage(), (Object)KotlinLanguage.INSTANCE);
    }

    public boolean acceptsElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof KtNamedFunction && !((KtNamedFunction)element).isLocal() || element instanceof KtProperty && !((KtProperty)element).isLocal() || element instanceof KtClassLikeDeclaration;
    }

    private final CodeVisionProviderBase.CodeVisionInfo getVisionInfo(PsiElement element, PsiFile file) {
        KtNamedDeclaration ktNamedDeclaration = element instanceof KtNamedDeclaration ? (KtNamedDeclaration)element : null;
        if (ktNamedDeclaration == null) {
            return null;
        }
        KtNamedDeclaration namedDeclaration = ktNamedDeclaration;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        int result2 = KotlinUsagesCountManager.Companion.getInstance(project).countMemberUsages(file, namedDeclaration);
        if (result2 == 0) {
            return null;
        }
        Object[] objectArray = new Object[]{result2};
        return new CodeVisionProviderBase.CodeVisionInfo(KotlinBundle.message((String)"hints.codevision.usages.format", (Object[])objectArray), Integer.valueOf(result2), false, 4, null);
    }

    @Nullable
    public String getHint(@NotNull PsiElement element, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CodeVisionProviderBase.CodeVisionInfo codeVisionInfo = this.getVisionInfo(element, file);
        return codeVisionInfo != null ? codeVisionInfo.getText() : null;
    }

    public void logClickToFUS(@NotNull PsiElement element, @NotNull String hint2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)hint2, (String)"hint");
        KotlinCodeVisionUsagesCollector.INSTANCE.logUsagesClicked(element.getProject());
    }

    @NotNull
    public String getName() {
        String string = JavaBundle.message((String)"settings.inlay.java.usages", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public List<CodeVisionRelativeOrdering> getRelativeOrderings() {
        return CollectionsKt.listOf((Object)new CodeVisionRelativeOrdering.CodeVisionRelativeOrderingBefore("kotlin.inheritors"));
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/hints/KotlinReferencesCodeVisionProvider$Companion;", "", "<init>", "()V", "ID", "", "intellij.kotlin.codeInsight"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

