/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.evaluate.MiscompiledCodeException;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledCodeFragmentData;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"nonExistentClassName", "", "checkCodeFragmentBytecode", "", "compiledData", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData;", "containsNonExistentClass", "", "classBytes", "", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nCodeFragmentBytecodeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFragmentBytecodeChecker.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/CodeFragmentBytecodeCheckerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1761#2,3:90\n*S KotlinDebug\n*F\n+ 1 CodeFragmentBytecodeChecker.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/CodeFragmentBytecodeCheckerKt\n*L\n12#1:90,3\n*E\n"})
public final class CodeFragmentBytecodeCheckerKt {
    @NotNull
    private static final String nonExistentClassName = "error/NonExistentClass";

    public static final void checkCodeFragmentBytecode(@NotNull CompiledCodeFragmentData compiledData) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)compiledData, (String)"compiledData");
            Iterable $this$any$iv = compiledData.getClasses();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClassToLoad it = (ClassToLoad)element$iv;
                    boolean bl2 = false;
                    if (!CodeFragmentBytecodeCheckerKt.containsNonExistentClass(it.getBytes())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new MiscompiledCodeException("Code fragment contains references to error/NonExistentClass");
        }
    }

    private static final boolean containsNonExistentClass(byte[] classBytes) {
        Ref.BooleanRef found = new Ref.BooleanRef();
        ClassReader reader = new ClassReader(classBytes);
        ClassVisitor visitor2 = new ClassVisitor(found){
            final /* synthetic */ Ref.BooleanRef $found;
            {
                this.$found = $found;
                super(589824);
            }

            public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                if (Intrinsics.areEqual((Object)"error/NonExistentClass", (Object)superName)) {
                    this.$found.element = true;
                }
                if (interfaces != null) {
                    for (String base : interfaces) {
                        if (!Intrinsics.areEqual((Object)"error/NonExistentClass", (Object)base)) continue;
                        this.$found.element = true;
                    }
                }
            }

            public FieldVisitor visitField(int access, String name2, String descriptor2, String signature, Object value) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                if (StringsKt.contains$default((CharSequence)descriptor2, (CharSequence)"Lerror/NonExistentClass;", (boolean)false, (int)2, null)) {
                    this.$found.element = true;
                }
                return super.visitField(access, name2, descriptor2, signature, value);
            }

            public MethodVisitor visitMethod(int access, String name2, String descriptor2, String signature, String[] exceptions) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                if (StringsKt.contains$default((CharSequence)descriptor2, (CharSequence)"Lerror/NonExistentClass;", (boolean)false, (int)2, null)) {
                    this.$found.element = true;
                }
                return new MethodVisitor(this.$found){
                    final /* synthetic */ Ref.BooleanRef $found;
                    {
                        this.$found = $found;
                        super(589824);
                    }

                    public void visitTypeInsn(int opcode, String type2) {
                        if (Intrinsics.areEqual((Object)"error/NonExistentClass", (Object)type2)) {
                            this.$found.element = true;
                        }
                    }

                    public void visitFieldInsn(int opcode, String owner, String name2, String descriptor2) {
                        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                        if (Intrinsics.areEqual((Object)"error/NonExistentClass", (Object)owner) || StringsKt.contains$default((CharSequence)descriptor2, (CharSequence)"Lerror/NonExistentClass;", (boolean)false, (int)2, null)) {
                            this.$found.element = true;
                        }
                    }

                    public void visitMethodInsn(int opcode, String owner, String name2, String descriptor2, boolean isInterface) {
                        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                        if (Intrinsics.areEqual((Object)"error/NonExistentClass", (Object)owner) || StringsKt.contains$default((CharSequence)descriptor2, (CharSequence)"Lerror/NonExistentClass;", (boolean)false, (int)2, null)) {
                            this.$found.element = true;
                        }
                    }

                    public void visitLdcInsn(Object cst) {
                        if (cst instanceof Type && Intrinsics.areEqual((Object)"error/NonExistentClass", (Object)((Type)cst).getInternalName())) {
                            this.$found.element = true;
                        }
                    }
                };
            }

            public void visitInnerClass(String name2, String outerName, String innerName, int access) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                if (Intrinsics.areEqual((Object)"error/NonExistentClass", (Object)name2)) {
                    this.$found.element = true;
                }
            }

            public void visitOuterClass(String owner, String name2, String descriptor2) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                if (Intrinsics.areEqual((Object)"error/NonExistentClass", (Object)owner)) {
                    this.$found.element = true;
                }
            }
        };
        reader.accept(visitor2, 0);
        return found.element;
    }
}

