/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.sun.jdi.ReferenceType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.metadata.jvm.KotlinClassMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.KotlinMetadataCache;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ$\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/KotlinMetadataCacheService;", "", "<init>", "()V", "METADATA_CACHE_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/idea/debugger/core/KotlinMetadataCache;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getKotlinMetadata", "Lkotlin/metadata/jvm/KotlinClassMetadata;", "refType", "Lcom/sun/jdi/ReferenceType;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "getKotlinMetadataList", "", "refTypes", "", "getCache", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinMetadataCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMetadataCacheService.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinMetadataCacheService\n+ 2 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n11#2:144\n12#2:146\n1#3:145\n*S KotlinDebug\n*F\n+ 1 KotlinMetadataCacheService.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinMetadataCacheService\n*L\n36#1:144\n36#1:146\n36#1:145\n*E\n"})
public final class KotlinMetadataCacheService {
    @NotNull
    public static final KotlinMetadataCacheService INSTANCE = new KotlinMetadataCacheService();
    @NotNull
    private static final Key<KotlinMetadataCache> METADATA_CACHE_KEY;

    private KotlinMetadataCacheService() {
    }

    @Nullable
    public final KotlinClassMetadata getKotlinMetadata(@NotNull ReferenceType refType, @NotNull EvaluationContext context2) {
        Intrinsics.checkNotNullParameter((Object)refType, (String)"refType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KotlinMetadataCache kotlinMetadataCache = this.getCache(context2);
        return kotlinMetadataCache != null ? kotlinMetadataCache.fetchKotlinMetadata(refType, context2) : null;
    }

    @Nullable
    public final List<KotlinClassMetadata> getKotlinMetadataList(@NotNull Collection<? extends ReferenceType> refTypes, @NotNull EvaluationContext context2) {
        Intrinsics.checkNotNullParameter(refTypes, (String)"refTypes");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KotlinMetadataCache kotlinMetadataCache = this.getCache(context2);
        return kotlinMetadataCache != null ? kotlinMetadataCache.fetchKotlinMetadataList(refTypes, context2) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinMetadataCache getCache(EvaluationContext context2) {
        Object object;
        void $this$getOrCreateUserData$iv;
        EvaluationContextImpl evaluationContextImpl = context2 instanceof EvaluationContextImpl ? (EvaluationContextImpl)context2 : null;
        if (evaluationContextImpl == null || (evaluationContextImpl = evaluationContextImpl.getVirtualMachineProxy()) == null) {
            return null;
        }
        EvaluationContextImpl vmProxy = evaluationContextImpl;
        UserDataHolderEx userDataHolderEx = (UserDataHolderEx)vmProxy;
        Key<KotlinMetadataCache> key$iv = METADATA_CACHE_KEY;
        boolean $i$f$getOrCreateUserData = false;
        Object object2 = $this$getOrCreateUserData$iv.getUserData(key$iv);
        if (object2 != null) {
            Object it$iv = object2;
            boolean bl = false;
            object = it$iv;
        } else {
            Key<KotlinMetadataCache> key = key$iv;
            void var9_9 = $this$getOrCreateUserData$iv;
            boolean bl = false;
            KotlinMetadataCache kotlinMetadataCache = new KotlinMetadataCache();
            Object object3 = var9_9.putUserDataIfAbsent(key, (Object)kotlinMetadataCache);
            object = object3;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"putUserDataIfAbsent(...)");
        }
        return (KotlinMetadataCache)object;
    }

    static {
        Key key = Key.create((String)"METADATA_CACHE_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        METADATA_CACHE_KEY = key;
    }
}

