/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fir.projectStructure.provider;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.projectStructure.DependenciesKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaBuiltinsModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibrarySourceModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptDependencyModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptModule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005J \u0010\t\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/ModuleChooser;", "", "<init>", "()V", "chooseModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "modules", "Lkotlin/sequences/Sequence;", "useSiteModule", "chooseByPriority", "getCandidatePriority", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/ModuleChooser$ModulePriority;", "candidate", "getCandidatePriorityFromDependencies", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/ModuleChooser$ModulePriority$ModuleDependency;", "ModulePriority", "intellij.kotlin.projectStructure"})
@SourceDebugExtension(value={"SMAP\nModuleChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleChooser.kt\norg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/ModuleChooser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class ModuleChooser {
    @NotNull
    public static final ModuleChooser INSTANCE = new ModuleChooser();

    private ModuleChooser() {
    }

    @Nullable
    public final KaModule chooseModule(@NotNull Sequence<? extends KaModule> modules2, @Nullable KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
        if (useSiteModule != null) {
            KaModule kaModule = this.chooseByPriority(modules2, useSiteModule);
            if (kaModule != null) {
                KaModule it = kaModule;
                boolean bl = false;
                return it;
            }
        }
        return (KaModule)SequencesKt.firstOrNull(modules2);
    }

    private final KaModule chooseByPriority(Sequence<? extends KaModule> modules2, KaModule useSiteModule) {
        KaModule bestCandidate = null;
        ModulePriority bestPriority = null;
        for (KaModule candidate : modules2) {
            ModulePriority priority;
            if (this.getCandidatePriority(candidate, useSiteModule) == null) continue;
            if (priority.isTheHighestPriority()) {
                return candidate;
            }
            if (bestPriority != null && priority.compareTo(bestPriority) >= 0) continue;
            bestPriority = priority;
            bestCandidate = candidate;
        }
        return bestCandidate;
    }

    private final ModulePriority getCandidatePriority(KaModule candidate, KaModule useSiteModule) {
        KaModule kaModule = useSiteModule;
        if (Intrinsics.areEqual((Object)kaModule, (Object)candidate)) {
            return ModulePriority.Self.INSTANCE;
        }
        if (kaModule instanceof KaDanglingFileModule) {
            return this.getCandidatePriority(candidate, ((KaDanglingFileModule)useSiteModule).getContextModule());
        }
        kaModule = candidate;
        if (kaModule instanceof KaScriptDependencyModule) {
            if (!(useSiteModule instanceof KaScriptModule) && !(useSiteModule instanceof KaScriptDependencyModule)) {
                return null;
            }
        } else {
            if (kaModule instanceof KaBuiltinsModule) {
                return ModulePriority.BuiltIns.INSTANCE;
            }
            if (kaModule instanceof KaNotUnderContentRootModule || kaModule instanceof KaDanglingFileModule || kaModule instanceof KaScriptModule) {
                return null;
            }
        }
        if ((kaModule = useSiteModule) instanceof KaLibraryModule || kaModule instanceof KaLibrarySourceModule) {
            return null;
        }
        if (kaModule instanceof KaNotUnderContentRootModule) {
            return null;
        }
        if (kaModule instanceof KaBuiltinsModule) {
            return null;
        }
        return this.getCandidatePriorityFromDependencies(useSiteModule, candidate);
    }

    private final ModulePriority.ModuleDependency getCandidatePriorityFromDependencies(KaModule useSiteModule, KaModule candidate) {
        int index2 = SequencesKt.indexOf(DependenciesKt.allDirectDependencies(useSiteModule), (Object)candidate);
        if (index2 < 0) {
            return null;
        }
        return new ModulePriority.ModuleDependency(index2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0003\r\u000e\u000fB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0000H\u0096\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u0082\u0001\u0003\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/ModuleChooser$ModulePriority;", "", "<init>", "()V", "priorityNumber", "", "getPriorityNumber", "()I", "isTheHighestPriority", "", "()Z", "compareTo", "other", "Self", "BuiltIns", "ModuleDependency", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/ModuleChooser$ModulePriority$BuiltIns;", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/ModuleChooser$ModulePriority$ModuleDependency;", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/ModuleChooser$ModulePriority$Self;", "intellij.kotlin.projectStructure"})
    private static abstract sealed class ModulePriority
    implements Comparable<ModulePriority> {
        private ModulePriority() {
        }

        protected abstract int getPriorityNumber();

        public final boolean isTheHighestPriority() {
            return this.getPriorityNumber() == 0;
        }

        @Override
        public int compareTo(@NotNull ModulePriority other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Intrinsics.compare((int)this.getPriorityNumber(), (int)other.getPriorityNumber());
        }

        public /* synthetic */ ModulePriority(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/ModuleChooser$ModulePriority$BuiltIns;", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/ModuleChooser$ModulePriority;", "<init>", "()V", "priorityNumber", "", "getPriorityNumber", "()I", "intellij.kotlin.projectStructure"})
        public static final class BuiltIns
        extends ModulePriority {
            @NotNull
            public static final BuiltIns INSTANCE = new BuiltIns();

            private BuiltIns() {
                super(null);
            }

            @Override
            protected int getPriorityNumber() {
                return Integer.MAX_VALUE;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/ModuleChooser$ModulePriority$ModuleDependency;", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/ModuleChooser$ModulePriority;", "indexInClassPath", "", "<init>", "(I)V", "getIndexInClassPath", "()I", "priorityNumber", "getPriorityNumber", "intellij.kotlin.projectStructure"})
        public static final class ModuleDependency
        extends ModulePriority {
            private final int indexInClassPath;

            public ModuleDependency(int indexInClassPath) {
                super(null);
                this.indexInClassPath = indexInClassPath;
            }

            public final int getIndexInClassPath() {
                return this.indexInClassPath;
            }

            @Override
            protected int getPriorityNumber() {
                return this.indexInClassPath + 1;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/ModuleChooser$ModulePriority$Self;", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/provider/ModuleChooser$ModulePriority;", "<init>", "()V", "priorityNumber", "", "getPriorityNumber", "()I", "intellij.kotlin.projectStructure"})
        public static final class Self
        extends ModulePriority {
            @NotNull
            public static final Self INSTANCE = new Self();

            private Self() {
                super(null);
            }

            @Override
            protected int getPriorityNumber() {
                return 0;
            }
        }
    }
}

