/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.JvmBackendClassResolver;
import org.jetbrains.kotlin.codegen.JvmBackendClassResolverKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmBackendClassResolver;", "Lorg/jetbrains/kotlin/codegen/JvmBackendClassResolver;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "<init>", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "getComponents", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "resolveToClassDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "jvm-backend"})
public final class FirJvmBackendClassResolver
implements JvmBackendClassResolver {
    @NotNull
    private final Fir2IrComponents components;

    public FirJvmBackendClassResolver(@NotNull Fir2IrComponents components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        this.components = components;
    }

    @NotNull
    public final Fir2IrComponents getComponents() {
        return this.components;
    }

    @NotNull
    public List<ClassDescriptor> resolveToClassDescriptors(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (type2.getSort() != 10) {
            return CollectionsKt.emptyList();
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(this.components.getSession()).getClassLikeSymbolByClassId(JvmBackendClassResolverKt.getClassId((Type)type2));
        if (firClassLikeSymbol == null) {
            return CollectionsKt.emptyList();
        }
        FirClassLikeSymbol<?> symbol = firClassLikeSymbol;
        if (!(symbol instanceof FirClassSymbol)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return CollectionsKt.listOf((Object)this.components.getClassifierStorage().getIrClassSymbol((FirClassSymbol)symbol).getDescriptor());
    }
}

