/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import com.hierynomus.sshj.signature.Ed25519PublicKey;
import com.hierynomus.sshj.signature.SignatureEdDSA;
import com.hierynomus.sshj.userauth.certificate.Certificate;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.ECDSAVariationsAdapter;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.signature.Signature;
import net.schmizz.sshj.signature.SignatureDSA;
import net.schmizz.sshj.signature.SignatureECDSA;
import net.schmizz.sshj.signature.SignatureRSA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum KeyType {
    RSA("ssh-rsa"){

        @Override
        public PublicKey readPubKeyFromBuffer(Buffer<?> buf) throws GeneralSecurityException {
            BigInteger n;
            BigInteger e;
            try {
                e = buf.readMPInt();
                n = buf.readMPInt();
            }
            catch (Buffer.BufferException be) {
                throw new GeneralSecurityException(be);
            }
            KeyFactory keyFactory = SecurityUtils.getKeyFactory("RSA");
            return keyFactory.generatePublic(new RSAPublicKeySpec(n, e));
        }

        @Override
        protected void writePubKeyContentsIntoBuffer(PublicKey pk, Buffer<?> buf) {
            RSAPublicKey rsaKey = (RSAPublicKey)pk;
            ((Buffer)buf.putMPInt(rsaKey.getPublicExponent())).putMPInt(rsaKey.getModulus());
        }

        @Override
        protected boolean isMyType(Key key) {
            return "RSA".equals(key.getAlgorithm());
        }
    }
    ,
    DSA("ssh-dss"){

        @Override
        public PublicKey readPubKeyFromBuffer(Buffer<?> buf) throws GeneralSecurityException {
            BigInteger y;
            BigInteger g;
            BigInteger q;
            BigInteger p;
            try {
                p = buf.readMPInt();
                q = buf.readMPInt();
                g = buf.readMPInt();
                y = buf.readMPInt();
            }
            catch (Buffer.BufferException be) {
                throw new GeneralSecurityException(be);
            }
            KeyFactory keyFactory = SecurityUtils.getKeyFactory("DSA");
            return keyFactory.generatePublic(new DSAPublicKeySpec(y, p, q, g));
        }

        @Override
        protected void writePubKeyContentsIntoBuffer(PublicKey pk, Buffer<?> buf) {
            DSAPublicKey dsaKey = (DSAPublicKey)pk;
            ((Buffer)((Buffer)((Buffer)buf.putMPInt(dsaKey.getParams().getP())).putMPInt(dsaKey.getParams().getQ())).putMPInt(dsaKey.getParams().getG())).putMPInt(dsaKey.getY());
        }

        @Override
        protected boolean isMyType(Key key) {
            return "DSA".equals(key.getAlgorithm());
        }
    }
    ,
    ECDSA256("ecdsa-sha2-nistp256"){

        @Override
        public PublicKey readPubKeyFromBuffer(Buffer<?> buf) throws GeneralSecurityException {
            return ECDSAVariationsAdapter.readPubKeyFromBuffer(buf, "256");
        }

        @Override
        protected void writePubKeyContentsIntoBuffer(PublicKey pk, Buffer<?> buf) {
            ECDSAVariationsAdapter.writePubKeyContentsIntoBuffer(pk, buf);
        }

        @Override
        protected boolean isMyType(Key key) {
            return ECDSAVariationsAdapter.isECKeyWithFieldSize(key, 256);
        }
    }
    ,
    ECDSA384("ecdsa-sha2-nistp384"){

        @Override
        public PublicKey readPubKeyFromBuffer(Buffer<?> buf) throws GeneralSecurityException {
            return ECDSAVariationsAdapter.readPubKeyFromBuffer(buf, "384");
        }

        @Override
        protected void writePubKeyContentsIntoBuffer(PublicKey pk, Buffer<?> buf) {
            ECDSAVariationsAdapter.writePubKeyContentsIntoBuffer(pk, buf);
        }

        @Override
        protected boolean isMyType(Key key) {
            return ECDSAVariationsAdapter.isECKeyWithFieldSize(key, 384);
        }
    }
    ,
    ECDSA521("ecdsa-sha2-nistp521"){

        @Override
        public PublicKey readPubKeyFromBuffer(Buffer<?> buf) throws GeneralSecurityException {
            return ECDSAVariationsAdapter.readPubKeyFromBuffer(buf, "521");
        }

        @Override
        protected void writePubKeyContentsIntoBuffer(PublicKey pk, Buffer<?> buf) {
            ECDSAVariationsAdapter.writePubKeyContentsIntoBuffer(pk, buf);
        }

        @Override
        protected boolean isMyType(Key key) {
            return ECDSAVariationsAdapter.isECKeyWithFieldSize(key, 521);
        }
    }
    ,
    ED25519("ssh-ed25519"){
        private final Logger log = LoggerFactory.getLogger(KeyType.class);

        @Override
        public PublicKey readPubKeyFromBuffer(Buffer<?> buf) throws GeneralSecurityException {
            try {
                int keyLen = buf.readUInt32AsInt();
                byte[] p = new byte[keyLen];
                buf.readRawBytes(p);
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("Key algo: %s, Key curve: 25519, Key Len: %s\np: %s", this.sType, keyLen, Arrays.toString(p)));
                }
                EdDSANamedCurveSpec ed25519 = EdDSANamedCurveTable.getByName("Ed25519");
                EdDSAPublicKeySpec publicSpec = new EdDSAPublicKeySpec(p, (EdDSAParameterSpec)ed25519);
                return new Ed25519PublicKey(publicSpec);
            }
            catch (Buffer.BufferException be) {
                throw new SSHRuntimeException(be);
            }
        }

        @Override
        protected void writePubKeyContentsIntoBuffer(PublicKey pk, Buffer<?> buf) {
            EdDSAPublicKey key = (EdDSAPublicKey)pk;
            buf.putBytes(key.getAbyte());
        }

        @Override
        protected boolean isMyType(Key key) {
            return "EdDSA".equals(key.getAlgorithm());
        }
    }
    ,
    RSA_CERT("ssh-rsa-cert-v01@openssh.com"){

        @Override
        public PublicKey readPubKeyFromBuffer(Buffer<?> buf) throws GeneralSecurityException {
            return CertUtils.readPubKey(buf, RSA);
        }

        @Override
        protected void writePubKeyContentsIntoBuffer(PublicKey pk, Buffer<?> buf) {
            CertUtils.writePubKeyContentsIntoBuffer(pk, RSA, buf);
        }

        @Override
        protected boolean isMyType(Key key) {
            return CertUtils.isCertificateOfType(key, RSA);
        }

        @Override
        public KeyType getParent() {
            return RSA;
        }
    }
    ,
    DSA_CERT("ssh-dss-cert-v01@openssh.com"){

        @Override
        public PublicKey readPubKeyFromBuffer(Buffer<?> buf) throws GeneralSecurityException {
            return CertUtils.readPubKey(buf, DSA);
        }

        @Override
        protected void writePubKeyContentsIntoBuffer(PublicKey pk, Buffer<?> buf) {
            CertUtils.writePubKeyContentsIntoBuffer(pk, DSA, buf);
        }

        @Override
        protected boolean isMyType(Key key) {
            return CertUtils.isCertificateOfType(key, DSA);
        }

        @Override
        public KeyType getParent() {
            return DSA;
        }
    }
    ,
    ED25519_CERT("ssh-ed25519-cert-v01@openssh.com"){

        @Override
        public PublicKey readPubKeyFromBuffer(Buffer<?> buf) throws GeneralSecurityException {
            return CertUtils.readPubKey(buf, ED25519);
        }

        @Override
        protected void writePubKeyContentsIntoBuffer(PublicKey pk, Buffer<?> buf) {
            CertUtils.writePubKeyContentsIntoBuffer(pk, ED25519, buf);
        }

        @Override
        protected boolean isMyType(Key key) {
            return CertUtils.isCertificateOfType(key, ED25519);
        }

        @Override
        public KeyType getParent() {
            return ED25519;
        }
    }
    ,
    ECDSA256_CERT("ecdsa-sha2-nistp256-cert-v01@openssh.com"){

        @Override
        public PublicKey readPubKeyFromBuffer(Buffer<?> buf) throws GeneralSecurityException {
            return CertUtils.readPubKey(buf, ECDSA256);
        }

        @Override
        protected void writePubKeyContentsIntoBuffer(PublicKey pk, Buffer<?> buf) {
            CertUtils.writePubKeyContentsIntoBuffer(pk, ECDSA256, buf);
        }

        @Override
        protected boolean isMyType(Key key) {
            return CertUtils.isCertificateOfType(key, ECDSA256);
        }

        @Override
        public KeyType getParent() {
            return ECDSA256;
        }
    }
    ,
    ECDSA384_CERT("ecdsa-sha2-nistp384-cert-v01@openssh.com"){

        @Override
        public PublicKey readPubKeyFromBuffer(Buffer<?> buf) throws GeneralSecurityException {
            return CertUtils.readPubKey(buf, ECDSA384);
        }

        @Override
        protected void writePubKeyContentsIntoBuffer(PublicKey pk, Buffer<?> buf) {
            CertUtils.writePubKeyContentsIntoBuffer(pk, ECDSA384, buf);
        }

        @Override
        protected boolean isMyType(Key key) {
            return CertUtils.isCertificateOfType(key, ECDSA384);
        }

        @Override
        public KeyType getParent() {
            return ECDSA384;
        }
    }
    ,
    ECDSA521_CERT("ecdsa-sha2-nistp521-cert-v01@openssh.com"){

        @Override
        public PublicKey readPubKeyFromBuffer(Buffer<?> buf) throws GeneralSecurityException {
            return CertUtils.readPubKey(buf, ECDSA521);
        }

        @Override
        protected void writePubKeyContentsIntoBuffer(PublicKey pk, Buffer<?> buf) {
            CertUtils.writePubKeyContentsIntoBuffer(pk, ECDSA521, buf);
        }

        @Override
        protected boolean isMyType(Key key) {
            return CertUtils.isCertificateOfType(key, ECDSA521);
        }

        @Override
        public KeyType getParent() {
            return ECDSA521;
        }
    }
    ,
    UNKNOWN("unknown"){

        @Override
        public PublicKey readPubKeyFromBuffer(Buffer<?> buf) throws GeneralSecurityException {
            throw new UnsupportedOperationException("Don't know how to decode key:" + this.sType);
        }

        @Override
        public void putPubKeyIntoBuffer(PublicKey pk, Buffer<?> buf) {
            throw new UnsupportedOperationException("Don't know how to encode key: " + pk);
        }

        @Override
        protected void writePubKeyContentsIntoBuffer(PublicKey pk, Buffer<?> buf) {
            throw new UnsupportedOperationException("Don't know how to encode key: " + pk);
        }

        @Override
        protected boolean isMyType(Key key) {
            return false;
        }
    };

    protected final String sType;

    private KeyType(String type) {
        this.sType = type;
    }

    public abstract PublicKey readPubKeyFromBuffer(Buffer<?> var1) throws GeneralSecurityException;

    protected abstract void writePubKeyContentsIntoBuffer(PublicKey var1, Buffer<?> var2);

    public void putPubKeyIntoBuffer(PublicKey pk, Buffer<?> buf) {
        this.writePubKeyContentsIntoBuffer(pk, (Buffer<?>)buf.putString(this.sType));
    }

    protected abstract boolean isMyType(Key var1);

    public static KeyType fromKey(Key key) {
        KeyType result = UNKNOWN;
        for (KeyType kt : KeyType.values()) {
            if (!kt.isMyType(key) || result != UNKNOWN && !kt.isSubType(result)) continue;
            result = kt;
        }
        return result;
    }

    private boolean isSubType(KeyType keyType) {
        for (KeyType node = this; node != null; node = node.getParent()) {
            if (keyType != node) continue;
            return true;
        }
        return false;
    }

    public KeyType getParent() {
        return null;
    }

    public static KeyType fromString(String sType) {
        for (KeyType kt : KeyType.values()) {
            if (!kt.sType.equals(sType)) continue;
            return kt;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.sType;
    }

    public static class CertUtils {
        public static final List<Factory.Named<Signature>> ALL_SIGNATURES = Arrays.asList(new SignatureRSA.FactorySSHRSA(), new SignatureRSA.FactoryCERT(), new SignatureRSA.FactoryRSASHA256(), new SignatureRSA.FactoryRSASHA512(), new SignatureDSA.Factory(), new SignatureDSA.Factory(), new SignatureECDSA.Factory256(), new SignatureECDSA.Factory256(), new SignatureECDSA.Factory384(), new SignatureECDSA.Factory384(), new SignatureECDSA.Factory521(), new SignatureECDSA.Factory521(), new SignatureEdDSA.Factory(), new SignatureEdDSA.Factory());

        static <T extends PublicKey> Certificate<T> readPubKey(Buffer<?> buf, KeyType innerKeyType) throws GeneralSecurityException {
            Certificate.Builder builder = Certificate.getBuilder();
            try {
                builder.nonce(buf.readBytes());
                builder.publicKey(innerKeyType.readPubKeyFromBuffer(buf));
                builder.serial(buf.readUInt64AsBigInteger());
                builder.type(buf.readUInt32());
                builder.id(buf.readString());
                builder.validPrincipals(CertUtils.unpackList(buf.readBytes()));
                builder.validAfter(CertUtils.dateFromEpoch(buf.readUInt64AsBigInteger()));
                builder.validBefore(CertUtils.dateFromEpoch(buf.readUInt64AsBigInteger()));
                builder.critOptions(CertUtils.unpackMap(buf.readBytes()));
                builder.extensions(CertUtils.unpackMap(buf.readBytes()));
                buf.readString();
                builder.signatureKey(buf.readBytes());
                builder.signature(buf.readBytes());
            }
            catch (Buffer.BufferException be) {
                throw new GeneralSecurityException(be);
            }
            return builder.build();
        }

        static void writePubKeyContentsIntoBuffer(PublicKey publicKey, KeyType innerKeyType, Buffer<?> buf) {
            Certificate<PublicKey> certificate = CertUtils.toCertificate(publicKey);
            buf.putBytes(certificate.getNonce());
            innerKeyType.writePubKeyContentsIntoBuffer(certificate.getKey(), buf);
            ((Buffer)((Buffer)((Buffer)((Buffer)((Buffer)((Buffer)((Buffer)((Buffer)((Buffer)((Buffer)buf.putUInt64(certificate.getSerial())).putUInt32(certificate.getType())).putString(certificate.getId())).putBytes(CertUtils.packList(certificate.getValidPrincipals()))).putUInt64(CertUtils.epochFromDate(certificate.getValidAfter()))).putUInt64(CertUtils.epochFromDate(certificate.getValidBefore()))).putBytes(CertUtils.packMap(certificate.getCritOptions()))).putBytes(CertUtils.packMap(certificate.getExtensions()))).putString("")).putBytes(certificate.getSignatureKey())).putBytes(certificate.getSignature());
        }

        public static String verifyHostCertificate(byte[] certRaw, Certificate<?> cert, String hostname) throws Buffer.BufferException, SSHRuntimeException {
            String signatureType = new Buffer.PlainBuffer(cert.getSignature()).readString();
            Signature signature = (Signature)Factory.Named.Util.create(ALL_SIGNATURES, signatureType);
            if (signature == null) {
                return "Unknown signature algorithm `" + signatureType + "`";
            }
            if (cert.getValidPrincipals() != null && !cert.getValidPrincipals().isEmpty()) {
                String principal;
                boolean ok = false;
                Iterator<String> iterator = cert.getValidPrincipals().iterator();
                while (iterator.hasNext() && !(ok = CertUtils.matchPattern(hostname, principal = iterator.next()))) {
                }
                if (!ok) {
                    StringBuilder error = new StringBuilder().append("Hostname `").append(hostname).append("` doesn't match any of the principals: `");
                    String delimiter = "";
                    for (String principal2 : cert.getValidPrincipals()) {
                        error.append(delimiter).append(principal2);
                        delimiter = "`, `";
                    }
                    error.append("`");
                    return error.toString();
                }
            }
            Date today = new Date();
            if (cert.getValidAfter() != null && today.before(cert.getValidAfter())) {
                return "Certificate is valid after " + cert.getValidAfter() + ", today is " + today;
            }
            if (cert.getValidBefore() != null && today.after(cert.getValidBefore())) {
                return "Certificate is valid before " + cert.getValidBefore() + ", today is " + today;
            }
            signature.initVerify(new Buffer.PlainBuffer(cert.getSignatureKey()).readPublicKey());
            signature.update(certRaw, 0, certRaw.length - cert.getSignature().length - 4);
            if (signature.verify(cert.getSignature())) {
                return null;
            }
            return "Signature verification failed";
        }

        public static boolean matchPattern(String target, String pattern) {
            StringBuilder regex = new StringBuilder();
            String endEscape = "";
            for (int i = 0; i < pattern.length(); ++i) {
                char p = pattern.charAt(i);
                if (p == '?' || p == '*') {
                    regex.append(endEscape);
                    endEscape = "";
                    if (p == '?') {
                        regex.append('.');
                        continue;
                    }
                    regex.append(".*");
                    continue;
                }
                if (endEscape.isEmpty()) {
                    regex.append("\\Q");
                    endEscape = "\\E";
                }
                regex.append(p);
            }
            return Pattern.compile(regex.toString()).matcher(target).matches();
        }

        static boolean isCertificateOfType(Key key, KeyType innerKeyType) {
            if (!(key instanceof Certificate)) {
                return false;
            }
            Object innerKey = ((Certificate)key).getKey();
            return innerKeyType.isMyType((Key)innerKey);
        }

        static Certificate<PublicKey> toCertificate(PublicKey key) {
            if (!(key instanceof Certificate)) {
                throw new UnsupportedOperationException("Can't convert non-certificate key " + key.getAlgorithm() + " to certificate");
            }
            return (Certificate)key;
        }

        private static Date dateFromEpoch(BigInteger seconds) {
            BigInteger maxValue = BigInteger.valueOf(9223372036854775L);
            if (seconds.compareTo(maxValue) > 0) {
                return new Date(maxValue.longValue() * 1000L);
            }
            return new Date(seconds.longValue() * 1000L);
        }

        private static BigInteger epochFromDate(Date date) {
            long time = date.getTime() / 1000L;
            if (time >= 9223372036854775L) {
                return Buffer.MAX_UINT64_VALUE;
            }
            return BigInteger.valueOf(time);
        }

        private static String unpackString(byte[] packedString) throws Buffer.BufferException {
            if (packedString.length == 0) {
                return "";
            }
            return new Buffer.PlainBuffer(packedString).readString();
        }

        private static List<String> unpackList(byte[] packedString) throws Buffer.BufferException {
            ArrayList<String> list = new ArrayList<String>();
            Buffer.PlainBuffer buf = new Buffer.PlainBuffer(packedString);
            while (buf.available() > 0) {
                list.add(buf.readString());
            }
            return list;
        }

        private static Map<String, String> unpackMap(byte[] packedString) throws Buffer.BufferException {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            Buffer.PlainBuffer buf = new Buffer.PlainBuffer(packedString);
            while (buf.available() > 0) {
                String name = buf.readString();
                String data = CertUtils.unpackString(buf.readStringAsBytes());
                map.put(name, data);
            }
            return map;
        }

        private static byte[] packString(String data) {
            if (data == null || data.isEmpty()) {
                return "".getBytes();
            }
            return ((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(data)).getCompactData();
        }

        private static byte[] packList(Iterable<String> strings) {
            Buffer.PlainBuffer buf = new Buffer.PlainBuffer();
            for (String string : strings) {
                buf.putString(string);
            }
            return buf.getCompactData();
        }

        private static byte[] packMap(Map<String, String> map) {
            Buffer.PlainBuffer buf = new Buffer.PlainBuffer();
            ArrayList<String> keys = new ArrayList<String>(map.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                buf.putString(key);
                String value = map.get(key);
                buf.putString(CertUtils.packString(value));
            }
            return buf.getCompactData();
        }
    }
}

