/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementType;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.lexer.YAMLGrammarCharUtil;
import org.jetbrains.yaml.psi.YAMLBlockScalar;
import org.jetbrains.yaml.psi.YAMLScalarText;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarTextEvaluator;
import org.jetbrains.yaml.psi.impl.YamlScalarTextEvaluator;

public class YAMLScalarTextImpl
extends YAMLBlockScalarImpl
implements YAMLScalarText,
YAMLBlockScalar {
    public YAMLScalarTextImpl(@NotNull ASTNode node) {
        if (node == null) {
            YAMLScalarTextImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @NotNull
    protected IElementType getContentType() {
        YAMLElementType yAMLElementType = YAMLTokenTypes.SCALAR_TEXT;
        if (yAMLElementType == null) {
            YAMLScalarTextImpl.$$$reportNull$$$0(1);
        }
        return yAMLElementType;
    }

    @Override
    @NotNull
    public YamlScalarTextEvaluator<YAMLScalarTextImpl> getTextEvaluator() {
        return new YAMLBlockScalarTextEvaluator<YAMLScalarTextImpl>(this, this){

            @Override
            @NotNull
            protected String getRangesJoiner(@NotNull CharSequence text, @NotNull List<TextRange> contentRanges, int indexBefore) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (contentRanges == null) {
                    1.$$$reportNull$$$0(1);
                }
                TextRange leftRange = contentRanges.get(indexBefore);
                TextRange rightRange = contentRanges.get(indexBefore + 1);
                if (leftRange.isEmpty()) {
                    if (rightRange.getLength() == 1 && text.charAt(rightRange.getStartOffset()) == '\n' && this.getChompingIndicator() != YAMLBlockScalarTextEvaluator.ChompingIndicator.KEEP) {
                        return "";
                    }
                    return "\n";
                }
                if (1.startsWithWhitespace(text, leftRange) || 1.startsWithWhitespace(text, rightRange)) {
                    return "\n";
                }
                if (rightRange.isEmpty()) {
                    int i;
                    for (i = indexBefore + 2; i < contentRanges.size() && contentRanges.get(i).isEmpty(); ++i) {
                    }
                    if (i >= contentRanges.size() ? this.getChompingIndicator() == YAMLBlockScalarTextEvaluator.ChompingIndicator.KEEP : 1.startsWithWhitespace(text, contentRanges.get(i))) {
                        return "\n";
                    }
                    return "";
                }
                return " ";
            }

            @Override
            @NotNull
            public String getTextValue(@Nullable TextRange rangeInHost) {
                Object value = super.getTextValue(rangeInHost);
                if (!StringUtil.isEmptyOrSpaces((String)value) && this.getChompingIndicator() != YAMLBlockScalarTextEvaluator.ChompingIndicator.STRIP && this.isEnding(rangeInHost)) {
                    value = (String)value + "\n";
                }
                String string = value;
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static boolean startsWithWhitespace(@NotNull CharSequence text, @NotNull TextRange range) {
                if (text == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (range == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (range.isEmpty()) {
                    return false;
                }
                char c = text.charAt(range.getStartOffset());
                return c == ' ' || c == '\t';
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "contentRanges";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/yaml/psi/impl/YAMLScalarTextImpl$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "range";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLScalarTextImpl$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTextValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getRangesJoiner";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "startsWithWhitespace";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Override
    @NotNull
    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        if (input == null) {
            YAMLScalarTextImpl.$$$reportNull$$$0(2);
        }
        if (!StringUtil.endsWithChar((CharSequence)input, (char)'\n')) {
            throw new IllegalArgumentException("Should end with a line break");
        }
        int indent = this.locateIndent();
        if (indent == 0) {
            indent = YAMLUtil.getIndentToThisElement((PsiElement)this) + 2;
        }
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indent);
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        int currentLength = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '\n') {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\n" + indentString)));
                currentLength = 0;
                continue;
            }
            if (currentLength > 60 && input.charAt(i) == ' ' && i + 1 < input.length() && YAMLGrammarCharUtil.isNonSpaceChar(input.charAt(i + 1))) {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\n" + indentString)));
                currentLength = 0;
                continue;
            }
            ++currentLength;
        }
        ArrayList<Pair<TextRange, String>> arrayList = result;
        if (arrayList == null) {
            YAMLScalarTextImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    public String toString() {
        return "YAML scalar text";
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            YAMLScalarTextImpl.$$$reportNull$$$0(4);
        }
        if (visitor instanceof YamlPsiElementVisitor) {
            ((YamlPsiElementVisitor)visitor).visitScalarText(this);
        } else {
            super.accept(visitor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/psi/impl/YAMLScalarTextImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLScalarTextImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEncodeReplacements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEncodeReplacements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

