/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.codeInspection.i18n.NlsInfo;
import com.intellij.codeInspection.restriction.AnnotationContext;
import com.intellij.codeInspection.restriction.StringFlowUtil;
import com.intellij.lang.Language;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiConcatenationUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import java.text.ChoiceFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.util.UastExpressionUtils;

public final class JavaI18nUtil {
    public static final PropertyCreationHandler DEFAULT_PROPERTY_CREATION_HANDLER = (project, propertiesFiles, key, value, parameters) -> I18nUtil.createProperty((Project)project, (Collection)propertiesFiles, (String)key, (String)value, (boolean)true);
    static final PropertyCreationHandler EMPTY_CREATION_HANDLER = (project, propertiesFiles, key, value, parameters) -> {};

    private JavaI18nUtil() {
    }

    @Nullable
    public static TextRange getSelectedRange(Editor editor, @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JavaI18nUtil.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            return null;
        }
        String selectedText = editor.getSelectionModel().getSelectedText();
        if (selectedText != null) {
            return new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
        }
        PsiElement psiElement = psiFile.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement == null || psiElement instanceof PsiWhiteSpace) {
            return null;
        }
        return psiElement.getTextRange();
    }

    public static boolean mustBePropertyKey(@NotNull PsiExpression expression, @Nullable Ref<? super PsiAnnotationMemberValue> resourceBundleRef) {
        UExpression value;
        Ref resourceBundleURef;
        UExpression uExpression;
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(1);
        }
        if ((uExpression = (UExpression)UastContextKt.toUElement((PsiElement)expression, UExpression.class)) == null) {
            return false;
        }
        Ref ref = resourceBundleURef = resourceBundleRef == null ? null : Ref.create();
        if (!JavaI18nUtil.mustBePropertyKey(uExpression, (Ref<? super UExpression>)resourceBundleURef)) {
            return false;
        }
        if (resourceBundleURef != null && (value = (UExpression)resourceBundleURef.get()) != null) {
            resourceBundleRef.set(ObjectUtils.tryCast((Object)value.getSourcePsi(), PsiAnnotationMemberValue.class));
        }
        return true;
    }

    public static boolean mustBePropertyKey(@NotNull UExpression expression, @Nullable Ref<? super UExpression> resourceBundleRef) {
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(2);
        }
        expression = StringFlowUtil.goUp((UExpression)expression, (boolean)false, NlsInfo.factory());
        AnnotationContext context = AnnotationContext.fromExpression((UExpression)expression);
        return context.allItems().anyMatch(owner -> {
            PsiAnnotation annotation = owner.findAnnotation("org.jetbrains.annotations.PropertyKey");
            if (annotation != null && resourceBundleRef != null) {
                PsiAnnotationMemberValue attributeValue = annotation.findAttributeValue("resourceBundle");
                resourceBundleRef.set((Object)UastContextKt.toUElement((PsiElement)attributeValue, UExpression.class));
            }
            return annotation != null;
        });
    }

    @NotNull
    static UExpression getTopLevelExpression(@NotNull UExpression expression, boolean stopAtCall) {
        UExpression parent;
        UElement uElement;
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(3);
        }
        while (!(!((uElement = expression.getUastParent()) instanceof UExpression) || (parent = (UExpression)uElement) instanceof UBlockExpression || parent instanceof UReturnExpression || parent instanceof UIfExpression && UastUtils.isPsiAncestor((UElement)((UIfExpression)parent).getCondition(), (UElement)expression) || UastExpressionUtils.isAssignment((UElement)(expression = parent)))) {
            UastCallKind kind;
            if (!(expression instanceof UCallExpression) || !stopAtCall || (kind = ((UCallExpression)expression).getKind()) != UastCallKind.METHOD_CALL) continue;
            if (!(expression.getUastParent() instanceof UQualifiedReferenceExpression)) break;
            expression = (UExpression)expression.getUastParent();
            break;
        }
        UExpression uExpression = expression;
        if (uExpression == null) {
            JavaI18nUtil.$$$reportNull$$$0(4);
        }
        return uExpression;
    }

    static boolean isValidPropertyReference(@NotNull Project project, @NotNull PsiExpression expression, @NotNull String key, @NotNull Ref<? super String> outResourceBundle) {
        Ref resourceBundleRef;
        if (project == null) {
            JavaI18nUtil.$$$reportNull$$$0(5);
        }
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(6);
        }
        if (key == null) {
            JavaI18nUtil.$$$reportNull$$$0(7);
        }
        if (outResourceBundle == null) {
            JavaI18nUtil.$$$reportNull$$$0(8);
        }
        if (JavaI18nUtil.mustBePropertyKey(expression, (Ref<? super PsiAnnotationMemberValue>)(resourceBundleRef = Ref.create()))) {
            Object resourceBundleName = resourceBundleRef.get();
            if (!(resourceBundleName instanceof PsiExpression)) {
                return false;
            }
            PsiExpression expr = (PsiExpression)resourceBundleName;
            PsiConstantEvaluationHelper constantEvaluationHelper = JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper();
            Object value = constantEvaluationHelper.computeConstantExpression((PsiElement)expr);
            if (value == null) {
                PsiElement resolve;
                if (expr instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)expr).resolve()) instanceof PsiField && ((PsiField)resolve).hasModifierProperty("final") && (value = constantEvaluationHelper.computeConstantExpression((PsiElement)((PsiField)resolve).getInitializer())) == null) {
                    return false;
                }
                if (value == null) {
                    ResourceBundle resourceBundle = JavaI18nUtil.resolveResourceBundleByKey(key, project);
                    if (resourceBundle == null) {
                        return false;
                    }
                    PropertiesFile defaultPropertiesFile = resourceBundle.getDefaultPropertiesFile();
                    String bundleName = BundleNameEvaluator.DEFAULT.evaluateBundleName(defaultPropertiesFile.getContainingFile());
                    if (bundleName == null) {
                        return false;
                    }
                    value = bundleName;
                }
            }
            String bundleName = value.toString();
            outResourceBundle.set((Object)bundleName);
            return JavaI18nUtil.isPropertyRef(expression, key, bundleName);
        }
        return true;
    }

    @Nullable
    private static ResourceBundle resolveResourceBundleByKey(@NotNull String key, @NotNull Project project) {
        if (key == null) {
            JavaI18nUtil.$$$reportNull$$$0(9);
        }
        if (project == null) {
            JavaI18nUtil.$$$reportNull$$$0(10);
        }
        Ref bundleRef = Ref.create();
        boolean r = PropertiesReferenceManager.getInstance((Project)project).processAllPropertiesFiles((baseName, propertiesFile) -> {
            if (propertiesFile.findPropertyByKey(key) != null) {
                if (bundleRef.get() == null) {
                    bundleRef.set((Object)propertiesFile.getResourceBundle());
                } else {
                    return ((ResourceBundle)bundleRef.get()).equals(propertiesFile.getResourceBundle());
                }
            }
            return true;
        });
        return r ? (ResourceBundle)bundleRef.get() : null;
    }

    private static boolean isPropertyRef(@NotNull PsiExpression expression, @NotNull String key, @Nullable String resourceBundleName) {
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(11);
        }
        if (key == null) {
            JavaI18nUtil.$$$reportNull$$$0(12);
        }
        if (resourceBundleName == null) {
            return !PropertiesImplUtil.findPropertiesByKey((Project)expression.getProject(), (String)key).isEmpty();
        }
        List propertiesFiles = I18nUtil.propertiesFilesByBundleName((String)resourceBundleName, (PsiElement)expression);
        boolean containedInPropertiesFile = false;
        for (PropertiesFile propertiesFile : propertiesFiles) {
            containedInPropertiesFile |= propertiesFile.findPropertyByKey(key) != null;
        }
        return containedInPropertiesFile;
    }

    @NotNull
    public static Set<String> suggestExpressionOfType(PsiClassType type, PsiElement context) {
        PsiExpression[] expressions;
        PsiVariable[] variables = MacroUtil.getVariablesVisibleAt((PsiElement)context, (String)"");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (PsiVariable var : variables) {
            PsiType varType = var.getType();
            PsiIdentifier identifier = var.getNameIdentifier();
            if (type != null && !type.isAssignableFrom(varType) || identifier == null) continue;
            result.add(identifier.getText());
        }
        for (PsiExpression expression : expressions = MacroUtil.getStandardExpressionsOfType((PsiElement)context, (PsiType)type)) {
            result.add(expression.getText());
        }
        if (type != null) {
            JavaI18nUtil.addAvailableMethodsOfType(type, context, result);
        }
        LinkedHashSet<String> linkedHashSet = result;
        if (linkedHashSet == null) {
            JavaI18nUtil.$$$reportNull$$$0(13);
        }
        return linkedHashSet;
    }

    private static void addAvailableMethodsOfType(@NotNull PsiClassType type, @NotNull PsiElement context, @NotNull Collection<? super String> result) {
        if (type == null) {
            JavaI18nUtil.$$$reportNull$$$0(14);
        }
        if (context == null) {
            JavaI18nUtil.$$$reportNull$$$0(15);
        }
        if (result == null) {
            JavaI18nUtil.$$$reportNull$$$0(16);
        }
        PsiScopesUtil.treeWalkUp((element, state) -> {
            PsiMethod method;
            PsiType returnType;
            if (element instanceof PsiMethod && (returnType = (method = (PsiMethod)element).getReturnType()) != null && TypeConversionUtil.isAssignable((PsiType)type, (PsiType)returnType) && method.getParameterList().isEmpty()) {
                result.add(method.getName() + "()");
            }
            return true;
        }, (PsiElement)context, null);
    }

    public static int getPropertyValuePlaceholdersCount(@NotNull String propertyValue) {
        if (propertyValue == null) {
            JavaI18nUtil.$$$reportNull$$$0(17);
        }
        try {
            return JavaI18nUtil.countFormatParameters(new MessageFormat(propertyValue));
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
    }

    private static int countFormatParameters(@NotNull MessageFormat mf) {
        if (mf == null) {
            JavaI18nUtil.$$$reportNull$$$0(18);
        }
        Format[] formats = mf.getFormatsByArgumentIndex();
        int maxLength = formats.length;
        for (Format format : formats) {
            if (!(format instanceof ChoiceFormat)) continue;
            for (Object o : ((ChoiceFormat)format).getFormats()) {
                maxLength = Math.max(maxLength, JavaI18nUtil.countFormatParameters(new MessageFormat((String)o)));
            }
        }
        return maxLength;
    }

    public static int getPropertyValueParamsMaxCount(@NotNull UExpression expression) {
        SortedSet<Integer> paramsCount;
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(19);
        }
        if ((paramsCount = JavaI18nUtil.getPropertyValueParamsCount(expression, null)).isEmpty()) {
            return -1;
        }
        return paramsCount.last();
    }

    @NotNull
    static SortedSet<Integer> getPropertyValueParamsCount(@NotNull PsiExpression expression, @Nullable String resourceBundleName) {
        UExpression uExpression;
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(20);
        }
        if ((uExpression = (UExpression)UastContextKt.toUElement((PsiElement)expression, UExpression.class)) == null) {
            return new TreeSet<Integer>();
        }
        return JavaI18nUtil.getPropertyValueParamsCount(uExpression, resourceBundleName);
    }

    @NotNull
    private static SortedSet<Integer> getPropertyValueParamsCount(@NotNull UExpression expression, @Nullable String resourceBundleName) {
        UInjectionHost injectionHost;
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(21);
        }
        if (expression instanceof UInjectionHost) {
            injectionHost = (UInjectionHost)expression;
        } else if (expression instanceof UReferenceExpression) {
            PsiElement resolved = ((UReferenceExpression)expression).resolve();
            PsiField field = resolved == null ? null : (PsiField)resolved;
            injectionHost = field != null && field.hasModifierProperty("final") && field.getInitializer() instanceof PsiLiteralExpression ? (UInjectionHost)UastContextKt.toUElement((PsiElement)field.getInitializer(), UInjectionHost.class) : null;
        } else {
            injectionHost = null;
        }
        TreeSet<Integer> paramsCount = new TreeSet<Integer>();
        if (injectionHost == null) {
            TreeSet<Integer> treeSet = paramsCount;
            if (treeSet == null) {
                JavaI18nUtil.$$$reportNull$$$0(22);
            }
            return treeSet;
        }
        for (PsiReference reference : UastLiteralUtils.getInjectedReferences((UInjectionHost)injectionHost)) {
            if (!(reference instanceof PsiPolyVariantReference)) continue;
            for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(false)) {
                if (!result.isValidResult() || !(result.getElement() instanceof IProperty)) continue;
                try {
                    String propertyValue;
                    PsiFile file;
                    IProperty property = (IProperty)result.getElement();
                    if (resourceBundleName != null && !resourceBundleName.equals(BundleNameEvaluator.DEFAULT.evaluateBundleName(file = property.getPropertiesFile().getContainingFile())) || (propertyValue = property.getValue()) == null) continue;
                    paramsCount.add(JavaI18nUtil.getPropertyValuePlaceholdersCount(propertyValue));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        TreeSet<Integer> treeSet = paramsCount;
        if (treeSet == null) {
            JavaI18nUtil.$$$reportNull$$$0(23);
        }
        return treeSet;
    }

    @NotNull
    public static String buildUnescapedFormatString(@NotNull UStringConcatenationsFacade cf, @NotNull List<? super UExpression> formatParameters, @NotNull Project project) {
        if (cf == null) {
            JavaI18nUtil.$$$reportNull$$$0(24);
        }
        if (formatParameters == null) {
            JavaI18nUtil.$$$reportNull$$$0(25);
        }
        if (project == null) {
            JavaI18nUtil.$$$reportNull$$$0(26);
        }
        return JavaI18nUtil.buildUnescapedFormatString(cf, formatParameters, project, false);
    }

    @NotNull
    private static String buildUnescapedFormatString(@NotNull UStringConcatenationsFacade cf, @NotNull List<? super UExpression> formatParameters, @NotNull Project project, boolean nested) {
        if (cf == null) {
            JavaI18nUtil.$$$reportNull$$$0(27);
        }
        if (formatParameters == null) {
            JavaI18nUtil.$$$reportNull$$$0(28);
        }
        if (project == null) {
            JavaI18nUtil.$$$reportNull$$$0(29);
        }
        StringBuilder result = new StringBuilder();
        boolean noEscapingRequired = !nested && SequencesKt.all((Sequence)cf.getUastOperands(), expression -> expression instanceof ULiteralExpression);
        for (UExpression expression2 : SequencesKt.asIterable((Sequence)cf.getUastOperands())) {
            while (expression2 instanceof UParenthesizedExpression) {
                expression2 = ((UParenthesizedExpression)expression2).getExpression();
            }
            if (expression2 instanceof ULiteralExpression) {
                Object value = ((ULiteralExpression)expression2).getValue();
                if (value == null) continue;
                if (noEscapingRequired) {
                    result.append(value);
                    continue;
                }
                String formatString = PsiConcatenationUtil.formatString((String)value.toString(), (boolean)false);
                result.append(nested ? PsiConcatenationUtil.formatString((String)formatString, (boolean)false) : formatString);
                continue;
            }
            if (!nested && JavaI18nUtil.addChoicePattern(expression2, formatParameters, project, result)) continue;
            result.append("{").append(formatParameters.size()).append("}");
            formatParameters.add((UExpression)expression2);
        }
        String string = result.toString();
        if (string == null) {
            JavaI18nUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    private static boolean addChoicePattern(@NotNull UExpression expression, @NotNull List<? super UExpression> formatParameters, @NotNull Project project, @NotNull StringBuilder result) {
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(31);
        }
        if (formatParameters == null) {
            JavaI18nUtil.$$$reportNull$$$0(32);
        }
        if (project == null) {
            JavaI18nUtil.$$$reportNull$$$0(33);
        }
        if (result == null) {
            JavaI18nUtil.$$$reportNull$$$0(34);
        }
        if (!(expression instanceof UIfExpression)) {
            return false;
        }
        PsiElement sourcePsi = expression.getSourcePsi();
        if (sourcePsi == null) {
            return false;
        }
        UastCodeGenerationPlugin generationPlugin = UastCodeGenerationPlugin.byLanguage((Language)sourcePsi.getLanguage());
        if (generationPlugin == null) {
            return false;
        }
        UExpression thenExpression = ((UIfExpression)expression).getThenExpression();
        UExpression elseExpression = ((UIfExpression)expression).getElseExpression();
        if (!(thenExpression instanceof UInjectionHost) && !(elseExpression instanceof UInjectionHost)) {
            return false;
        }
        boolean nested = !(thenExpression instanceof UInjectionHost) || !(elseExpression instanceof UInjectionHost);
        String thenStr = JavaI18nUtil.getSideText(formatParameters, project, thenExpression, nested);
        String elseStr = JavaI18nUtil.getSideText(formatParameters, project, elseExpression, nested);
        result.append("{").append(formatParameters.size()).append(", choice, 0#").append(thenStr).append("|1#").append(elseStr).append("}");
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        UIfExpression exCopy = (UIfExpression)UastContextKt.toUElement((PsiElement)sourcePsi.copy(), UIfExpression.class);
        assert (exCopy != null);
        generationPlugin.replace((UElement)Objects.requireNonNull(exCopy.getThenExpression()), (UElement)Objects.requireNonNull((ULiteralExpression)UastContextKt.toUElement((PsiElement)elementFactory.createExpressionFromText("0", null), ULiteralExpression.class)), ULiteralExpression.class);
        generationPlugin.replace((UElement)Objects.requireNonNull(exCopy.getElseExpression()), (UElement)Objects.requireNonNull((ULiteralExpression)UastContextKt.toUElement((PsiElement)elementFactory.createExpressionFromText("1", null), ULiteralExpression.class)), ULiteralExpression.class);
        formatParameters.add((UExpression)exCopy);
        return true;
    }

    @NotNull
    private static String getSideText(@NotNull List<? super UExpression> formatParameters, @NotNull Project project, UExpression expression, boolean nested) {
        Object elseStr;
        if (formatParameters == null) {
            JavaI18nUtil.$$$reportNull$$$0(35);
        }
        if (project == null) {
            JavaI18nUtil.$$$reportNull$$$0(36);
        }
        if (expression instanceof ULiteralExpression) {
            Object elseValue = ((ULiteralExpression)expression).getValue();
            if (elseValue != null) {
                elseStr = PsiConcatenationUtil.formatString((String)elseValue.toString(), (boolean)false);
                elseStr = nested ? PsiConcatenationUtil.formatString((String)elseStr, (boolean)false) : elseStr;
            } else {
                elseStr = "null";
            }
        } else {
            UStringConcatenationsFacade concatenation = UStringConcatenationsFacade.createFromTopConcatenation((UExpression)expression);
            if (concatenation != null) {
                elseStr = JavaI18nUtil.buildUnescapedFormatString(concatenation, formatParameters, project, true);
            } else {
                elseStr = "{" + formatParameters.size() + "}";
                formatParameters.add((UExpression)expression);
            }
        }
        String string = ((String)elseStr).replaceAll("([<>|#])", "'$1'");
        if (string == null) {
            JavaI18nUtil.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    static String composeParametersText(@NotNull List<? extends UExpression> args) {
        if (args == null) {
            JavaI18nUtil.$$$reportNull$$$0(38);
        }
        String string = args.stream().map(UElement::getSourcePsi).filter(Objects::nonNull).map(psi -> psi.getText()).collect(Collectors.joining(","));
        if (string == null) {
            JavaI18nUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Nullable
    public static Property resolveProperty(@NotNull UExpression expression) {
        PsiElement psi;
        if (expression == null) {
            JavaI18nUtil.$$$reportNull$$$0(40);
        }
        if ((psi = expression.getSourcePsi()) == null) {
            return null;
        }
        if (expression.equals((Object)UastContextKt.toUElement((PsiElement)psi.getParent()))) {
            psi = psi.getParent();
        }
        return JavaI18nUtil.resolveProperty(psi);
    }

    @Nullable
    public static Property resolveProperty(PsiElement psi) {
        PsiReference[] references;
        for (PsiReference reference : references = psi.getReferences()) {
            PsiElement element;
            ResolveResult[] resolveResults;
            if (!(reference instanceof PropertyReference) || (resolveResults = ((PropertyReference)reference).multiResolve(false)).length != 1 || !resolveResults[0].isValidResult() || !((element = resolveResults[0].getElement()) instanceof Property)) continue;
            return (Property)element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 13, 22, 23, 30, 37, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 31: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 13: 
            case 22: 
            case 23: 
            case 30: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/JavaI18nUtil";
                break;
            }
            case 5: 
            case 10: 
            case 26: 
            case 29: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outResourceBundle";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyValue";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mf";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cf";
                break;
            }
            case 25: 
            case 28: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatParameters";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/JavaI18nUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelExpression";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestExpressionOfType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyValueParamsCount";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "buildUnescapedFormatString";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getSideText";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "composeParametersText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRange";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "mustBePropertyKey";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelExpression";
                break;
            }
            case 4: 
            case 13: 
            case 22: 
            case 23: 
            case 30: 
            case 37: 
            case 39: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isValidPropertyReference";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveResourceBundleByKey";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyRef";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addAvailableMethodsOfType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValuePlaceholdersCount";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "countFormatParameters";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValueParamsMaxCount";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValueParamsCount";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "buildUnescapedFormatString";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addChoicePattern";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getSideText";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "composeParametersText";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "resolveProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 13, 22, 23, 30, 37, 39 -> new IllegalStateException(string);
        };
    }
}

