/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineScopeInfo;
import org.jetbrains.kotlin.codegen.inline.InlineScopeUtilsKt;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006\u001a\u0018\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b*\u00020\nH\u0000\u001a\u0018\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b*\u00020\nH\u0002\u001a\u0012\u0010\f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\r\u001a\u00020\u0004\u001a\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\"\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\u00a8\u0006\u0013"}, d2={"updateCallSiteLineNumber", "", "name", "newLineNumber", "", "calculate", "Lkotlin/Function1;", "getLabelToIndexMap", "", "Lorg/jetbrains/org/objectweb/asm/Label;", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "getLabelToLineNumberMap", "addScopeInfo", "number", "getInlineDepth", "variableName", "isInlineLambdaName", "", "(Ljava/lang/String;)Z", "backend"})
@SourceDebugExtension(value={"SMAP\nInlineScopesGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineScopesGenerator.kt\norg/jetbrains/kotlin/codegen/inline/InlineScopesGeneratorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,411:1\n812#2,12:412\n1205#2,2:424\n1282#2,4:426\n*S KotlinDebug\n*F\n+ 1 InlineScopesGenerator.kt\norg/jetbrains/kotlin/codegen/inline/InlineScopesGeneratorKt\n*L\n369#1:412,12\n371#1:424,2\n371#1:426,4\n*E\n"})
public final class InlineScopesGeneratorKt {
    @NotNull
    public static final String updateCallSiteLineNumber(@NotNull String name, int newLineNumber) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return InlineScopesGeneratorKt.updateCallSiteLineNumber(name, (Function1<? super Integer, Integer>)((Function1)arg_0 -> InlineScopesGeneratorKt.updateCallSiteLineNumber$lambda$0(newLineNumber, arg_0)));
    }

    @NotNull
    public static final String updateCallSiteLineNumber(@NotNull String name, @NotNull Function1<? super Integer, Integer> calculate) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(calculate, (String)"calculate");
        InlineScopeInfo inlineScopeInfo = InlineScopeUtilsKt.getInlineScopeInfo(name);
        if (inlineScopeInfo == null) {
            return name;
        }
        InlineScopeInfo inlineScopeInfo2 = inlineScopeInfo;
        int scopeNumber = inlineScopeInfo2.component1();
        Integer callSiteLineNumber = inlineScopeInfo2.component2();
        Integer surroundingScopeNumber = inlineScopeInfo2.component3();
        if (callSiteLineNumber == null) {
            return name;
        }
        int newLineNumber = ((Number)calculate.invoke((Object)callSiteLineNumber)).intValue();
        if (newLineNumber == callSiteLineNumber) {
            return name;
        }
        String newName = InlineScopesGeneratorKt.addScopeInfo(InlineScopesGeneratorKt.addScopeInfo(InlineScopeUtilsKt.dropInlineScopeInfo(name), scopeNumber), newLineNumber);
        if (surroundingScopeNumber == null) {
            return newName;
        }
        return InlineScopesGeneratorKt.addScopeInfo(newName, surroundingScopeNumber);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<Label, Integer> getLabelToIndexMap(@NotNull MethodNode $this$getLabelToIndexMap) {
        void $this$associateTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getLabelToIndexMap, (String)"<this>");
        InsnList insnList = $this$getLabelToIndexMap.instructions;
        Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
        Iterable $this$filterIsInstance$iv = (Iterable)insnList;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LabelNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)((List)destination$iv$iv));
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            boolean bl = false;
            int index = indexedValue.component1();
            LabelNode labelNode = (LabelNode)indexedValue.component2();
            indexedValue = TuplesKt.to((Object)labelNode.getLabel(), (Object)index);
            map.put(indexedValue.getFirst(), indexedValue.getSecond());
        }
        return destination$iv$iv2;
    }

    private static final Map<Label, Integer> getLabelToLineNumberMap(MethodNode $this$getLabelToLineNumberMap) {
        Map result = new LinkedHashMap();
        int currentLineNumber = 0;
        ListIterator listIterator = $this$getLabelToLineNumberMap.instructions.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)listIterator, (String)"iterator(...)");
        ListIterator listIterator2 = listIterator;
        while (listIterator2.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)listIterator2.next();
            if (insn instanceof LineNumberNode) {
                currentLineNumber = ((LineNumberNode)insn).line;
                continue;
            }
            if (!(insn instanceof LabelNode)) continue;
            result.put(((LabelNode)insn).getLabel(), currentLineNumber);
        }
        return result;
    }

    @NotNull
    public static final String addScopeInfo(@NotNull String $this$addScopeInfo, int number) {
        Intrinsics.checkNotNullParameter((Object)$this$addScopeInfo, (String)"<this>");
        return $this$addScopeInfo + '\\' + number;
    }

    private static final int getInlineDepth(String variableName) {
        int depth = 0;
        int suffixLen = 3;
        for (int endIndex = variableName.length(); endIndex >= suffixLen; endIndex -= suffixLen) {
            String string = variableName.substring(endIndex - suffixLen, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            if (!Intrinsics.areEqual((Object)string, (Object)"$iv")) break;
            ++depth;
        }
        return depth;
    }

    private static final boolean isInlineLambdaName(String $this$isInlineLambdaName) {
        return StringsKt.startsWith$default((String)$this$isInlineLambdaName, (String)"$i$a$", (boolean)false, (int)2, null);
    }

    private static final int updateCallSiteLineNumber$lambda$0(int $newLineNumber, int it) {
        return $newLineNumber;
    }

    public static final /* synthetic */ boolean access$isInlineLambdaName(String $receiver) {
        return InlineScopesGeneratorKt.isInlineLambdaName($receiver);
    }

    public static final /* synthetic */ Map access$getLabelToLineNumberMap(MethodNode $receiver) {
        return InlineScopesGeneratorKt.getLabelToLineNumberMap($receiver);
    }

    public static final /* synthetic */ int access$getInlineDepth(String variableName) {
        return InlineScopesGeneratorKt.getInlineDepth(variableName);
    }
}

