/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.common.bazel;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/intellij/testFramework/common/bazel/BazelLabel;", "", "repo", "", "packageName", "target", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getRepo", "()Ljava/lang/String;", "getPackageName", "getTarget", "asLabel", "getAsLabel", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.platform.testFramework.common"})
@ApiStatus.Experimental
public final class BazelLabel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String repo;
    @NotNull
    private final String packageName;
    @NotNull
    private final String target;
    @NotNull
    private static final Regex regex = new Regex("@([a-zA-Z0-9_-]+)//([a-z0-9_/-]+)?:([a-zA-Z0-9._-]+)");

    public BazelLabel(@NotNull String repo, @NotNull String packageName, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.repo = repo;
        this.packageName = packageName;
        this.target = target;
    }

    @NotNull
    public final String getRepo() {
        return this.repo;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final String getTarget() {
        return this.target;
    }

    @NotNull
    public final String getAsLabel() {
        return "@" + this.repo + "//" + this.packageName + ":" + this.target;
    }

    @NotNull
    public final String component1() {
        return this.repo;
    }

    @NotNull
    public final String component2() {
        return this.packageName;
    }

    @NotNull
    public final String component3() {
        return this.target;
    }

    @NotNull
    public final BazelLabel copy(@NotNull String repo, @NotNull String packageName, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new BazelLabel(repo, packageName, target);
    }

    public static /* synthetic */ BazelLabel copy$default(BazelLabel bazelLabel, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = bazelLabel.repo;
        }
        if ((n & 2) != 0) {
            string2 = bazelLabel.packageName;
        }
        if ((n & 4) != 0) {
            string3 = bazelLabel.target;
        }
        return bazelLabel.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "BazelLabel(repo=" + this.repo + ", packageName=" + this.packageName + ", target=" + this.target + ")";
    }

    public int hashCode() {
        int result = this.repo.hashCode();
        result = result * 31 + this.packageName.hashCode();
        result = result * 31 + this.target.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BazelLabel)) {
            return false;
        }
        BazelLabel bazelLabel = (BazelLabel)other;
        if (!Intrinsics.areEqual((Object)this.repo, (Object)bazelLabel.repo)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.packageName, (Object)bazelLabel.packageName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.target, (Object)bazelLabel.target);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/testFramework/common/bazel/BazelLabel$Companion;", "", "<init>", "()V", "regex", "Lkotlin/text/Regex;", "fromString", "Lcom/intellij/testFramework/common/bazel/BazelLabel;", "label", "", "intellij.platform.testFramework.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BazelLabel fromString(@NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            MatchResult matchResult = regex.matchEntire((CharSequence)label);
            if (matchResult == null) {
                throw new IllegalStateException(("Bazel label must match '" + regex.getPattern() + "': " + label).toString());
            }
            MatchResult match = matchResult;
            return new BazelLabel((String)match.getGroupValues().get(1), (String)match.getGroupValues().get(2), (String)match.getGroupValues().get(3));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

