/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.NestedTable;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.JBIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StaticNestedTable
implements NestedTable {
    private final Object[][] myRowsValues;
    private final HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode myColumnsHierarchy;

    public StaticNestedTable(Object[][] values, HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode hierarchy) {
        this.myRowsValues = values;
        this.myColumnsHierarchy = hierarchy;
    }

    @Override
    public HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode getColumnsHierarchy() {
        return this.myColumnsHierarchy;
    }

    @Override
    public Object getValueAt(int rowIdx, int colIdx) {
        return this.myRowsValues[rowIdx][colIdx];
    }

    @Override
    public Object getValueAt(GridRow row, GridColumn column) {
        Object[] rowValues = this.myRowsValues[GridRow.toRealIdx(row)];
        if (column instanceof HierarchicalColumnsDataGridModel.HierarchicalGridColumn) {
            HierarchicalColumnsDataGridModel.HierarchicalGridColumn hierarchicalColumn = (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)column;
            return HierarchicalColumnsDataGridModel.extractValueByHierarchicalIndex(rowValues, hierarchicalColumn.getPathFromRoot());
        }
        return rowValues[column.getColumnNumber()];
    }

    @Override
    public void setValueAt(int rowIdx, int colIdx, Object value) {
        if (!this.isValidRowIdx(rowIdx) || !this.isValidColumnIdx(colIdx)) {
            return;
        }
        this.myRowsValues[rowIdx][colIdx] = value;
    }

    @Override
    public int getRowsNum() {
        return this.myRowsValues.length;
    }

    @Override
    public int getColumnsNum() {
        return this.myRowsValues.length > 0 ? this.myRowsValues[0].length : 0;
    }

    @Override
    public boolean isValidRowIdx(int rowIdx) {
        return rowIdx > -1 && rowIdx < this.getRowsNum();
    }

    @Override
    public boolean isValidColumnIdx(int colIdx) {
        return colIdx > -1 && colIdx < this.getColumnsNum();
    }

    @Override
    public int getColumnType(int colIdx) {
        if (!this.isValidColumnIdx(colIdx)) {
            throw new IllegalStateException("Given column index " + colIdx + " is not valid.");
        }
        TypeMerger merger = HierarchicalColumnsDataGridModel.determineColumnType(this.myRowsValues, new int[]{colIdx});
        return DocumentDataHookUp.DataMarkup.getType(merger);
    }

    @Override
    public String getColumnTypeName(int colIdx) {
        if (!this.isValidColumnIdx(colIdx)) {
            throw new IllegalStateException("Given column index " + colIdx + " is not valid.");
        }
        TypeMerger merger = HierarchicalColumnsDataGridModel.determineColumnType(this.myRowsValues, new int[]{colIdx});
        return merger.getName();
    }

    @Override
    public String getColumnName(int colIdx) {
        return this.myColumnsHierarchy.getChildren().get(colIdx).getName();
    }

    @Override
    public void addRow(GridRow value) {
        throw new IllegalStateException(String.format("The %s does not support rows addition, use another implementation instead.", this.getClass().getSimpleName()));
    }

    @Override
    @NotNull
    public Iterator<Map<String, Object>> iterator() {
        return new JBIterator<Map<String, Object>>(){
            private int myNextValueIdx;

            protected Map<String, Object> nextImpl() {
                return this.myNextValueIdx < StaticNestedTable.this.getRowsNum() ? StaticNestedTable.this.toMap(this.myNextValueIdx++) : (Map<String, Object>)this.stop();
            }
        };
    }

    private Map<String, Object> toMap(int rowIdx) {
        HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode root = this.myColumnsHierarchy;
        HashMap<String, Object> result = new HashMap<String, Object>();
        int i = 0;
        while (i < root.getChildren().size()) {
            HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode node = root.getChildren().get(i);
            this.dfs(rowIdx, node, result, new int[]{i++});
        }
        return result;
    }

    private void dfs(int rowIdx, HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode node, Map<String, Object> result, int[] path) {
        if (node.getChildren().isEmpty()) {
            Object value = HierarchicalColumnsDataGridModel.extractValueByHierarchicalIndex(this.myRowsValues[rowIdx], path);
            result.put(node.getName(), value);
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        int[] updatedPath = ArrayUtil.append((int[])path, (int)0);
        int lastIdx = updatedPath.length - 1;
        int idx = 0;
        while (idx < node.getChildren().size()) {
            HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode c = node.getChildren().get(idx);
            updatedPath[lastIdx] = idx++;
            this.dfs(rowIdx, c, data, updatedPath);
        }
        result.put(node.getName(), data);
    }
}

