/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileActionKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/actions/IgnoreFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "ignoreFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class IgnoreFileAction
extends DumbAwareAction {
    @NotNull
    private final VirtualFile ignoreFile;

    public IgnoreFileAction(@NotNull VirtualFile ignoreFile) {
        Intrinsics.checkNotNullParameter((Object)ignoreFile, (String)"ignoreFile");
        this.ignoreFile = ignoreFile;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)project2, (VirtualFile)this.ignoreFile);
        if (abstractVcs == null) {
            return;
        }
        AbstractVcs vcs = abstractVcs;
        VirtualFile virtualFile = this.ignoreFile.getParent();
        if (virtualFile == null) {
            return;
        }
        VirtualFile ignoreFileRoot = virtualFile;
        List<IgnoredFileBean> ignored = IgnoreFileActionKt.getIgnoredFileBeans(e, ignoreFileRoot, vcs);
        if (ignored.isEmpty()) {
            return;
        }
        IgnoreFileActionKt.writeIgnoreFileEntries$default(project2, this.ignoreFile, ignored, null, null, 24, null);
    }
}

