/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.rules.Example;
import ai.grazie.rules.MatchingResult;
import ai.grazie.rules.NodeRuleMatch;
import ai.grazie.rules.Rule;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.Tree;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZeroWidthSpaceRule
extends Rule {
    private static final Pattern regex = Pattern.compile("\\p{L}[\\p{L}\\d]*(\u200b+[\\p{L}\\d]+)+");
    private final String message;

    public ZeroWidthSpaceRule(String name, String description, @Nullable String url, String message, String exampleText) {
        super("Punctuation.ZERO_WIDTH_SPACE", name, description, url, new Example(exampleText, ZeroWidthSpaceRule.removeZeroWidthSpaces(exampleText)));
        this.message = message;
    }

    @Override
    public boolean supportsFlatTrees() {
        return true;
    }

    @Override
    @NotNull
    public MatchingResult match(Tree tree) {
        if (tree.nodes().isEmpty()) {
            tree = tree.getFlatTree();
        }
        String text = tree.text();
        for (int i = 1; i < text.length(); ++i) {
            if (text.charAt(i) != '\u200b') continue;
            return this.performRegexSearch(tree);
        }
        return MatchingResult.EMPTY;
    }

    private MatchingResult performRegexSearch(Tree tree) {
        ArrayList<NodeRuleMatch> matches = new ArrayList<NodeRuleMatch>();
        Matcher matcher = regex.matcher(tree.text());
        while (matcher.find()) {
            String clean = ZeroWidthSpaceRule.removeZeroWidthSpaces(matcher.group());
            if (!tree.treeSupport().tagToken(clean).hasPos(".*")) continue;
            int start = matcher.start();
            int end = matcher.end();
            matches.add(new NodeRuleMatch((Rule)this, NodeMatch.EMPTY.withAnchor(Objects.requireNonNull(tree.findNodeAt(start))).withMessage(this.message).withCorrector(NodeCorrector.rawReplace(start, end, clean).batchCapable("ZeroWidthSpace"))));
        }
        return MatchingResult.from(matches);
    }

    public static String removeZeroWidthSpaces(String s) {
        return s.replace("\u200b", "");
    }
}

