/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Point;
import java.util.Map;
import javax.swing.JScrollBar;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.HorizontalJScrollBarLocation;
import org.assertj.swing.driver.JScrollBarLocationStrategy;
import org.assertj.swing.driver.VerticalJScrollBarLocation;
import org.assertj.swing.util.Maps;

public final class JScrollBarLocation {
    private static final int BLOCK_OFFSET = 4;
    private static final Map<Integer, JScrollBarLocationStrategy> LOCATIONS = Maps.newHashMap();

    @Nonnull
    @RunsInCurrentThread
    public Point thumbLocation(@Nonnull JScrollBar scrollBar, int position) {
        double fraction = (double)position / (double)this.maximumMinusMinimum(scrollBar);
        return this.locationStrategyFor(scrollBar).thumbLocation(scrollBar, fraction);
    }

    @RunsInCurrentThread
    private int maximumMinusMinimum(@Nonnull JScrollBar scrollBar) {
        return scrollBar.getMaximum() - scrollBar.getMinimum();
    }

    @Nonnull
    @RunsInCurrentThread
    public Point blockLocationToScrollUp(@Nonnull JScrollBar scrollBar) {
        Point p = this.unitLocationToScrollUp(scrollBar);
        int offset = 4;
        return this.blockLocation(scrollBar, p, offset);
    }

    @Nonnull
    @RunsInCurrentThread
    public Point blockLocationToScrollDown(@Nonnull JScrollBar scrollBar) {
        Point p = this.unitLocationToScrollDown(scrollBar);
        int offset = -4;
        return this.blockLocation(scrollBar, p, offset);
    }

    @Nonnull
    @RunsInCurrentThread
    private Point blockLocation(@Nonnull JScrollBar scrollBar, @Nonnull Point unitLocation, int offset) {
        return this.locationStrategyFor(scrollBar).blockLocation(scrollBar, unitLocation, offset);
    }

    @Nonnull
    @RunsInCurrentThread
    public Point unitLocationToScrollUp(@Nonnull JScrollBar scrollBar) {
        int arrow = this.locationStrategyFor(scrollBar).arrow(scrollBar);
        return new Point(arrow / 2, arrow / 2);
    }

    @Nonnull
    @RunsInCurrentThread
    public Point unitLocationToScrollDown(@Nonnull JScrollBar scrollBar) {
        return this.locationStrategyFor(scrollBar).unitLocationToScrollDown(scrollBar);
    }

    @Nonnull
    @RunsInCurrentThread
    private JScrollBarLocationStrategy locationStrategyFor(JScrollBar scrollBar) {
        JScrollBarLocationStrategy strategy = LOCATIONS.get(scrollBar.getOrientation());
        return (JScrollBarLocationStrategy)Preconditions.checkNotNull((Object)strategy);
    }

    static {
        LOCATIONS.put(0, new HorizontalJScrollBarLocation());
        LOCATIONS.put(1, new VerticalJScrollBarLocation());
    }
}

