/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.file.BasicFileResolver;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.BuildOptionSet;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.StringBuildOption;

public class BuildLayoutParametersBuildOptions
extends BuildOptionSet<BuildLayoutParameters> {
    private static List<BuildOption<? super BuildLayoutParameters>> options;

    public List<BuildOption<? super BuildLayoutParameters>> getAllOptions() {
        return options;
    }

    static {
        ArrayList<StringBuildOption> options = new ArrayList<StringBuildOption>();
        options.add(new GradleUserHomeOption());
        options.add(new ProjectDirOption());
        BuildLayoutParametersBuildOptions.options = Collections.unmodifiableList(options);
    }

    public static class GradleUserHomeOption
    extends StringBuildOption<BuildLayoutParameters> {
        public GradleUserHomeOption() {
            super("gradle.user.home", new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"gradle-user-home", (String)"g", (String)"Specifies the Gradle user home directory. Defaults to ~/.gradle")});
        }

        public void applyTo(String value, BuildLayoutParameters settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setGradleUserHomeDir((File)resolver.transform((Object)value));
        }
    }

    public static class ProjectDirOption
    extends StringBuildOption<BuildLayoutParameters> {
        public ProjectDirOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"project-dir", (String)"p", (String)"Specifies the start directory for Gradle. Defaults to current directory.")});
        }

        public void applyTo(String value, BuildLayoutParameters settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            File projectDir = (File)resolver.transform((Object)value);
            settings.setCurrentDir(projectDir);
            settings.setProjectDir(projectDir);
        }
    }
}

