from esphome.components.mipi import DriverChip
import esphome.config_validation as cv

# fmt: off
DriverChip(
    "JC1060P470",
    width=1024,
    height=600,
    hsync_back_porch=160,
    hsync_pulse_width=40,
    hsync_front_porch=160,
    vsync_back_porch=23,
    vsync_pulse_width=10,
    vsync_front_porch=12,
    pclk_frequency="54MHz",
    lane_bit_rate="750Mbps",
    swap_xy=cv.UNDEFINED,
    color_order="RGB",
    initsequence=[
        (0x30, 0x00), (0xF7, 0x49, 0x61, 0x02, 0x00), (0x30, 0x01), (0x04, 0x0C), (0x05, 0x00), (0x06, 0x00),
        (0x0B, 0x11), (0x17, 0x00), (0x20, 0x04), (0x1F, 0x05), (0x23, 0x00), (0x25, 0x19), (0x28, 0x18), (0x29, 0x04), (0x2A, 0x01),
        (0x2B, 0x04), (0x2C, 0x01), (0x30, 0x02), (0x01, 0x22), (0x03, 0x12), (0x04, 0x00), (0x05, 0x64), (0x0A, 0x08),
        (0x0B, 0x0A, 0x1A, 0x0B, 0x0D, 0x0D, 0x11, 0x10, 0x06, 0x08, 0x1F, 0x1D),
        (0x0C, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D),
        (0x0D, 0x16, 0x1B, 0x0B, 0x0D, 0x0D, 0x11, 0x10, 0x07, 0x09, 0x1E, 0x1C),
        (0x0E, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D),
        (0x0F, 0x16, 0x1B, 0x0D, 0x0B, 0x0D, 0x11, 0x10, 0x1C, 0x1E, 0x09, 0x07),
        (0x10, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D),
        (0x11, 0x0A, 0x1A, 0x0D, 0x0B, 0x0D, 0x11, 0x10, 0x1D, 0x1F, 0x08, 0x06),
        (0x12, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D),
        (0x14, 0x00, 0x00, 0x11, 0x11), (0x18, 0x99), (0x30, 0x06),
        (0x12, 0x36, 0x2C, 0x2E, 0x3C, 0x38, 0x35, 0x35, 0x32, 0x2E, 0x1D, 0x2B, 0x21, 0x16, 0x29,),
        (0x13, 0x36, 0x2C, 0x2E, 0x3C, 0x38, 0x35, 0x35, 0x32, 0x2E, 0x1D, 0x2B, 0x21, 0x16, 0x29,),
        (0x30, 0x0A), (0x02, 0x4F), (0x0B, 0x40), (0x12, 0x3E), (0x13, 0x78), (0x30, 0x0D), (0x0D, 0x04),
        (0x10, 0x0C), (0x11, 0x0C), (0x12, 0x0C), (0x13, 0x0C), (0x30, 0x00),
    ],
)


# JC4880P443 Driver Configuration (ST7701)
# Using parameters from esp_lcd_st7701.h and the working full init sequence
# ----------------------------------------------------------------------------------------------------------------------
# * Resolution: 480x800
# * PCLK Frequency: 34 MHz
# * DSI Lane Bit Rate: 500 Mbps (using 2-Lane DSI configuration)
# * Horizontal Timing (hsync_pulse_width=12, hsync_back_porch=42, hsync_front_porch=42)
# * Vertical Timing (vsync_pulse_width=2, vsync_back_porch=8, vsync_front_porch=166)
# ----------------------------------------------------------------------------------------------------------------------
DriverChip(
    "JC4880P443",
    width=480,
    height=800,
    hsync_back_porch=42,
    hsync_pulse_width=12,
    hsync_front_porch=42,
    vsync_back_porch=8,
    vsync_pulse_width=2,
    vsync_front_porch=166,
    pclk_frequency="34MHz",
    lane_bit_rate="500Mbps",
    swap_xy=cv.UNDEFINED,
    color_order="RGB",
    reset_pin=5,
    initsequence=[
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x13),
        (0xEF, 0x08),
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x10),
        (0xC0, 0x63, 0x00),
        (0xC1, 0x0D, 0x02),
        (0xC2, 0x10, 0x08),
        (0xCC, 0x10),
        (0xB0, 0x80, 0x09, 0x53, 0x0C, 0xD0, 0x07, 0x0C, 0x09, 0x09, 0x28, 0x06, 0xD4, 0x13, 0x69, 0x2B, 0x71),
        (0xB1, 0x80, 0x94, 0x5A, 0x10, 0xD3, 0x06, 0x0A, 0x08, 0x08, 0x25, 0x03, 0xD3, 0x12, 0x66, 0x6A, 0x0D),
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x11),
        (0xB0, 0x5D),
        (0xB1, 0x58),
        (0xB2, 0x87),
        (0xB3, 0x80),
        (0xB5, 0x4E),
        (0xB7, 0x85),
        (0xB8, 0x21),
        (0xB9, 0x10, 0x1F),
        (0xBB, 0x03),
        (0xBC, 0x00),
        (0xC1, 0x78),
        (0xC2, 0x78),
        (0xD0, 0x88),
        (0xE0, 0x00, 0x3A, 0x02),
        (0xE1, 0x04, 0xA0, 0x00, 0xA0, 0x05, 0xA0, 0x00, 0xA0, 0x00, 0x40, 0x40),
        (0xE2, 0x30, 0x00, 0x40, 0x40, 0x32, 0xA0, 0x00, 0xA0, 0x00, 0xA0, 0x00, 0xA0, 0x00),
        (0xE3, 0x00, 0x00, 0x33, 0x33),
        (0xE4, 0x44, 0x44),
        (0xE5, 0x09, 0x2E, 0xA0, 0xA0, 0x0B, 0x30, 0xA0, 0xA0, 0x05, 0x2A, 0xA0, 0xA0, 0x07, 0x2C, 0xA0, 0xA0),
        (0xE6, 0x00, 0x00, 0x33, 0x33),
        (0xE7, 0x44, 0x44),
        (0xE8, 0x08, 0x2D, 0xA0, 0xA0, 0x0A, 0x2F, 0xA0, 0xA0, 0x04, 0x29, 0xA0, 0xA0, 0x06, 0x2B, 0xA0, 0xA0),
        (0xEB, 0x00, 0x00, 0x4E, 0x4E, 0x00, 0x00, 0x00),
        (0xEC, 0x08, 0x01),
        (0xED, 0xB0, 0x2B, 0x98, 0xA4, 0x56, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x65, 0x4A, 0x89, 0xB2, 0x0B),
        (0xEF, 0x08, 0x08, 0x08, 0x45, 0x3F, 0x54),
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x00),
    ]
)

# jc8012P4A1 Driver Configuration (jd9365)
# Using parameters from esp_lcd_jd9365.h and the working full init sequence
# ----------------------------------------------------------------------------------------------------------------------
# * Resolution: 800x1280
# * PCLK Frequency: 60 MHz
# * DSI Lane Bit Rate: 1 Gbps (using 2-Lane DSI configuration)
# * Horizontal Timing (hsync_pulse_width=20, hsync_back_porch=20, hsync_front_porch=40)
# * Vertical Timing (vsync_pulse_width=4, vsync_back_porch=8, vsync_front_porch=20)
# ----------------------------------------------------------------------------------------------------------------------
DriverChip(
    "JC8012P4A1",
    width=800,
    height=1280,
    hsync_back_porch=20,
    hsync_pulse_width=20,
    hsync_front_porch=40,
    vsync_back_porch=8,
    vsync_pulse_width=4,
    vsync_front_porch=20,
    pclk_frequency="60MHz",
    lane_bit_rate="1Gbps",
    swap_xy=cv.UNDEFINED,
    color_order="RGB",
    reset_pin=27,
    initsequence=[
        (0xE0, 0x00),
        (0xE1, 0x93),
        (0xE2, 0x65),
        (0xE3, 0xF8),
        (0x80, 0x01),
        (0xE0, 0x01),
        (0x00, 0x00),
        (0x01, 0x39),
        (0x03, 0x10),
        (0x04, 0x41),
        (0x0C, 0x74),
        (0x17, 0x00),
        (0x18, 0xD7),
        (0x19, 0x00),
        (0x1A, 0x00),
        (0x1B, 0xD7),
        (0x1C, 0x00),
        (0x24, 0xFE),
        (0x35, 0x26),
        (0x37, 0x69),
        (0x38, 0x05),
        (0x39, 0x06),
        (0x3A, 0x08),
        (0x3C, 0x78),
        (0x3D, 0xFF),
        (0x3E, 0xFF),
        (0x3F, 0xFF),
        (0x40, 0x06),
        (0x41, 0xA0),
        (0x43, 0x14),
        (0x44, 0x0B),
        (0x45, 0x30),
        (0x4B, 0x04),
        (0x55, 0x02),
        (0x57, 0x89),
        (0x59, 0x0A),
        (0x5A, 0x28),
        (0x5B, 0x15),
        (0x5D, 0x50),
        (0x5E, 0x37),
        (0x5F, 0x29),
        (0x60, 0x1E),
        (0x61, 0x1D),
        (0x62, 0x12),
        (0x63, 0x1A),
        (0x64, 0x08),
        (0x65, 0x25),
        (0x66, 0x26),
        (0x67, 0x28),
        (0x68, 0x49),
        (0x69, 0x3A),
        (0x6A, 0x43),
        (0x6B, 0x3A),
        (0x6C, 0x3B),
        (0x6D, 0x32),
        (0x6E, 0x1F),
        (0x6F, 0x0E),
        (0x70, 0x50),
        (0x71, 0x37),
        (0x72, 0x29),
        (0x73, 0x1E),
        (0x74, 0x1D),
        (0x75, 0x12),
        (0x76, 0x1A),
        (0x77, 0x08),
        (0x78, 0x25),
        (0x79, 0x26),
        (0x7A, 0x28),
        (0x7B, 0x49),
        (0x7C, 0x3A),
        (0x7D, 0x43),
        (0x7E, 0x3A),
        (0x7F, 0x3B),
        (0x80, 0x32),
        (0x81, 0x1F),
        (0x82, 0x0E),
        (0xE0, 0x02),
        (0x00, 0x1F),
        (0x01, 0x1F),
        (0x02, 0x52),
        (0x03, 0x51),
        (0x04, 0x50),
        (0x05, 0x4B),
        (0x06, 0x4A),
        (0x07, 0x49),
        (0x08, 0x48),
        (0x09, 0x47),
        (0x0A, 0x46),
        (0x0B, 0x45),
        (0x0C, 0x44),
        (0x0D, 0x40),
        (0x0E, 0x41),
        (0x0F, 0x1F),
        (0x10, 0x1F),
        (0x11, 0x1F),
        (0x12, 0x1F),
        (0x13, 0x1F),
        (0x14, 0x1F),
        (0x15, 0x1F),
        (0x16, 0x1F),
        (0x17, 0x1F),
        (0x18, 0x52),
        (0x19, 0x51),
        (0x1A, 0x50),
        (0x1B, 0x4B),
        (0x1C, 0x4A),
        (0x1D, 0x49),
        (0x1E, 0x48),
        (0x1F, 0x47),
        (0x20, 0x46),
        (0x21, 0x45),
        (0x22, 0x44),
        (0x23, 0x40),
        (0x24, 0x41),
        (0x25, 0x1F),
        (0x26, 0x1F),
        (0x27, 0x1F),
        (0x28, 0x1F),
        (0x29, 0x1F),
        (0x2A, 0x1F),
        (0x2B, 0x1F),
        (0x2C, 0x1F),
        (0x2D, 0x1F),
        (0x2E, 0x52),
        (0x2F, 0x40),
        (0x30, 0x41),
        (0x31, 0x48),
        (0x32, 0x49),
        (0x33, 0x4A),
        (0x34, 0x4B),
        (0x35, 0x44),
        (0x36, 0x45),
        (0x37, 0x46),
        (0x38, 0x47),
        (0x39, 0x51),
        (0x3A, 0x50),
        (0x3B, 0x1F),
        (0x3C, 0x1F),
        (0x3D, 0x1F),
        (0x3E, 0x1F),
        (0x3F, 0x1F),
        (0x40, 0x1F),
        (0x41, 0x1F),
        (0x42, 0x1F),
        (0x43, 0x1F),
        (0x44, 0x52),
        (0x45, 0x40),
        (0x46, 0x41),
        (0x47, 0x48),
        (0x48, 0x49),
        (0x49, 0x4A),
        (0x4A, 0x4B),
        (0x4B, 0x44),
        (0x4C, 0x45),
        (0x4D, 0x46),
        (0x4E, 0x47),
        (0x4F, 0x51),
        (0x50, 0x50),
        (0x51, 0x1F),
        (0x52, 0x1F),
        (0x53, 0x1F),
        (0x54, 0x1F),
        (0x55, 0x1F),
        (0x56, 0x1F),
        (0x57, 0x1F),
        (0x58, 0x40),
        (0x59, 0x00),
        (0x5A, 0x00),
        (0x5B, 0x10),
        (0x5C, 0x05),
        (0x5D, 0x50),
        (0x5E, 0x01),
        (0x5F, 0x02),
        (0x60, 0x50),
        (0x61, 0x06),
        (0x62, 0x04),
        (0x63, 0x03),
        (0x64, 0x64),
        (0x65, 0x65),
        (0x66, 0x0B),
        (0x67, 0x73),
        (0x68, 0x07),
        (0x69, 0x06),
        (0x6A, 0x64),
        (0x6B, 0x08),
        (0x6C, 0x00),
        (0x6D, 0x32),
        (0x6E, 0x08),
        (0xE0, 0x04),
        (0x2C, 0x6B),
        (0x35, 0x08),
        (0x37, 0x00),
        (0xE0, 0x00),
    ]
)
# fmt: on
