// java wrapper for vtkGraphItem object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGraphItem.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkContextItem_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGraphItem_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGraphItem",dType)) { return me; }
  if ((res= vtkContextItem_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGraphItem_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraphItem* op = static_cast<vtkGraphItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGraphItem_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraphItem* op = static_cast<vtkGraphItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraphItem_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraphItem* op = static_cast<vtkGraphItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraphItem_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraphItem* op = static_cast<vtkGraphItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphItem_SetGraph_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGraph * temp0;
  temp0 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraphItem* op = static_cast<vtkGraphItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGraph(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraphItem_GetGraph_15(JNIEnv* env, jobject obj)
{
  vtkGraph * temp20;

  vtkGraphItem* op = static_cast<vtkGraphItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGraph();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraphItem_GetLayout_16(JNIEnv* env, jobject obj)
{
  vtkIncrementalForceLayout * temp20;

  vtkGraphItem* op = static_cast<vtkGraphItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLayout();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphItem_StartLayoutAnimation_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindowInteractor * temp0;
  temp0 = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraphItem* op = static_cast<vtkGraphItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartLayoutAnimation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphItem_StopLayoutAnimation_18(JNIEnv* env, jobject obj)
{

  vtkGraphItem* op = static_cast<vtkGraphItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->StopLayoutAnimation();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphItem_UpdateLayout_19(JNIEnv* env, jobject obj)
{

  vtkGraphItem* op = static_cast<vtkGraphItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateLayout();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGraphItem_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGraphItem::New());
}
