// java wrapper for vtkTextActor3D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTextActor3D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkProp3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTextActor3D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTextActor3D",dType)) { return me; }
  if ((res= vtkProp3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor3D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor3D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextActor3D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextActor3D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor3D_SetInput_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInput(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTextActor3D_GetInput_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor3D_SetTextProperty_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextActor3D_GetTextProperty_17(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor3D_GetRenderedDPI_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderedDPI();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor3D_ShallowCopy_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkTextActor3D_GetBounds_110(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor3D_GetBounds_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor3D_GetBoundingBox_112(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[4];
  int   temp20;
  env->GetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBoundingBox(temp0);
  env->SetIntArrayRegion(id0, 0, 4, reinterpret_cast<jint*>(&temp0[0]));
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor3D_ReleaseGraphicsResources_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor3D_SetForceOpaque_114(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForceOpaque(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextActor3D_GetForceOpaque_115(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetForceOpaque();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor3D_ForceOpaqueOn_116(JNIEnv* env, jobject obj)
{

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceOpaqueOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor3D_ForceOpaqueOff_117(JNIEnv* env, jobject obj)
{

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceOpaqueOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor3D_SetForceTranslucent_118(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForceTranslucent(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTextActor3D_GetForceTranslucent_119(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetForceTranslucent();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor3D_ForceTranslucentOn_120(JNIEnv* env, jobject obj)
{

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceTranslucentOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextActor3D_ForceTranslucentOff_121(JNIEnv* env, jobject obj)
{

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceTranslucentOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor3D_RenderOpaqueGeometry_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor3D_RenderTranslucentPolygonalGeometry_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor3D_RenderOverlay_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextActor3D_HasTranslucentPolygonalGeometry_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTextActor3D* op = static_cast<vtkTextActor3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTextActor3D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTextActor3D::New());
}
