// java wrapper for vtkImageViewer object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageViewer.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageViewer_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageViewer",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageViewer_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageViewer_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageViewer_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageViewer_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageViewer_GetWindowName_14(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWindowName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer_Render_15(JNIEnv* env, jobject obj)
{

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer_SetInputData_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageData * temp0;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageViewer_GetInput_17(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer_SetInputConnection_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputConnection(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageViewer_GetWholeZMin_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWholeZMin();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageViewer_GetWholeZMax_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWholeZMax();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageViewer_GetZSlice_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZSlice();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer_SetZSlice_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZSlice(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageViewer_GetColorWindow_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorWindow();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageViewer_GetColorLevel_114(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorLevel();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer_SetColorWindow_115(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorWindow(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer_SetColorLevel_116(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorLevel(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageViewer_GetPosition_117(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer_SetPosition_118(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer_SetPosition_119(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageViewer_GetSize_120(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer_SetSize_121(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer_SetSize_122(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageViewer_GetRenderWindow_123(JNIEnv* env, jobject obj)
{
  vtkRenderWindow * temp20;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderWindow();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer_SetRenderWindow_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderWindow(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageViewer_GetRenderer_125(JNIEnv* env, jobject obj)
{
  vtkRenderer * temp20;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderer();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageViewer_GetImageMapper_126(JNIEnv* env, jobject obj)
{
  vtkImageMapper * temp20;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageMapper();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageViewer_GetActor2D_127(JNIEnv* env, jobject obj)
{
  vtkActor2D * temp20;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActor2D();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer_SetupInteractor_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindowInteractor * temp0;
  temp0 = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetupInteractor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer_SetOffScreenRendering_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOffScreenRendering(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageViewer_GetOffScreenRendering_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffScreenRendering();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer_OffScreenRenderingOn_131(JNIEnv* env, jobject obj)
{

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  op->OffScreenRenderingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageViewer_OffScreenRenderingOff_132(JNIEnv* env, jobject obj)
{

  vtkImageViewer* op = static_cast<vtkImageViewer*>(vtkJavaGetPointerFromObject(env, obj));
  op->OffScreenRenderingOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageViewer_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageViewer::New());
}
