// java wrapper for vtkMySQLDatabase object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMySQLDatabase.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkSQLDatabase_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMySQLDatabase_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMySQLDatabase",dType)) { return me; }
  if ((res= vtkSQLDatabase_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMySQLDatabase_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMySQLDatabase_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMySQLDatabase_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMySQLDatabase_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMySQLDatabase_Open_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Open(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMySQLDatabase_Close_15(JNIEnv* env, jobject obj)
{

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  op->Close();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMySQLDatabase_IsOpen_16(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsOpen();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMySQLDatabase_GetQueryInstance_17(JNIEnv* env, jobject obj)
{
  vtkSQLQuery * temp20;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetQueryInstance();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMySQLDatabase_GetTables_18(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTables();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMySQLDatabase_GetRecord_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkStringArray * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRecord(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMySQLDatabase_IsSupported_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsSupported(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMySQLDatabase_HasError_111(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasError();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMySQLDatabase_GetLastErrorText_112(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastErrorText();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMySQLDatabase_GetDatabaseType_113(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDatabaseType();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMySQLDatabase_SetHostName_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHostName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMySQLDatabase_GetHostName_115(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHostName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMySQLDatabase_SetUser_116(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUser(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMySQLDatabase_GetUser_117(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUser();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMySQLDatabase_SetPassword_118(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPassword(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMySQLDatabase_SetDatabaseName_119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDatabaseName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMySQLDatabase_GetDatabaseName_120(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDatabaseName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMySQLDatabase_SetReconnect_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReconnect(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMySQLDatabase_GetReconnect_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReconnect();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMySQLDatabase_ReconnectOn_123(JNIEnv* env, jobject obj)
{

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReconnectOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMySQLDatabase_ReconnectOff_124(JNIEnv* env, jobject obj)
{

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReconnectOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMySQLDatabase_SetServerPort_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetServerPort(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMySQLDatabase_GetServerPortMinValue_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetServerPortMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMySQLDatabase_GetServerPortMaxValue_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetServerPortMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMySQLDatabase_GetServerPort_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetServerPort();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMySQLDatabase_GetURL_129(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetURL();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMySQLDatabase_GetTablePreamble_130(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  vtkStdString   temp20;
  temp0 = (id0 != 0) ? true : false;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTablePreamble(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMySQLDatabase_GetColumnSpecification_131(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkSQLDatabaseSchema * temp0;
  int   temp1;
  int   temp2;
  vtkStdString   temp20;
  temp0 = static_cast<vtkSQLDatabaseSchema*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColumnSpecification(temp0,temp1,temp2);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMySQLDatabase_CreateDatabase_132(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1)
{
  char * temp0;
  bool   temp1;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateDatabase(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMySQLDatabase_DropDatabase_133(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DropDatabase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMySQLDatabase_ParseURL_134(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMySQLDatabase* op = static_cast<vtkMySQLDatabase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ParseURL(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkMySQLDatabase_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkMySQLDatabase::New());
}
