// java wrapper for vtkGLTFExporter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGLTFExporter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkExporter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGLTFExporter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGLTFExporter",dType)) { return me; }
  if ((res= vtkExporter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGLTFExporter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGLTFExporter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFExporter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGLTFExporter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFExporter_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGLTFExporter_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGLTFExporter_GetInlineData_16(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInlineData();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFExporter_SetInlineData_17(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInlineData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFExporter_InlineDataOn_18(JNIEnv* env, jobject obj)
{

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->InlineDataOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFExporter_InlineDataOff_19(JNIEnv* env, jobject obj)
{

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->InlineDataOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGLTFExporter_GetSaveNormal_110(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSaveNormal();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFExporter_SetSaveNormal_111(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSaveNormal(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFExporter_SaveNormalOn_112(JNIEnv* env, jobject obj)
{

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SaveNormalOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFExporter_SaveNormalOff_113(JNIEnv* env, jobject obj)
{

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SaveNormalOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGLTFExporter_GetSaveBatchId_114(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSaveBatchId();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFExporter_SetSaveBatchId_115(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSaveBatchId(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFExporter_SaveBatchIdOn_116(JNIEnv* env, jobject obj)
{

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SaveBatchIdOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFExporter_SaveBatchIdOff_117(JNIEnv* env, jobject obj)
{

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SaveBatchIdOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGLTFExporter_GetSaveNaNValues_118(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSaveNaNValues();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFExporter_SetSaveNaNValues_119(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSaveNaNValues(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFExporter_SaveNaNValuesOn_120(JNIEnv* env, jobject obj)
{

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SaveNaNValuesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGLTFExporter_SaveNaNValuesOff_121(JNIEnv* env, jobject obj)
{

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SaveNaNValuesOff();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGLTFExporter_WriteToString_122(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkGLTFExporter* op = static_cast<vtkGLTFExporter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->WriteToString();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGLTFExporter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGLTFExporter::New());
}
