// java wrapper for vtkPKdTree object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPKdTree.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkKdTree_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPKdTree_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPKdTree",dType)) { return me; }
  if ((res= vtkKdTree_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPKdTree_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPKdTree_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPKdTree_BuildLocator_14(JNIEnv* env, jobject obj)
{

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildLocator();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPKdTree_GetTotalNumberOfCells_15(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTotalNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_CreateProcessCellCountData_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateProcessCellCountData();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_CreateGlobalDataArrayBounds_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateGlobalDataArrayBounds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPKdTree_SetController_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMultiProcessController * temp0;
  temp0 = static_cast<vtkMultiProcessController*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetController(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPKdTree_GetController_19(JNIEnv* env, jobject obj)
{
  vtkMultiProcessController * temp20;

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetController();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetRegionAssignment_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRegionAssignment();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_AssignRegionsRoundRobin_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AssignRegionsRoundRobin();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_AssignRegionsContiguous_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AssignRegionsContiguous();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetRegionAssignmentMapLength_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRegionAssignmentMapLength();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetRegionAssignmentList_114(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIntArray * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRegionAssignmentList(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPKdTree_GetAllProcessesBorderingOnPoint_115(JNIEnv* env, jobject obj,jfloat id0,jfloat id1,jfloat id2,jobject id3)
{
  float   temp0;
  float   temp1;
  float   temp2;
  vtkIntArray * temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id3));

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetAllProcessesBorderingOnPoint(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetProcessAssignedToRegion_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProcessAssignedToRegion(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_HasData_117(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasData(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetProcessCellCountForRegion_118(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProcessCellCountForRegion(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetTotalProcessesInRegion_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTotalProcessesInRegion(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetProcessListForRegion_120(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIntArray * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProcessListForRegion(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetTotalRegionsForProcess_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTotalRegionsForProcess(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetRegionListForProcess_122(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIntArray * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRegionListForProcess(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPKdTree_GetCellListsForProcessRegions_123(JNIEnv* env, jobject obj,jint id0,jint id1,jobject id2,jobject id3)
{
  int   temp0;
  int   temp1;
  vtkIdList * temp2;
  vtkIdList * temp3;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id3));

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellListsForProcessRegions(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPKdTree_GetCellListsForProcessRegions_124(JNIEnv* env, jobject obj,jint id0,jobject id1,jobject id2,jobject id3)
{
  int   temp0;
  vtkDataSet * temp1;
  vtkIdList * temp2;
  vtkIdList * temp3;
  long long   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id3));

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellListsForProcessRegions(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPKdTree_GetCellListsForProcessRegions_125(JNIEnv* env, jobject obj,jint id0,jobject id1,jobject id2)
{
  int   temp0;
  vtkIdList * temp1;
  vtkIdList * temp2;
  long long   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellListsForProcessRegions(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_ViewOrderAllProcessesInDirection_126(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1)
{
  double temp0[3];
  vtkIntArray * temp1;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ViewOrderAllProcessesInDirection(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_ViewOrderAllProcessesFromPosition_127(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1)
{
  double temp0[3];
  vtkIntArray * temp1;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ViewOrderAllProcessesFromPosition(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetCellArrayGlobalRange_128(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloatArray id1)
{
  char * temp0;
  float temp1[2];
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetFloatArrayRegion(id1, 0, 2, &temp1[0]);

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayGlobalRange(temp0,temp1);
  delete[] temp0;
  env->SetFloatArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetPointArrayGlobalRange_129(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloatArray id1)
{
  char * temp0;
  float temp1[2];
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetFloatArrayRegion(id1, 0, 2, &temp1[0]);

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayGlobalRange(temp0,temp1);
  delete[] temp0;
  env->SetFloatArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetCellArrayGlobalRange_130(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdoubleArray id1)
{
  char * temp0;
  double temp1[2];
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayGlobalRange(temp0,temp1);
  delete[] temp0;
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetPointArrayGlobalRange_131(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdoubleArray id1)
{
  char * temp0;
  double temp1[2];
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayGlobalRange(temp0,temp1);
  delete[] temp0;
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetCellArrayGlobalRange_132(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[2];
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayGlobalRange(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetPointArrayGlobalRange_133(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[2];
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayGlobalRange(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetCellArrayGlobalRange_134(JNIEnv* env, jobject obj,jint id0,jfloatArray id1)
{
  int   temp0;
  float temp1[2];
  int   temp20;
  temp0 = id0;
  env->GetFloatArrayRegion(id1, 0, 2, &temp1[0]);

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayGlobalRange(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPKdTree_GetPointArrayGlobalRange_135(JNIEnv* env, jobject obj,jint id0,jfloatArray id1)
{
  int   temp0;
  float temp1[2];
  int   temp20;
  temp0 = id0;
  env->GetFloatArrayRegion(id1, 0, 2, &temp1[0]);

  vtkPKdTree* op = static_cast<vtkPKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayGlobalRange(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPKdTree_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPKdTree::New());
}
