// java wrapper for vtkMoleculeMapper object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMoleculeMapper.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkMapper_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMoleculeMapper_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMoleculeMapper",dType)) { return me; }
  if ((res= vtkMapper_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMoleculeMapper_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMoleculeMapper_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMoleculeMapper_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMoleculeMapper_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetInputData_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMolecule * temp0;
  temp0 = static_cast<vtkMolecule*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMoleculeMapper_GetInput_15(JNIEnv* env, jobject obj)
{
  vtkMolecule * temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_UseBallAndStickSettings_16(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseBallAndStickSettings();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_UseVDWSpheresSettings_17(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseVDWSpheresSettings();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_UseLiquoriceStickSettings_18(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseLiquoriceStickSettings();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_UseFastSettings_19(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseFastSettings();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMoleculeMapper_GetRenderAtoms_110(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderAtoms();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetRenderAtoms_111(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderAtoms(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_RenderAtomsOn_112(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderAtomsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_RenderAtomsOff_113(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderAtomsOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMoleculeMapper_GetRenderBonds_114(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderBonds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetRenderBonds_115(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderBonds(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_RenderBondsOn_116(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderBondsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_RenderBondsOff_117(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderBondsOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMoleculeMapper_GetRenderLattice_118(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderLattice();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetRenderLattice_119(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderLattice(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_RenderLatticeOn_120(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderLatticeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_RenderLatticeOff_121(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderLatticeOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMoleculeMapper_GetAtomicRadiusType_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAtomicRadiusType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetAtomicRadiusType_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAtomicRadiusType(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMoleculeMapper_GetAtomicRadiusTypeAsString_124(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAtomicRadiusTypeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetAtomicRadiusTypeToCovalentRadius_125(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAtomicRadiusTypeToCovalentRadius();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetAtomicRadiusTypeToVDWRadius_126(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAtomicRadiusTypeToVDWRadius();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetAtomicRadiusTypeToUnitRadius_127(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAtomicRadiusTypeToUnitRadius();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetAtomicRadiusTypeToCustomArrayRadius_128(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAtomicRadiusTypeToCustomArrayRadius();

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkMoleculeMapper_GetAtomicRadiusScaleFactor_129(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAtomicRadiusScaleFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetAtomicRadiusScaleFactor_130(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAtomicRadiusScaleFactor(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMoleculeMapper_GetUseMultiCylindersForBonds_131(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseMultiCylindersForBonds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetUseMultiCylindersForBonds_132(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseMultiCylindersForBonds(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_UseMultiCylindersForBondsOn_133(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseMultiCylindersForBondsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_UseMultiCylindersForBondsOff_134(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseMultiCylindersForBondsOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMoleculeMapper_GetBondColorMode_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBondColorMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetBondColorMode_136(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBondColorMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMoleculeMapper_GetBondColorModeMinValue_137(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBondColorModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMoleculeMapper_GetBondColorModeMaxValue_138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBondColorModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetBondColorModeToSingleColor_139(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBondColorModeToSingleColor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetBondColorModeToDiscreteByAtom_140(JNIEnv* env, jobject obj)
{

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBondColorModeToDiscreteByAtom();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMoleculeMapper_GetBondColorModeAsString_141(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBondColorModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMoleculeMapper_GetAtomColorMode_142(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAtomColorMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetAtomColorMode_143(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAtomColorMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMoleculeMapper_GetAtomColorModeMinValue_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAtomColorModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMoleculeMapper_GetAtomColorModeMaxValue_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAtomColorModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMoleculeMapper_GetAtomColor_146(JNIEnv* env, jobject obj)
{
   unsigned char * temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAtomColor();
  return vtkJavaMakeJArrayOfByte(env, reinterpret_cast<jbyte*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetAtomColor_147(JNIEnv* env, jobject obj,jbyte id0,jbyte id1,jbyte id2)
{
   unsigned char   temp0;
   unsigned char   temp1;
   unsigned char   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAtomColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMoleculeMapper_GetBondColor_148(JNIEnv* env, jobject obj)
{
   unsigned char * temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBondColor();
  return vtkJavaMakeJArrayOfByte(env, reinterpret_cast<jbyte*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetBondColor_149(JNIEnv* env, jobject obj,jbyte id0,jbyte id1,jbyte id2)
{
   unsigned char   temp0;
   unsigned char   temp1;
   unsigned char   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBondColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkMoleculeMapper_GetBondRadius_150(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBondRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetBondRadius_151(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBondRadius(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMoleculeMapper_GetLatticeColor_152(JNIEnv* env, jobject obj)
{
   unsigned char * temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLatticeColor();
  return vtkJavaMakeJArrayOfByte(env, reinterpret_cast<jbyte*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetLatticeColor_153(JNIEnv* env, jobject obj,jbyte id0,jbyte id1,jbyte id2)
{
   unsigned char   temp0;
   unsigned char   temp1;
   unsigned char   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLatticeColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_GetSelectedAtomsAndBonds_154(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkSelection * temp0;
  vtkIdTypeArray * temp1;
  vtkIdTypeArray * temp2;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSelectedAtomsAndBonds(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_GetSelectedAtoms_155(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkSelection * temp0;
  vtkIdTypeArray * temp1;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSelectedAtoms(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_GetSelectedBonds_156(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkSelection * temp0;
  vtkIdTypeArray * temp1;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSelectedBonds(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_Render_157(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkRenderer * temp0;
  vtkActor * temp1;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkActor*>(vtkJavaGetPointerFromObject(env, id1));

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_ReleaseGraphicsResources_158(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_GetBounds_159(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMoleculeMapper_FillInputPortInformation_160(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkInformation * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id1));

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FillInputPortInformation(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMoleculeMapper_GetSupportsSelection_161(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSupportsSelection();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMoleculeMapper_GetAtomicRadiusArrayName_162(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAtomicRadiusArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetAtomicRadiusArrayName_163(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAtomicRadiusArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMoleculeMapper_SetMapScalars_164(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMapScalars(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMoleculeMapper_GetPeriodicTable_165(JNIEnv* env, jobject obj)
{
  vtkPeriodicTable * temp20;

  vtkMoleculeMapper* op = static_cast<vtkMoleculeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPeriodicTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkMoleculeMapper_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkMoleculeMapper::New());
}
