// java wrapper for vtkCompositeDataSet object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCompositeDataSet.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCompositeDataSet_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCompositeDataSet",dType)) { return me; }
  if ((res= vtkDataObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCompositeDataSet_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCompositeDataSet_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataSet_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataSet_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataSet_NewIterator_14(JNIEnv* env, jobject obj)
{
  vtkCompositeDataIterator * temp20;

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewIterator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCompositeDataSet_GetDataObjectType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataSet_CopyStructure_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCompositeDataSet * temp0;
  temp0 = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyStructure(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataSet_SetDataSet_17(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkCompositeDataIterator * temp0;
  vtkDataObject * temp1;
  temp0 = static_cast<vtkCompositeDataIterator*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSet(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataSet_GetDataSet_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCompositeDataIterator * temp0;
  vtkDataObject * temp20;
  temp0 = static_cast<vtkCompositeDataIterator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSet(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataSet_GetDataSet_19(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  vtkDataObject * temp20;
  temp0 = id0;

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSet(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataSet_GetActualMemorySize_110(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataSet_GetData_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkCompositeDataSet * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataSet_GetData_112(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkCompositeDataSet * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataSet_Initialize_113(JNIEnv* env, jobject obj)
{

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataSet_CompositeShallowCopy_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCompositeDataSet * temp0;
  temp0 = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->CompositeShallowCopy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataSet_GetNumberOfPoints_115(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataSet_GetNumberOfCells_116(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataSet_GetNumberOfElements_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElements(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositeDataSet_GetBounds_118(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataSet_NAME_119(JNIEnv* env, jobject obj)
{
  vtkInformationStringKey * temp20;

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NAME();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositeDataSet_CURRENT_1PROCESS_1CAN_1LOAD_1BLOCK_120(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CURRENT_PROCESS_CAN_LOAD_BLOCK();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositeDataSet_SupportsGhostArray_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkCompositeDataSet* op = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SupportsGhostArray(temp0);
  return temp20;

}
