// java wrapper for vtkObjectBase object
//
#define VTK_WRAPPING_CXX
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkObjectBase.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>

extern "C" JNIEXPORT void* vtkObjectBase_Typecast(void* me,char* dType)
{
  if (!strcmp("vtkObjectBase",dType)) { return me; }
  return nullptr;
}


extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkObjectBase_GetClassName_10(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClassName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkObjectBase_GetObjectDescription_11(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetObjectDescription();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObjectBase_IsTypeOf_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObjectBase_IsA_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkObjectBase_GetNumberOfGenerationsFromBaseType_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkObjectBase_GetNumberOfGenerationsFromBase_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObjectBase_FastDelete_16(JNIEnv* env, jobject obj)
{

  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  op->FastDelete();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObjectBase_InitializeObjectBase_17(JNIEnv* env, jobject obj)
{

  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeObjectBase();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObjectBase_Register_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkObjectBase * temp0;
  temp0 = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, id0));

  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  op->Register(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObjectBase_UnRegister_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkObjectBase * temp0;
  temp0 = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, id0));

  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnRegister(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkObjectBase_UsesGarbageCollector_110(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UsesGarbageCollector();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkObjectBase_GetReferenceCount_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReferenceCount();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObjectBase_SetReferenceCount_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReferenceCount(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkObjectBase_SetMemkindDirectory_113(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMemkindDirectory(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkObjectBase_GetUsingMemkind_114(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUsingMemkind();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkObjectBase_GetIsInMemkind_115(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIsInMemkind();
  return temp20;

}

extern "C" JNIEXPORT void JNICALL Java_vtk_vtkObjectBase_VTKDeleteReference(JNIEnv*,jclass,jlong id)
  {
  vtkObjectBase* op = reinterpret_cast<vtkObjectBase*>(id);
  op->Delete();
}

extern "C" JNIEXPORT jbyteArray JNICALL Java_vtk_vtkObjectBase_VTKGetClassNameBytesFromReference(JNIEnv* env,jclass,jlong id)
{
  const char* name = "";
  if(id != 0)
  {
    vtkObjectBase* op = reinterpret_cast<vtkObjectBase*>(id);
    name = op->GetClassName();
  }
  return (name == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, name, strlen(name));
}

extern "C" JNIEXPORT void JNICALL Java_vtk_vtkObjectBase_VTKDelete(JNIEnv* env,jobject obj)
  {
  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  op->Delete();
}

extern "C" JNIEXPORT void JNICALL Java_vtk_vtkObjectBase_VTKRegister(JNIEnv* env,jobject obj)
  {
 vtkObjectBase*  op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  op->Register(op);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkObjectBase_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkObjectBase::New());
}

extern "C" JNIEXPORT jbyteArray JNICALL Java_vtk_vtkObjectBase_PrintBytes(JNIEnv* env, jobject obj)
{
  vtkObjectBase* op = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, obj));
  std::ostringstream stream;
  op->Print(stream);
  stream.put('\0');
  return vtkJavaStringToUTF8(env, stream.str());
}
