// python wrapper for vtkH5PartReader
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkH5PartReader.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkH5PartReader(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkH5PartReader_ClassNew(); }


static PyObject *
PyvtkH5PartReader_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkH5PartReader::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkH5PartReader::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkH5PartReader *tempr = vtkH5PartReader::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkH5PartReader *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkH5PartReader::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkH5PartReader::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkH5PartReader::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  size_t size0 = ap.GetStringSize(0);
  vtkPythonArgs::Array<char> store0(2*size0 + 1);
  char *temp0 = store0.Data();
  char *save0 = temp0 + size0 + 1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkH5PartReader::SetFileName(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkH5PartReader::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetXarray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXarray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetXarray() :
      op->vtkH5PartReader::GetXarray());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_SetXarray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetXarray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetXarray(temp0);
    }
    else
    {
      op->vtkH5PartReader::SetXarray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetYarray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetYarray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetYarray() :
      op->vtkH5PartReader::GetYarray());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_SetYarray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetYarray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetYarray(temp0);
    }
    else
    {
      op->vtkH5PartReader::SetYarray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetZarray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZarray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetZarray() :
      op->vtkH5PartReader::GetZarray());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_SetZarray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZarray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZarray(temp0);
    }
    else
    {
      op->vtkH5PartReader::SetZarray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_SetGenerateVertexCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateVertexCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateVertexCells(temp0);
    }
    else
    {
      op->vtkH5PartReader::SetGenerateVertexCells(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetGenerateVertexCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateVertexCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGenerateVertexCells() :
      op->vtkH5PartReader::GetGenerateVertexCells());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GenerateVertexCellsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateVertexCellsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateVertexCellsOn();
    }
    else
    {
      op->vtkH5PartReader::GenerateVertexCellsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GenerateVertexCellsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateVertexCellsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateVertexCellsOff();
    }
    else
    {
      op->vtkH5PartReader::GenerateVertexCellsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_SetCombineVectorComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCombineVectorComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCombineVectorComponents(temp0);
    }
    else
    {
      op->vtkH5PartReader::SetCombineVectorComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetCombineVectorComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCombineVectorComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCombineVectorComponents() :
      op->vtkH5PartReader::GetCombineVectorComponents());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_CombineVectorComponentsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CombineVectorComponentsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CombineVectorComponentsOn();
    }
    else
    {
      op->vtkH5PartReader::CombineVectorComponentsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_CombineVectorComponentsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CombineVectorComponentsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CombineVectorComponentsOff();
    }
    else
    {
      op->vtkH5PartReader::CombineVectorComponentsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_SetMaskOutOfTimeRangeOutput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaskOutOfTimeRangeOutput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaskOutOfTimeRangeOutput(temp0);
    }
    else
    {
      op->vtkH5PartReader::SetMaskOutOfTimeRangeOutput(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetMaskOutOfTimeRangeOutput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaskOutOfTimeRangeOutput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMaskOutOfTimeRangeOutput() :
      op->vtkH5PartReader::GetMaskOutOfTimeRangeOutput());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_MaskOutOfTimeRangeOutputOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MaskOutOfTimeRangeOutputOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MaskOutOfTimeRangeOutputOn();
    }
    else
    {
      op->vtkH5PartReader::MaskOutOfTimeRangeOutputOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_MaskOutOfTimeRangeOutputOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MaskOutOfTimeRangeOutputOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MaskOutOfTimeRangeOutputOff();
    }
    else
    {
      op->vtkH5PartReader::MaskOutOfTimeRangeOutputOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetNumberOfPointArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfPointArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfPointArrays() :
      op->vtkH5PartReader::GetNumberOfPointArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetPointArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetPointArrayName(temp0) :
      op->vtkH5PartReader::GetPointArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetPointArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPointArrayStatus(temp0) :
      op->vtkH5PartReader::GetPointArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_SetPointArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetPointArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkH5PartReader::SetPointArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_DisableAll(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DisableAll");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DisableAll();
    }
    else
    {
      op->vtkH5PartReader::DisableAll();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_EnableAll(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableAll");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableAll();
    }
    else
    {
      op->vtkH5PartReader::EnableAll();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_Disable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Disable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Disable(temp0);
    }
    else
    {
      op->vtkH5PartReader::Disable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_Enable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Enable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Enable(temp0);
    }
    else
    {
      op->vtkH5PartReader::Enable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetNumberOfPointArrayStatusArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfPointArrayStatusArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfPointArrayStatusArrays() :
      op->vtkH5PartReader::GetNumberOfPointArrayStatusArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetPointArrayStatusArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointArrayStatusArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetPointArrayStatusArrayName(temp0) :
      op->vtkH5PartReader::GetPointArrayStatusArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetPointArrayStatusArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointArrayStatusArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPointArrayStatusArrayStatus(temp0) :
      op->vtkH5PartReader::GetPointArrayStatusArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_SetPointArrayStatusArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointArrayStatusArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetPointArrayStatusArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkH5PartReader::SetPointArrayStatusArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetNumberOfCoordinateArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfCoordinateArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfCoordinateArrays() :
      op->vtkH5PartReader::GetNumberOfCoordinateArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetCoordinateArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCoordinateArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetCoordinateArrayName(temp0) :
      op->vtkH5PartReader::GetCoordinateArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_GetCoordinateArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCoordinateArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCoordinateArrayStatus(temp0) :
      op->vtkH5PartReader::GetCoordinateArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkH5PartReader_SetCoordinateArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCoordinateArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkH5PartReader *op = static_cast<vtkH5PartReader *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetCoordinateArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkH5PartReader::SetCoordinateArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkH5PartReader_Methods[] = {
  {"IsTypeOf", PyvtkH5PartReader_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkH5PartReader_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkH5PartReader_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkH5PartReader\nC++: static vtkH5PartReader *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkH5PartReader_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkH5PartReader\nC++: vtkH5PartReader *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkH5PartReader_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkH5PartReader_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetFileName", PyvtkH5PartReader_SetFileName, METH_VARARGS,
   "SetFileName(self, filename:str) -> None\nC++: void SetFileName(char *filename)\n\nSpecify file name.\n"},
  {"GetFileName", PyvtkH5PartReader_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\n"},
  {"GetXarray", PyvtkH5PartReader_GetXarray, METH_VARARGS,
   "GetXarray(self) -> str\nC++: virtual char *GetXarray()\n\nSet/Get the array that will be used for the X coordinates\n"},
  {"SetXarray", PyvtkH5PartReader_SetXarray, METH_VARARGS,
   "SetXarray(self, _arg:str) -> None\nC++: virtual void SetXarray(const char *_arg)\n\n"},
  {"GetYarray", PyvtkH5PartReader_GetYarray, METH_VARARGS,
   "GetYarray(self) -> str\nC++: virtual char *GetYarray()\n\nSet/Get the array that will be used for the Y coordinates\n"},
  {"SetYarray", PyvtkH5PartReader_SetYarray, METH_VARARGS,
   "SetYarray(self, _arg:str) -> None\nC++: virtual void SetYarray(const char *_arg)\n\n"},
  {"GetZarray", PyvtkH5PartReader_GetZarray, METH_VARARGS,
   "GetZarray(self) -> str\nC++: virtual char *GetZarray()\n\nSet/Get the array that will be used for the Z coordinates\n"},
  {"SetZarray", PyvtkH5PartReader_SetZarray, METH_VARARGS,
   "SetZarray(self, _arg:str) -> None\nC++: virtual void SetZarray(const char *_arg)\n\n"},
  {"SetGenerateVertexCells", PyvtkH5PartReader_SetGenerateVertexCells, METH_VARARGS,
   "SetGenerateVertexCells(self, _arg:int) -> None\nC++: virtual void SetGenerateVertexCells(int _arg)\n\nWhen set (default no), the reader will generate a vertex cell for\neach point/particle read. When using the points directly this is\nunnecessary and time can be saved by omitting cell generation\nvtkPointSpriteMapper does not require them. When using ParaView,\ncell generation is recommended, without them many filter\noperations are unavailable\n"},
  {"GetGenerateVertexCells", PyvtkH5PartReader_GetGenerateVertexCells, METH_VARARGS,
   "GetGenerateVertexCells(self) -> int\nC++: virtual int GetGenerateVertexCells()\n\n"},
  {"GenerateVertexCellsOn", PyvtkH5PartReader_GenerateVertexCellsOn, METH_VARARGS,
   "GenerateVertexCellsOn(self) -> None\nC++: virtual void GenerateVertexCellsOn()\n\n"},
  {"GenerateVertexCellsOff", PyvtkH5PartReader_GenerateVertexCellsOff, METH_VARARGS,
   "GenerateVertexCellsOff(self) -> None\nC++: virtual void GenerateVertexCellsOff()\n\n"},
  {"SetCombineVectorComponents", PyvtkH5PartReader_SetCombineVectorComponents, METH_VARARGS,
   "SetCombineVectorComponents(self, _arg:int) -> None\nC++: virtual void SetCombineVectorComponents(int _arg)\n\nWhen this option is set, scalar fields with names which form a\npattern of the form scalar_0, scalar_1, scalar_2 will be combined\ninto a single vector field with N components\n"},
  {"GetCombineVectorComponents", PyvtkH5PartReader_GetCombineVectorComponents, METH_VARARGS,
   "GetCombineVectorComponents(self) -> int\nC++: virtual int GetCombineVectorComponents()\n\n"},
  {"CombineVectorComponentsOn", PyvtkH5PartReader_CombineVectorComponentsOn, METH_VARARGS,
   "CombineVectorComponentsOn(self) -> None\nC++: virtual void CombineVectorComponentsOn()\n\n"},
  {"CombineVectorComponentsOff", PyvtkH5PartReader_CombineVectorComponentsOff, METH_VARARGS,
   "CombineVectorComponentsOff(self) -> None\nC++: virtual void CombineVectorComponentsOff()\n\n"},
  {"SetMaskOutOfTimeRangeOutput", PyvtkH5PartReader_SetMaskOutOfTimeRangeOutput, METH_VARARGS,
   "SetMaskOutOfTimeRangeOutput(self, _arg:int) -> None\nC++: virtual void SetMaskOutOfTimeRangeOutput(int _arg)\n\nNormally, a request for data at time t=x, where x is either\nbefore the start of time for the data, or after the end, will\nresult in the first or last timestep of data to be retrieved\n(time is clamped to max/min values). Forsome\napplications/animations, it may be desirable to not display data\nfor invalid times. When MaskOutOfTimeRangeOutput is set to ON,\nthe reader will return an empty dataset for out of range\nrequests. This helps avoid corruption of animations.\n"},
  {"GetMaskOutOfTimeRangeOutput", PyvtkH5PartReader_GetMaskOutOfTimeRangeOutput, METH_VARARGS,
   "GetMaskOutOfTimeRangeOutput(self) -> int\nC++: virtual int GetMaskOutOfTimeRangeOutput()\n\n"},
  {"MaskOutOfTimeRangeOutputOn", PyvtkH5PartReader_MaskOutOfTimeRangeOutputOn, METH_VARARGS,
   "MaskOutOfTimeRangeOutputOn(self) -> None\nC++: virtual void MaskOutOfTimeRangeOutputOn()\n\n"},
  {"MaskOutOfTimeRangeOutputOff", PyvtkH5PartReader_MaskOutOfTimeRangeOutputOff, METH_VARARGS,
   "MaskOutOfTimeRangeOutputOff(self) -> None\nC++: virtual void MaskOutOfTimeRangeOutputOff()\n\n"},
  {"GetNumberOfPointArrays", PyvtkH5PartReader_GetNumberOfPointArrays, METH_VARARGS,
   "GetNumberOfPointArrays(self) -> int\nC++: int GetNumberOfPointArrays()\n\nAn H5Part file may contain multiple arrays a GUI (eg Paraview)\ncan provide a mechanism for selecting which data arrays are to be\nread from the file. The PointArray variables and members can be\nused to query the names and number of arrays available and set\nthe status (on/off) for each array, thereby controlling which\nshould be read from the file. Paraview queries these point arrays\nafter the (update) information part of the pipeline has been\nupdated, and before the (update) data part is updated.\n"},
  {"GetPointArrayName", PyvtkH5PartReader_GetPointArrayName, METH_VARARGS,
   "GetPointArrayName(self, index:int) -> str\nC++: const char *GetPointArrayName(int index)\n\n"},
  {"GetPointArrayStatus", PyvtkH5PartReader_GetPointArrayStatus, METH_VARARGS,
   "GetPointArrayStatus(self, name:str) -> int\nC++: int GetPointArrayStatus(const char *name)\n\n"},
  {"SetPointArrayStatus", PyvtkH5PartReader_SetPointArrayStatus, METH_VARARGS,
   "SetPointArrayStatus(self, name:str, status:int) -> None\nC++: void SetPointArrayStatus(const char *name, int status)\n\n"},
  {"DisableAll", PyvtkH5PartReader_DisableAll, METH_VARARGS,
   "DisableAll(self) -> None\nC++: void DisableAll()\n\n"},
  {"EnableAll", PyvtkH5PartReader_EnableAll, METH_VARARGS,
   "EnableAll(self) -> None\nC++: void EnableAll()\n\n"},
  {"Disable", PyvtkH5PartReader_Disable, METH_VARARGS,
   "Disable(self, name:str) -> None\nC++: void Disable(const char *name)\n\n"},
  {"Enable", PyvtkH5PartReader_Enable, METH_VARARGS,
   "Enable(self, name:str) -> None\nC++: void Enable(const char *name)\n\n"},
  {"GetNumberOfPointArrayStatusArrays", PyvtkH5PartReader_GetNumberOfPointArrayStatusArrays, METH_VARARGS,
   "GetNumberOfPointArrayStatusArrays(self) -> int\nC++: int GetNumberOfPointArrayStatusArrays()\n\n"},
  {"GetPointArrayStatusArrayName", PyvtkH5PartReader_GetPointArrayStatusArrayName, METH_VARARGS,
   "GetPointArrayStatusArrayName(self, index:int) -> str\nC++: const char *GetPointArrayStatusArrayName(int index)\n\n"},
  {"GetPointArrayStatusArrayStatus", PyvtkH5PartReader_GetPointArrayStatusArrayStatus, METH_VARARGS,
   "GetPointArrayStatusArrayStatus(self, name:str) -> int\nC++: int GetPointArrayStatusArrayStatus(const char *name)\n\n"},
  {"SetPointArrayStatusArrayStatus", PyvtkH5PartReader_SetPointArrayStatusArrayStatus, METH_VARARGS,
   "SetPointArrayStatusArrayStatus(self, name:str, status:int) -> None\nC++: void SetPointArrayStatusArrayStatus(const char *name,\n    int status)\n\n"},
  {"GetNumberOfCoordinateArrays", PyvtkH5PartReader_GetNumberOfCoordinateArrays, METH_VARARGS,
   "GetNumberOfCoordinateArrays(self) -> int\nC++: int GetNumberOfCoordinateArrays()\n\n"},
  {"GetCoordinateArrayName", PyvtkH5PartReader_GetCoordinateArrayName, METH_VARARGS,
   "GetCoordinateArrayName(self, index:int) -> str\nC++: const char *GetCoordinateArrayName(int index)\n\n"},
  {"GetCoordinateArrayStatus", PyvtkH5PartReader_GetCoordinateArrayStatus, METH_VARARGS,
   "GetCoordinateArrayStatus(self, name:str) -> int\nC++: int GetCoordinateArrayStatus(const char *name)\n\n"},
  {"SetCoordinateArrayStatus", PyvtkH5PartReader_SetCoordinateArrayStatus, METH_VARARGS,
   "SetCoordinateArrayStatus(self, name:str, status:int) -> None\nC++: void SetCoordinateArrayStatus(const char *name, int status)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkH5PartReader_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkH5PartReader_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkH5PartReader_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkH5PartReader_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("xarray"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkH5PartReader_GetXarray(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkH5PartReader_SetXarray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkH5PartReader_SetXarray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetXarray/SetXarray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("yarray"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkH5PartReader_GetYarray(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkH5PartReader_SetYarray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkH5PartReader_SetYarray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetYarray/SetYarray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("zarray"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkH5PartReader_GetZarray(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkH5PartReader_SetZarray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkH5PartReader_SetZarray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetZarray/SetZarray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_vertex_cells"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkH5PartReader_GetGenerateVertexCells(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkH5PartReader_SetGenerateVertexCells(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkH5PartReader_SetGenerateVertexCells(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateVertexCells/SetGenerateVertexCells\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("combine_vector_components"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkH5PartReader_GetCombineVectorComponents(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkH5PartReader_SetCombineVectorComponents(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkH5PartReader_SetCombineVectorComponents(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCombineVectorComponents/SetCombineVectorComponents\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("mask_out_of_time_range_output"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkH5PartReader_GetMaskOutOfTimeRangeOutput(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkH5PartReader_SetMaskOutOfTimeRangeOutput(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkH5PartReader_SetMaskOutOfTimeRangeOutput(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaskOutOfTimeRangeOutput/SetMaskOutOfTimeRangeOutput\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_point_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkH5PartReader_GetNumberOfPointArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfPointArrays\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_point_array_status_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkH5PartReader_GetNumberOfPointArrayStatusArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfPointArrayStatusArrays\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_coordinate_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkH5PartReader_GetNumberOfCoordinateArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfCoordinateArrays\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkH5PartReader_Doc =
  "vtkH5PartReader - Read H5Part particle files\n\n"
  "Superclass: vtkPolyDataAlgorithm\n\n"
  "vtkH5PartReader reads compatible with H5Part : documented here\n"
  "http://amas.web.psi.ch/docs/H5Part-doc/h5part.html\n\n"
  "ote Thanks to John Bidiscombe of CSCS - Swiss National Supercomputing\n"
  "Centre for creating and contributing the original implementation of\n"
  "this class.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkH5PartReader_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOH5part.vtkH5PartReader", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkH5PartReader_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkH5PartReader_StaticNew()
{
  return vtkH5PartReader::New();
}

PyObject *PyvtkH5PartReader_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkH5PartReader_Type, PyvtkH5PartReader_Methods,
    "vtkH5PartReader",
 &PyvtkH5PartReader_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkPolyDataAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkH5PartReader_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkH5PartReader(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkH5PartReader_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkH5PartReader", o) != 0)
  {
    Py_DECREF(o);
  }

}

