//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1

import (
	unsafe "unsafe"

	corev1 "k8s.io/api/core/v1"
	discoveryv1 "k8s.io/api/discovery/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	core "k8s.io/kubernetes/pkg/apis/core"
	discovery "k8s.io/kubernetes/pkg/apis/discovery"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*discoveryv1.Endpoint)(nil), (*discovery.Endpoint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_Endpoint_To_discovery_Endpoint(a.(*discoveryv1.Endpoint), b.(*discovery.Endpoint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*discovery.Endpoint)(nil), (*discoveryv1.Endpoint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_discovery_Endpoint_To_v1_Endpoint(a.(*discovery.Endpoint), b.(*discoveryv1.Endpoint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*discoveryv1.EndpointConditions)(nil), (*discovery.EndpointConditions)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_EndpointConditions_To_discovery_EndpointConditions(a.(*discoveryv1.EndpointConditions), b.(*discovery.EndpointConditions), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*discovery.EndpointConditions)(nil), (*discoveryv1.EndpointConditions)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_discovery_EndpointConditions_To_v1_EndpointConditions(a.(*discovery.EndpointConditions), b.(*discoveryv1.EndpointConditions), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*discoveryv1.EndpointHints)(nil), (*discovery.EndpointHints)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_EndpointHints_To_discovery_EndpointHints(a.(*discoveryv1.EndpointHints), b.(*discovery.EndpointHints), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*discovery.EndpointHints)(nil), (*discoveryv1.EndpointHints)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_discovery_EndpointHints_To_v1_EndpointHints(a.(*discovery.EndpointHints), b.(*discoveryv1.EndpointHints), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*discoveryv1.EndpointPort)(nil), (*discovery.EndpointPort)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_EndpointPort_To_discovery_EndpointPort(a.(*discoveryv1.EndpointPort), b.(*discovery.EndpointPort), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*discovery.EndpointPort)(nil), (*discoveryv1.EndpointPort)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_discovery_EndpointPort_To_v1_EndpointPort(a.(*discovery.EndpointPort), b.(*discoveryv1.EndpointPort), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*discoveryv1.EndpointSlice)(nil), (*discovery.EndpointSlice)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_EndpointSlice_To_discovery_EndpointSlice(a.(*discoveryv1.EndpointSlice), b.(*discovery.EndpointSlice), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*discovery.EndpointSlice)(nil), (*discoveryv1.EndpointSlice)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_discovery_EndpointSlice_To_v1_EndpointSlice(a.(*discovery.EndpointSlice), b.(*discoveryv1.EndpointSlice), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*discoveryv1.EndpointSliceList)(nil), (*discovery.EndpointSliceList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_EndpointSliceList_To_discovery_EndpointSliceList(a.(*discoveryv1.EndpointSliceList), b.(*discovery.EndpointSliceList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*discovery.EndpointSliceList)(nil), (*discoveryv1.EndpointSliceList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_discovery_EndpointSliceList_To_v1_EndpointSliceList(a.(*discovery.EndpointSliceList), b.(*discoveryv1.EndpointSliceList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*discoveryv1.ForNode)(nil), (*discovery.ForNode)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ForNode_To_discovery_ForNode(a.(*discoveryv1.ForNode), b.(*discovery.ForNode), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*discovery.ForNode)(nil), (*discoveryv1.ForNode)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_discovery_ForNode_To_v1_ForNode(a.(*discovery.ForNode), b.(*discoveryv1.ForNode), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*discoveryv1.ForZone)(nil), (*discovery.ForZone)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ForZone_To_discovery_ForZone(a.(*discoveryv1.ForZone), b.(*discovery.ForZone), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*discovery.ForZone)(nil), (*discoveryv1.ForZone)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_discovery_ForZone_To_v1_ForZone(a.(*discovery.ForZone), b.(*discoveryv1.ForZone), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_Endpoint_To_discovery_Endpoint(in *discoveryv1.Endpoint, out *discovery.Endpoint, s conversion.Scope) error {
	out.Addresses = *(*[]string)(unsafe.Pointer(&in.Addresses))
	if err := Convert_v1_EndpointConditions_To_discovery_EndpointConditions(&in.Conditions, &out.Conditions, s); err != nil {
		return err
	}
	out.Hostname = (*string)(unsafe.Pointer(in.Hostname))
	out.TargetRef = (*core.ObjectReference)(unsafe.Pointer(in.TargetRef))
	out.DeprecatedTopology = *(*map[string]string)(unsafe.Pointer(&in.DeprecatedTopology))
	out.NodeName = (*string)(unsafe.Pointer(in.NodeName))
	out.Zone = (*string)(unsafe.Pointer(in.Zone))
	out.Hints = (*discovery.EndpointHints)(unsafe.Pointer(in.Hints))
	return nil
}

// Convert_v1_Endpoint_To_discovery_Endpoint is an autogenerated conversion function.
func Convert_v1_Endpoint_To_discovery_Endpoint(in *discoveryv1.Endpoint, out *discovery.Endpoint, s conversion.Scope) error {
	return autoConvert_v1_Endpoint_To_discovery_Endpoint(in, out, s)
}

func autoConvert_discovery_Endpoint_To_v1_Endpoint(in *discovery.Endpoint, out *discoveryv1.Endpoint, s conversion.Scope) error {
	out.Addresses = *(*[]string)(unsafe.Pointer(&in.Addresses))
	if err := Convert_discovery_EndpointConditions_To_v1_EndpointConditions(&in.Conditions, &out.Conditions, s); err != nil {
		return err
	}
	out.Hostname = (*string)(unsafe.Pointer(in.Hostname))
	out.TargetRef = (*corev1.ObjectReference)(unsafe.Pointer(in.TargetRef))
	out.DeprecatedTopology = *(*map[string]string)(unsafe.Pointer(&in.DeprecatedTopology))
	out.NodeName = (*string)(unsafe.Pointer(in.NodeName))
	out.Zone = (*string)(unsafe.Pointer(in.Zone))
	out.Hints = (*discoveryv1.EndpointHints)(unsafe.Pointer(in.Hints))
	return nil
}

// Convert_discovery_Endpoint_To_v1_Endpoint is an autogenerated conversion function.
func Convert_discovery_Endpoint_To_v1_Endpoint(in *discovery.Endpoint, out *discoveryv1.Endpoint, s conversion.Scope) error {
	return autoConvert_discovery_Endpoint_To_v1_Endpoint(in, out, s)
}

func autoConvert_v1_EndpointConditions_To_discovery_EndpointConditions(in *discoveryv1.EndpointConditions, out *discovery.EndpointConditions, s conversion.Scope) error {
	out.Ready = (*bool)(unsafe.Pointer(in.Ready))
	out.Serving = (*bool)(unsafe.Pointer(in.Serving))
	out.Terminating = (*bool)(unsafe.Pointer(in.Terminating))
	return nil
}

// Convert_v1_EndpointConditions_To_discovery_EndpointConditions is an autogenerated conversion function.
func Convert_v1_EndpointConditions_To_discovery_EndpointConditions(in *discoveryv1.EndpointConditions, out *discovery.EndpointConditions, s conversion.Scope) error {
	return autoConvert_v1_EndpointConditions_To_discovery_EndpointConditions(in, out, s)
}

func autoConvert_discovery_EndpointConditions_To_v1_EndpointConditions(in *discovery.EndpointConditions, out *discoveryv1.EndpointConditions, s conversion.Scope) error {
	out.Ready = (*bool)(unsafe.Pointer(in.Ready))
	out.Serving = (*bool)(unsafe.Pointer(in.Serving))
	out.Terminating = (*bool)(unsafe.Pointer(in.Terminating))
	return nil
}

// Convert_discovery_EndpointConditions_To_v1_EndpointConditions is an autogenerated conversion function.
func Convert_discovery_EndpointConditions_To_v1_EndpointConditions(in *discovery.EndpointConditions, out *discoveryv1.EndpointConditions, s conversion.Scope) error {
	return autoConvert_discovery_EndpointConditions_To_v1_EndpointConditions(in, out, s)
}

func autoConvert_v1_EndpointHints_To_discovery_EndpointHints(in *discoveryv1.EndpointHints, out *discovery.EndpointHints, s conversion.Scope) error {
	out.ForZones = *(*[]discovery.ForZone)(unsafe.Pointer(&in.ForZones))
	out.ForNodes = *(*[]discovery.ForNode)(unsafe.Pointer(&in.ForNodes))
	return nil
}

// Convert_v1_EndpointHints_To_discovery_EndpointHints is an autogenerated conversion function.
func Convert_v1_EndpointHints_To_discovery_EndpointHints(in *discoveryv1.EndpointHints, out *discovery.EndpointHints, s conversion.Scope) error {
	return autoConvert_v1_EndpointHints_To_discovery_EndpointHints(in, out, s)
}

func autoConvert_discovery_EndpointHints_To_v1_EndpointHints(in *discovery.EndpointHints, out *discoveryv1.EndpointHints, s conversion.Scope) error {
	out.ForZones = *(*[]discoveryv1.ForZone)(unsafe.Pointer(&in.ForZones))
	out.ForNodes = *(*[]discoveryv1.ForNode)(unsafe.Pointer(&in.ForNodes))
	return nil
}

// Convert_discovery_EndpointHints_To_v1_EndpointHints is an autogenerated conversion function.
func Convert_discovery_EndpointHints_To_v1_EndpointHints(in *discovery.EndpointHints, out *discoveryv1.EndpointHints, s conversion.Scope) error {
	return autoConvert_discovery_EndpointHints_To_v1_EndpointHints(in, out, s)
}

func autoConvert_v1_EndpointPort_To_discovery_EndpointPort(in *discoveryv1.EndpointPort, out *discovery.EndpointPort, s conversion.Scope) error {
	out.Name = (*string)(unsafe.Pointer(in.Name))
	out.Protocol = (*core.Protocol)(unsafe.Pointer(in.Protocol))
	out.Port = (*int32)(unsafe.Pointer(in.Port))
	out.AppProtocol = (*string)(unsafe.Pointer(in.AppProtocol))
	return nil
}

// Convert_v1_EndpointPort_To_discovery_EndpointPort is an autogenerated conversion function.
func Convert_v1_EndpointPort_To_discovery_EndpointPort(in *discoveryv1.EndpointPort, out *discovery.EndpointPort, s conversion.Scope) error {
	return autoConvert_v1_EndpointPort_To_discovery_EndpointPort(in, out, s)
}

func autoConvert_discovery_EndpointPort_To_v1_EndpointPort(in *discovery.EndpointPort, out *discoveryv1.EndpointPort, s conversion.Scope) error {
	out.Name = (*string)(unsafe.Pointer(in.Name))
	out.Protocol = (*corev1.Protocol)(unsafe.Pointer(in.Protocol))
	out.Port = (*int32)(unsafe.Pointer(in.Port))
	out.AppProtocol = (*string)(unsafe.Pointer(in.AppProtocol))
	return nil
}

// Convert_discovery_EndpointPort_To_v1_EndpointPort is an autogenerated conversion function.
func Convert_discovery_EndpointPort_To_v1_EndpointPort(in *discovery.EndpointPort, out *discoveryv1.EndpointPort, s conversion.Scope) error {
	return autoConvert_discovery_EndpointPort_To_v1_EndpointPort(in, out, s)
}

func autoConvert_v1_EndpointSlice_To_discovery_EndpointSlice(in *discoveryv1.EndpointSlice, out *discovery.EndpointSlice, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.AddressType = discovery.AddressType(in.AddressType)
	out.Endpoints = *(*[]discovery.Endpoint)(unsafe.Pointer(&in.Endpoints))
	out.Ports = *(*[]discovery.EndpointPort)(unsafe.Pointer(&in.Ports))
	return nil
}

// Convert_v1_EndpointSlice_To_discovery_EndpointSlice is an autogenerated conversion function.
func Convert_v1_EndpointSlice_To_discovery_EndpointSlice(in *discoveryv1.EndpointSlice, out *discovery.EndpointSlice, s conversion.Scope) error {
	return autoConvert_v1_EndpointSlice_To_discovery_EndpointSlice(in, out, s)
}

func autoConvert_discovery_EndpointSlice_To_v1_EndpointSlice(in *discovery.EndpointSlice, out *discoveryv1.EndpointSlice, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.AddressType = discoveryv1.AddressType(in.AddressType)
	out.Endpoints = *(*[]discoveryv1.Endpoint)(unsafe.Pointer(&in.Endpoints))
	out.Ports = *(*[]discoveryv1.EndpointPort)(unsafe.Pointer(&in.Ports))
	return nil
}

// Convert_discovery_EndpointSlice_To_v1_EndpointSlice is an autogenerated conversion function.
func Convert_discovery_EndpointSlice_To_v1_EndpointSlice(in *discovery.EndpointSlice, out *discoveryv1.EndpointSlice, s conversion.Scope) error {
	return autoConvert_discovery_EndpointSlice_To_v1_EndpointSlice(in, out, s)
}

func autoConvert_v1_EndpointSliceList_To_discovery_EndpointSliceList(in *discoveryv1.EndpointSliceList, out *discovery.EndpointSliceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]discovery.EndpointSlice)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_EndpointSliceList_To_discovery_EndpointSliceList is an autogenerated conversion function.
func Convert_v1_EndpointSliceList_To_discovery_EndpointSliceList(in *discoveryv1.EndpointSliceList, out *discovery.EndpointSliceList, s conversion.Scope) error {
	return autoConvert_v1_EndpointSliceList_To_discovery_EndpointSliceList(in, out, s)
}

func autoConvert_discovery_EndpointSliceList_To_v1_EndpointSliceList(in *discovery.EndpointSliceList, out *discoveryv1.EndpointSliceList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]discoveryv1.EndpointSlice)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_discovery_EndpointSliceList_To_v1_EndpointSliceList is an autogenerated conversion function.
func Convert_discovery_EndpointSliceList_To_v1_EndpointSliceList(in *discovery.EndpointSliceList, out *discoveryv1.EndpointSliceList, s conversion.Scope) error {
	return autoConvert_discovery_EndpointSliceList_To_v1_EndpointSliceList(in, out, s)
}

func autoConvert_v1_ForNode_To_discovery_ForNode(in *discoveryv1.ForNode, out *discovery.ForNode, s conversion.Scope) error {
	out.Name = in.Name
	return nil
}

// Convert_v1_ForNode_To_discovery_ForNode is an autogenerated conversion function.
func Convert_v1_ForNode_To_discovery_ForNode(in *discoveryv1.ForNode, out *discovery.ForNode, s conversion.Scope) error {
	return autoConvert_v1_ForNode_To_discovery_ForNode(in, out, s)
}

func autoConvert_discovery_ForNode_To_v1_ForNode(in *discovery.ForNode, out *discoveryv1.ForNode, s conversion.Scope) error {
	out.Name = in.Name
	return nil
}

// Convert_discovery_ForNode_To_v1_ForNode is an autogenerated conversion function.
func Convert_discovery_ForNode_To_v1_ForNode(in *discovery.ForNode, out *discoveryv1.ForNode, s conversion.Scope) error {
	return autoConvert_discovery_ForNode_To_v1_ForNode(in, out, s)
}

func autoConvert_v1_ForZone_To_discovery_ForZone(in *discoveryv1.ForZone, out *discovery.ForZone, s conversion.Scope) error {
	out.Name = in.Name
	return nil
}

// Convert_v1_ForZone_To_discovery_ForZone is an autogenerated conversion function.
func Convert_v1_ForZone_To_discovery_ForZone(in *discoveryv1.ForZone, out *discovery.ForZone, s conversion.Scope) error {
	return autoConvert_v1_ForZone_To_discovery_ForZone(in, out, s)
}

func autoConvert_discovery_ForZone_To_v1_ForZone(in *discovery.ForZone, out *discoveryv1.ForZone, s conversion.Scope) error {
	out.Name = in.Name
	return nil
}

// Convert_discovery_ForZone_To_v1_ForZone is an autogenerated conversion function.
func Convert_discovery_ForZone_To_v1_ForZone(in *discovery.ForZone, out *discoveryv1.ForZone, s conversion.Scope) error {
	return autoConvert_discovery_ForZone_To_v1_ForZone(in, out, s)
}
