#ifndef itkImageFunctionBaseSwigInterface_h
#define itkImageFunctionBaseSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkPhasedArray3DSpecialCoordinatesImage.h"
#include "itkImageFunction.h"

using itkImageFunctionISC2DF = itk::ImageFunction< itk::Image< signed char,2 >,double,float >;
using itkImageFunctionISC2DF_Pointer = itk::ImageFunction< itk::Image< signed char,2 >,double,float >::Pointer;
using itkImageFunctionISC2DD = itk::ImageFunction< itk::Image< signed char,2 >,double,double >;
using itkImageFunctionISC2DD_Pointer = itk::ImageFunction< itk::Image< signed char,2 >,double,double >::Pointer;
using itkImageFunctionISS2DF = itk::ImageFunction< itk::Image< signed short,2 >,double,float >;
using itkImageFunctionISS2DF_Pointer = itk::ImageFunction< itk::Image< signed short,2 >,double,float >::Pointer;
using itkImageFunctionISS2DD = itk::ImageFunction< itk::Image< signed short,2 >,double,double >;
using itkImageFunctionISS2DD_Pointer = itk::ImageFunction< itk::Image< signed short,2 >,double,double >::Pointer;
using itkImageFunctionIUC2DF = itk::ImageFunction< itk::Image< unsigned char,2 >,double,float >;
using itkImageFunctionIUC2DF_Pointer = itk::ImageFunction< itk::Image< unsigned char,2 >,double,float >::Pointer;
using itkImageFunctionIUC2DD = itk::ImageFunction< itk::Image< unsigned char,2 >,double,double >;
using itkImageFunctionIUC2DD_Pointer = itk::ImageFunction< itk::Image< unsigned char,2 >,double,double >::Pointer;
using itkImageFunctionIULL2DF = itk::ImageFunction< itk::Image< unsigned long long,2 >,double,float >;
using itkImageFunctionIULL2DF_Pointer = itk::ImageFunction< itk::Image< unsigned long long,2 >,double,float >::Pointer;
using itkImageFunctionIULL2DD = itk::ImageFunction< itk::Image< unsigned long long,2 >,double,double >;
using itkImageFunctionIULL2DD_Pointer = itk::ImageFunction< itk::Image< unsigned long long,2 >,double,double >::Pointer;
using itkImageFunctionIUS2DF = itk::ImageFunction< itk::Image< unsigned short,2 >,double,float >;
using itkImageFunctionIUS2DF_Pointer = itk::ImageFunction< itk::Image< unsigned short,2 >,double,float >::Pointer;
using itkImageFunctionIUS2DD = itk::ImageFunction< itk::Image< unsigned short,2 >,double,double >;
using itkImageFunctionIUS2DD_Pointer = itk::ImageFunction< itk::Image< unsigned short,2 >,double,double >::Pointer;
using itkImageFunctionIF2DF = itk::ImageFunction< itk::Image< float,2 >,double,float >;
using itkImageFunctionIF2DF_Pointer = itk::ImageFunction< itk::Image< float,2 >,double,float >::Pointer;
using itkImageFunctionIF2DD = itk::ImageFunction< itk::Image< float,2 >,double,double >;
using itkImageFunctionIF2DD_Pointer = itk::ImageFunction< itk::Image< float,2 >,double,double >::Pointer;
using itkImageFunctionID2DF = itk::ImageFunction< itk::Image< double,2 >,double,float >;
using itkImageFunctionID2DF_Pointer = itk::ImageFunction< itk::Image< double,2 >,double,float >::Pointer;
using itkImageFunctionID2DD = itk::ImageFunction< itk::Image< double,2 >,double,double >;
using itkImageFunctionID2DD_Pointer = itk::ImageFunction< itk::Image< double,2 >,double,double >::Pointer;
using itkImageFunctionIVD22VD2D = itk::ImageFunction< itk::Image< itk::Vector< double,2 >,2 >,itk::Vector< double,2 >,double >;
using itkImageFunctionIVD22VD2D_Pointer = itk::ImageFunction< itk::Image< itk::Vector< double,2 >,2 >,itk::Vector< double,2 >,double >::Pointer;
using itkImageFunctionIVD22CVD2D = itk::ImageFunction< itk::Image< itk::Vector< double,2 >,2 >,itk::CovariantVector< double,2 >,double >;
using itkImageFunctionIVD22CVD2D_Pointer = itk::ImageFunction< itk::Image< itk::Vector< double,2 >,2 >,itk::CovariantVector< double,2 >,double >::Pointer;
using itkImageFunctionIVD22DD = itk::ImageFunction< itk::Image< itk::Vector< double,2 >,2 >,double,double >;
using itkImageFunctionIVD22DD_Pointer = itk::ImageFunction< itk::Image< itk::Vector< double,2 >,2 >,double,double >::Pointer;
using itkImageFunctionIVF22VD2D = itk::ImageFunction< itk::Image< itk::Vector< float,2 >,2 >,itk::Vector< double,2 >,double >;
using itkImageFunctionIVF22VD2D_Pointer = itk::ImageFunction< itk::Image< itk::Vector< float,2 >,2 >,itk::Vector< double,2 >,double >::Pointer;
using itkImageFunctionIVF22CVD2D = itk::ImageFunction< itk::Image< itk::Vector< float,2 >,2 >,itk::CovariantVector< double,2 >,double >;
using itkImageFunctionIVF22CVD2D_Pointer = itk::ImageFunction< itk::Image< itk::Vector< float,2 >,2 >,itk::CovariantVector< double,2 >,double >::Pointer;
using itkImageFunctionIVF22DD = itk::ImageFunction< itk::Image< itk::Vector< float,2 >,2 >,double,double >;
using itkImageFunctionIVF22DD_Pointer = itk::ImageFunction< itk::Image< itk::Vector< float,2 >,2 >,double,double >::Pointer;
using itkImageFunctionICVD22VD2D = itk::ImageFunction< itk::Image< itk::CovariantVector< double,2 >,2 >,itk::Vector< double,2 >,double >;
using itkImageFunctionICVD22VD2D_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< double,2 >,2 >,itk::Vector< double,2 >,double >::Pointer;
using itkImageFunctionICVD22CVD2D = itk::ImageFunction< itk::Image< itk::CovariantVector< double,2 >,2 >,itk::CovariantVector< double,2 >,double >;
using itkImageFunctionICVD22CVD2D_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< double,2 >,2 >,itk::CovariantVector< double,2 >,double >::Pointer;
using itkImageFunctionICVD22DD = itk::ImageFunction< itk::Image< itk::CovariantVector< double,2 >,2 >,double,double >;
using itkImageFunctionICVD22DD_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< double,2 >,2 >,double,double >::Pointer;
using itkImageFunctionICVF22VD2D = itk::ImageFunction< itk::Image< itk::CovariantVector< float,2 >,2 >,itk::Vector< double,2 >,double >;
using itkImageFunctionICVF22VD2D_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< float,2 >,2 >,itk::Vector< double,2 >,double >::Pointer;
using itkImageFunctionICVF22CVD2D = itk::ImageFunction< itk::Image< itk::CovariantVector< float,2 >,2 >,itk::CovariantVector< double,2 >,double >;
using itkImageFunctionICVF22CVD2D_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< float,2 >,2 >,itk::CovariantVector< double,2 >,double >::Pointer;
using itkImageFunctionICVF22DD = itk::ImageFunction< itk::Image< itk::CovariantVector< float,2 >,2 >,double,double >;
using itkImageFunctionICVF22DD_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< float,2 >,2 >,double,double >::Pointer;
using itkImageFunctionIRGBUC2RGBUCD = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned char >,2 >,itk::RGBPixel< unsigned char >,double >;
using itkImageFunctionIRGBUC2RGBUCD_Pointer = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned char >,2 >,itk::RGBPixel< unsigned char >,double >::Pointer;
using itkImageFunctionIRGBUS2RGBUSD = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned short >,2 >,itk::RGBPixel< unsigned short >,double >;
using itkImageFunctionIRGBUS2RGBUSD_Pointer = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned short >,2 >,itk::RGBPixel< unsigned short >,double >::Pointer;
using itkImageFunctionIRGBAUC2RGBAUCD = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,2 >,itk::RGBAPixel< unsigned char >,double >;
using itkImageFunctionIRGBAUC2RGBAUCD_Pointer = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,2 >,itk::RGBAPixel< unsigned char >,double >::Pointer;
using itkImageFunctionIRGBAUS2RGBAUSD = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,2 >,itk::RGBAPixel< unsigned short >,double >;
using itkImageFunctionIRGBAUS2RGBAUSD_Pointer = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,2 >,itk::RGBAPixel< unsigned short >,double >::Pointer;
using itkImageFunctionIRGBUC2RGBDD = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned char >,2 >,itk::RGBPixel< double >,double >;
using itkImageFunctionIRGBUC2RGBDD_Pointer = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned char >,2 >,itk::RGBPixel< double >,double >::Pointer;
using itkImageFunctionIRGBUS2RGBDD = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned short >,2 >,itk::RGBPixel< double >,double >;
using itkImageFunctionIRGBUS2RGBDD_Pointer = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned short >,2 >,itk::RGBPixel< double >,double >::Pointer;
using itkImageFunctionIRGBAUC2RGBADD = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,2 >,itk::RGBAPixel< double >,double >;
using itkImageFunctionIRGBAUC2RGBADD_Pointer = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,2 >,itk::RGBAPixel< double >,double >::Pointer;
using itkImageFunctionIRGBAUS2RGBADD = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,2 >,itk::RGBAPixel< double >,double >;
using itkImageFunctionIRGBAUS2RGBADD_Pointer = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,2 >,itk::RGBAPixel< double >,double >::Pointer;
using itkImageFunctionISC3DF = itk::ImageFunction< itk::Image< signed char,3 >,double,float >;
using itkImageFunctionISC3DF_Pointer = itk::ImageFunction< itk::Image< signed char,3 >,double,float >::Pointer;
using itkImageFunctionISC3DD = itk::ImageFunction< itk::Image< signed char,3 >,double,double >;
using itkImageFunctionISC3DD_Pointer = itk::ImageFunction< itk::Image< signed char,3 >,double,double >::Pointer;
using itkImageFunctionISS3DF = itk::ImageFunction< itk::Image< signed short,3 >,double,float >;
using itkImageFunctionISS3DF_Pointer = itk::ImageFunction< itk::Image< signed short,3 >,double,float >::Pointer;
using itkImageFunctionISS3DD = itk::ImageFunction< itk::Image< signed short,3 >,double,double >;
using itkImageFunctionISS3DD_Pointer = itk::ImageFunction< itk::Image< signed short,3 >,double,double >::Pointer;
using itkImageFunctionIUC3DF = itk::ImageFunction< itk::Image< unsigned char,3 >,double,float >;
using itkImageFunctionIUC3DF_Pointer = itk::ImageFunction< itk::Image< unsigned char,3 >,double,float >::Pointer;
using itkImageFunctionIUC3DD = itk::ImageFunction< itk::Image< unsigned char,3 >,double,double >;
using itkImageFunctionIUC3DD_Pointer = itk::ImageFunction< itk::Image< unsigned char,3 >,double,double >::Pointer;
using itkImageFunctionIULL3DF = itk::ImageFunction< itk::Image< unsigned long long,3 >,double,float >;
using itkImageFunctionIULL3DF_Pointer = itk::ImageFunction< itk::Image< unsigned long long,3 >,double,float >::Pointer;
using itkImageFunctionIULL3DD = itk::ImageFunction< itk::Image< unsigned long long,3 >,double,double >;
using itkImageFunctionIULL3DD_Pointer = itk::ImageFunction< itk::Image< unsigned long long,3 >,double,double >::Pointer;
using itkImageFunctionIUS3DF = itk::ImageFunction< itk::Image< unsigned short,3 >,double,float >;
using itkImageFunctionIUS3DF_Pointer = itk::ImageFunction< itk::Image< unsigned short,3 >,double,float >::Pointer;
using itkImageFunctionIUS3DD = itk::ImageFunction< itk::Image< unsigned short,3 >,double,double >;
using itkImageFunctionIUS3DD_Pointer = itk::ImageFunction< itk::Image< unsigned short,3 >,double,double >::Pointer;
using itkImageFunctionIF3DF = itk::ImageFunction< itk::Image< float,3 >,double,float >;
using itkImageFunctionIF3DF_Pointer = itk::ImageFunction< itk::Image< float,3 >,double,float >::Pointer;
using itkImageFunctionIF3DD = itk::ImageFunction< itk::Image< float,3 >,double,double >;
using itkImageFunctionIF3DD_Pointer = itk::ImageFunction< itk::Image< float,3 >,double,double >::Pointer;
using itkImageFunctionID3DF = itk::ImageFunction< itk::Image< double,3 >,double,float >;
using itkImageFunctionID3DF_Pointer = itk::ImageFunction< itk::Image< double,3 >,double,float >::Pointer;
using itkImageFunctionID3DD = itk::ImageFunction< itk::Image< double,3 >,double,double >;
using itkImageFunctionID3DD_Pointer = itk::ImageFunction< itk::Image< double,3 >,double,double >::Pointer;
using itkImageFunctionIVD33VD3D = itk::ImageFunction< itk::Image< itk::Vector< double,3 >,3 >,itk::Vector< double,3 >,double >;
using itkImageFunctionIVD33VD3D_Pointer = itk::ImageFunction< itk::Image< itk::Vector< double,3 >,3 >,itk::Vector< double,3 >,double >::Pointer;
using itkImageFunctionIVD33CVD3D = itk::ImageFunction< itk::Image< itk::Vector< double,3 >,3 >,itk::CovariantVector< double,3 >,double >;
using itkImageFunctionIVD33CVD3D_Pointer = itk::ImageFunction< itk::Image< itk::Vector< double,3 >,3 >,itk::CovariantVector< double,3 >,double >::Pointer;
using itkImageFunctionIVD33DD = itk::ImageFunction< itk::Image< itk::Vector< double,3 >,3 >,double,double >;
using itkImageFunctionIVD33DD_Pointer = itk::ImageFunction< itk::Image< itk::Vector< double,3 >,3 >,double,double >::Pointer;
using itkImageFunctionIVF33VD3D = itk::ImageFunction< itk::Image< itk::Vector< float,3 >,3 >,itk::Vector< double,3 >,double >;
using itkImageFunctionIVF33VD3D_Pointer = itk::ImageFunction< itk::Image< itk::Vector< float,3 >,3 >,itk::Vector< double,3 >,double >::Pointer;
using itkImageFunctionIVF33CVD3D = itk::ImageFunction< itk::Image< itk::Vector< float,3 >,3 >,itk::CovariantVector< double,3 >,double >;
using itkImageFunctionIVF33CVD3D_Pointer = itk::ImageFunction< itk::Image< itk::Vector< float,3 >,3 >,itk::CovariantVector< double,3 >,double >::Pointer;
using itkImageFunctionIVF33DD = itk::ImageFunction< itk::Image< itk::Vector< float,3 >,3 >,double,double >;
using itkImageFunctionIVF33DD_Pointer = itk::ImageFunction< itk::Image< itk::Vector< float,3 >,3 >,double,double >::Pointer;
using itkImageFunctionICVD33VD3D = itk::ImageFunction< itk::Image< itk::CovariantVector< double,3 >,3 >,itk::Vector< double,3 >,double >;
using itkImageFunctionICVD33VD3D_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< double,3 >,3 >,itk::Vector< double,3 >,double >::Pointer;
using itkImageFunctionICVD33CVD3D = itk::ImageFunction< itk::Image< itk::CovariantVector< double,3 >,3 >,itk::CovariantVector< double,3 >,double >;
using itkImageFunctionICVD33CVD3D_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< double,3 >,3 >,itk::CovariantVector< double,3 >,double >::Pointer;
using itkImageFunctionICVD33DD = itk::ImageFunction< itk::Image< itk::CovariantVector< double,3 >,3 >,double,double >;
using itkImageFunctionICVD33DD_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< double,3 >,3 >,double,double >::Pointer;
using itkImageFunctionICVF33VD3D = itk::ImageFunction< itk::Image< itk::CovariantVector< float,3 >,3 >,itk::Vector< double,3 >,double >;
using itkImageFunctionICVF33VD3D_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< float,3 >,3 >,itk::Vector< double,3 >,double >::Pointer;
using itkImageFunctionICVF33CVD3D = itk::ImageFunction< itk::Image< itk::CovariantVector< float,3 >,3 >,itk::CovariantVector< double,3 >,double >;
using itkImageFunctionICVF33CVD3D_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< float,3 >,3 >,itk::CovariantVector< double,3 >,double >::Pointer;
using itkImageFunctionICVF33DD = itk::ImageFunction< itk::Image< itk::CovariantVector< float,3 >,3 >,double,double >;
using itkImageFunctionICVF33DD_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< float,3 >,3 >,double,double >::Pointer;
using itkImageFunctionIRGBUC3RGBUCD = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned char >,3 >,itk::RGBPixel< unsigned char >,double >;
using itkImageFunctionIRGBUC3RGBUCD_Pointer = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned char >,3 >,itk::RGBPixel< unsigned char >,double >::Pointer;
using itkImageFunctionIRGBUS3RGBUSD = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned short >,3 >,itk::RGBPixel< unsigned short >,double >;
using itkImageFunctionIRGBUS3RGBUSD_Pointer = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned short >,3 >,itk::RGBPixel< unsigned short >,double >::Pointer;
using itkImageFunctionIRGBAUC3RGBAUCD = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,3 >,itk::RGBAPixel< unsigned char >,double >;
using itkImageFunctionIRGBAUC3RGBAUCD_Pointer = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,3 >,itk::RGBAPixel< unsigned char >,double >::Pointer;
using itkImageFunctionIRGBAUS3RGBAUSD = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,3 >,itk::RGBAPixel< unsigned short >,double >;
using itkImageFunctionIRGBAUS3RGBAUSD_Pointer = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,3 >,itk::RGBAPixel< unsigned short >,double >::Pointer;
using itkImageFunctionIRGBUC3RGBDD = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned char >,3 >,itk::RGBPixel< double >,double >;
using itkImageFunctionIRGBUC3RGBDD_Pointer = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned char >,3 >,itk::RGBPixel< double >,double >::Pointer;
using itkImageFunctionIRGBUS3RGBDD = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned short >,3 >,itk::RGBPixel< double >,double >;
using itkImageFunctionIRGBUS3RGBDD_Pointer = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned short >,3 >,itk::RGBPixel< double >,double >::Pointer;
using itkImageFunctionIRGBAUC3RGBADD = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,3 >,itk::RGBAPixel< double >,double >;
using itkImageFunctionIRGBAUC3RGBADD_Pointer = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,3 >,itk::RGBAPixel< double >,double >::Pointer;
using itkImageFunctionIRGBAUS3RGBADD = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,3 >,itk::RGBAPixel< double >,double >;
using itkImageFunctionIRGBAUS3RGBADD_Pointer = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,3 >,itk::RGBAPixel< double >,double >::Pointer;
using itkImageFunctionISC4DF = itk::ImageFunction< itk::Image< signed char,4 >,double,float >;
using itkImageFunctionISC4DF_Pointer = itk::ImageFunction< itk::Image< signed char,4 >,double,float >::Pointer;
using itkImageFunctionISC4DD = itk::ImageFunction< itk::Image< signed char,4 >,double,double >;
using itkImageFunctionISC4DD_Pointer = itk::ImageFunction< itk::Image< signed char,4 >,double,double >::Pointer;
using itkImageFunctionISS4DF = itk::ImageFunction< itk::Image< signed short,4 >,double,float >;
using itkImageFunctionISS4DF_Pointer = itk::ImageFunction< itk::Image< signed short,4 >,double,float >::Pointer;
using itkImageFunctionISS4DD = itk::ImageFunction< itk::Image< signed short,4 >,double,double >;
using itkImageFunctionISS4DD_Pointer = itk::ImageFunction< itk::Image< signed short,4 >,double,double >::Pointer;
using itkImageFunctionIUC4DF = itk::ImageFunction< itk::Image< unsigned char,4 >,double,float >;
using itkImageFunctionIUC4DF_Pointer = itk::ImageFunction< itk::Image< unsigned char,4 >,double,float >::Pointer;
using itkImageFunctionIUC4DD = itk::ImageFunction< itk::Image< unsigned char,4 >,double,double >;
using itkImageFunctionIUC4DD_Pointer = itk::ImageFunction< itk::Image< unsigned char,4 >,double,double >::Pointer;
using itkImageFunctionIULL4DF = itk::ImageFunction< itk::Image< unsigned long long,4 >,double,float >;
using itkImageFunctionIULL4DF_Pointer = itk::ImageFunction< itk::Image< unsigned long long,4 >,double,float >::Pointer;
using itkImageFunctionIULL4DD = itk::ImageFunction< itk::Image< unsigned long long,4 >,double,double >;
using itkImageFunctionIULL4DD_Pointer = itk::ImageFunction< itk::Image< unsigned long long,4 >,double,double >::Pointer;
using itkImageFunctionIUS4DF = itk::ImageFunction< itk::Image< unsigned short,4 >,double,float >;
using itkImageFunctionIUS4DF_Pointer = itk::ImageFunction< itk::Image< unsigned short,4 >,double,float >::Pointer;
using itkImageFunctionIUS4DD = itk::ImageFunction< itk::Image< unsigned short,4 >,double,double >;
using itkImageFunctionIUS4DD_Pointer = itk::ImageFunction< itk::Image< unsigned short,4 >,double,double >::Pointer;
using itkImageFunctionIF4DF = itk::ImageFunction< itk::Image< float,4 >,double,float >;
using itkImageFunctionIF4DF_Pointer = itk::ImageFunction< itk::Image< float,4 >,double,float >::Pointer;
using itkImageFunctionIF4DD = itk::ImageFunction< itk::Image< float,4 >,double,double >;
using itkImageFunctionIF4DD_Pointer = itk::ImageFunction< itk::Image< float,4 >,double,double >::Pointer;
using itkImageFunctionID4DF = itk::ImageFunction< itk::Image< double,4 >,double,float >;
using itkImageFunctionID4DF_Pointer = itk::ImageFunction< itk::Image< double,4 >,double,float >::Pointer;
using itkImageFunctionID4DD = itk::ImageFunction< itk::Image< double,4 >,double,double >;
using itkImageFunctionID4DD_Pointer = itk::ImageFunction< itk::Image< double,4 >,double,double >::Pointer;
using itkImageFunctionIVD44VD4D = itk::ImageFunction< itk::Image< itk::Vector< double,4 >,4 >,itk::Vector< double,4 >,double >;
using itkImageFunctionIVD44VD4D_Pointer = itk::ImageFunction< itk::Image< itk::Vector< double,4 >,4 >,itk::Vector< double,4 >,double >::Pointer;
using itkImageFunctionIVD44CVD4D = itk::ImageFunction< itk::Image< itk::Vector< double,4 >,4 >,itk::CovariantVector< double,4 >,double >;
using itkImageFunctionIVD44CVD4D_Pointer = itk::ImageFunction< itk::Image< itk::Vector< double,4 >,4 >,itk::CovariantVector< double,4 >,double >::Pointer;
using itkImageFunctionIVD44DD = itk::ImageFunction< itk::Image< itk::Vector< double,4 >,4 >,double,double >;
using itkImageFunctionIVD44DD_Pointer = itk::ImageFunction< itk::Image< itk::Vector< double,4 >,4 >,double,double >::Pointer;
using itkImageFunctionIVF44VD4D = itk::ImageFunction< itk::Image< itk::Vector< float,4 >,4 >,itk::Vector< double,4 >,double >;
using itkImageFunctionIVF44VD4D_Pointer = itk::ImageFunction< itk::Image< itk::Vector< float,4 >,4 >,itk::Vector< double,4 >,double >::Pointer;
using itkImageFunctionIVF44CVD4D = itk::ImageFunction< itk::Image< itk::Vector< float,4 >,4 >,itk::CovariantVector< double,4 >,double >;
using itkImageFunctionIVF44CVD4D_Pointer = itk::ImageFunction< itk::Image< itk::Vector< float,4 >,4 >,itk::CovariantVector< double,4 >,double >::Pointer;
using itkImageFunctionIVF44DD = itk::ImageFunction< itk::Image< itk::Vector< float,4 >,4 >,double,double >;
using itkImageFunctionIVF44DD_Pointer = itk::ImageFunction< itk::Image< itk::Vector< float,4 >,4 >,double,double >::Pointer;
using itkImageFunctionICVD44VD4D = itk::ImageFunction< itk::Image< itk::CovariantVector< double,4 >,4 >,itk::Vector< double,4 >,double >;
using itkImageFunctionICVD44VD4D_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< double,4 >,4 >,itk::Vector< double,4 >,double >::Pointer;
using itkImageFunctionICVD44CVD4D = itk::ImageFunction< itk::Image< itk::CovariantVector< double,4 >,4 >,itk::CovariantVector< double,4 >,double >;
using itkImageFunctionICVD44CVD4D_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< double,4 >,4 >,itk::CovariantVector< double,4 >,double >::Pointer;
using itkImageFunctionICVD44DD = itk::ImageFunction< itk::Image< itk::CovariantVector< double,4 >,4 >,double,double >;
using itkImageFunctionICVD44DD_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< double,4 >,4 >,double,double >::Pointer;
using itkImageFunctionICVF44VD4D = itk::ImageFunction< itk::Image< itk::CovariantVector< float,4 >,4 >,itk::Vector< double,4 >,double >;
using itkImageFunctionICVF44VD4D_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< float,4 >,4 >,itk::Vector< double,4 >,double >::Pointer;
using itkImageFunctionICVF44CVD4D = itk::ImageFunction< itk::Image< itk::CovariantVector< float,4 >,4 >,itk::CovariantVector< double,4 >,double >;
using itkImageFunctionICVF44CVD4D_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< float,4 >,4 >,itk::CovariantVector< double,4 >,double >::Pointer;
using itkImageFunctionICVF44DD = itk::ImageFunction< itk::Image< itk::CovariantVector< float,4 >,4 >,double,double >;
using itkImageFunctionICVF44DD_Pointer = itk::ImageFunction< itk::Image< itk::CovariantVector< float,4 >,4 >,double,double >::Pointer;
using itkImageFunctionIRGBUC4RGBUCD = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned char >,4 >,itk::RGBPixel< unsigned char >,double >;
using itkImageFunctionIRGBUC4RGBUCD_Pointer = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned char >,4 >,itk::RGBPixel< unsigned char >,double >::Pointer;
using itkImageFunctionIRGBUS4RGBUSD = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned short >,4 >,itk::RGBPixel< unsigned short >,double >;
using itkImageFunctionIRGBUS4RGBUSD_Pointer = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned short >,4 >,itk::RGBPixel< unsigned short >,double >::Pointer;
using itkImageFunctionIRGBAUC4RGBAUCD = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,4 >,itk::RGBAPixel< unsigned char >,double >;
using itkImageFunctionIRGBAUC4RGBAUCD_Pointer = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,4 >,itk::RGBAPixel< unsigned char >,double >::Pointer;
using itkImageFunctionIRGBAUS4RGBAUSD = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,4 >,itk::RGBAPixel< unsigned short >,double >;
using itkImageFunctionIRGBAUS4RGBAUSD_Pointer = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,4 >,itk::RGBAPixel< unsigned short >,double >::Pointer;
using itkImageFunctionIRGBUC4RGBDD = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned char >,4 >,itk::RGBPixel< double >,double >;
using itkImageFunctionIRGBUC4RGBDD_Pointer = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned char >,4 >,itk::RGBPixel< double >,double >::Pointer;
using itkImageFunctionIRGBUS4RGBDD = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned short >,4 >,itk::RGBPixel< double >,double >;
using itkImageFunctionIRGBUS4RGBDD_Pointer = itk::ImageFunction< itk::Image< itk::RGBPixel< unsigned short >,4 >,itk::RGBPixel< double >,double >::Pointer;
using itkImageFunctionIRGBAUC4RGBADD = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,4 >,itk::RGBAPixel< double >,double >;
using itkImageFunctionIRGBAUC4RGBADD_Pointer = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,4 >,itk::RGBAPixel< double >,double >::Pointer;
using itkImageFunctionIRGBAUS4RGBADD = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,4 >,itk::RGBAPixel< double >,double >;
using itkImageFunctionIRGBAUS4RGBADD_Pointer = itk::ImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,4 >,itk::RGBAPixel< double >,double >::Pointer;
using itkImageFunctionPA3DSCIFD = itk::ImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, double, double >;
using itkImageFunctionPA3DSCIFD_Pointer = itk::ImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, double, double >::Pointer;
using itkImageFunctionPA3DSCIUCD = itk::ImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, double, double >;
using itkImageFunctionPA3DSCIUCD_Pointer = itk::ImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, double, double >::Pointer;


#include "itkImageFunctionBaseSwigInterface.h"
#include "itkPhasedArray3DSpecialCoordinatesImageSwigInterface.h"
#include "ITKCommonBaseSwigInterface.h"
#include "itkImageSwigInterface.h"
#include "itkVectorSwigInterface.h"
#include "itkRGBPixelSwigInterface.h"
#include "itkFunctionBaseSwigInterface.h"
#include "itkCovariantVectorSwigInterface.h"
#include "itkPointSwigInterface.h"
#include "itkContinuousIndexSwigInterface.h"
#include "itkIndexSwigInterface.h"
#include "itkRGBAPixelSwigInterface.h"
#endif
