#ifndef itkImageDuplicatorSwigInterface_h
#define itkImageDuplicatorSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkImageDuplicator.h"

using itkImageDuplicatorISC2 = itk::ImageDuplicator< itk::Image< signed char,2 > >;
using itkImageDuplicatorISC2_Pointer = itk::ImageDuplicator< itk::Image< signed char,2 > >::Pointer;
using itkImageDuplicatorISC3 = itk::ImageDuplicator< itk::Image< signed char,3 > >;
using itkImageDuplicatorISC3_Pointer = itk::ImageDuplicator< itk::Image< signed char,3 > >::Pointer;
using itkImageDuplicatorISC4 = itk::ImageDuplicator< itk::Image< signed char,4 > >;
using itkImageDuplicatorISC4_Pointer = itk::ImageDuplicator< itk::Image< signed char,4 > >::Pointer;
using itkImageDuplicatorISS2 = itk::ImageDuplicator< itk::Image< signed short,2 > >;
using itkImageDuplicatorISS2_Pointer = itk::ImageDuplicator< itk::Image< signed short,2 > >::Pointer;
using itkImageDuplicatorISS3 = itk::ImageDuplicator< itk::Image< signed short,3 > >;
using itkImageDuplicatorISS3_Pointer = itk::ImageDuplicator< itk::Image< signed short,3 > >::Pointer;
using itkImageDuplicatorISS4 = itk::ImageDuplicator< itk::Image< signed short,4 > >;
using itkImageDuplicatorISS4_Pointer = itk::ImageDuplicator< itk::Image< signed short,4 > >::Pointer;
using itkImageDuplicatorIUC2 = itk::ImageDuplicator< itk::Image< unsigned char,2 > >;
using itkImageDuplicatorIUC2_Pointer = itk::ImageDuplicator< itk::Image< unsigned char,2 > >::Pointer;
using itkImageDuplicatorIRGBUC2 = itk::ImageDuplicator< itk::Image< itk::RGBPixel< unsigned char >,2 > >;
using itkImageDuplicatorIRGBUC2_Pointer = itk::ImageDuplicator< itk::Image< itk::RGBPixel< unsigned char >,2 > >::Pointer;
using itkImageDuplicatorIRGBAUC2 = itk::ImageDuplicator< itk::Image< itk::RGBAPixel< unsigned char >,2 > >;
using itkImageDuplicatorIRGBAUC2_Pointer = itk::ImageDuplicator< itk::Image< itk::RGBAPixel< unsigned char >,2 > >::Pointer;
using itkImageDuplicatorIUC3 = itk::ImageDuplicator< itk::Image< unsigned char,3 > >;
using itkImageDuplicatorIUC3_Pointer = itk::ImageDuplicator< itk::Image< unsigned char,3 > >::Pointer;
using itkImageDuplicatorIRGBUC3 = itk::ImageDuplicator< itk::Image< itk::RGBPixel< unsigned char >,3 > >;
using itkImageDuplicatorIRGBUC3_Pointer = itk::ImageDuplicator< itk::Image< itk::RGBPixel< unsigned char >,3 > >::Pointer;
using itkImageDuplicatorIRGBAUC3 = itk::ImageDuplicator< itk::Image< itk::RGBAPixel< unsigned char >,3 > >;
using itkImageDuplicatorIRGBAUC3_Pointer = itk::ImageDuplicator< itk::Image< itk::RGBAPixel< unsigned char >,3 > >::Pointer;
using itkImageDuplicatorIUC4 = itk::ImageDuplicator< itk::Image< unsigned char,4 > >;
using itkImageDuplicatorIUC4_Pointer = itk::ImageDuplicator< itk::Image< unsigned char,4 > >::Pointer;
using itkImageDuplicatorIRGBUC4 = itk::ImageDuplicator< itk::Image< itk::RGBPixel< unsigned char >,4 > >;
using itkImageDuplicatorIRGBUC4_Pointer = itk::ImageDuplicator< itk::Image< itk::RGBPixel< unsigned char >,4 > >::Pointer;
using itkImageDuplicatorIRGBAUC4 = itk::ImageDuplicator< itk::Image< itk::RGBAPixel< unsigned char >,4 > >;
using itkImageDuplicatorIRGBAUC4_Pointer = itk::ImageDuplicator< itk::Image< itk::RGBAPixel< unsigned char >,4 > >::Pointer;
using itkImageDuplicatorIULL2 = itk::ImageDuplicator< itk::Image< unsigned long long,2 > >;
using itkImageDuplicatorIULL2_Pointer = itk::ImageDuplicator< itk::Image< unsigned long long,2 > >::Pointer;
using itkImageDuplicatorIULL3 = itk::ImageDuplicator< itk::Image< unsigned long long,3 > >;
using itkImageDuplicatorIULL3_Pointer = itk::ImageDuplicator< itk::Image< unsigned long long,3 > >::Pointer;
using itkImageDuplicatorIULL4 = itk::ImageDuplicator< itk::Image< unsigned long long,4 > >;
using itkImageDuplicatorIULL4_Pointer = itk::ImageDuplicator< itk::Image< unsigned long long,4 > >::Pointer;
using itkImageDuplicatorIUS2 = itk::ImageDuplicator< itk::Image< unsigned short,2 > >;
using itkImageDuplicatorIUS2_Pointer = itk::ImageDuplicator< itk::Image< unsigned short,2 > >::Pointer;
using itkImageDuplicatorIRGBUS2 = itk::ImageDuplicator< itk::Image< itk::RGBPixel< unsigned short >,2 > >;
using itkImageDuplicatorIRGBUS2_Pointer = itk::ImageDuplicator< itk::Image< itk::RGBPixel< unsigned short >,2 > >::Pointer;
using itkImageDuplicatorIRGBAUS2 = itk::ImageDuplicator< itk::Image< itk::RGBAPixel< unsigned short >,2 > >;
using itkImageDuplicatorIRGBAUS2_Pointer = itk::ImageDuplicator< itk::Image< itk::RGBAPixel< unsigned short >,2 > >::Pointer;
using itkImageDuplicatorIUS3 = itk::ImageDuplicator< itk::Image< unsigned short,3 > >;
using itkImageDuplicatorIUS3_Pointer = itk::ImageDuplicator< itk::Image< unsigned short,3 > >::Pointer;
using itkImageDuplicatorIRGBUS3 = itk::ImageDuplicator< itk::Image< itk::RGBPixel< unsigned short >,3 > >;
using itkImageDuplicatorIRGBUS3_Pointer = itk::ImageDuplicator< itk::Image< itk::RGBPixel< unsigned short >,3 > >::Pointer;
using itkImageDuplicatorIRGBAUS3 = itk::ImageDuplicator< itk::Image< itk::RGBAPixel< unsigned short >,3 > >;
using itkImageDuplicatorIRGBAUS3_Pointer = itk::ImageDuplicator< itk::Image< itk::RGBAPixel< unsigned short >,3 > >::Pointer;
using itkImageDuplicatorIUS4 = itk::ImageDuplicator< itk::Image< unsigned short,4 > >;
using itkImageDuplicatorIUS4_Pointer = itk::ImageDuplicator< itk::Image< unsigned short,4 > >::Pointer;
using itkImageDuplicatorIRGBUS4 = itk::ImageDuplicator< itk::Image< itk::RGBPixel< unsigned short >,4 > >;
using itkImageDuplicatorIRGBUS4_Pointer = itk::ImageDuplicator< itk::Image< itk::RGBPixel< unsigned short >,4 > >::Pointer;
using itkImageDuplicatorIRGBAUS4 = itk::ImageDuplicator< itk::Image< itk::RGBAPixel< unsigned short >,4 > >;
using itkImageDuplicatorIRGBAUS4_Pointer = itk::ImageDuplicator< itk::Image< itk::RGBAPixel< unsigned short >,4 > >::Pointer;
using itkImageDuplicatorIF2 = itk::ImageDuplicator< itk::Image< float,2 > >;
using itkImageDuplicatorIF2_Pointer = itk::ImageDuplicator< itk::Image< float,2 > >::Pointer;
using itkImageDuplicatorISSRTF22 = itk::ImageDuplicator< itk::Image< itk::SymmetricSecondRankTensor< float, 2 >, 2 > >;
using itkImageDuplicatorISSRTF22_Pointer = itk::ImageDuplicator< itk::Image< itk::SymmetricSecondRankTensor< float, 2 >, 2 > >::Pointer;
using itkImageDuplicatorIVF22 = itk::ImageDuplicator< itk::Image< itk::Vector< float,2 >,2 > >;
using itkImageDuplicatorIVF22_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< float,2 >,2 > >::Pointer;
using itkImageDuplicatorICVF22 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,2 >,2 > >;
using itkImageDuplicatorICVF22_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,2 >,2 > >::Pointer;
using itkImageDuplicatorIVF32 = itk::ImageDuplicator< itk::Image< itk::Vector< float,3 >,2 > >;
using itkImageDuplicatorIVF32_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< float,3 >,2 > >::Pointer;
using itkImageDuplicatorICVF32 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,3 >,2 > >;
using itkImageDuplicatorICVF32_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,3 >,2 > >::Pointer;
using itkImageDuplicatorIVF42 = itk::ImageDuplicator< itk::Image< itk::Vector< float,4 >,2 > >;
using itkImageDuplicatorIVF42_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< float,4 >,2 > >::Pointer;
using itkImageDuplicatorICVF42 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,4 >,2 > >;
using itkImageDuplicatorICVF42_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,4 >,2 > >::Pointer;
using itkImageDuplicatorIF3 = itk::ImageDuplicator< itk::Image< float,3 > >;
using itkImageDuplicatorIF3_Pointer = itk::ImageDuplicator< itk::Image< float,3 > >::Pointer;
using itkImageDuplicatorISSRTF33 = itk::ImageDuplicator< itk::Image< itk::SymmetricSecondRankTensor< float, 3 >, 3 > >;
using itkImageDuplicatorISSRTF33_Pointer = itk::ImageDuplicator< itk::Image< itk::SymmetricSecondRankTensor< float, 3 >, 3 > >::Pointer;
using itkImageDuplicatorIVF23 = itk::ImageDuplicator< itk::Image< itk::Vector< float,2 >,3 > >;
using itkImageDuplicatorIVF23_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< float,2 >,3 > >::Pointer;
using itkImageDuplicatorICVF23 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,2 >,3 > >;
using itkImageDuplicatorICVF23_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,2 >,3 > >::Pointer;
using itkImageDuplicatorIVF33 = itk::ImageDuplicator< itk::Image< itk::Vector< float,3 >,3 > >;
using itkImageDuplicatorIVF33_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< float,3 >,3 > >::Pointer;
using itkImageDuplicatorICVF33 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,3 >,3 > >;
using itkImageDuplicatorICVF33_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,3 >,3 > >::Pointer;
using itkImageDuplicatorIVF43 = itk::ImageDuplicator< itk::Image< itk::Vector< float,4 >,3 > >;
using itkImageDuplicatorIVF43_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< float,4 >,3 > >::Pointer;
using itkImageDuplicatorICVF43 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,4 >,3 > >;
using itkImageDuplicatorICVF43_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,4 >,3 > >::Pointer;
using itkImageDuplicatorIF4 = itk::ImageDuplicator< itk::Image< float,4 > >;
using itkImageDuplicatorIF4_Pointer = itk::ImageDuplicator< itk::Image< float,4 > >::Pointer;
using itkImageDuplicatorISSRTF44 = itk::ImageDuplicator< itk::Image< itk::SymmetricSecondRankTensor< float, 4 >, 4 > >;
using itkImageDuplicatorISSRTF44_Pointer = itk::ImageDuplicator< itk::Image< itk::SymmetricSecondRankTensor< float, 4 >, 4 > >::Pointer;
using itkImageDuplicatorIVF24 = itk::ImageDuplicator< itk::Image< itk::Vector< float,2 >,4 > >;
using itkImageDuplicatorIVF24_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< float,2 >,4 > >::Pointer;
using itkImageDuplicatorICVF24 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,2 >,4 > >;
using itkImageDuplicatorICVF24_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,2 >,4 > >::Pointer;
using itkImageDuplicatorIVF34 = itk::ImageDuplicator< itk::Image< itk::Vector< float,3 >,4 > >;
using itkImageDuplicatorIVF34_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< float,3 >,4 > >::Pointer;
using itkImageDuplicatorICVF34 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,3 >,4 > >;
using itkImageDuplicatorICVF34_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,3 >,4 > >::Pointer;
using itkImageDuplicatorIVF44 = itk::ImageDuplicator< itk::Image< itk::Vector< float,4 >,4 > >;
using itkImageDuplicatorIVF44_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< float,4 >,4 > >::Pointer;
using itkImageDuplicatorICVF44 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,4 >,4 > >;
using itkImageDuplicatorICVF44_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< float,4 >,4 > >::Pointer;
using itkImageDuplicatorID2 = itk::ImageDuplicator< itk::Image< double,2 > >;
using itkImageDuplicatorID2_Pointer = itk::ImageDuplicator< itk::Image< double,2 > >::Pointer;
using itkImageDuplicatorISSRTD22 = itk::ImageDuplicator< itk::Image< itk::SymmetricSecondRankTensor< double, 2 >, 2 > >;
using itkImageDuplicatorISSRTD22_Pointer = itk::ImageDuplicator< itk::Image< itk::SymmetricSecondRankTensor< double, 2 >, 2 > >::Pointer;
using itkImageDuplicatorIVD22 = itk::ImageDuplicator< itk::Image< itk::Vector< double,2 >,2 > >;
using itkImageDuplicatorIVD22_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< double,2 >,2 > >::Pointer;
using itkImageDuplicatorICVD22 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,2 >,2 > >;
using itkImageDuplicatorICVD22_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,2 >,2 > >::Pointer;
using itkImageDuplicatorIVD32 = itk::ImageDuplicator< itk::Image< itk::Vector< double,3 >,2 > >;
using itkImageDuplicatorIVD32_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< double,3 >,2 > >::Pointer;
using itkImageDuplicatorICVD32 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,3 >,2 > >;
using itkImageDuplicatorICVD32_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,3 >,2 > >::Pointer;
using itkImageDuplicatorIVD42 = itk::ImageDuplicator< itk::Image< itk::Vector< double,4 >,2 > >;
using itkImageDuplicatorIVD42_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< double,4 >,2 > >::Pointer;
using itkImageDuplicatorICVD42 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,4 >,2 > >;
using itkImageDuplicatorICVD42_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,4 >,2 > >::Pointer;
using itkImageDuplicatorID3 = itk::ImageDuplicator< itk::Image< double,3 > >;
using itkImageDuplicatorID3_Pointer = itk::ImageDuplicator< itk::Image< double,3 > >::Pointer;
using itkImageDuplicatorISSRTD33 = itk::ImageDuplicator< itk::Image< itk::SymmetricSecondRankTensor< double, 3 >, 3 > >;
using itkImageDuplicatorISSRTD33_Pointer = itk::ImageDuplicator< itk::Image< itk::SymmetricSecondRankTensor< double, 3 >, 3 > >::Pointer;
using itkImageDuplicatorIVD23 = itk::ImageDuplicator< itk::Image< itk::Vector< double,2 >,3 > >;
using itkImageDuplicatorIVD23_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< double,2 >,3 > >::Pointer;
using itkImageDuplicatorICVD23 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,2 >,3 > >;
using itkImageDuplicatorICVD23_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,2 >,3 > >::Pointer;
using itkImageDuplicatorIVD33 = itk::ImageDuplicator< itk::Image< itk::Vector< double,3 >,3 > >;
using itkImageDuplicatorIVD33_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< double,3 >,3 > >::Pointer;
using itkImageDuplicatorICVD33 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,3 >,3 > >;
using itkImageDuplicatorICVD33_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,3 >,3 > >::Pointer;
using itkImageDuplicatorIVD43 = itk::ImageDuplicator< itk::Image< itk::Vector< double,4 >,3 > >;
using itkImageDuplicatorIVD43_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< double,4 >,3 > >::Pointer;
using itkImageDuplicatorICVD43 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,4 >,3 > >;
using itkImageDuplicatorICVD43_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,4 >,3 > >::Pointer;
using itkImageDuplicatorID4 = itk::ImageDuplicator< itk::Image< double,4 > >;
using itkImageDuplicatorID4_Pointer = itk::ImageDuplicator< itk::Image< double,4 > >::Pointer;
using itkImageDuplicatorISSRTD44 = itk::ImageDuplicator< itk::Image< itk::SymmetricSecondRankTensor< double, 4 >, 4 > >;
using itkImageDuplicatorISSRTD44_Pointer = itk::ImageDuplicator< itk::Image< itk::SymmetricSecondRankTensor< double, 4 >, 4 > >::Pointer;
using itkImageDuplicatorIVD24 = itk::ImageDuplicator< itk::Image< itk::Vector< double,2 >,4 > >;
using itkImageDuplicatorIVD24_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< double,2 >,4 > >::Pointer;
using itkImageDuplicatorICVD24 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,2 >,4 > >;
using itkImageDuplicatorICVD24_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,2 >,4 > >::Pointer;
using itkImageDuplicatorIVD34 = itk::ImageDuplicator< itk::Image< itk::Vector< double,3 >,4 > >;
using itkImageDuplicatorIVD34_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< double,3 >,4 > >::Pointer;
using itkImageDuplicatorICVD34 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,3 >,4 > >;
using itkImageDuplicatorICVD34_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,3 >,4 > >::Pointer;
using itkImageDuplicatorIVD44 = itk::ImageDuplicator< itk::Image< itk::Vector< double,4 >,4 > >;
using itkImageDuplicatorIVD44_Pointer = itk::ImageDuplicator< itk::Image< itk::Vector< double,4 >,4 > >::Pointer;
using itkImageDuplicatorICVD44 = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,4 >,4 > >;
using itkImageDuplicatorICVD44_Pointer = itk::ImageDuplicator< itk::Image< itk::CovariantVector< double,4 >,4 > >::Pointer;
using itkImageDuplicatorIUI2 = itk::ImageDuplicator< itk::Image< unsigned int,2 > >;
using itkImageDuplicatorIUI2_Pointer = itk::ImageDuplicator< itk::Image< unsigned int,2 > >::Pointer;
using itkImageDuplicatorIUI3 = itk::ImageDuplicator< itk::Image< unsigned int,3 > >;
using itkImageDuplicatorIUI3_Pointer = itk::ImageDuplicator< itk::Image< unsigned int,3 > >::Pointer;
using itkImageDuplicatorIUI4 = itk::ImageDuplicator< itk::Image< unsigned int,4 > >;
using itkImageDuplicatorIUI4_Pointer = itk::ImageDuplicator< itk::Image< unsigned int,4 > >::Pointer;
using itkImageDuplicatorIUL2 = itk::ImageDuplicator< itk::Image< unsigned long,2 > >;
using itkImageDuplicatorIUL2_Pointer = itk::ImageDuplicator< itk::Image< unsigned long,2 > >::Pointer;
using itkImageDuplicatorIUL3 = itk::ImageDuplicator< itk::Image< unsigned long,3 > >;
using itkImageDuplicatorIUL3_Pointer = itk::ImageDuplicator< itk::Image< unsigned long,3 > >::Pointer;
using itkImageDuplicatorIUL4 = itk::ImageDuplicator< itk::Image< unsigned long,4 > >;
using itkImageDuplicatorIUL4_Pointer = itk::ImageDuplicator< itk::Image< unsigned long,4 > >::Pointer;
using itkImageDuplicatorISI2 = itk::ImageDuplicator< itk::Image< signed int,2 > >;
using itkImageDuplicatorISI2_Pointer = itk::ImageDuplicator< itk::Image< signed int,2 > >::Pointer;
using itkImageDuplicatorISI3 = itk::ImageDuplicator< itk::Image< signed int,3 > >;
using itkImageDuplicatorISI3_Pointer = itk::ImageDuplicator< itk::Image< signed int,3 > >::Pointer;
using itkImageDuplicatorISI4 = itk::ImageDuplicator< itk::Image< signed int,4 > >;
using itkImageDuplicatorISI4_Pointer = itk::ImageDuplicator< itk::Image< signed int,4 > >::Pointer;
using itkImageDuplicatorVICD2 = itk::ImageDuplicator< itk::VectorImage< std::complex< double >,2 > >;
using itkImageDuplicatorVICD2_Pointer = itk::ImageDuplicator< itk::VectorImage< std::complex< double >,2 > >::Pointer;
using itkImageDuplicatorVICD3 = itk::ImageDuplicator< itk::VectorImage< std::complex< double >,3 > >;
using itkImageDuplicatorVICD3_Pointer = itk::ImageDuplicator< itk::VectorImage< std::complex< double >,3 > >::Pointer;
using itkImageDuplicatorVICD4 = itk::ImageDuplicator< itk::VectorImage< std::complex< double >,4 > >;
using itkImageDuplicatorVICD4_Pointer = itk::ImageDuplicator< itk::VectorImage< std::complex< double >,4 > >::Pointer;
using itkImageDuplicatorVICF2 = itk::ImageDuplicator< itk::VectorImage< std::complex< float >,2 > >;
using itkImageDuplicatorVICF2_Pointer = itk::ImageDuplicator< itk::VectorImage< std::complex< float >,2 > >::Pointer;
using itkImageDuplicatorVICF3 = itk::ImageDuplicator< itk::VectorImage< std::complex< float >,3 > >;
using itkImageDuplicatorVICF3_Pointer = itk::ImageDuplicator< itk::VectorImage< std::complex< float >,3 > >::Pointer;
using itkImageDuplicatorVICF4 = itk::ImageDuplicator< itk::VectorImage< std::complex< float >,4 > >;
using itkImageDuplicatorVICF4_Pointer = itk::ImageDuplicator< itk::VectorImage< std::complex< float >,4 > >::Pointer;
using itkImageDuplicatorVISC2 = itk::ImageDuplicator< itk::VectorImage< signed char,2 > >;
using itkImageDuplicatorVISC2_Pointer = itk::ImageDuplicator< itk::VectorImage< signed char,2 > >::Pointer;
using itkImageDuplicatorVISC3 = itk::ImageDuplicator< itk::VectorImage< signed char,3 > >;
using itkImageDuplicatorVISC3_Pointer = itk::ImageDuplicator< itk::VectorImage< signed char,3 > >::Pointer;
using itkImageDuplicatorVISC4 = itk::ImageDuplicator< itk::VectorImage< signed char,4 > >;
using itkImageDuplicatorVISC4_Pointer = itk::ImageDuplicator< itk::VectorImage< signed char,4 > >::Pointer;
using itkImageDuplicatorVISS2 = itk::ImageDuplicator< itk::VectorImage< signed short,2 > >;
using itkImageDuplicatorVISS2_Pointer = itk::ImageDuplicator< itk::VectorImage< signed short,2 > >::Pointer;
using itkImageDuplicatorVISS3 = itk::ImageDuplicator< itk::VectorImage< signed short,3 > >;
using itkImageDuplicatorVISS3_Pointer = itk::ImageDuplicator< itk::VectorImage< signed short,3 > >::Pointer;
using itkImageDuplicatorVISS4 = itk::ImageDuplicator< itk::VectorImage< signed short,4 > >;
using itkImageDuplicatorVISS4_Pointer = itk::ImageDuplicator< itk::VectorImage< signed short,4 > >::Pointer;
using itkImageDuplicatorVIUC2 = itk::ImageDuplicator< itk::VectorImage< unsigned char,2 > >;
using itkImageDuplicatorVIUC2_Pointer = itk::ImageDuplicator< itk::VectorImage< unsigned char,2 > >::Pointer;
using itkImageDuplicatorVIUC3 = itk::ImageDuplicator< itk::VectorImage< unsigned char,3 > >;
using itkImageDuplicatorVIUC3_Pointer = itk::ImageDuplicator< itk::VectorImage< unsigned char,3 > >::Pointer;
using itkImageDuplicatorVIUC4 = itk::ImageDuplicator< itk::VectorImage< unsigned char,4 > >;
using itkImageDuplicatorVIUC4_Pointer = itk::ImageDuplicator< itk::VectorImage< unsigned char,4 > >::Pointer;
using itkImageDuplicatorVIULL2 = itk::ImageDuplicator< itk::VectorImage< unsigned long long,2 > >;
using itkImageDuplicatorVIULL2_Pointer = itk::ImageDuplicator< itk::VectorImage< unsigned long long,2 > >::Pointer;
using itkImageDuplicatorVIULL3 = itk::ImageDuplicator< itk::VectorImage< unsigned long long,3 > >;
using itkImageDuplicatorVIULL3_Pointer = itk::ImageDuplicator< itk::VectorImage< unsigned long long,3 > >::Pointer;
using itkImageDuplicatorVIULL4 = itk::ImageDuplicator< itk::VectorImage< unsigned long long,4 > >;
using itkImageDuplicatorVIULL4_Pointer = itk::ImageDuplicator< itk::VectorImage< unsigned long long,4 > >::Pointer;
using itkImageDuplicatorVIUS2 = itk::ImageDuplicator< itk::VectorImage< unsigned short,2 > >;
using itkImageDuplicatorVIUS2_Pointer = itk::ImageDuplicator< itk::VectorImage< unsigned short,2 > >::Pointer;
using itkImageDuplicatorVIUS3 = itk::ImageDuplicator< itk::VectorImage< unsigned short,3 > >;
using itkImageDuplicatorVIUS3_Pointer = itk::ImageDuplicator< itk::VectorImage< unsigned short,3 > >::Pointer;
using itkImageDuplicatorVIUS4 = itk::ImageDuplicator< itk::VectorImage< unsigned short,4 > >;
using itkImageDuplicatorVIUS4_Pointer = itk::ImageDuplicator< itk::VectorImage< unsigned short,4 > >::Pointer;
using itkImageDuplicatorVIF2 = itk::ImageDuplicator< itk::VectorImage< float,2 > >;
using itkImageDuplicatorVIF2_Pointer = itk::ImageDuplicator< itk::VectorImage< float,2 > >::Pointer;
using itkImageDuplicatorVIF3 = itk::ImageDuplicator< itk::VectorImage< float,3 > >;
using itkImageDuplicatorVIF3_Pointer = itk::ImageDuplicator< itk::VectorImage< float,3 > >::Pointer;
using itkImageDuplicatorVIF4 = itk::ImageDuplicator< itk::VectorImage< float,4 > >;
using itkImageDuplicatorVIF4_Pointer = itk::ImageDuplicator< itk::VectorImage< float,4 > >::Pointer;
using itkImageDuplicatorVID2 = itk::ImageDuplicator< itk::VectorImage< double,2 > >;
using itkImageDuplicatorVID2_Pointer = itk::ImageDuplicator< itk::VectorImage< double,2 > >::Pointer;
using itkImageDuplicatorVID3 = itk::ImageDuplicator< itk::VectorImage< double,3 > >;
using itkImageDuplicatorVID3_Pointer = itk::ImageDuplicator< itk::VectorImage< double,3 > >::Pointer;
using itkImageDuplicatorVID4 = itk::ImageDuplicator< itk::VectorImage< double,4 > >;
using itkImageDuplicatorVID4_Pointer = itk::ImageDuplicator< itk::VectorImage< double,4 > >::Pointer;


#include "itkImageSwigInterface.h"
#include "itkVectorImageSwigInterface.h"
#include "ITKCommonBaseSwigInterface.h"
#include "itkImageDuplicatorSwigInterface.h"
#endif
