//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/matching/common_inputs/transport_socket/v3/transport_socket_inputs.proto

package transport_socketv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on EndpointMetadataInput with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *EndpointMetadataInput) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on EndpointMetadataInput with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// EndpointMetadataInputMultiError, or nil if none found.
func (m *EndpointMetadataInput) ValidateAll() error {
	return m.validate(true)
}

func (m *EndpointMetadataInput) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Filter

	if len(m.GetPath()) < 1 {
		err := EndpointMetadataInputValidationError{
			field:  "Path",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetPath() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, EndpointMetadataInputValidationError{
						field:  fmt.Sprintf("Path[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, EndpointMetadataInputValidationError{
						field:  fmt.Sprintf("Path[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return EndpointMetadataInputValidationError{
					field:  fmt.Sprintf("Path[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return EndpointMetadataInputMultiError(errors)
	}

	return nil
}

// EndpointMetadataInputMultiError is an error wrapping multiple validation
// errors returned by EndpointMetadataInput.ValidateAll() if the designated
// constraints aren't met.
type EndpointMetadataInputMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m EndpointMetadataInputMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m EndpointMetadataInputMultiError) AllErrors() []error { return m }

// EndpointMetadataInputValidationError is the validation error returned by
// EndpointMetadataInput.Validate if the designated constraints aren't met.
type EndpointMetadataInputValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndpointMetadataInputValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndpointMetadataInputValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndpointMetadataInputValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndpointMetadataInputValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndpointMetadataInputValidationError) ErrorName() string {
	return "EndpointMetadataInputValidationError"
}

// Error satisfies the builtin error interface
func (e EndpointMetadataInputValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndpointMetadataInput.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndpointMetadataInputValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndpointMetadataInputValidationError{}

// Validate checks the field values on LocalityMetadataInput with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *LocalityMetadataInput) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on LocalityMetadataInput with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// LocalityMetadataInputMultiError, or nil if none found.
func (m *LocalityMetadataInput) ValidateAll() error {
	return m.validate(true)
}

func (m *LocalityMetadataInput) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Filter

	if len(m.GetPath()) < 1 {
		err := LocalityMetadataInputValidationError{
			field:  "Path",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetPath() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, LocalityMetadataInputValidationError{
						field:  fmt.Sprintf("Path[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, LocalityMetadataInputValidationError{
						field:  fmt.Sprintf("Path[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return LocalityMetadataInputValidationError{
					field:  fmt.Sprintf("Path[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return LocalityMetadataInputMultiError(errors)
	}

	return nil
}

// LocalityMetadataInputMultiError is an error wrapping multiple validation
// errors returned by LocalityMetadataInput.ValidateAll() if the designated
// constraints aren't met.
type LocalityMetadataInputMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LocalityMetadataInputMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LocalityMetadataInputMultiError) AllErrors() []error { return m }

// LocalityMetadataInputValidationError is the validation error returned by
// LocalityMetadataInput.Validate if the designated constraints aren't met.
type LocalityMetadataInputValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LocalityMetadataInputValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LocalityMetadataInputValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LocalityMetadataInputValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LocalityMetadataInputValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LocalityMetadataInputValidationError) ErrorName() string {
	return "LocalityMetadataInputValidationError"
}

// Error satisfies the builtin error interface
func (e LocalityMetadataInputValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLocalityMetadataInput.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LocalityMetadataInputValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LocalityMetadataInputValidationError{}

// Validate checks the field values on FilterStateInput with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *FilterStateInput) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on FilterStateInput with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// FilterStateInputMultiError, or nil if none found.
func (m *FilterStateInput) ValidateAll() error {
	return m.validate(true)
}

func (m *FilterStateInput) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetKey()) < 1 {
		err := FilterStateInputValidationError{
			field:  "Key",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return FilterStateInputMultiError(errors)
	}

	return nil
}

// FilterStateInputMultiError is an error wrapping multiple validation errors
// returned by FilterStateInput.ValidateAll() if the designated constraints
// aren't met.
type FilterStateInputMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FilterStateInputMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FilterStateInputMultiError) AllErrors() []error { return m }

// FilterStateInputValidationError is the validation error returned by
// FilterStateInput.Validate if the designated constraints aren't met.
type FilterStateInputValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FilterStateInputValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FilterStateInputValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FilterStateInputValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FilterStateInputValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FilterStateInputValidationError) ErrorName() string { return "FilterStateInputValidationError" }

// Error satisfies the builtin error interface
func (e FilterStateInputValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFilterStateInput.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FilterStateInputValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FilterStateInputValidationError{}

// Validate checks the field values on TransportSocketNameAction with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *TransportSocketNameAction) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TransportSocketNameAction with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// TransportSocketNameActionMultiError, or nil if none found.
func (m *TransportSocketNameAction) ValidateAll() error {
	return m.validate(true)
}

func (m *TransportSocketNameAction) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := TransportSocketNameActionValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return TransportSocketNameActionMultiError(errors)
	}

	return nil
}

// TransportSocketNameActionMultiError is an error wrapping multiple validation
// errors returned by TransportSocketNameAction.ValidateAll() if the
// designated constraints aren't met.
type TransportSocketNameActionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TransportSocketNameActionMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TransportSocketNameActionMultiError) AllErrors() []error { return m }

// TransportSocketNameActionValidationError is the validation error returned by
// TransportSocketNameAction.Validate if the designated constraints aren't met.
type TransportSocketNameActionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TransportSocketNameActionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TransportSocketNameActionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TransportSocketNameActionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TransportSocketNameActionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TransportSocketNameActionValidationError) ErrorName() string {
	return "TransportSocketNameActionValidationError"
}

// Error satisfies the builtin error interface
func (e TransportSocketNameActionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTransportSocketNameAction.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TransportSocketNameActionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TransportSocketNameActionValidationError{}

// Validate checks the field values on EndpointMetadataInput_PathSegment with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *EndpointMetadataInput_PathSegment) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on EndpointMetadataInput_PathSegment
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// EndpointMetadataInput_PathSegmentMultiError, or nil if none found.
func (m *EndpointMetadataInput_PathSegment) ValidateAll() error {
	return m.validate(true)
}

func (m *EndpointMetadataInput_PathSegment) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofSegmentPresent := false
	switch v := m.Segment.(type) {
	case *EndpointMetadataInput_PathSegment_Key:
		if v == nil {
			err := EndpointMetadataInput_PathSegmentValidationError{
				field:  "Segment",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofSegmentPresent = true

		if utf8.RuneCountInString(m.GetKey()) < 1 {
			err := EndpointMetadataInput_PathSegmentValidationError{
				field:  "Key",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofSegmentPresent {
		err := EndpointMetadataInput_PathSegmentValidationError{
			field:  "Segment",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return EndpointMetadataInput_PathSegmentMultiError(errors)
	}

	return nil
}

// EndpointMetadataInput_PathSegmentMultiError is an error wrapping multiple
// validation errors returned by
// EndpointMetadataInput_PathSegment.ValidateAll() if the designated
// constraints aren't met.
type EndpointMetadataInput_PathSegmentMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m EndpointMetadataInput_PathSegmentMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m EndpointMetadataInput_PathSegmentMultiError) AllErrors() []error { return m }

// EndpointMetadataInput_PathSegmentValidationError is the validation error
// returned by EndpointMetadataInput_PathSegment.Validate if the designated
// constraints aren't met.
type EndpointMetadataInput_PathSegmentValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e EndpointMetadataInput_PathSegmentValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e EndpointMetadataInput_PathSegmentValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e EndpointMetadataInput_PathSegmentValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e EndpointMetadataInput_PathSegmentValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e EndpointMetadataInput_PathSegmentValidationError) ErrorName() string {
	return "EndpointMetadataInput_PathSegmentValidationError"
}

// Error satisfies the builtin error interface
func (e EndpointMetadataInput_PathSegmentValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sEndpointMetadataInput_PathSegment.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = EndpointMetadataInput_PathSegmentValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = EndpointMetadataInput_PathSegmentValidationError{}

// Validate checks the field values on LocalityMetadataInput_PathSegment with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *LocalityMetadataInput_PathSegment) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on LocalityMetadataInput_PathSegment
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// LocalityMetadataInput_PathSegmentMultiError, or nil if none found.
func (m *LocalityMetadataInput_PathSegment) ValidateAll() error {
	return m.validate(true)
}

func (m *LocalityMetadataInput_PathSegment) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofSegmentPresent := false
	switch v := m.Segment.(type) {
	case *LocalityMetadataInput_PathSegment_Key:
		if v == nil {
			err := LocalityMetadataInput_PathSegmentValidationError{
				field:  "Segment",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofSegmentPresent = true

		if utf8.RuneCountInString(m.GetKey()) < 1 {
			err := LocalityMetadataInput_PathSegmentValidationError{
				field:  "Key",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofSegmentPresent {
		err := LocalityMetadataInput_PathSegmentValidationError{
			field:  "Segment",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return LocalityMetadataInput_PathSegmentMultiError(errors)
	}

	return nil
}

// LocalityMetadataInput_PathSegmentMultiError is an error wrapping multiple
// validation errors returned by
// LocalityMetadataInput_PathSegment.ValidateAll() if the designated
// constraints aren't met.
type LocalityMetadataInput_PathSegmentMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LocalityMetadataInput_PathSegmentMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LocalityMetadataInput_PathSegmentMultiError) AllErrors() []error { return m }

// LocalityMetadataInput_PathSegmentValidationError is the validation error
// returned by LocalityMetadataInput_PathSegment.Validate if the designated
// constraints aren't met.
type LocalityMetadataInput_PathSegmentValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LocalityMetadataInput_PathSegmentValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LocalityMetadataInput_PathSegmentValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LocalityMetadataInput_PathSegmentValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LocalityMetadataInput_PathSegmentValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LocalityMetadataInput_PathSegmentValidationError) ErrorName() string {
	return "LocalityMetadataInput_PathSegmentValidationError"
}

// Error satisfies the builtin error interface
func (e LocalityMetadataInput_PathSegmentValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLocalityMetadataInput_PathSegment.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LocalityMetadataInput_PathSegmentValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LocalityMetadataInput_PathSegmentValidationError{}
