// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v6.33.2
// source: envoy/extensions/http/cache_v2/file_system_http_cache/v3/file_system_http_cache.proto

package file_system_http_cachev3

import (
	_ "github.com/cncf/xds/go/udpa/annotations"
	_ "github.com/cncf/xds/go/xds/annotations/v3"
	v3 "github.com/envoyproxy/go-control-plane/envoy/extensions/common/async_files/v3"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Configuration for a cache implementation that caches in the local file system.
//
// By default this cache uses a least-recently-used eviction strategy.
//
// For implementation details, see `DESIGN.md <https://github.com/envoyproxy/envoy/blob/main/source/extensions/http/cache_v2/file_system_http_cache/DESIGN.md>`_.
// [#next-free-field: 11]
type FileSystemHttpCacheV2Config struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration of a manager for how the file system is used asynchronously.
	ManagerConfig *v3.AsyncFileManagerConfig `protobuf:"bytes,1,opt,name=manager_config,json=managerConfig,proto3" json:"manager_config,omitempty"`
	// Path at which the cache files will be stored.
	//
	// This also doubles as the unique identifier for a cache, so a cache can be shared
	// between different routes, or separate paths can be used to specify separate caches.
	//
	// If the same “cache_path“ is used in more than one “CacheV2Config“, the rest of the
	// “FileSystemHttpCacheV2Config“ must also match, and will refer to the same cache
	// instance.
	CachePath string `protobuf:"bytes,2,opt,name=cache_path,json=cachePath,proto3" json:"cache_path,omitempty"`
	// The maximum size of the cache in bytes - when reached, cache eviction is triggered.
	//
	// This is measured as the sum of file sizes, such that it includes headers, trailers,
	// and metadata, but does not include e.g. file system overhead and block size padding.
	//
	// If unset there is no limit except file system failure.
	MaxCacheSizeBytes *wrapperspb.UInt64Value `protobuf:"bytes,3,opt,name=max_cache_size_bytes,json=maxCacheSizeBytes,proto3" json:"max_cache_size_bytes,omitempty"`
	// The maximum size of a cache entry in bytes - larger responses will not be cached.
	//
	// This is measured as the file size for the cache entry, such that it includes
	// headers, trailers, and metadata.
	//
	// If unset there is no limit.
	//
	// [#not-implemented-hide:]
	MaxIndividualCacheEntrySizeBytes *wrapperspb.UInt64Value `protobuf:"bytes,4,opt,name=max_individual_cache_entry_size_bytes,json=maxIndividualCacheEntrySizeBytes,proto3" json:"max_individual_cache_entry_size_bytes,omitempty"`
	// The maximum number of cache entries - when reached, cache eviction is triggered.
	//
	// If unset there is no limit.
	MaxCacheEntryCount *wrapperspb.UInt64Value `protobuf:"bytes,5,opt,name=max_cache_entry_count,json=maxCacheEntryCount,proto3" json:"max_cache_entry_count,omitempty"`
	// A number of folders into which to subdivide the cache.
	//
	// Setting this can help with performance in file systems where a large number of inodes
	// in a single branch degrades performance. The optimal value in that case would be
	// “sqrt(expected_cache_entry_count)“.
	//
	// On file systems that perform well with many inodes, the default value of 1 should be used.
	//
	// [#not-implemented-hide:]
	CacheSubdivisions uint32 `protobuf:"varint,6,opt,name=cache_subdivisions,json=cacheSubdivisions,proto3" json:"cache_subdivisions,omitempty"`
	// The amount of the maximum cache size or count to evict when cache eviction is
	// triggered. For example, if “max_cache_size_bytes“ is 10000000 and “evict_fraction“
	// is 0.2, then when the cache exceeds 10MB, entries will be evicted until the cache size is
	// less than or equal to 8MB.
	//
	// The default value of 0 means when the cache exceeds 10MB, entries will be evicted only
	// until the cache is less than or equal to 10MB.
	//
	// Evicting a larger fraction will mean the eviction thread will run less often (sparing
	// CPU load) at the cost of more cache misses due to the extra evicted entries.
	//
	// [#not-implemented-hide:]
	EvictFraction float32 `protobuf:"fixed32,7,opt,name=evict_fraction,json=evictFraction,proto3" json:"evict_fraction,omitempty"`
	// The longest amount of time to wait before running a cache eviction pass. An eviction
	// pass may not necessarily remove any files, but it will update the cache state to match
	// the on-disk state. This can be important if multiple instances are accessing the same
	// cache in parallel. (e.g. if two instances each independently added non-overlapping 10MB
	// of content to a cache with a 15MB limit, neither instance would be aware that the limit
	// was exceeded without this synchronizing pass.)
	//
	// If an eviction pass has not happened within this duration, the eviction thread will
	// be awoken and perform an eviction pass.
	//
	// If unset, there will be no eviction passes except those triggered by cache limits.
	//
	// [#not-implemented-hide:]
	MaxEvictionPeriod *durationpb.Duration `protobuf:"bytes,8,opt,name=max_eviction_period,json=maxEvictionPeriod,proto3" json:"max_eviction_period,omitempty"`
	// The shortest amount of time between cache eviction passes. This can be used to reduce
	// eviction churn, if your cache max size can be flexible. If a cache eviction pass already
	// occurred more recently than this period when another would be triggered, that new
	// pass is cancelled.
	//
	// This means the cache can potentially grow beyond “max_cache_size_bytes“ by as much as
	// can be written within the duration specified.
	//
	// Generally you would use *either* “min_eviction_period“ *or* “evict_fraction“ to
	// reduce churn. Both together will work but since they're both aiming for the same goal,
	// it's simpler not to.
	//
	// [#not-implemented-hide:]
	MinEvictionPeriod *durationpb.Duration `protobuf:"bytes,9,opt,name=min_eviction_period,json=minEvictionPeriod,proto3" json:"min_eviction_period,omitempty"`
	// If true, and the cache path does not exist, attempt to create the cache path, including
	// any missing directories leading up to it. On failure, the config is rejected.
	//
	// If false, and the cache path does not exist, the config is rejected.
	//
	// [#not-implemented-hide:]
	CreateCachePath bool `protobuf:"varint,10,opt,name=create_cache_path,json=createCachePath,proto3" json:"create_cache_path,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *FileSystemHttpCacheV2Config) Reset() {
	*x = FileSystemHttpCacheV2Config{}
	mi := &file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileSystemHttpCacheV2Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileSystemHttpCacheV2Config) ProtoMessage() {}

func (x *FileSystemHttpCacheV2Config) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileSystemHttpCacheV2Config.ProtoReflect.Descriptor instead.
func (*FileSystemHttpCacheV2Config) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_rawDescGZIP(), []int{0}
}

func (x *FileSystemHttpCacheV2Config) GetManagerConfig() *v3.AsyncFileManagerConfig {
	if x != nil {
		return x.ManagerConfig
	}
	return nil
}

func (x *FileSystemHttpCacheV2Config) GetCachePath() string {
	if x != nil {
		return x.CachePath
	}
	return ""
}

func (x *FileSystemHttpCacheV2Config) GetMaxCacheSizeBytes() *wrapperspb.UInt64Value {
	if x != nil {
		return x.MaxCacheSizeBytes
	}
	return nil
}

func (x *FileSystemHttpCacheV2Config) GetMaxIndividualCacheEntrySizeBytes() *wrapperspb.UInt64Value {
	if x != nil {
		return x.MaxIndividualCacheEntrySizeBytes
	}
	return nil
}

func (x *FileSystemHttpCacheV2Config) GetMaxCacheEntryCount() *wrapperspb.UInt64Value {
	if x != nil {
		return x.MaxCacheEntryCount
	}
	return nil
}

func (x *FileSystemHttpCacheV2Config) GetCacheSubdivisions() uint32 {
	if x != nil {
		return x.CacheSubdivisions
	}
	return 0
}

func (x *FileSystemHttpCacheV2Config) GetEvictFraction() float32 {
	if x != nil {
		return x.EvictFraction
	}
	return 0
}

func (x *FileSystemHttpCacheV2Config) GetMaxEvictionPeriod() *durationpb.Duration {
	if x != nil {
		return x.MaxEvictionPeriod
	}
	return nil
}

func (x *FileSystemHttpCacheV2Config) GetMinEvictionPeriod() *durationpb.Duration {
	if x != nil {
		return x.MinEvictionPeriod
	}
	return nil
}

func (x *FileSystemHttpCacheV2Config) GetCreateCachePath() bool {
	if x != nil {
		return x.CreateCachePath
	}
	return false
}

var File_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto protoreflect.FileDescriptor

const file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_rawDesc = "" +
	"\n" +
	"Uenvoy/extensions/http/cache_v2/file_system_http_cache/v3/file_system_http_cache.proto\x128envoy.extensions.http.cache_v2.file_system_http_cache.v3\x1a?envoy/extensions/common/async_files/v3/async_file_manager.proto\x1a\x1egoogle/protobuf/duration.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a\x1fxds/annotations/v3/status.proto\x1a\x1dudpa/annotations/status.proto\x1a\x17validate/validate.proto\"\xdd\x05\n" +
	"\x1bFileSystemHttpCacheV2Config\x12o\n" +
	"\x0emanager_config\x18\x01 \x01(\v2>.envoy.extensions.common.async_files.v3.AsyncFileManagerConfigB\b\xfaB\x05\x8a\x01\x02\x10\x01R\rmanagerConfig\x12&\n" +
	"\n" +
	"cache_path\x18\x02 \x01(\tB\a\xfaB\x04r\x02\x10\x01R\tcachePath\x12M\n" +
	"\x14max_cache_size_bytes\x18\x03 \x01(\v2\x1c.google.protobuf.UInt64ValueR\x11maxCacheSizeBytes\x12m\n" +
	"%max_individual_cache_entry_size_bytes\x18\x04 \x01(\v2\x1c.google.protobuf.UInt64ValueR maxIndividualCacheEntrySizeBytes\x12O\n" +
	"\x15max_cache_entry_count\x18\x05 \x01(\v2\x1c.google.protobuf.UInt64ValueR\x12maxCacheEntryCount\x12-\n" +
	"\x12cache_subdivisions\x18\x06 \x01(\rR\x11cacheSubdivisions\x12%\n" +
	"\x0eevict_fraction\x18\a \x01(\x02R\revictFraction\x12I\n" +
	"\x13max_eviction_period\x18\b \x01(\v2\x19.google.protobuf.DurationR\x11maxEvictionPeriod\x12I\n" +
	"\x13min_eviction_period\x18\t \x01(\v2\x19.google.protobuf.DurationR\x11minEvictionPeriod\x12*\n" +
	"\x11create_cache_path\x18\n" +
	" \x01(\bR\x0fcreateCachePathB\xee\x01\xba\x80\xc8\xd1\x06\x02\x10\x02\xd2Ƥ\xe1\x06\x02\b\x01\n" +
	"Fio.envoyproxy.envoy.extensions.http.cache_v2.file_system_http_cache.v3B\x18FileSystemHttpCacheProtoP\x01Zxgithub.com/envoyproxy/go-control-plane/envoy/extensions/http/cache_v2/file_system_http_cache/v3;file_system_http_cachev3b\x06proto3"

var (
	file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_rawDescOnce sync.Once
	file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_rawDescData []byte
)

func file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_rawDescGZIP() []byte {
	file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_rawDescOnce.Do(func() {
		file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_rawDesc), len(file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_rawDesc)))
	})
	return file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_rawDescData
}

var file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_goTypes = []any{
	(*FileSystemHttpCacheV2Config)(nil), // 0: envoy.extensions.http.cache_v2.file_system_http_cache.v3.FileSystemHttpCacheV2Config
	(*v3.AsyncFileManagerConfig)(nil),   // 1: envoy.extensions.common.async_files.v3.AsyncFileManagerConfig
	(*wrapperspb.UInt64Value)(nil),      // 2: google.protobuf.UInt64Value
	(*durationpb.Duration)(nil),         // 3: google.protobuf.Duration
}
var file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_depIdxs = []int32{
	1, // 0: envoy.extensions.http.cache_v2.file_system_http_cache.v3.FileSystemHttpCacheV2Config.manager_config:type_name -> envoy.extensions.common.async_files.v3.AsyncFileManagerConfig
	2, // 1: envoy.extensions.http.cache_v2.file_system_http_cache.v3.FileSystemHttpCacheV2Config.max_cache_size_bytes:type_name -> google.protobuf.UInt64Value
	2, // 2: envoy.extensions.http.cache_v2.file_system_http_cache.v3.FileSystemHttpCacheV2Config.max_individual_cache_entry_size_bytes:type_name -> google.protobuf.UInt64Value
	2, // 3: envoy.extensions.http.cache_v2.file_system_http_cache.v3.FileSystemHttpCacheV2Config.max_cache_entry_count:type_name -> google.protobuf.UInt64Value
	3, // 4: envoy.extensions.http.cache_v2.file_system_http_cache.v3.FileSystemHttpCacheV2Config.max_eviction_period:type_name -> google.protobuf.Duration
	3, // 5: envoy.extensions.http.cache_v2.file_system_http_cache.v3.FileSystemHttpCacheV2Config.min_eviction_period:type_name -> google.protobuf.Duration
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() {
	file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_init()
}
func file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_init() {
	if File_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_rawDesc), len(file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_goTypes,
		DependencyIndexes: file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_depIdxs,
		MessageInfos:      file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_msgTypes,
	}.Build()
	File_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto = out.File
	file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_goTypes = nil
	file_envoy_extensions_http_cache_v2_file_system_http_cache_v3_file_system_http_cache_proto_depIdxs = nil
}
