/*
 * Copyright 2024 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */

static const char* __doc_gr_digital_constellation_soft_decoder_cf = R"doc(Constellation Decoder.

Decode a constellation's points from a complex space to soft bits based on the map and soft decision LUT of the  object.


Does not support constellations of dimensionality higher than 1


npwr sets the noise power to use for soft decoding. this is equivalent to 10**(-SNR/10) if the constellation is received at unit average power. defaults to -1 allowing npwr and LUT in the constellation object to be used as-is. values above 0 will recalculate LUT and set the constellation object. noise powers in the range of 0.01-1 are common.

Constructor Specific Documentation:

Make constellation decoder block.

Args:
    constellation : A constellation derived from class 'constellation'. Use base() method to get a shared pointer to this base class type.
    npwr : sets expected noise power, default -1 set unused.)doc";

static const char*
    __doc_gr_digital_constellation_soft_decoder_cf_constellation_soft_decoder_cf_0 =
        R"doc()doc";

static const char*
    __doc_gr_digital_constellation_soft_decoder_cf_constellation_soft_decoder_cf_1 =
        R"doc()doc";

static const char* __doc_gr_digital_constellation_soft_decoder_cf_make = R"doc(Constellation Decoder.

Decode a constellation's points from a complex space to soft bits based on the map and soft decision LUT of the  object.


Does not support constellations of dimensionality higher than 1


npwr sets the noise power to use for soft decoding. this is equivalent to 10**(-SNR/10) if the constellation is received at unit average power. defaults to -1 allowing npwr and LUT in the constellation object to be used as-is. values above 0 will recalculate LUT and set the constellation object. noise powers in the range of 0.01-1 are common.

Constructor Specific Documentation:

Make constellation decoder block.

Args:
    constellation : A constellation derived from class 'constellation'. Use base() method to get a shared pointer to this base class type.
    npwr : sets expected noise power, default -1 set unused.)doc";

static const char* __doc_gr_digital_constellation_soft_decoder_cf_set_npwr = R"doc(set constellation noise power for soft decision calculation)doc";

static const char* __doc_gr_digital_constellation_soft_decoder_cf_set_constellation =
    R"doc()doc";
