/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_header_format_default = R"doc(Default header formatter for PDU formatting.

Used to handle the default packet header.


See the parent class header_format_base for details of how these classes operate.


The default header created in this base class consists of an access code and the packet length. The length is encoded as a 16-bit value repeated twice:





Where the access code is <= 64 bits and hdr is:





The access code and header are formatted for network byte order.


This header generator does not calculate or append a CRC to the packet. Use the CRC32 Async block for that before adding the header. The header's length will then measure the payload plus the CRC length (4 bytes for a CRC32).


The default header parser produces a PMT dictionary that contains the following keys. All formatter blocks MUST produce these two values in any dictionary.

Constructor Specific Documentation:

Factory to create an async packet header formatter; returns an sptr to the object.

Args:
    access_code : An access code that is used to find and synchronize the start of a packet. Used in the parser and in other blocks like a corr_est block that helps trigger the receiver. Can be up to 64-bits long.
    threshold : How many bits can be wrong in the access code and still count as correct.
    bps : The number of bits/second used in the payload's modulator.)doc";


static const char* __doc_gr_digital_header_format_default_header_format_default_0 =
    R"doc()doc";


static const char* __doc_gr_digital_header_format_default_header_format_default_1 =
    R"doc()doc";


static const char* __doc_gr_digital_header_format_default_format = R"doc(Creates a header from the access code and packet length and creates an output header as a PMT vector in the form:)doc";


static const char* __doc_gr_digital_header_format_default_parse = R"doc(Parses a header of the form:





This is implemented as a state machine that starts off searching for the access code. Once found, the access code is used to find the start of the packet and the following header. This default header encodes the length of the payload a 16 bit integer twice. The state machine finds the header and checks that both payload length values are the same. It then goes into its final state that reads in the payload (based on the payload length) and produces a payload as a PMT u8 vector of packed bytes.)doc";


static const char* __doc_gr_digital_header_format_default_header_nbits = R"doc(Returns the length of the formatted header in bits.)doc";


static const char* __doc_gr_digital_header_format_default_set_access_code = R"doc(Updates the access code. Must be a string of 1's and 0's and <= 64 bits.)doc";


static const char* __doc_gr_digital_header_format_default_access_code = R"doc(Returns the formatted access code as a 64-bit register.)doc";


static const char* __doc_gr_digital_header_format_default_set_threshold = R"doc(Sets the threshold for number of access code bits can be in error before detection. Defaults to 0.)doc";


static const char* __doc_gr_digital_header_format_default_threshold = R"doc(Returns threshold value for access code detection.)doc";


static const char* __doc_gr_digital_header_format_default_make = R"doc(Default header formatter for PDU formatting.

Used to handle the default packet header.


See the parent class header_format_base for details of how these classes operate.


The default header created in this base class consists of an access code and the packet length. The length is encoded as a 16-bit value repeated twice:





Where the access code is <= 64 bits and hdr is:





The access code and header are formatted for network byte order.


This header generator does not calculate or append a CRC to the packet. Use the CRC32 Async block for that before adding the header. The header's length will then measure the payload plus the CRC length (4 bytes for a CRC32).


The default header parser produces a PMT dictionary that contains the following keys. All formatter blocks MUST produce these two values in any dictionary.

Constructor Specific Documentation:

Factory to create an async packet header formatter; returns an sptr to the object.

Args:
    access_code : An access code that is used to find and synchronize the start of a packet. Used in the parser and in other blocks like a corr_est block that helps trigger the receiver. Can be up to 64-bits long.
    threshold : How many bits can be wrong in the access code and still count as correct.
    bps : The number of bits/second used in the payload's modulator.)doc";
