/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_wavfile_sink = R"doc(Write stream to a Microsoft PCM (.wav) file.

Values must be floats within [-1;1]. Check gr_make_wavfile_sink() for extra info.

Constructor Specific Documentation:



Args:
    filename : 
    n_channels : 
    sample_rate : 
    format : 
    subformat : 
    append : )doc";


static const char* __doc_gr_blocks_wavfile_sink_wavfile_sink_0 = R"doc()doc";


static const char* __doc_gr_blocks_wavfile_sink_wavfile_sink_1 = R"doc()doc";


static const char* __doc_gr_blocks_wavfile_sink_make = R"doc(Write stream to a Microsoft PCM (.wav) file.

Values must be floats within [-1;1]. Check gr_make_wavfile_sink() for extra info.

Constructor Specific Documentation:



Args:
    filename : 
    n_channels : 
    sample_rate : 
    format : 
    subformat : 
    append : )doc";


static const char* __doc_gr_blocks_wavfile_sink_open = R"doc(Opens a new file and writes a WAV header. Thread-safe.)doc";


static const char* __doc_gr_blocks_wavfile_sink_close = R"doc(Closes the currently active file and completes the WAV header. Thread-safe.)doc";


static const char* __doc_gr_blocks_wavfile_sink_set_sample_rate = R"doc(Set the sample rate. This will not affect the WAV file currently opened. Any following open() calls will use this new sample rate.)doc";


static const char* __doc_gr_blocks_wavfile_sink_set_bits_per_sample = R"doc(Currently, this function does nothing. Bits per sample are controlled by the subformat.)doc";


static const char* __doc_gr_blocks_wavfile_sink_set_append = R"doc(Enable appending to an existing file instead of creating it. This will not affect the WAV file currently opened (see set_sample_rate()).)doc";
