//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/hal_sandbox/PHalParent.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/ReferrerInfoUtils.h"

#include "mozilla/dom/PContentParent.h"
#include "mozilla/dom/PBrowserParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace hal_sandbox {


auto PHalParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PHalParent::PHalParent() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PHalParent);
}

PHalParent::~PHalParent()
{
    MOZ_COUNT_DTOR(PHalParent);
}

auto PHalParent::ActorAlloc() -> void
{
}

auto PHalParent::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PHalParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PHalParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PHalParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PHalParent::Manager() const -> PContentParent*
{
    return static_cast<PContentParent*>(IProtocol::Manager());
}

auto PHalParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PHalParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PHalParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PHalParent::SendNotifyBatteryChange(const BatteryInformation& aBatteryInfo) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_NotifyBatteryChange(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aBatteryInfo);
    // Sentinel = 'aBatteryInfo'
    ((&(writer__)))->WriteSentinel(509674697);


    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_NotifyBatteryChange", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalParent::SendNotifyNetworkChange(const NetworkInformation& aNetworkInfo) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_NotifyNetworkChange(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aNetworkInfo);
    // Sentinel = 'aNetworkInfo'
    ((&(writer__)))->WriteSentinel(522519768);


    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_NotifyNetworkChange", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalParent::SendNotifyWakeLockChange(const WakeLockInformation& aWakeLockInfo) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_NotifyWakeLockChange(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aWakeLockInfo);
    // Sentinel = 'aWakeLockInfo'
    ((&(writer__)))->WriteSentinel(577701119);


    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_NotifyWakeLockChange", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalParent::SendNotifySensorChange(const SensorData& aSensorData) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHal::Msg_NotifySensorChange(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aSensorData);
    // Sentinel = 'aSensorData'
    ((&(writer__)))->WriteSentinel(434504790);


    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHalParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHal::Msg_NotifySensorChange", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHalParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PHalParent::OnMessageReceived(const Message& msg__) -> PHalParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PHal::Msg_Vibrate__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_Vibrate", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__pattern = IPC::ReadParam<nsTArray<uint32_t>>((&(reader__)));
            if (!maybe__pattern) {
                FatalError("Error deserializing 'uint32_t[]'");
                return MsgValueError;

            }
            auto& pattern = *maybe__pattern;
            // Sentinel = 'pattern'
            if ((!(((&(reader__)))->ReadSentinel(200409855)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t[]'");
                return MsgValueError;
            }
            auto maybe__id = IPC::ReadParam<nsTArray<uint64_t>>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'uint64_t[]'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t[]'");
                return MsgValueError;
            }
            auto maybe__browser = IPC::ReadParam<mozilla::NotNull<PBrowserParent*>>((&(reader__)));
            if (!maybe__browser) {
                FatalError("Error deserializing 'NotNull<PBrowser>'");
                return MsgValueError;

            }
            auto& browser = *maybe__browser;
            // Sentinel = 'browser'
            if ((!(((&(reader__)))->ReadSentinel(201130757)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NotNull<PBrowser>'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvVibrate(std::move(pattern), std::move(id), browser);
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Msg_CancelVibrate__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_CancelVibrate", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<nsTArray<uint64_t>>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'uint64_t[]'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t[]'");
                return MsgValueError;
            }
            auto maybe__browser = IPC::ReadParam<mozilla::NotNull<PBrowserParent*>>((&(reader__)));
            if (!maybe__browser) {
                FatalError("Error deserializing 'NotNull<PBrowser>'");
                return MsgValueError;

            }
            auto& browser = *maybe__browser;
            // Sentinel = 'browser'
            if ((!(((&(reader__)))->ReadSentinel(201130757)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NotNull<PBrowser>'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvCancelVibrate(std::move(id), browser);
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Msg_EnableBatteryNotifications__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_EnableBatteryNotifications", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvEnableBatteryNotifications();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Msg_DisableBatteryNotifications__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_DisableBatteryNotifications", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDisableBatteryNotifications();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Msg_EnableNetworkNotifications__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_EnableNetworkNotifications", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvEnableNetworkNotifications();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Msg_DisableNetworkNotifications__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_DisableNetworkNotifications", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDisableNetworkNotifications();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Msg_ModifyWakeLock__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_ModifyWakeLock", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aTopic = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__aTopic) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& aTopic = *maybe__aTopic;
            // Sentinel = 'aTopic'
            if ((!(((&(reader__)))->ReadSentinel(137429601)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__aLockAdjust = IPC::ReadParam<WakeLockControl>((&(reader__)));
            if (!maybe__aLockAdjust) {
                FatalError("Error deserializing 'WakeLockControl'");
                return MsgValueError;

            }
            auto& aLockAdjust = *maybe__aLockAdjust;
            // Sentinel = 'aLockAdjust'
            if ((!(((&(reader__)))->ReadSentinel(418710614)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'WakeLockControl'");
                return MsgValueError;
            }
            auto maybe__aHiddenAdjust = IPC::ReadParam<WakeLockControl>((&(reader__)));
            if (!maybe__aHiddenAdjust) {
                FatalError("Error deserializing 'WakeLockControl'");
                return MsgValueError;

            }
            auto& aHiddenAdjust = *maybe__aHiddenAdjust;
            // Sentinel = 'aHiddenAdjust'
            if ((!(((&(reader__)))->ReadSentinel(575538457)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'WakeLockControl'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvModifyWakeLock(std::move(aTopic), std::move(aLockAdjust), std::move(aHiddenAdjust));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Msg_EnableWakeLockNotifications__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_EnableWakeLockNotifications", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvEnableWakeLockNotifications();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Msg_DisableWakeLockNotifications__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_DisableWakeLockNotifications", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDisableWakeLockNotifications();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Msg_LockScreenOrientation__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_LockScreenOrientation", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aOrientation = IPC::ReadParam<ScreenOrientation>((&(reader__)));
            if (!maybe__aOrientation) {
                FatalError("Error deserializing 'ScreenOrientation'");
                return MsgValueError;

            }
            auto& aOrientation = *maybe__aOrientation;
            // Sentinel = 'aOrientation'
            if ((!(((&(reader__)))->ReadSentinel(524289262)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ScreenOrientation'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PHal::Reply_LockScreenOrientation(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            LockScreenOrientationResolver resolver = [resolver__ = std::move(resolver__)](const nsresult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'result'
                    ((&(writer__)))->WriteSentinel(153223840);

                    if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PHalParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (this)->RecvLockScreenOrientation(std::move(aOrientation), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Msg_UnlockScreenOrientation__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_UnlockScreenOrientation", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvUnlockScreenOrientation();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Msg_PerformHapticFeedback__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_PerformHapticFeedback", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aType = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__aType) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& aType = *maybe__aType;
            // Sentinel = 'aType'
            if ((!(((&(reader__)))->ReadSentinel(99222020)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvPerformHapticFeedback(std::move(aType));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Msg_EnableSensorNotifications__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_EnableSensorNotifications", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aSensor = IPC::ReadParam<SensorType>((&(reader__)));
            if (!maybe__aSensor) {
                FatalError("Error deserializing 'SensorType'");
                return MsgValueError;

            }
            auto& aSensor = *maybe__aSensor;
            // Sentinel = 'aSensor'
            if ((!(((&(reader__)))->ReadSentinel(184156892)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'SensorType'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvEnableSensorNotifications(std::move(aSensor));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Msg_DisableSensorNotifications__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_DisableSensorNotifications", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aSensor = IPC::ReadParam<SensorType>((&(reader__)));
            if (!maybe__aSensor) {
                FatalError("Error deserializing 'SensorType'");
                return MsgValueError;

            }
            auto& aSensor = *maybe__aSensor;
            // Sentinel = 'aSensor'
            if ((!(((&(reader__)))->ReadSentinel(184156892)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'SensorType'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvDisableSensorNotifications(std::move(aSensor));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHal::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PHalParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PHalParent::Result
{
    switch (msg__.type()) {
    case PHal::Msg_GetCurrentBatteryInformation__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_GetCurrentBatteryInformation", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            BatteryInformation aBatteryInfo{};
            mozilla::ipc::IPCResult __ok = (this)->RecvGetCurrentBatteryInformation((&(aBatteryInfo)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PHal::Reply_GetCurrentBatteryInformation(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), aBatteryInfo);
            // Sentinel = 'aBatteryInfo'
            ((&(writer__)))->WriteSentinel(509674697);
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PHal::Msg_GetCurrentNetworkInformation__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_GetCurrentNetworkInformation", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            NetworkInformation aNetworkInfo{};
            mozilla::ipc::IPCResult __ok = (this)->RecvGetCurrentNetworkInformation((&(aNetworkInfo)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PHal::Reply_GetCurrentNetworkInformation(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), aNetworkInfo);
            // Sentinel = 'aNetworkInfo'
            ((&(writer__)))->WriteSentinel(522519768);
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    case PHal::Msg_GetWakeLockInfo__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHal::Msg_GetWakeLockInfo", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aTopic = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__aTopic) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& aTopic = *maybe__aTopic;
            // Sentinel = 'aTopic'
            if ((!(((&(reader__)))->ReadSentinel(137429601)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            WakeLockInformation aWakeLockInfo{};
            mozilla::ipc::IPCResult __ok = (this)->RecvGetWakeLockInfo(std::move(aTopic), (&(aWakeLockInfo)));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            reply__ = PHal::Reply_GetWakeLockInfo(id__);
            IPC::MessageWriter writer__{
                    (*(reply__)),
                    this};

            IPC::WriteParam((&(writer__)), aWakeLockInfo);
            // Sentinel = 'aWakeLockInfo'
            ((&(writer__)))->WriteSentinel(577701119);
            if (mozilla::ipc::LoggingEnabledFor("PHal", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHalParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Sending reply ",
                    reply__->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}



} // namespace hal_sandbox
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::hal_sandbox::PHalParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PHal'
    (aWriter)->WriteSentinel(55181670);
}

auto ParamTraits<::mozilla::hal_sandbox::PHalParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PHal actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PHal'
    if ((!((aReader)->ReadSentinel(55181670)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PHal actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PHalMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PHal)");

        return {};
    }
    return static_cast<::mozilla::hal_sandbox::PHalParent*>(actor);
}

} // namespace IPC
