//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/indexedDB/PBackgroundIDBCursorChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/indexedDB/ActorsChild.h"
#include "mozilla/dom/indexedDB/Key.h"
#include "mozilla/dom/indexedDB/KeyPath.h"
#include "mozilla/dom/indexedDB/SerializationHelpers.h"
#include "mozilla/dom/quota/SerializationHelpers.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/dom/indexedDB/PBackgroundIDBTransactionChild.h"
#include "mozilla/dom/indexedDB/PBackgroundIDBVersionChangeTransactionChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace indexedDB {


auto PBackgroundIDBCursorChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PBackgroundIDBCursorChild::PBackgroundIDBCursorChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PBackgroundIDBCursorChild);
}

PBackgroundIDBCursorChild::~PBackgroundIDBCursorChild()
{
    MOZ_COUNT_DTOR(PBackgroundIDBCursorChild);
}

auto PBackgroundIDBCursorChild::ActorAlloc() -> void
{
    AddRef();
}

auto PBackgroundIDBCursorChild::ActorDealloc() -> void
{
    Release();
}

auto PBackgroundIDBCursorChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PBackgroundIDBCursorChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PBackgroundIDBCursorChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PBackgroundIDBCursorChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PBackgroundIDBCursorChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PBackgroundIDBCursorChild::SendDeleteMe() -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBCursor::Msg_DeleteMe(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBCursor", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBCursorChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBCursor::Msg_DeleteMe", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundIDBCursorChild::SendContinue(
        const int64_t& requestId,
        const CursorRequestParams& params,
        const Key& currentKey,
        const Key& currentObjectStoreKey) -> bool
{
    UniquePtr<IPC::Message> msg__ = PBackgroundIDBCursor::Msg_Continue(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), requestId);
    // Sentinel = 'requestId'
    ((&(writer__)))->WriteSentinel(320799671);
    IPC::WriteParam((&(writer__)), params);
    // Sentinel = 'params'
    ((&(writer__)))->WriteSentinel(146997893);
    IPC::WriteParam((&(writer__)), currentKey);
    // Sentinel = 'currentKey'
    ((&(writer__)))->WriteSentinel(388695085);
    IPC::WriteParam((&(writer__)), currentObjectStoreKey);
    // Sentinel = 'currentObjectStoreKey'
    ((&(writer__)))->WriteSentinel(1594886289);


    if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBCursor", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PBackgroundIDBCursorChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PBackgroundIDBCursor::Msg_Continue", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PBackgroundIDBCursorChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PBackgroundIDBCursorChild::OnMessageReceived(const Message& msg__) -> PBackgroundIDBCursorChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PBackgroundIDBCursor::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBCursor", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBCursorChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBCursor::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<indexedDB::BackgroundCursorChildBase*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PBackgroundIDBCursor::Msg_Response__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PBackgroundIDBCursor", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PBackgroundIDBCursorChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PBackgroundIDBCursor::Msg_Response", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__response = IPC::ReadParam<CursorResponse>((&(reader__)));
            if (!maybe__response) {
                FatalError("Error deserializing 'CursorResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!(((&(reader__)))->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CursorResponse'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<indexedDB::BackgroundCursorChildBase*>(this))->RecvResponse(std::move(response));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PBackgroundIDBCursorChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PBackgroundIDBCursorChild::Result
{
    return MsgNotKnown;
}



} // namespace indexedDB
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBCursorChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PBackgroundIDBCursor'
    (aWriter)->WriteSentinel(1310721950);
}

auto ParamTraits<::mozilla::dom::indexedDB::PBackgroundIDBCursorChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PBackgroundIDBCursor actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PBackgroundIDBCursor'
    if ((!((aReader)->ReadSentinel(1310721950)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PBackgroundIDBCursor actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PBackgroundIDBCursorMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PBackgroundIDBCursor)");

        return {};
    }
    return static_cast<::mozilla::dom::indexedDB::PBackgroundIDBCursorChild*>(actor);
}

} // namespace IPC
