/* THIS FILE IS AUTOGENERATED FROM AudioWorkletNode.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "AudioNodeBinding.h"
#include "AudioWorkletNodeBinding.h"
#include "EventHandlerBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/AudioContext.h"
#include "mozilla/dom/AudioParamMap.h"
#include "mozilla/dom/AudioWorkletNode.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/MessagePort.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/WebIDLPrefs.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



AudioWorkletNodeOptions::AudioWorkletNodeOptions()
  : AudioNodeOptions(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}



bool
AudioWorkletNodeOptions::InitIds(JSContext* cx, AudioWorkletNodeOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->processorOptions_id.init(cx, "processorOptions") ||
      !atomsCache->parameterData_id.init(cx, "parameterData") ||
      !atomsCache->outputChannelCount_id.init(cx, "outputChannelCount") ||
      !atomsCache->numberOfOutputs_id.init(cx, "numberOfOutputs") ||
      !atomsCache->numberOfInputs_id.init(cx, "numberOfInputs")) {
    return false;
  }
  return true;
}

bool
AudioWorkletNodeOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  AudioWorkletNodeOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<AudioWorkletNodeOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!AudioNodeOptions::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->numberOfInputs_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'numberOfInputs' member of AudioWorkletNodeOptions", &mNumberOfInputs)) {
      return false;
    }
  } else {
    mNumberOfInputs = 1U;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->numberOfOutputs_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'numberOfOutputs' member of AudioWorkletNodeOptions", &mNumberOfOutputs)) {
      return false;
    }
  } else {
    mNumberOfOutputs = 1U;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->outputChannelCount_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mOutputChannelCount.Construct();
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'outputChannelCount' member of AudioWorkletNodeOptions", "sequence");
        return false;
      }
      Sequence<uint32_t> &arr = (mOutputChannelCount.Value());
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        uint32_t* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        uint32_t& slot = *slotPtr;
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp, "Element of 'outputChannelCount' member of AudioWorkletNodeOptions", &slot)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'outputChannelCount' member of AudioWorkletNodeOptions", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->parameterData_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mParameterData.Construct();
    if (temp.ref().isObject()) {
      auto& recordEntries = (mParameterData.Value()).Entries();

      JS::Rooted<JSObject*> recordObj(cx, &temp.ref().toObject());
      JS::RootedVector<jsid> ids(cx);
      if (!js::GetPropertyKeys(cx, recordObj,
                               JSITER_OWNONLY | JSITER_HIDDEN | JSITER_SYMBOLS, &ids)) {
        return false;
      }
      if (!recordEntries.SetCapacity(ids.length(), mozilla::fallible)) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      JS::Rooted<JS::Value> propNameValue(cx);
      JS::Rooted<JS::Value> temp(cx);
      JS::Rooted<jsid> curId(cx);
      JS::Rooted<JS::Value> idVal(cx);
      // Use a hashset to keep track of ids seen, to avoid
      // introducing nasty O(N^2) behavior scanning for them all the
      // time.  Ideally we'd use a data structure with O(1) lookup
      // _and_ ordering for the MozMap, but we don't have one lying
      // around.
      nsTHashtable<nsStringHashKey> idsSeen;
      for (size_t i = 0; i < ids.length(); ++i) {
        curId = ids[i];

        JS::Rooted<mozilla::Maybe<JS::PropertyDescriptor>> desc(cx);
        if (!JS_GetOwnPropertyDescriptorById(cx, recordObj, curId,
                                             &desc)) {
          return false;
        }

        if (desc.isNothing() || !desc->enumerable()) {
          continue;
        }

        idVal = js::IdToValue(curId);
        nsString propName;
        // This will just throw if idVal is a Symbol, like the spec says
        // to do.
        if (!ConvertJSValueToString(cx, idVal, "key of 'parameterData' member of AudioWorkletNodeOptions", propName)) {
          return false;
        }

        if (!JS_GetPropertyById(cx, recordObj, curId, &temp)) {
          return false;
        }

        Record<nsString, double>::EntryType* entry;
        if (!idsSeen.EnsureInserted(propName)) {
          // Find the existing entry.
          auto idx = recordEntries.IndexOf(propName);
          MOZ_ASSERT(idx != recordEntries.NoIndex,
                     "Why is it not found?");
          // Now blow it away to make it look like it was just added
          // to the array, because it's not obvious that it's
          // safe to write to its already-initialized mValue via our
          // normal codegen conversions.  For example, the value
          // could be a union and this would change its type, but
          // codegen assumes we won't do that.
          entry = recordEntries.ReconstructElementAt(idx);
        } else {
          // Safe to do an infallible append here, because we did a
          // SetCapacity above to the right capacity.
          entry = recordEntries.AppendElement();
        }
        entry->mKey = propName;
        double& slot = entry->mValue;
        if (!ValueToPrimitive<double, eDefault>(cx, temp, "Value in 'parameterData' member of AudioWorkletNodeOptions", &slot)) {
          return false;
        } else if (!std::isfinite(slot)) {
          cx.ThrowErrorMessage<MSG_NOT_FINITE>("Value in 'parameterData' member of AudioWorkletNodeOptions");
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'parameterData' member of AudioWorkletNodeOptions");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->processorOptions_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mProcessorOptions.Construct();
    if (temp.ref().isObject()) {
#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunreachable-code"
#pragma clang diagnostic ignored "-Wunreachable-code-return"
#endif // __clang__
      if ((passedToJSImpl) && !CallerSubsumes(temp.ref())) {
        cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("'processorOptions' member of AudioWorkletNodeOptions");
        return false;
      }
#ifdef __clang__
#pragma clang diagnostic pop
#endif // __clang__
      (mProcessorOptions.Value()) = &temp.ref().toObject();
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'processorOptions' member of AudioWorkletNodeOptions");
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
AudioWorkletNodeOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
AudioWorkletNodeOptions::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  AudioWorkletNodeOptionsAtoms* atomsCache = GetAtomCache<AudioWorkletNodeOptionsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!AudioNodeOptions::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mNumberOfInputs;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->numberOfInputs_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mNumberOfOutputs;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->numberOfOutputs_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mOutputChannelCount.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<uint32_t> const & currentValue = mOutputChannelCount.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            tmp.setNumber(currentValue[sequenceIdx0]);
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->outputChannelCount_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mParameterData.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Record<nsString, double> const & currentValue = mParameterData.InternalValue();

      JS::Rooted<JSObject*> returnObj(cx, JS_NewPlainObject(cx));
      if (!returnObj) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (auto& entry : currentValue.Entries()) {
          auto& recordValue0 = entry.mValue;
          // Control block to let us common up the JS_DefineUCProperty calls when there
          // are different ways to succeed at wrapping the value.
          do {
            tmp.set(JS_NumberValue(double(recordValue0)));
            break;
          } while (false);
          if (!JS_DefineUCProperty(cx, returnObj,
                                   entry.mKey.BeginReading(),
                                   entry.mKey.Length(), tmp,
                                   JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnObj);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->parameterData_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mProcessorOptions.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      JSObject* const & currentValue = mProcessorOptions.InternalValue();
      JS::ExposeObjectToActiveJS(currentValue);
      temp.setObject(*currentValue);
      if (!MaybeWrapObjectValue(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->processorOptions_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
AudioWorkletNodeOptions::TraceDictionary(JSTracer* trc)
{
  AudioNodeOptions::TraceDictionary(trc);
  if (mProcessorOptions.WasPassed()) {
    JS::TraceRoot(trc, &mProcessorOptions.Value(), "AudioWorkletNodeOptions.mProcessorOptions");
  }
}


namespace AudioWorkletNode_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<AudioNode_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get_parameters(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioWorkletNode", "parameters", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::AudioWorkletNode*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::AudioParamMap>(MOZ_KnownLive(self)->GetParameters(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "AudioWorkletNode.parameters getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo parameters_getterinfo = {
  { get_parameters },
  { prototypes::id::AudioWorkletNode },
  { PrototypeTraits<prototypes::id::AudioWorkletNode>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_port(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioWorkletNode", "port", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::AudioWorkletNode*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::MessagePort>(MOZ_KnownLive(self)->Port()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo port_getterinfo = {
  { get_port },
  { prototypes::id::AudioWorkletNode },
  { PrototypeTraits<prototypes::id::AudioWorkletNode>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onprocessorerror(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioWorkletNode", "onprocessorerror", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::AudioWorkletNode*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnprocessorerror());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onprocessorerror(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioWorkletNode", "onprocessorerror", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::AudioWorkletNode*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnprocessorerror(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnprocessorerror(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onprocessorerror_getterinfo = {
  { get_onprocessorerror },
  { prototypes::id::AudioWorkletNode },
  { PrototypeTraits<prototypes::id::AudioWorkletNode>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onprocessorerror_setterinfo = {
  { (JSJitGetterOp)set_onprocessorerror },
  { prototypes::id::AudioWorkletNode },
  { PrototypeTraits<prototypes::id::AudioWorkletNode>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::AudioWorkletNode* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::AudioWorkletNode>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::AudioWorkletNode>(self);
  }
}

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("parameters", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &parameters_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("port", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &port_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("onprocessorerror", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onprocessorerror_getterinfo, GenericSetter<NormalThisPolicy>, &onprocessorerror_setterinfo),
  JS_PS_END
};

static const PrefableDisablers sAttributes_disablers0 = {
  WebIDLPrefIndex::NoPref, 0, true, OriginTrial(0), nullptr
};

static const Prefable<const JSPropertySpec> sAttributes[] = {
  { &sAttributes_disablers0, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(3 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[3];
static PropertyInfo sNativeProperties_propertyInfos[3];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  false, 0,
  true,  0 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  3,
  sNativeProperties_sortedPropertyIndices,
  {
    { sAttributes, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(3 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::AudioWorkletNode,
  constructors::id::AudioWorkletNode,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "AudioWorkletNode constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioWorkletNode", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "AudioWorkletNode");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::AudioWorkletNode,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  if (!args.requireAtLeast(cx, "AudioWorkletNode constructor", 2)) {
    return false;
  }
  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  NonNull<mozilla::dom::AudioContext> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::BaseAudioContext, mozilla::dom::AudioContext>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "BaseAudioContext");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  RootedDictionary<binding_detail::FastAudioWorkletNodeOptions> arg2(cx);
  if (!arg2.Init(cx, (args.hasDefined(2)) ? args[2] : JS::NullHandleValue, "Argument 3", false)) {
    return false;
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
    if (arg2.mProcessorOptions.WasPassed()) {
      if (!JS_WrapObject(cx, JS::MutableHandle<JSObject*>::fromMarkedLocation(&arg2.mProcessorOptions.Value()))) {
        return false;
      }
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::AudioWorkletNode>(mozilla::dom::AudioWorkletNode::Constructor(global, MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1)), Constify(arg2), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "AudioWorkletNode constructor"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  AudioNode_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::AudioWorkletNode>::Depth,
  prototypes::id::AudioWorkletNode,
  true,
  2,
  "AudioWorkletNode",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "AudioWorkletNodePrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::AudioWorkletNode,
  PrototypeTraits<prototypes::id::AudioWorkletNode>::Depth,
  &sNativePropertyHooks,
  AudioNode_Binding::GetProtoObject
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return mozilla::dom::IsSecureContextOrObjectIsFromSecureContext(aCx, aObj);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "AudioWorkletNode",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::AudioWorkletNode>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::EventTarget, prototypes::id::AudioNode, prototypes::id::AudioWorkletNode, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::AudioWorkletNode>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::AudioWorkletNode>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::AudioWorkletNode>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::AudioWorkletNode>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::AudioWorkletNode* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::AudioWorkletNode>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::AudioWorkletNode*>);
  MOZ_ASSERT(static_cast<mozilla::dom::AudioNode*>(aObject) ==
             reinterpret_cast<mozilla::dom::AudioNode*>(aObject),
             "Multiple inheritance for mozilla::dom::AudioNode is broken.");
  MOZ_ASSERT(static_cast<mozilla::dom::EventTarget*>(aObject) ==
             reinterpret_cast<mozilla::dom::EventTarget*>(aObject),
             "Multiple inheritance for mozilla::dom::EventTarget is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::AudioWorkletNode> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::AudioWorkletNode);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::AudioWorkletNode);

  JS::Handle<JSObject*> parentProto(AudioNode_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(AudioNode_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 2, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "AudioWorkletNode",
                              ShouldExpose<AudioWorkletNode_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::AudioWorkletNode,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::AudioWorkletNode,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace AudioWorkletNode_Binding



} // namespace mozilla::dom
