/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef rust_minidump_writer_linux_ffi_generated_h
#define rust_minidump_writer_linux_ffi_generated_h

/* Generated with cbindgen:0.29.2 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. See RunCbindgen.py */


#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>
#include <unistd.h>
#include <ucontext.h>
#include <sys/signalfd.h>

typedef struct MinidumpWriterContext MinidumpWriterContext;

typedef struct DirectAuxvDumpInfo {
  uintptr_t program_header_count;
  uintptr_t program_header_address;
  uintptr_t linux_gate_address;
  uintptr_t entry_address;
} DirectAuxvDumpInfo;

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

struct MinidumpWriterContext *minidump_writer_create(const char *dump_path,
                                                     pid_t child,
                                                     pid_t child_blamed_thread,
                                                     char **error_msg);

void minidump_writer_set_crash_context(struct MinidumpWriterContext *context,
                                       const ucontext_t *ucontext,
                                       const fpregset_t *float_state,
                                       const signalfd_siginfo *siginfo);

void minidump_writer_set_direct_auxv_dump_info(struct MinidumpWriterContext *context,
                                               const struct DirectAuxvDumpInfo *direct_auxv_dump_info);

bool minidump_writer_dump(struct MinidumpWriterContext *context, char **error_msg);

void free_minidump_error_msg(char *error_msg);

#ifdef __cplusplus
}  // extern "C"
#endif  // __cplusplus

#endif  /* rust_minidump_writer_linux_ffi_generated_h */
