/*
 *
 *  Copyright (C) 2022, OFFIS e.V.
 *  All rights reserved.  See COPYRIGHT file for details.
 *
 *  This software and supporting documentation were developed by
 *
 *    OFFIS e.V.
 *    R&D Division Health
 *    Escherweg 2
 *    D-26121 Oldenburg, Germany
 *
 *
 *  Module:  ofstd
 *
 *  Author:  Marco Eichelberg
 *
 *  Purpose: Binary data for compiling the esdb files into the oficonv library
 *
 */

#include "dcmtk/config/osconfig.h"

#ifndef DATA_ESDB_H
#define DATA_ESDB_H

#ifdef DCMTK_ENABLE_BUILTIN_OFICONV_DATA

extern unsigned char esdb_esdb_alias_db[];
extern unsigned int esdb_esdb_alias_db_len;
extern unsigned char esdb_esdb_dir_db[];
extern unsigned int esdb_esdb_dir_db_len;
extern unsigned char esdb_EUC_EUC_CN_esdb[];
extern unsigned int esdb_EUC_EUC_CN_esdb_len;
extern unsigned char esdb_EUC_EUC_KR_esdb[];
extern unsigned int esdb_EUC_EUC_KR_esdb_len;
extern unsigned char esdb_GB_GB18030_esdb[];
extern unsigned int esdb_GB_GB18030_esdb_len;
extern unsigned char esdb_GB_GBK_esdb[];
extern unsigned int esdb_GB_GBK_esdb_len;
extern unsigned char esdb_ISO646_ISO646_US_esdb[];
extern unsigned int esdb_ISO646_ISO646_US_esdb_len;
extern unsigned char esdb_ISO_8859_ISO_8859_11_esdb[];
extern unsigned int esdb_ISO_8859_ISO_8859_11_esdb_len;
extern unsigned char esdb_ISO_8859_ISO_8859_15_esdb[];
extern unsigned int esdb_ISO_8859_ISO_8859_15_esdb_len;
extern unsigned char esdb_ISO_8859_ISO_8859_1_esdb[];
extern unsigned int esdb_ISO_8859_ISO_8859_1_esdb_len;
extern unsigned char esdb_ISO_8859_ISO_8859_2_esdb[];
extern unsigned int esdb_ISO_8859_ISO_8859_2_esdb_len;
extern unsigned char esdb_ISO_8859_ISO_8859_3_esdb[];
extern unsigned int esdb_ISO_8859_ISO_8859_3_esdb_len;
extern unsigned char esdb_ISO_8859_ISO_8859_4_esdb[];
extern unsigned int esdb_ISO_8859_ISO_8859_4_esdb_len;
extern unsigned char esdb_ISO_8859_ISO_8859_5_esdb[];
extern unsigned int esdb_ISO_8859_ISO_8859_5_esdb_len;
extern unsigned char esdb_ISO_8859_ISO_8859_6_esdb[];
extern unsigned int esdb_ISO_8859_ISO_8859_6_esdb_len;
extern unsigned char esdb_ISO_8859_ISO_8859_7_esdb[];
extern unsigned int esdb_ISO_8859_ISO_8859_7_esdb_len;
extern unsigned char esdb_ISO_8859_ISO_8859_8_esdb[];
extern unsigned int esdb_ISO_8859_ISO_8859_8_esdb_len;
extern unsigned char esdb_ISO_8859_ISO_8859_9_esdb[];
extern unsigned int esdb_ISO_8859_ISO_8859_9_esdb_len;
extern unsigned char esdb_MISC_JISX0201_KANA_esdb[];
extern unsigned int esdb_MISC_JISX0201_KANA_esdb_len;
extern unsigned char esdb_MISC_JISX0208_1990_esdb[];
extern unsigned int esdb_MISC_JISX0208_1990_esdb_len;
extern unsigned char esdb_MISC_JISX0212_esdb[];
extern unsigned int esdb_MISC_JISX0212_esdb_len;
extern unsigned char esdb_MISC_Shift_JIS_esdb[];
extern unsigned int esdb_MISC_Shift_JIS_esdb_len;
extern unsigned char esdb_UTF_UTF_16BE_esdb[];
extern unsigned int esdb_UTF_UTF_16BE_esdb_len;
extern unsigned char esdb_UTF_UTF_16_esdb[];
extern unsigned int esdb_UTF_UTF_16_esdb_len;
extern unsigned char esdb_UTF_UTF_16_INTERNAL_esdb[];
extern unsigned int esdb_UTF_UTF_16_INTERNAL_esdb_len;
extern unsigned char esdb_UTF_UTF_16LE_esdb[];
extern unsigned int esdb_UTF_UTF_16LE_esdb_len;
extern unsigned char esdb_UTF_UTF_16_SWAPPED_esdb[];
extern unsigned int esdb_UTF_UTF_16_SWAPPED_esdb_len;
extern unsigned char esdb_UTF_UTF_32BE_esdb[];
extern unsigned int esdb_UTF_UTF_32BE_esdb_len;
extern unsigned char esdb_UTF_UTF_32_esdb[];
extern unsigned int esdb_UTF_UTF_32_esdb_len;
extern unsigned char esdb_UTF_UTF_32_INTERNAL_esdb[];
extern unsigned int esdb_UTF_UTF_32_INTERNAL_esdb_len;
extern unsigned char esdb_UTF_UTF_32LE_esdb[];
extern unsigned int esdb_UTF_UTF_32LE_esdb_len;
extern unsigned char esdb_UTF_UTF_32_SWAPPED_esdb[];
extern unsigned int esdb_UTF_UTF_32_SWAPPED_esdb_len;
extern unsigned char esdb_UTF_UTF_8_esdb[];
extern unsigned int esdb_UTF_UTF_8_esdb_len;

#endif

#endif /* DATA_ESDB_H */
