\name{ImageFileReader}
\alias{ImageFileReader}
\title{ImageFileReader}
\Rdversion{1.1}
\docType{class}
\description{
Read an image file and return a SimpleITK Image.
ImageFileReader}
\details{
The reader can handle scalar images, and vector images. Pixel types
such as RGB, RGBA are loaded as multi-component images with vector
pixel types. Additionally, tensor images are loaded with the pixel
type being a 1-d vector.
An interface is also provided to access the information from the
underlying itk::ImageIO. This information can be loaded with the
ReadImageInformation method. The information is from the itk::ImageIO
interface. In some degenerate cases reading the bulk data may produce
different results. Please see itk::ImageFileReader for more details.
Reading takes place by the ITK ImageIO factory mechanism. ITK contains
many ImageIO classes which are responsible for reading separate file
formats. By default, each ImageIO is asked if it "can read" the
file, and the first one which "can read" the format is used. The
list of available ImageIOs can be obtained using the
GetRegisteredImageIOs method. The ImageIO used can be overridden with
the SetImageIO method. This is useful in cases when multiple ImageIOs
"can read" the file and the user wants to select a specific IO (not
the first).
See:
ReadImage for the procedural interface
ImageFileReader}
%C++ includes: sitkImageFileReader.h
\section{Methods}{
\describe{
\item{Image Execute() override:}{
Set/Get The output PixelType of the image.
By default the value is sitkUnknown, which enable the output pixel
type to be same as the file. If the pixel type is specified then the itk::ConvertPixelBuffer will be used to convert the pixels.
}
\item{const std::vector< int > & GetExtractIndex() const:}{}
\item{const std::vector< unsigned int > & GetExtractSize() const:}{}
\item{std::string GetFileName() const:}{}
\item{std::string GetMetaData(const std::string &key) const:}{
Get the value of a meta-data dictionary entry as a string.
If the key is not in the dictionary then an exception is thrown.
String types in the dictionary are returned as their native string.
Other types are printed to string before returning.
}
\item{std::vector< std::string > GetMetaDataKeys() const:}{
Get the meta-data dictionary keys.
This is only valid after successful ReadImageInformation or Execute of
this filter.
Returns a vector of keys to the key/value entries in the file's meta-
data dictionary. Iterate through with these keys to get the values.
}
\item{std::string GetName() const override:}{
return user readable name of the filter
}
\item{bool HasMetaDataKey(const std::string &key) const:}{
Query a meta-data dictionary for the existence of a key.
}
\item{ ImageFileReader():}{}
\item{void ReadImageInformation():}{
Read only the meta-data and image information in the file.
This method can be used to determine what the size and pixel type of
an image file is without reading the whole image. Even if SimpleITK
does not support an image of a certain dimension or type, the meta-
information can still be read.
}
\item{Self SetExtractIndex(const std::vector< int > &index):}{
starting index from the image on disk to extract.
Missing dimensions are treated the same as 0.
/sa ExtractImageFilter
}
\item{Self SetExtractSize(const std::vector< unsigned int > &size):}{
size of image to extract from file.
By default the reader loads the entire image, this is specified when
the size has zero length.
If specified, then the image returned from Execute will be of this size. If the ImageIO and file support reading just a
region, then the reader will perform streaming.
The dimension of the image can be reduced by specifying a dimension's
size as 0. For example a size of $[10,20,30,0,0]$ results in a 3D
image with size of $[10,20,30]$. This enables reading a 5D image into
a 3D image. If the length of the specified size is greater than the
dimension of the image file, an exception will be generated. If the
size's length is less than the image's dimension then the missing
values are assumed to be zero.
When the dimension of the image is reduced, the direction cosine
matrix will be set to the identity. However, the spacing for the
selected axis will remain. The matrix from the file can still be
obtained by ImageFileReader::GetDirection.
/sa ExtractImageFilter
}
\item{Self SetFileName(const std::string &fn):}{}
\item{std::string ToString() const override:}{
Print ourselves to string
}
\item{ ~ImageFileReader() override:}{}
}
}
