/*
	This file is part of Warzone 2100.
	Copyright (C) 2020-2021  Warzone 2100 Project

	Warzone 2100 is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Warzone 2100 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Warzone 2100; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "../include/wzmaplib/map_debug.h"
#include "../include/wzmaplib/map.h"

namespace WzMap {

// MARK: - Logging

LoggingProtocol::~LoggingProtocol()
{
	// no-op
}

void LoggingProtocol::printLog(LoggingProtocol::LogLevel level, const char *function, int line, const char *str)
{
	std::string outputMessage;
	outputMessage = std::string("[") + function + ":" + std::to_string(line) + "] ";
	outputMessage += str;

	fprintf(stdout, "%s", outputMessage.c_str());
}

} // namespace WzMap
