// python wrapper for ttkTableDistanceMatrix
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkTableDistanceMatrix.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkTableDistanceMatrix(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkTableDistanceMatrix_ClassNew(); }


static PyObject *
PyttkTableDistanceMatrix_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkTableDistanceMatrix::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTableDistanceMatrix_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDistanceMatrix *op = static_cast<ttkTableDistanceMatrix *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkTableDistanceMatrix::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTableDistanceMatrix_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkTableDistanceMatrix *tempr = ttkTableDistanceMatrix::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTableDistanceMatrix_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDistanceMatrix *op = static_cast<ttkTableDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkTableDistanceMatrix *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkTableDistanceMatrix::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTableDistanceMatrix_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkTableDistanceMatrix::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTableDistanceMatrix_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDistanceMatrix *op = static_cast<ttkTableDistanceMatrix *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkTableDistanceMatrix::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTableDistanceMatrix_SetScalarFields(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScalarFields");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDistanceMatrix *op = static_cast<ttkTableDistanceMatrix *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScalarFields(temp0);
    }
    else
    {
      op->ttkTableDistanceMatrix::SetScalarFields(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTableDistanceMatrix_SetSelectFieldsWithRegexp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectFieldsWithRegexp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDistanceMatrix *op = static_cast<ttkTableDistanceMatrix *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSelectFieldsWithRegexp(temp0);
    }
    else
    {
      op->ttkTableDistanceMatrix::SetSelectFieldsWithRegexp(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTableDistanceMatrix_GetSelectFieldsWithRegexp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectFieldsWithRegexp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDistanceMatrix *op = static_cast<ttkTableDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSelectFieldsWithRegexp() :
      op->ttkTableDistanceMatrix::GetSelectFieldsWithRegexp());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTableDistanceMatrix_SetRegexpString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRegexpString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDistanceMatrix *op = static_cast<ttkTableDistanceMatrix *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRegexpString(temp0);
    }
    else
    {
      op->ttkTableDistanceMatrix::SetRegexpString(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTableDistanceMatrix_GetRegexpString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRegexpString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDistanceMatrix *op = static_cast<ttkTableDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetRegexpString() :
      op->ttkTableDistanceMatrix::GetRegexpString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTableDistanceMatrix_ClearScalarFields(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearScalarFields");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDistanceMatrix *op = static_cast<ttkTableDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearScalarFields();
    }
    else
    {
      op->ttkTableDistanceMatrix::ClearScalarFields();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTableDistanceMatrix_SetDistanceType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDistanceType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDistanceMatrix *op = static_cast<ttkTableDistanceMatrix *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDistanceType(temp0);
    }
    else
    {
      op->ttkTableDistanceMatrix::SetDistanceType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTableDistanceMatrix_GetDistanceType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDistanceType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTableDistanceMatrix *op = static_cast<ttkTableDistanceMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetDistanceType() :
      op->ttkTableDistanceMatrix::GetDistanceType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkTableDistanceMatrix_Methods[] = {
  {"IsTypeOf", PyttkTableDistanceMatrix_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkTableDistanceMatrix_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkTableDistanceMatrix_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkTableDistanceMatrix\nC++: static ttkTableDistanceMatrix *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkTableDistanceMatrix_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkTableDistanceMatrix\nC++: ttkTableDistanceMatrix *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkTableDistanceMatrix_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkTableDistanceMatrix_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetScalarFields", PyttkTableDistanceMatrix_SetScalarFields, METH_VARARGS,
   "SetScalarFields(self, s:str) -> None\nC++: void SetScalarFields(const std::string &s)\n\n"},
  {"SetSelectFieldsWithRegexp", PyttkTableDistanceMatrix_SetSelectFieldsWithRegexp, METH_VARARGS,
   "SetSelectFieldsWithRegexp(self, _arg:bool) -> None\nC++: virtual void SetSelectFieldsWithRegexp(bool _arg)\n\n"},
  {"GetSelectFieldsWithRegexp", PyttkTableDistanceMatrix_GetSelectFieldsWithRegexp, METH_VARARGS,
   "GetSelectFieldsWithRegexp(self) -> bool\nC++: virtual bool GetSelectFieldsWithRegexp()\n\n"},
  {"SetRegexpString", PyttkTableDistanceMatrix_SetRegexpString, METH_VARARGS,
   "SetRegexpString(self, _arg:str) -> None\nC++: virtual void SetRegexpString(const std::string &_arg)\n\n"},
  {"GetRegexpString", PyttkTableDistanceMatrix_GetRegexpString, METH_VARARGS,
   "GetRegexpString(self) -> str\nC++: virtual std::string GetRegexpString()\n\n"},
  {"ClearScalarFields", PyttkTableDistanceMatrix_ClearScalarFields, METH_VARARGS,
   "ClearScalarFields(self) -> None\nC++: void ClearScalarFields()\n\n"},
  {"SetDistanceType", PyttkTableDistanceMatrix_SetDistanceType, METH_VARARGS,
   "SetDistanceType(self, _arg:str) -> None\nC++: virtual void SetDistanceType(const std::string &_arg)\n\n"},
  {"GetDistanceType", PyttkTableDistanceMatrix_GetDistanceType, METH_VARARGS,
   "GetDistanceType(self) -> str\nC++: virtual std::string GetDistanceType()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkTableDistanceMatrix_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("scalar_fields"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTableDistanceMatrix_SetScalarFields(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTableDistanceMatrix_SetScalarFields(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScalarFields\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("select_fields_with_regexp"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTableDistanceMatrix_GetSelectFieldsWithRegexp(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTableDistanceMatrix_SetSelectFieldsWithRegexp(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTableDistanceMatrix_SetSelectFieldsWithRegexp(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSelectFieldsWithRegexp/SetSelectFieldsWithRegexp\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("regexp_string"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTableDistanceMatrix_GetRegexpString(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTableDistanceMatrix_SetRegexpString(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTableDistanceMatrix_SetRegexpString(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRegexpString/SetRegexpString\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("distance_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTableDistanceMatrix_GetDistanceType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTableDistanceMatrix_SetDistanceType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTableDistanceMatrix_SetDistanceType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDistanceType/SetDistanceType\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkTableDistanceMatrix_Doc =
  "ttkTableDistanceMatrix - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Pierre Guillou <pierre.guillou@lip6.fr>\\date January 2022\n\n"
  "Computes a distance matrix using LDistance from a vtkTable\n\n"
  "\\sa LDistanceMatrix\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_householdAnalysis/\"\n"
  "  >Persistent Generators Household Analysis example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_periodicPicture/\"\n"
  "  >Persistent Generators Periodic Picture example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkTableDistanceMatrix_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkTableDistanceMatrix.ttkTableDistanceMatrix", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkTableDistanceMatrix_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkTableDistanceMatrix_StaticNew()
{
  return ttkTableDistanceMatrix::New();
}

PyObject *PyttkTableDistanceMatrix_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkTableDistanceMatrix_Type, PyttkTableDistanceMatrix_Methods,
    "ttkTableDistanceMatrix",
 &PyttkTableDistanceMatrix_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkTableDistanceMatrix_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkTableDistanceMatrix(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkTableDistanceMatrix_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkTableDistanceMatrix", o) != 0)
  {
    Py_DECREF(o);
  }

}

