// python wrapper for ttkStableManifoldPersistence
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkStableManifoldPersistence.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkStableManifoldPersistence(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkStableManifoldPersistence_ClassNew(); }


static PyObject *
PyttkStableManifoldPersistence_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkStableManifoldPersistence::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkStableManifoldPersistence_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkStableManifoldPersistence *op = static_cast<ttkStableManifoldPersistence *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkStableManifoldPersistence::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkStableManifoldPersistence_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkStableManifoldPersistence *tempr = ttkStableManifoldPersistence::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkStableManifoldPersistence_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkStableManifoldPersistence *op = static_cast<ttkStableManifoldPersistence *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkStableManifoldPersistence *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkStableManifoldPersistence::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkStableManifoldPersistence_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkStableManifoldPersistence::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkStableManifoldPersistence_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkStableManifoldPersistence *op = static_cast<ttkStableManifoldPersistence *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkStableManifoldPersistence::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkStableManifoldPersistence_GetIsUnstable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsUnstable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkStableManifoldPersistence *op = static_cast<ttkStableManifoldPersistence *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIsUnstable() :
      op->ttkStableManifoldPersistence::GetIsUnstable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkStableManifoldPersistence_SetIsUnstable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIsUnstable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkStableManifoldPersistence *op = static_cast<ttkStableManifoldPersistence *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIsUnstable(temp0);
    }
    else
    {
      op->ttkStableManifoldPersistence::SetIsUnstable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkStableManifoldPersistence_Methods[] = {
  {"IsTypeOf", PyttkStableManifoldPersistence_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkStableManifoldPersistence_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkStableManifoldPersistence_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkStableManifoldPersistence\nC++: static ttkStableManifoldPersistence *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkStableManifoldPersistence_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkStableManifoldPersistence\nC++: ttkStableManifoldPersistence *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkStableManifoldPersistence_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkStableManifoldPersistence_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetIsUnstable", PyttkStableManifoldPersistence_GetIsUnstable, METH_VARARGS,
   "GetIsUnstable(self) -> bool\nC++: virtual bool GetIsUnstable()\n\n"},
  {"SetIsUnstable", PyttkStableManifoldPersistence_SetIsUnstable, METH_VARARGS,
   "SetIsUnstable(self, _arg:bool) -> None\nC++: virtual void SetIsUnstable(bool _arg)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkStableManifoldPersistence_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("is_unstable"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkStableManifoldPersistence_GetIsUnstable(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkStableManifoldPersistence_SetIsUnstable(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkStableManifoldPersistence_SetIsUnstable(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIsUnstable/SetIsUnstable\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkStableManifoldPersistence_Doc =
  "ttkStableManifoldPersistence - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Julien Tierny <julien.tierny@sorbonne-universite.fr>\\date\n"
  "June 2021\n\n"
  "TTK VTK-filter for attaching to an input stable manifold (given by\n"
  "the Morse-Smale complex module) its persistence (given by the\n"
  "persistence diagram).\n\n"
  "Given an input stable manifold (1D, 2D or 3D) computed by the\n"
  "Morse-Smale complex, this module attaches to it the persistence (and\n"
  "the type) of the persistence pair of the critical point it is based\n"
  "on (i.e. the critical point where the integral lines of the manifold\n"
  "terminate). The inputs of this filter correspond to outputs of the\n"
  "Morse-Smale complex and Persistence diagram modules (which need to be\n"
  "pre-exist in the analysis pipeline).\n\n"
  "\\param Input0 Stable manifold (1D, 2D or 3D, vtkDataSet generated by\n"
  "    the\n"
  "Morse-Smale complex module).\n"
  "\\param Input1 Critical points (vtkPolyData generated by the\n"
  "    Morse-Smale\n"
  "complex module)\n"
  "\\param Input2 Persistence diagram (vtkUnstructuredGrid generated by\n"
  "    the\n"
  "Persistence diagram module)\n"
  "\\param Output Stable manifold with persistence and pair type.\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "\\sa ttkMorseSmaleComplex\n"
  "\\sa ttkPersistenceDiagram\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkStableManifoldPersistence_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkStableManifoldPersistence.ttkStableManifoldPersistence", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkStableManifoldPersistence_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkStableManifoldPersistence_StaticNew()
{
  return ttkStableManifoldPersistence::New();
}

PyObject *PyttkStableManifoldPersistence_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkStableManifoldPersistence_Type, PyttkStableManifoldPersistence_Methods,
    "ttkStableManifoldPersistence",
 &PyttkStableManifoldPersistence_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkStableManifoldPersistence_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkStableManifoldPersistence(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkStableManifoldPersistence_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkStableManifoldPersistence", o) != 0)
  {
    Py_DECREF(o);
  }

}

