
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_claims.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

static PyTypeObject CLAIM_INT64_Type;
static PyTypeObject CLAIM_UINT64_Type;
static PyTypeObject CLAIM_STRING_Type;
static PyTypeObject CLAIM_ENTRY_VALUES_Type;
static PyTypeObject CLAIM_ENTRY_Type;
static PyTypeObject CLAIMS_ARRAY_Type;
static PyTypeObject CLAIMS_SET_METADATA_CTR_Type;
static PyTypeObject CLAIMS_SET_CTR_Type;
static PyTypeObject CLAIMS_SET_Type;
static PyTypeObject CLAIMS_SET_NDR_Type;
static PyTypeObject CLAIMS_SET_METADATA_NDR_Type;
static PyTypeObject CLAIMS_SET_METADATA_Type;
static PyTypeObject claims_tf_condition_Type;
static PyTypeObject claims_tf_condition_set_Type;
static PyTypeObject claims_tf_property_ref_Type;
static PyTypeObject claims_tf_property_Type;
static PyTypeObject claims_tf_rule_action_Type;
static PyTypeObject claims_tf_rule_Type;
static PyTypeObject claims_tf_rule_set_Type;
static PyTypeObject claims_InterfaceType;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_CLAIM_INT64_get_value_count(PyObject *obj, void *closure)
{
	struct CLAIM_INT64 *object = pytalloc_get_ptr(obj);
	PyObject *py_value_count;
	py_value_count = PyLong_FromUnsignedLongLong((uint32_t)(object->value_count));
	return py_value_count;
}

static int py_CLAIM_INT64_set_value_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIM_INT64 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->value_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->value_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->value_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIM_INT64_get_values(PyObject *obj, void *closure)
{
	struct CLAIM_INT64 *object = pytalloc_get_ptr(obj);
	PyObject *py_values;
	if (object->values == NULL) {
		Py_RETURN_NONE;
	}
	if (object->values == NULL) {
		py_values = Py_None;
		Py_INCREF(py_values);
	} else {
		py_values = PyList_New(object->value_count);
		if (py_values == NULL) {
			return NULL;
		}
		{
			int values_cntr_1;
			for (values_cntr_1 = 0; values_cntr_1 < (object->value_count); values_cntr_1++) {
				PyObject *py_values_1;
				py_values_1 = PyLong_FromLongLong((object->values)[values_cntr_1]);
				PyList_SetItem(py_values, values_cntr_1, py_values_1);
			}
		}
	}
	return py_values;
}

static int py_CLAIM_INT64_set_values(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIM_INT64 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->values));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->values");
		return -1;
	}
	if (value == Py_None) {
		object->values = NULL;
	} else {
		object->values = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int values_cntr_1;
			object->values = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->values, PyList_GET_SIZE(value));
			if (!object->values) { return -1; }
			talloc_set_name_const(object->values, "ARRAY: object->values");
			for (values_cntr_1 = 0; values_cntr_1 < PyList_GET_SIZE(value); values_cntr_1++) {
				if (PyList_GET_ITEM(value, values_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->values)[values_cntr_1]");
					return -1;
				}
				{
					const long long int_max = ndr_sizeof2intmax(sizeof((object->values)[values_cntr_1]));
					const long long int_min = -int_max - 1;
					if (PyLong_Check(PyList_GET_ITEM(value, values_cntr_1))) {
						long long test_var;
						test_var = PyLong_AsLongLong(PyList_GET_ITEM(value, values_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var < int_min || test_var > int_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
							  PyLong_Type.tp_name, int_min, int_max, test_var);
							return -1;
						}
						(object->values)[values_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_CLAIM_INT64_getsetters[] = {
	{
		.name = discard_const_p(char, "value_count"),
		.get = py_CLAIM_INT64_get_value_count,
		.set = py_CLAIM_INT64_set_value_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "values"),
		.get = py_CLAIM_INT64_get_values,
		.set = py_CLAIM_INT64_set_values,
		.doc = discard_const_p(char, "PIDL-generated element of base type int64")
	},
	{ .name = NULL }
};

static PyObject *py_CLAIM_INT64_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CLAIM_INT64, type);
}


static PyTypeObject CLAIM_INT64_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.CLAIM_INT64",
	.tp_getset = py_CLAIM_INT64_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CLAIM_INT64_new,
};


static PyObject *py_CLAIM_UINT64_get_value_count(PyObject *obj, void *closure)
{
	struct CLAIM_UINT64 *object = pytalloc_get_ptr(obj);
	PyObject *py_value_count;
	py_value_count = PyLong_FromUnsignedLongLong((uint32_t)(object->value_count));
	return py_value_count;
}

static int py_CLAIM_UINT64_set_value_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIM_UINT64 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->value_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->value_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->value_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIM_UINT64_get_values(PyObject *obj, void *closure)
{
	struct CLAIM_UINT64 *object = pytalloc_get_ptr(obj);
	PyObject *py_values;
	if (object->values == NULL) {
		Py_RETURN_NONE;
	}
	if (object->values == NULL) {
		py_values = Py_None;
		Py_INCREF(py_values);
	} else {
		py_values = PyList_New(object->value_count);
		if (py_values == NULL) {
			return NULL;
		}
		{
			int values_cntr_1;
			for (values_cntr_1 = 0; values_cntr_1 < (object->value_count); values_cntr_1++) {
				PyObject *py_values_1;
				py_values_1 = PyLong_FromUnsignedLongLong((object->values)[values_cntr_1]);
				PyList_SetItem(py_values, values_cntr_1, py_values_1);
			}
		}
	}
	return py_values;
}

static int py_CLAIM_UINT64_set_values(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIM_UINT64 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->values));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->values");
		return -1;
	}
	if (value == Py_None) {
		object->values = NULL;
	} else {
		object->values = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int values_cntr_1;
			object->values = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->values, PyList_GET_SIZE(value));
			if (!object->values) { return -1; }
			talloc_set_name_const(object->values, "ARRAY: object->values");
			for (values_cntr_1 = 0; values_cntr_1 < PyList_GET_SIZE(value); values_cntr_1++) {
				if (PyList_GET_ITEM(value, values_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->values)[values_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->values)[values_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, values_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, values_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->values)[values_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_CLAIM_UINT64_getsetters[] = {
	{
		.name = discard_const_p(char, "value_count"),
		.get = py_CLAIM_UINT64_get_value_count,
		.set = py_CLAIM_UINT64_set_value_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "values"),
		.get = py_CLAIM_UINT64_get_values,
		.set = py_CLAIM_UINT64_set_values,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_CLAIM_UINT64_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CLAIM_UINT64, type);
}


static PyTypeObject CLAIM_UINT64_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.CLAIM_UINT64",
	.tp_getset = py_CLAIM_UINT64_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CLAIM_UINT64_new,
};


static PyObject *py_CLAIM_STRING_get_value_count(PyObject *obj, void *closure)
{
	struct CLAIM_STRING *object = pytalloc_get_ptr(obj);
	PyObject *py_value_count;
	py_value_count = PyLong_FromUnsignedLongLong((uint32_t)(object->value_count));
	return py_value_count;
}

static int py_CLAIM_STRING_set_value_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIM_STRING *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->value_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->value_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->value_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIM_STRING_get_values(PyObject *obj, void *closure)
{
	struct CLAIM_STRING *object = pytalloc_get_ptr(obj);
	PyObject *py_values;
	if (object->values == NULL) {
		Py_RETURN_NONE;
	}
	if (object->values == NULL) {
		py_values = Py_None;
		Py_INCREF(py_values);
	} else {
		py_values = PyList_New(object->value_count);
		if (py_values == NULL) {
			return NULL;
		}
		{
			int values_cntr_1;
			for (values_cntr_1 = 0; values_cntr_1 < (object->value_count); values_cntr_1++) {
				PyObject *py_values_1;
				if ((object->values)[values_cntr_1] == NULL) {
					py_values_1 = Py_None;
					Py_INCREF(py_values_1);
				} else {
					if ((object->values)[values_cntr_1] == NULL) {
						py_values_1 = Py_None;
						Py_INCREF(py_values_1);
					} else {
						py_values_1 = PyUnicode_Decode((object->values)[values_cntr_1], strlen((object->values)[values_cntr_1]), "utf-8", "ignore");
					}
				}
				PyList_SetItem(py_values, values_cntr_1, py_values_1);
			}
		}
	}
	return py_values;
}

static int py_CLAIM_STRING_set_values(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIM_STRING *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->values));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->values");
		return -1;
	}
	if (value == Py_None) {
		object->values = NULL;
	} else {
		object->values = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int values_cntr_1;
			object->values = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->values, PyList_GET_SIZE(value));
			if (!object->values) { return -1; }
			talloc_set_name_const(object->values, "ARRAY: object->values");
			for (values_cntr_1 = 0; values_cntr_1 < PyList_GET_SIZE(value); values_cntr_1++) {
				if (PyList_GET_ITEM(value, values_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->values)[values_cntr_1]");
					return -1;
				}
				if (PyList_GET_ITEM(value, values_cntr_1) == Py_None) {
					(object->values)[values_cntr_1] = NULL;
				} else {
					(object->values)[values_cntr_1] = NULL;
					{
						const char *test_str;
						const char *talloc_str;
						PyObject *unicode = NULL;
						if (PyUnicode_Check(PyList_GET_ITEM(value, values_cntr_1))) {
							unicode = PyUnicode_AsEncodedString(PyList_GET_ITEM(value, values_cntr_1), "utf-8", "ignore");
							if (unicode == NULL) {
								return -1;
							}
							test_str = PyBytes_AS_STRING(unicode);
						} else if (PyBytes_Check(PyList_GET_ITEM(value, values_cntr_1))) {
							test_str = PyBytes_AS_STRING(PyList_GET_ITEM(value, values_cntr_1));
						} else {
							PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(PyList_GET_ITEM(value, values_cntr_1))->tp_name);
							return -1;
						}
						talloc_str = talloc_strdup(object->values, test_str);
						if (unicode != NULL) {
							Py_DECREF(unicode);
						}
						if (talloc_str == NULL) {
							PyErr_NoMemory();
							return -1;
						}
						(object->values)[values_cntr_1] = talloc_str;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_CLAIM_STRING_getsetters[] = {
	{
		.name = discard_const_p(char, "value_count"),
		.get = py_CLAIM_STRING_get_value_count,
		.set = py_CLAIM_STRING_set_value_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "values"),
		.get = py_CLAIM_STRING_get_values,
		.set = py_CLAIM_STRING_set_values,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_CLAIM_STRING_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CLAIM_STRING, type);
}


static PyTypeObject CLAIM_STRING_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.CLAIM_STRING",
	.tp_getset = py_CLAIM_STRING_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CLAIM_STRING_new,
};

static PyObject *py_import_CLAIM_ENTRY_VALUES(TALLOC_CTX *mem_ctx, int level, union CLAIM_ENTRY_VALUES *in)
{
	PyObject *ret;

	switch (level) {
		case CLAIM_TYPE_INT64:
			ret = pytalloc_reference_ex(&CLAIM_INT64_Type, mem_ctx, &in->claim_int64);
			return ret;

		case CLAIM_TYPE_UINT64:
			ret = pytalloc_reference_ex(&CLAIM_UINT64_Type, mem_ctx, &in->claim_uint64);
			return ret;

		case CLAIM_TYPE_STRING:
			ret = pytalloc_reference_ex(&CLAIM_STRING_Type, mem_ctx, &in->claim_string);
			return ret;

		case CLAIM_TYPE_BOOLEAN:
			ret = pytalloc_reference_ex(&CLAIM_UINT64_Type, mem_ctx, &in->claim_boolean);
			return ret;

		default:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union CLAIM_ENTRY_VALUES *py_export_CLAIM_ENTRY_VALUES(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union CLAIM_ENTRY_VALUES *ret = talloc_zero(mem_ctx, union CLAIM_ENTRY_VALUES);
	switch (level) {
		case CLAIM_TYPE_INT64:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->claim_int64");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&CLAIM_INT64_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->claim_int64 = *(struct CLAIM_INT64 *)pytalloc_get_ptr(in);
			break;

		case CLAIM_TYPE_UINT64:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->claim_uint64");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&CLAIM_UINT64_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->claim_uint64 = *(struct CLAIM_UINT64 *)pytalloc_get_ptr(in);
			break;

		case CLAIM_TYPE_STRING:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->claim_string");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&CLAIM_STRING_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->claim_string = *(struct CLAIM_STRING *)pytalloc_get_ptr(in);
			break;

		case CLAIM_TYPE_BOOLEAN:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->claim_boolean");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&CLAIM_UINT64_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->claim_boolean = *(struct CLAIM_UINT64 *)pytalloc_get_ptr(in);
			break;

		default:
			break;

	}

	return ret;
}

static PyObject *py_CLAIM_ENTRY_VALUES_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union CLAIM_ENTRY_VALUES *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union CLAIM_ENTRY_VALUES *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union CLAIM_ENTRY_VALUES!");
		return NULL;
	}

	return py_import_CLAIM_ENTRY_VALUES(mem_ctx, level, in);
}

static PyObject *py_CLAIM_ENTRY_VALUES_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union CLAIM_ENTRY_VALUES *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_CLAIM_ENTRY_VALUES(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_CLAIM_ENTRY_VALUES_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_CLAIM_ENTRY_VALUES_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_CLAIM_ENTRY_VALUES_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_CLAIM_ENTRY_VALUES_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject CLAIM_ENTRY_VALUES_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.CLAIM_ENTRY_VALUES",
	.tp_getset = NULL,
	.tp_methods = py_CLAIM_ENTRY_VALUES_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CLAIM_ENTRY_VALUES_new,
};


static PyObject *py_CLAIM_ENTRY_get_id(PyObject *obj, void *closure)
{
	struct CLAIM_ENTRY *object = pytalloc_get_ptr(obj);
	PyObject *py_id;
	if (object->id == NULL) {
		Py_RETURN_NONE;
	}
	if (object->id == NULL) {
		py_id = Py_None;
		Py_INCREF(py_id);
	} else {
		if (object->id == NULL) {
			py_id = Py_None;
			Py_INCREF(py_id);
		} else {
			py_id = PyUnicode_Decode(object->id, strlen(object->id), "utf-8", "ignore");
		}
	}
	return py_id;
}

static int py_CLAIM_ENTRY_set_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIM_ENTRY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->id");
		return -1;
	}
	if (value == Py_None) {
		object->id = NULL;
	} else {
		object->id = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->id = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_CLAIM_ENTRY_get_type(PyObject *obj, void *closure)
{
	struct CLAIM_ENTRY *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyLong_FromLong((uint16_t)(object->type));
	return py_type;
}

static int py_CLAIM_ENTRY_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIM_ENTRY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIM_ENTRY_get_values(PyObject *obj, void *closure)
{
	struct CLAIM_ENTRY *object = pytalloc_get_ptr(obj);
	PyObject *py_values;
	py_values = pyrpc_import_union(&CLAIM_ENTRY_VALUES_Type, pytalloc_get_mem_ctx(obj), object->type, &object->values, "union CLAIM_ENTRY_VALUES");
	if (py_values == NULL) {
		return NULL;
	}
	return py_values;
}

static int py_CLAIM_ENTRY_set_values(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIM_ENTRY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->values");
		return -1;
	}
	{
		union CLAIM_ENTRY_VALUES *values_switch_0;
		values_switch_0 = (union CLAIM_ENTRY_VALUES *)pyrpc_export_union(&CLAIM_ENTRY_VALUES_Type, pytalloc_get_mem_ctx(py_obj), object->type, value, "union CLAIM_ENTRY_VALUES");
		if (values_switch_0 == NULL) {
			return -1;
		}
		object->values = *values_switch_0;
	}
	return 0;
}

static PyGetSetDef py_CLAIM_ENTRY_getsetters[] = {
	{
		.name = discard_const_p(char, "id"),
		.get = py_CLAIM_ENTRY_get_id,
		.set = py_CLAIM_ENTRY_set_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "type"),
		.get = py_CLAIM_ENTRY_get_type,
		.set = py_CLAIM_ENTRY_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type CLAIM_TYPE")
	},
	{
		.name = discard_const_p(char, "values"),
		.get = py_CLAIM_ENTRY_get_values,
		.set = py_CLAIM_ENTRY_set_values,
		.doc = discard_const_p(char, "PIDL-generated element of base type CLAIM_ENTRY_VALUES")
	},
	{ .name = NULL }
};

static PyObject *py_CLAIM_ENTRY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CLAIM_ENTRY, type);
}


static PyTypeObject CLAIM_ENTRY_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.CLAIM_ENTRY",
	.tp_getset = py_CLAIM_ENTRY_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CLAIM_ENTRY_new,
};


static PyObject *py_CLAIMS_ARRAY_get_claims_source_type(PyObject *obj, void *closure)
{
	struct CLAIMS_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_claims_source_type;
	py_claims_source_type = PyLong_FromLong((uint16_t)(object->claims_source_type));
	return py_claims_source_type;
}

static int py_CLAIMS_ARRAY_set_claims_source_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->claims_source_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->claims_source_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->claims_source_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIMS_ARRAY_get_claims_count(PyObject *obj, void *closure)
{
	struct CLAIMS_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_claims_count;
	py_claims_count = PyLong_FromUnsignedLongLong((uint32_t)(object->claims_count));
	return py_claims_count;
}

static int py_CLAIMS_ARRAY_set_claims_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_ARRAY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->claims_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->claims_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->claims_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIMS_ARRAY_get_claim_entries(PyObject *obj, void *closure)
{
	struct CLAIMS_ARRAY *object = pytalloc_get_ptr(obj);
	PyObject *py_claim_entries;
	if (object->claim_entries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->claim_entries == NULL) {
		py_claim_entries = Py_None;
		Py_INCREF(py_claim_entries);
	} else {
		py_claim_entries = PyList_New(object->claims_count);
		if (py_claim_entries == NULL) {
			return NULL;
		}
		{
			int claim_entries_cntr_1;
			for (claim_entries_cntr_1 = 0; claim_entries_cntr_1 < (object->claims_count); claim_entries_cntr_1++) {
				PyObject *py_claim_entries_1;
				py_claim_entries_1 = pytalloc_reference_ex(&CLAIM_ENTRY_Type, object->claim_entries, &(object->claim_entries)[claim_entries_cntr_1]);
				PyList_SetItem(py_claim_entries, claim_entries_cntr_1, py_claim_entries_1);
			}
		}
	}
	return py_claim_entries;
}

static int py_CLAIMS_ARRAY_set_claim_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_ARRAY *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->claim_entries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->claim_entries");
		return -1;
	}
	if (value == Py_None) {
		object->claim_entries = NULL;
	} else {
		object->claim_entries = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int claim_entries_cntr_1;
			object->claim_entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->claim_entries, PyList_GET_SIZE(value));
			if (!object->claim_entries) { return -1; }
			talloc_set_name_const(object->claim_entries, "ARRAY: object->claim_entries");
			for (claim_entries_cntr_1 = 0; claim_entries_cntr_1 < PyList_GET_SIZE(value); claim_entries_cntr_1++) {
				if (PyList_GET_ITEM(value, claim_entries_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->claim_entries)[claim_entries_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&CLAIM_ENTRY_Type, PyList_GET_ITEM(value, claim_entries_cntr_1), return -1;);
				if (talloc_reference(object->claim_entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, claim_entries_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->claim_entries)[claim_entries_cntr_1] = *(struct CLAIM_ENTRY *)pytalloc_get_ptr(PyList_GET_ITEM(value, claim_entries_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_CLAIMS_ARRAY_getsetters[] = {
	{
		.name = discard_const_p(char, "claims_source_type"),
		.get = py_CLAIMS_ARRAY_get_claims_source_type,
		.set = py_CLAIMS_ARRAY_set_claims_source_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type CLAIMS_SOURCE_TYPE")
	},
	{
		.name = discard_const_p(char, "claims_count"),
		.get = py_CLAIMS_ARRAY_get_claims_count,
		.set = py_CLAIMS_ARRAY_set_claims_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "claim_entries"),
		.get = py_CLAIMS_ARRAY_get_claim_entries,
		.set = py_CLAIMS_ARRAY_set_claim_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type CLAIM_ENTRY")
	},
	{ .name = NULL }
};

static PyObject *py_CLAIMS_ARRAY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CLAIMS_ARRAY, type);
}


static PyTypeObject CLAIMS_ARRAY_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.CLAIMS_ARRAY",
	.tp_getset = py_CLAIMS_ARRAY_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CLAIMS_ARRAY_new,
};


static PyObject *py_CLAIMS_SET_METADATA_CTR_get_metadata(PyObject *obj, void *closure)
{
	struct CLAIMS_SET_METADATA_CTR *object = pytalloc_get_ptr(obj);
	PyObject *py_metadata;
	if (object->metadata == NULL) {
		Py_RETURN_NONE;
	}
	if (object->metadata == NULL) {
		py_metadata = Py_None;
		Py_INCREF(py_metadata);
	} else {
		py_metadata = pytalloc_reference_ex(&CLAIMS_SET_METADATA_Type, object->metadata, object->metadata);
	}
	return py_metadata;
}

static int py_CLAIMS_SET_METADATA_CTR_set_metadata(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_SET_METADATA_CTR *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->metadata));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->metadata");
		return -1;
	}
	if (value == Py_None) {
		object->metadata = NULL;
	} else {
		object->metadata = NULL;
		PY_CHECK_TYPE(&CLAIMS_SET_METADATA_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->metadata = (struct CLAIMS_SET_METADATA *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_CLAIMS_SET_METADATA_CTR_getsetters[] = {
	{
		.name = discard_const_p(char, "metadata"),
		.get = py_CLAIMS_SET_METADATA_CTR_get_metadata,
		.set = py_CLAIMS_SET_METADATA_CTR_set_metadata,
		.doc = discard_const_p(char, "PIDL-generated element of base type CLAIMS_SET_METADATA")
	},
	{ .name = NULL }
};

static PyObject *py_CLAIMS_SET_METADATA_CTR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CLAIMS_SET_METADATA_CTR, type);
}


static PyTypeObject CLAIMS_SET_METADATA_CTR_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.CLAIMS_SET_METADATA_CTR",
	.tp_getset = py_CLAIMS_SET_METADATA_CTR_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CLAIMS_SET_METADATA_CTR_new,
};


static PyObject *py_CLAIMS_SET_CTR_get_claims(PyObject *obj, void *closure)
{
	struct CLAIMS_SET_CTR *object = pytalloc_get_ptr(obj);
	PyObject *py_claims;
	if (object->claims == NULL) {
		Py_RETURN_NONE;
	}
	if (object->claims == NULL) {
		py_claims = Py_None;
		Py_INCREF(py_claims);
	} else {
		py_claims = pytalloc_reference_ex(&CLAIMS_SET_Type, object->claims, object->claims);
	}
	return py_claims;
}

static int py_CLAIMS_SET_CTR_set_claims(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_SET_CTR *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->claims));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->claims");
		return -1;
	}
	if (value == Py_None) {
		object->claims = NULL;
	} else {
		object->claims = NULL;
		PY_CHECK_TYPE(&CLAIMS_SET_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->claims = (struct CLAIMS_SET *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_CLAIMS_SET_CTR_getsetters[] = {
	{
		.name = discard_const_p(char, "claims"),
		.get = py_CLAIMS_SET_CTR_get_claims,
		.set = py_CLAIMS_SET_CTR_set_claims,
		.doc = discard_const_p(char, "PIDL-generated element of base type CLAIMS_SET")
	},
	{ .name = NULL }
};

static PyObject *py_CLAIMS_SET_CTR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CLAIMS_SET_CTR, type);
}


static PyTypeObject CLAIMS_SET_CTR_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.CLAIMS_SET_CTR",
	.tp_getset = py_CLAIMS_SET_CTR_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CLAIMS_SET_CTR_new,
};


static PyObject *py_CLAIMS_SET_get_claims_array_count(PyObject *obj, void *closure)
{
	struct CLAIMS_SET *object = pytalloc_get_ptr(obj);
	PyObject *py_claims_array_count;
	py_claims_array_count = PyLong_FromUnsignedLongLong((uint32_t)(object->claims_array_count));
	return py_claims_array_count;
}

static int py_CLAIMS_SET_set_claims_array_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_SET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->claims_array_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->claims_array_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->claims_array_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIMS_SET_get_claims_arrays(PyObject *obj, void *closure)
{
	struct CLAIMS_SET *object = pytalloc_get_ptr(obj);
	PyObject *py_claims_arrays;
	if (object->claims_arrays == NULL) {
		Py_RETURN_NONE;
	}
	if (object->claims_arrays == NULL) {
		py_claims_arrays = Py_None;
		Py_INCREF(py_claims_arrays);
	} else {
		py_claims_arrays = PyList_New(object->claims_array_count);
		if (py_claims_arrays == NULL) {
			return NULL;
		}
		{
			int claims_arrays_cntr_1;
			for (claims_arrays_cntr_1 = 0; claims_arrays_cntr_1 < (object->claims_array_count); claims_arrays_cntr_1++) {
				PyObject *py_claims_arrays_1;
				py_claims_arrays_1 = pytalloc_reference_ex(&CLAIMS_ARRAY_Type, object->claims_arrays, &(object->claims_arrays)[claims_arrays_cntr_1]);
				PyList_SetItem(py_claims_arrays, claims_arrays_cntr_1, py_claims_arrays_1);
			}
		}
	}
	return py_claims_arrays;
}

static int py_CLAIMS_SET_set_claims_arrays(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_SET *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->claims_arrays));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->claims_arrays");
		return -1;
	}
	if (value == Py_None) {
		object->claims_arrays = NULL;
	} else {
		object->claims_arrays = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int claims_arrays_cntr_1;
			object->claims_arrays = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->claims_arrays, PyList_GET_SIZE(value));
			if (!object->claims_arrays) { return -1; }
			talloc_set_name_const(object->claims_arrays, "ARRAY: object->claims_arrays");
			for (claims_arrays_cntr_1 = 0; claims_arrays_cntr_1 < PyList_GET_SIZE(value); claims_arrays_cntr_1++) {
				if (PyList_GET_ITEM(value, claims_arrays_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->claims_arrays)[claims_arrays_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&CLAIMS_ARRAY_Type, PyList_GET_ITEM(value, claims_arrays_cntr_1), return -1;);
				if (talloc_reference(object->claims_arrays, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, claims_arrays_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->claims_arrays)[claims_arrays_cntr_1] = *(struct CLAIMS_ARRAY *)pytalloc_get_ptr(PyList_GET_ITEM(value, claims_arrays_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_CLAIMS_SET_get_reserved_type(PyObject *obj, void *closure)
{
	struct CLAIMS_SET *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved_type;
	py_reserved_type = PyLong_FromLong((uint16_t)(object->reserved_type));
	return py_reserved_type;
}

static int py_CLAIMS_SET_set_reserved_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_SET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIMS_SET_get_reserved_field_size(PyObject *obj, void *closure)
{
	struct CLAIMS_SET *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved_field_size;
	py_reserved_field_size = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved_field_size));
	return py_reserved_field_size;
}

static int py_CLAIMS_SET_set_reserved_field_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_SET *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved_field_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved_field_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved_field_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIMS_SET_get_reserved_field(PyObject *obj, void *closure)
{
	struct CLAIMS_SET *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved_field;
	if (object->reserved_field == NULL) {
		Py_RETURN_NONE;
	}
	if (object->reserved_field == NULL) {
		py_reserved_field = Py_None;
		Py_INCREF(py_reserved_field);
	} else {
		py_reserved_field = PyList_New(object->reserved_field_size);
		if (py_reserved_field == NULL) {
			return NULL;
		}
		{
			int reserved_field_cntr_1;
			for (reserved_field_cntr_1 = 0; reserved_field_cntr_1 < (object->reserved_field_size); reserved_field_cntr_1++) {
				PyObject *py_reserved_field_1;
				py_reserved_field_1 = PyLong_FromLong((uint16_t)((object->reserved_field)[reserved_field_cntr_1]));
				PyList_SetItem(py_reserved_field, reserved_field_cntr_1, py_reserved_field_1);
			}
		}
	}
	return py_reserved_field;
}

static int py_CLAIMS_SET_set_reserved_field(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_SET *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->reserved_field));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved_field");
		return -1;
	}
	if (value == Py_None) {
		object->reserved_field = NULL;
	} else {
		object->reserved_field = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int reserved_field_cntr_1;
			object->reserved_field = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->reserved_field, PyList_GET_SIZE(value));
			if (!object->reserved_field) { return -1; }
			talloc_set_name_const(object->reserved_field, "ARRAY: object->reserved_field");
			for (reserved_field_cntr_1 = 0; reserved_field_cntr_1 < PyList_GET_SIZE(value); reserved_field_cntr_1++) {
				if (PyList_GET_ITEM(value, reserved_field_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->reserved_field)[reserved_field_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->reserved_field)[reserved_field_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, reserved_field_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, reserved_field_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->reserved_field)[reserved_field_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_CLAIMS_SET_getsetters[] = {
	{
		.name = discard_const_p(char, "claims_array_count"),
		.get = py_CLAIMS_SET_get_claims_array_count,
		.set = py_CLAIMS_SET_set_claims_array_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "claims_arrays"),
		.get = py_CLAIMS_SET_get_claims_arrays,
		.set = py_CLAIMS_SET_set_claims_arrays,
		.doc = discard_const_p(char, "PIDL-generated element of base type CLAIMS_ARRAY")
	},
	{
		.name = discard_const_p(char, "reserved_type"),
		.get = py_CLAIMS_SET_get_reserved_type,
		.set = py_CLAIMS_SET_set_reserved_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "reserved_field_size"),
		.get = py_CLAIMS_SET_get_reserved_field_size,
		.set = py_CLAIMS_SET_set_reserved_field_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved_field"),
		.get = py_CLAIMS_SET_get_reserved_field,
		.set = py_CLAIMS_SET_set_reserved_field,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_CLAIMS_SET_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CLAIMS_SET, type);
}

static PyObject *py_CLAIMS_SET_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct CLAIMS_SET *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_CLAIMS_SET);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_CLAIMS_SET_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct CLAIMS_SET *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_CLAIMS_SET);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_CLAIMS_SET);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_CLAIMS_SET_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct CLAIMS_SET *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_CLAIMS_SET, "CLAIMS_SET", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_CLAIMS_SET, "CLAIMS_SET", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_CLAIMS_SET_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_CLAIMS_SET_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_CLAIMS_SET_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_CLAIMS_SET_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject CLAIMS_SET_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.CLAIMS_SET",
	.tp_getset = py_CLAIMS_SET_getsetters,
	.tp_methods = py_CLAIMS_SET_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CLAIMS_SET_new,
};


static PyObject *py_CLAIMS_SET_NDR_get_claims(PyObject *obj, void *closure)
{
	struct CLAIMS_SET_NDR *object = pytalloc_get_ptr(obj);
	PyObject *py_claims;
	py_claims = pytalloc_reference_ex(&CLAIMS_SET_CTR_Type, pytalloc_get_mem_ctx(obj), &object->claims);
	return py_claims;
}

static int py_CLAIMS_SET_NDR_set_claims(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_SET_NDR *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->claims");
		return -1;
	}
	PY_CHECK_TYPE(&CLAIMS_SET_CTR_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->claims = *(struct CLAIMS_SET_CTR *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_CLAIMS_SET_NDR_getsetters[] = {
	{
		.name = discard_const_p(char, "claims"),
		.get = py_CLAIMS_SET_NDR_get_claims,
		.set = py_CLAIMS_SET_NDR_set_claims,
		.doc = discard_const_p(char, "PIDL-generated element of base type CLAIMS_SET_CTR")
	},
	{ .name = NULL }
};

static PyObject *py_CLAIMS_SET_NDR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CLAIMS_SET_NDR, type);
}

static PyObject *py_CLAIMS_SET_NDR_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct CLAIMS_SET_NDR *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_CLAIMS_SET_NDR);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_CLAIMS_SET_NDR_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct CLAIMS_SET_NDR *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_CLAIMS_SET_NDR);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_CLAIMS_SET_NDR);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_CLAIMS_SET_NDR_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct CLAIMS_SET_NDR *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_CLAIMS_SET_NDR, "CLAIMS_SET_NDR", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_CLAIMS_SET_NDR, "CLAIMS_SET_NDR", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_CLAIMS_SET_NDR_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_CLAIMS_SET_NDR_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_CLAIMS_SET_NDR_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_CLAIMS_SET_NDR_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject CLAIMS_SET_NDR_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.CLAIMS_SET_NDR",
	.tp_getset = py_CLAIMS_SET_NDR_getsetters,
	.tp_methods = py_CLAIMS_SET_NDR_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CLAIMS_SET_NDR_new,
};


static PyObject *py_CLAIMS_SET_METADATA_NDR_get_claims(PyObject *obj, void *closure)
{
	struct CLAIMS_SET_METADATA_NDR *object = pytalloc_get_ptr(obj);
	PyObject *py_claims;
	py_claims = pytalloc_reference_ex(&CLAIMS_SET_METADATA_CTR_Type, pytalloc_get_mem_ctx(obj), &object->claims);
	return py_claims;
}

static int py_CLAIMS_SET_METADATA_NDR_set_claims(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_SET_METADATA_NDR *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->claims");
		return -1;
	}
	PY_CHECK_TYPE(&CLAIMS_SET_METADATA_CTR_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->claims = *(struct CLAIMS_SET_METADATA_CTR *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_CLAIMS_SET_METADATA_NDR_getsetters[] = {
	{
		.name = discard_const_p(char, "claims"),
		.get = py_CLAIMS_SET_METADATA_NDR_get_claims,
		.set = py_CLAIMS_SET_METADATA_NDR_set_claims,
		.doc = discard_const_p(char, "PIDL-generated element of base type CLAIMS_SET_METADATA_CTR")
	},
	{ .name = NULL }
};

static PyObject *py_CLAIMS_SET_METADATA_NDR_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CLAIMS_SET_METADATA_NDR, type);
}

static PyObject *py_CLAIMS_SET_METADATA_NDR_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct CLAIMS_SET_METADATA_NDR *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_CLAIMS_SET_METADATA_NDR);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_CLAIMS_SET_METADATA_NDR_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct CLAIMS_SET_METADATA_NDR *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_CLAIMS_SET_METADATA_NDR);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_CLAIMS_SET_METADATA_NDR);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_CLAIMS_SET_METADATA_NDR_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct CLAIMS_SET_METADATA_NDR *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_CLAIMS_SET_METADATA_NDR, "CLAIMS_SET_METADATA_NDR", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_CLAIMS_SET_METADATA_NDR, "CLAIMS_SET_METADATA_NDR", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_CLAIMS_SET_METADATA_NDR_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_CLAIMS_SET_METADATA_NDR_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_CLAIMS_SET_METADATA_NDR_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_CLAIMS_SET_METADATA_NDR_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject CLAIMS_SET_METADATA_NDR_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.CLAIMS_SET_METADATA_NDR",
	.tp_getset = py_CLAIMS_SET_METADATA_NDR_getsetters,
	.tp_methods = py_CLAIMS_SET_METADATA_NDR_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CLAIMS_SET_METADATA_NDR_new,
};


static PyObject *py_CLAIMS_SET_METADATA_get_claims_set_size(PyObject *obj, void *closure)
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(obj);
	PyObject *py_claims_set_size;
	py_claims_set_size = PyLong_FromUnsignedLongLong((uint32_t)(object->claims_set_size));
	return py_claims_set_size;
}

static int py_CLAIMS_SET_METADATA_set_claims_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->claims_set_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->claims_set_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->claims_set_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIMS_SET_METADATA_get_claims_set(PyObject *obj, void *closure)
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(obj);
	PyObject *py_claims_set;
	if (object->claims_set == NULL) {
		Py_RETURN_NONE;
	}
	if (object->claims_set == NULL) {
		py_claims_set = Py_None;
		Py_INCREF(py_claims_set);
	} else {
		py_claims_set = pytalloc_reference_ex(&CLAIMS_SET_NDR_Type, object->claims_set, object->claims_set);
	}
	return py_claims_set;
}

static int py_CLAIMS_SET_METADATA_set_claims_set(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->claims_set));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->claims_set");
		return -1;
	}
	if (value == Py_None) {
		object->claims_set = NULL;
	} else {
		object->claims_set = NULL;
		PY_CHECK_TYPE(&CLAIMS_SET_NDR_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->claims_set = (struct CLAIMS_SET_NDR *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_CLAIMS_SET_METADATA_get_compression_format(PyObject *obj, void *closure)
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(obj);
	PyObject *py_compression_format;
	py_compression_format = PyLong_FromLong((uint16_t)(object->compression_format));
	return py_compression_format;
}

static int py_CLAIMS_SET_METADATA_set_compression_format(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->compression_format");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->compression_format));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->compression_format = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIMS_SET_METADATA_get_uncompressed_claims_set_size(PyObject *obj, void *closure)
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(obj);
	PyObject *py_uncompressed_claims_set_size;
	py_uncompressed_claims_set_size = PyLong_FromUnsignedLongLong((uint32_t)(object->uncompressed_claims_set_size));
	return py_uncompressed_claims_set_size;
}

static int py_CLAIMS_SET_METADATA_set_uncompressed_claims_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->uncompressed_claims_set_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->uncompressed_claims_set_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->uncompressed_claims_set_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIMS_SET_METADATA_get_reserved_type(PyObject *obj, void *closure)
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved_type;
	py_reserved_type = PyLong_FromLong((uint16_t)(object->reserved_type));
	return py_reserved_type;
}

static int py_CLAIMS_SET_METADATA_set_reserved_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIMS_SET_METADATA_get_reserved_field_size(PyObject *obj, void *closure)
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved_field_size;
	py_reserved_field_size = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved_field_size));
	return py_reserved_field_size;
}

static int py_CLAIMS_SET_METADATA_set_reserved_field_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved_field_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved_field_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved_field_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CLAIMS_SET_METADATA_get_reserved_field(PyObject *obj, void *closure)
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved_field;
	if (object->reserved_field == NULL) {
		Py_RETURN_NONE;
	}
	if (object->reserved_field == NULL) {
		py_reserved_field = Py_None;
		Py_INCREF(py_reserved_field);
	} else {
		py_reserved_field = PyList_New(object->reserved_field_size);
		if (py_reserved_field == NULL) {
			return NULL;
		}
		{
			int reserved_field_cntr_1;
			for (reserved_field_cntr_1 = 0; reserved_field_cntr_1 < (object->reserved_field_size); reserved_field_cntr_1++) {
				PyObject *py_reserved_field_1;
				py_reserved_field_1 = PyLong_FromLong((uint16_t)((object->reserved_field)[reserved_field_cntr_1]));
				PyList_SetItem(py_reserved_field, reserved_field_cntr_1, py_reserved_field_1);
			}
		}
	}
	return py_reserved_field;
}

static int py_CLAIMS_SET_METADATA_set_reserved_field(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->reserved_field));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved_field");
		return -1;
	}
	if (value == Py_None) {
		object->reserved_field = NULL;
	} else {
		object->reserved_field = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int reserved_field_cntr_1;
			object->reserved_field = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->reserved_field, PyList_GET_SIZE(value));
			if (!object->reserved_field) { return -1; }
			talloc_set_name_const(object->reserved_field, "ARRAY: object->reserved_field");
			for (reserved_field_cntr_1 = 0; reserved_field_cntr_1 < PyList_GET_SIZE(value); reserved_field_cntr_1++) {
				if (PyList_GET_ITEM(value, reserved_field_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->reserved_field)[reserved_field_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->reserved_field)[reserved_field_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, reserved_field_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, reserved_field_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->reserved_field)[reserved_field_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_CLAIMS_SET_METADATA_getsetters[] = {
	{
		.name = discard_const_p(char, "claims_set_size"),
		.get = py_CLAIMS_SET_METADATA_get_claims_set_size,
		.set = py_CLAIMS_SET_METADATA_set_claims_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "claims_set"),
		.get = py_CLAIMS_SET_METADATA_get_claims_set,
		.set = py_CLAIMS_SET_METADATA_set_claims_set,
		.doc = discard_const_p(char, "PIDL-generated element of base type CLAIMS_SET_NDR")
	},
	{
		.name = discard_const_p(char, "compression_format"),
		.get = py_CLAIMS_SET_METADATA_get_compression_format,
		.set = py_CLAIMS_SET_METADATA_set_compression_format,
		.doc = discard_const_p(char, "PIDL-generated element of base type CLAIMS_COMPRESSION_FORMAT")
	},
	{
		.name = discard_const_p(char, "uncompressed_claims_set_size"),
		.get = py_CLAIMS_SET_METADATA_get_uncompressed_claims_set_size,
		.set = py_CLAIMS_SET_METADATA_set_uncompressed_claims_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved_type"),
		.get = py_CLAIMS_SET_METADATA_get_reserved_type,
		.set = py_CLAIMS_SET_METADATA_set_reserved_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "reserved_field_size"),
		.get = py_CLAIMS_SET_METADATA_get_reserved_field_size,
		.set = py_CLAIMS_SET_METADATA_set_reserved_field_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "reserved_field"),
		.get = py_CLAIMS_SET_METADATA_get_reserved_field,
		.set = py_CLAIMS_SET_METADATA_set_reserved_field,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_CLAIMS_SET_METADATA_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CLAIMS_SET_METADATA, type);
}

static PyObject *py_CLAIMS_SET_METADATA_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_CLAIMS_SET_METADATA);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_CLAIMS_SET_METADATA_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_CLAIMS_SET_METADATA);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_CLAIMS_SET_METADATA);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_CLAIMS_SET_METADATA_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct CLAIMS_SET_METADATA *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_CLAIMS_SET_METADATA, "CLAIMS_SET_METADATA", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_CLAIMS_SET_METADATA, "CLAIMS_SET_METADATA", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_CLAIMS_SET_METADATA_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_CLAIMS_SET_METADATA_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_CLAIMS_SET_METADATA_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_CLAIMS_SET_METADATA_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject CLAIMS_SET_METADATA_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.CLAIMS_SET_METADATA",
	.tp_getset = py_CLAIMS_SET_METADATA_getsetters,
	.tp_methods = py_CLAIMS_SET_METADATA_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CLAIMS_SET_METADATA_new,
};


static PyObject *py_claims_tf_condition_get_property(PyObject *obj, void *closure)
{
	struct claims_tf_condition *object = pytalloc_get_ptr(obj);
	PyObject *py_property;
	py_property = PyLong_FromLong((uint16_t)(object->property));
	return py_property;
}

static int py_claims_tf_condition_set_property(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_condition *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->property");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->property));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->property = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_claims_tf_condition_get_operator(PyObject *obj, void *closure)
{
	struct claims_tf_condition *object = pytalloc_get_ptr(obj);
	PyObject *py_operator;
	py_operator = PyLong_FromLong((uint16_t)(object->operator));
	return py_operator;
}

static int py_claims_tf_condition_set_operator(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_condition *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->operator");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->operator));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->operator = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_claims_tf_condition_get_string(PyObject *obj, void *closure)
{
	struct claims_tf_condition *object = pytalloc_get_ptr(obj);
	PyObject *py_string;
	if (object->string == NULL) {
		Py_RETURN_NONE;
	}
	if (object->string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		py_string = PyUnicode_Decode(object->string, strlen(object->string), "utf-8", "ignore");
	}
	return py_string;
}

static int py_claims_tf_condition_set_string(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_condition *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->string");
		return -1;
	}
	object->string = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->string);
	if (object->string == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->string = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_claims_tf_condition_getsetters[] = {
	{
		.name = discard_const_p(char, "property"),
		.get = py_claims_tf_condition_get_property,
		.set = py_claims_tf_condition_set_property,
		.doc = discard_const_p(char, "PIDL-generated element of base type claims_tf_property_enum")
	},
	{
		.name = discard_const_p(char, "operator"),
		.get = py_claims_tf_condition_get_operator,
		.set = py_claims_tf_condition_set_operator,
		.doc = discard_const_p(char, "PIDL-generated element of base type claims_tf_condition_operator")
	},
	{
		.name = discard_const_p(char, "string"),
		.get = py_claims_tf_condition_get_string,
		.set = py_claims_tf_condition_set_string,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_claims_tf_condition_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct claims_tf_condition, type);
}


static PyTypeObject claims_tf_condition_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.tf_condition",
	.tp_getset = py_claims_tf_condition_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_claims_tf_condition_new,
};


static PyObject *py_claims_tf_condition_set_get_opt_identifier(PyObject *obj, void *closure)
{
	struct claims_tf_condition_set *object = pytalloc_get_ptr(obj);
	PyObject *py_opt_identifier;
	if (object->opt_identifier == NULL) {
		Py_RETURN_NONE;
	}
	if (object->opt_identifier == NULL) {
		py_opt_identifier = Py_None;
		Py_INCREF(py_opt_identifier);
	} else {
		if (object->opt_identifier == NULL) {
			py_opt_identifier = Py_None;
			Py_INCREF(py_opt_identifier);
		} else {
			py_opt_identifier = PyUnicode_Decode(object->opt_identifier, strlen(object->opt_identifier), "utf-8", "ignore");
		}
	}
	return py_opt_identifier;
}

static int py_claims_tf_condition_set_set_opt_identifier(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_condition_set *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->opt_identifier");
		return -1;
	}
	if (value == Py_None) {
		object->opt_identifier = NULL;
	} else {
		object->opt_identifier = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->opt_identifier = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_claims_tf_condition_set_get_num_conditions(PyObject *obj, void *closure)
{
	struct claims_tf_condition_set *object = pytalloc_get_ptr(obj);
	PyObject *py_num_conditions;
	py_num_conditions = PyLong_FromUnsignedLongLong((uint32_t)(object->num_conditions));
	return py_num_conditions;
}

static int py_claims_tf_condition_set_set_num_conditions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_condition_set *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_conditions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_conditions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_conditions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_claims_tf_condition_set_get_conditions(PyObject *obj, void *closure)
{
	struct claims_tf_condition_set *object = pytalloc_get_ptr(obj);
	PyObject *py_conditions;
	py_conditions = PyList_New(object->num_conditions);
	if (py_conditions == NULL) {
		return NULL;
	}
	{
		int conditions_cntr_0;
		for (conditions_cntr_0 = 0; conditions_cntr_0 < (object->num_conditions); conditions_cntr_0++) {
			PyObject *py_conditions_0;
			py_conditions_0 = pytalloc_reference_ex(&claims_tf_condition_Type, object->conditions, &(object->conditions)[conditions_cntr_0]);
			PyList_SetItem(py_conditions, conditions_cntr_0, py_conditions_0);
		}
	}
	return py_conditions;
}

static int py_claims_tf_condition_set_set_conditions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_condition_set *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->conditions");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int conditions_cntr_0;
		object->conditions = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->conditions, PyList_GET_SIZE(value));
		if (!object->conditions) { return -1; }
		talloc_set_name_const(object->conditions, "ARRAY: object->conditions");
		for (conditions_cntr_0 = 0; conditions_cntr_0 < PyList_GET_SIZE(value); conditions_cntr_0++) {
			if (PyList_GET_ITEM(value, conditions_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->conditions)[conditions_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&claims_tf_condition_Type, PyList_GET_ITEM(value, conditions_cntr_0), return -1;);
			if (talloc_reference(object->conditions, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, conditions_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->conditions)[conditions_cntr_0] = *(struct claims_tf_condition *)pytalloc_get_ptr(PyList_GET_ITEM(value, conditions_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_claims_tf_condition_set_getsetters[] = {
	{
		.name = discard_const_p(char, "opt_identifier"),
		.get = py_claims_tf_condition_set_get_opt_identifier,
		.set = py_claims_tf_condition_set_set_opt_identifier,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "num_conditions"),
		.get = py_claims_tf_condition_set_get_num_conditions,
		.set = py_claims_tf_condition_set_set_num_conditions,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "conditions"),
		.get = py_claims_tf_condition_set_get_conditions,
		.set = py_claims_tf_condition_set_set_conditions,
		.doc = discard_const_p(char, "PIDL-generated element of base type claims_tf_condition")
	},
	{ .name = NULL }
};

static PyObject *py_claims_tf_condition_set_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct claims_tf_condition_set, type);
}


static PyTypeObject claims_tf_condition_set_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.tf_condition_set",
	.tp_getset = py_claims_tf_condition_set_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_claims_tf_condition_set_new,
};


static PyObject *py_claims_tf_property_ref_get_identifier(PyObject *obj, void *closure)
{
	struct claims_tf_property_ref *object = pytalloc_get_ptr(obj);
	PyObject *py_identifier;
	if (object->identifier == NULL) {
		Py_RETURN_NONE;
	}
	if (object->identifier == NULL) {
		py_identifier = Py_None;
		Py_INCREF(py_identifier);
	} else {
		if (object->identifier == NULL) {
			py_identifier = Py_None;
			Py_INCREF(py_identifier);
		} else {
			py_identifier = PyUnicode_Decode(object->identifier, strlen(object->identifier), "utf-8", "ignore");
		}
	}
	return py_identifier;
}

static int py_claims_tf_property_ref_set_identifier(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_property_ref *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->identifier");
		return -1;
	}
	if (value == Py_None) {
		object->identifier = NULL;
	} else {
		object->identifier = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->identifier = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_claims_tf_property_ref_get_property(PyObject *obj, void *closure)
{
	struct claims_tf_property_ref *object = pytalloc_get_ptr(obj);
	PyObject *py_property;
	py_property = PyLong_FromLong((uint16_t)(object->property));
	return py_property;
}

static int py_claims_tf_property_ref_set_property(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_property_ref *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->property");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->property));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->property = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_claims_tf_property_ref_getsetters[] = {
	{
		.name = discard_const_p(char, "identifier"),
		.get = py_claims_tf_property_ref_get_identifier,
		.set = py_claims_tf_property_ref_set_identifier,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "property"),
		.get = py_claims_tf_property_ref_get_property,
		.set = py_claims_tf_property_ref_set_property,
		.doc = discard_const_p(char, "PIDL-generated element of base type claims_tf_property_enum")
	},
	{ .name = NULL }
};

static PyObject *py_claims_tf_property_ref_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct claims_tf_property_ref, type);
}


static PyTypeObject claims_tf_property_ref_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.tf_property_ref",
	.tp_getset = py_claims_tf_property_ref_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_claims_tf_property_ref_new,
};


static PyObject *py_claims_tf_property_get_ref(PyObject *obj, void *closure)
{
	struct claims_tf_property *object = pytalloc_get_ptr(obj);
	PyObject *py_ref;
	py_ref = pytalloc_reference_ex(&claims_tf_property_ref_Type, pytalloc_get_mem_ctx(obj), &object->ref);
	return py_ref;
}

static int py_claims_tf_property_set_ref(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_property *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ref");
		return -1;
	}
	PY_CHECK_TYPE(&claims_tf_property_ref_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ref = *(struct claims_tf_property_ref *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_claims_tf_property_get_string(PyObject *obj, void *closure)
{
	struct claims_tf_property *object = pytalloc_get_ptr(obj);
	PyObject *py_string;
	if (object->string == NULL) {
		Py_RETURN_NONE;
	}
	if (object->string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		if (object->string == NULL) {
			py_string = Py_None;
			Py_INCREF(py_string);
		} else {
			py_string = PyUnicode_Decode(object->string, strlen(object->string), "utf-8", "ignore");
		}
	}
	return py_string;
}

static int py_claims_tf_property_set_string(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_property *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->string");
		return -1;
	}
	if (value == Py_None) {
		object->string = NULL;
	} else {
		object->string = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->string = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_claims_tf_property_getsetters[] = {
	{
		.name = discard_const_p(char, "ref"),
		.get = py_claims_tf_property_get_ref,
		.set = py_claims_tf_property_set_ref,
		.doc = discard_const_p(char, "PIDL-generated element of base type claims_tf_property_ref")
	},
	{
		.name = discard_const_p(char, "string"),
		.get = py_claims_tf_property_get_string,
		.set = py_claims_tf_property_set_string,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_claims_tf_property_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct claims_tf_property, type);
}


static PyTypeObject claims_tf_property_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.tf_property",
	.tp_getset = py_claims_tf_property_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_claims_tf_property_new,
};


static PyObject *py_claims_tf_rule_action_get_type(PyObject *obj, void *closure)
{
	struct claims_tf_rule_action *object = pytalloc_get_ptr(obj);
	PyObject *py_type;
	py_type = pytalloc_reference_ex(&claims_tf_property_Type, pytalloc_get_mem_ctx(obj), &object->type);
	return py_type;
}

static int py_claims_tf_rule_action_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_rule_action *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->type");
		return -1;
	}
	PY_CHECK_TYPE(&claims_tf_property_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->type = *(struct claims_tf_property *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_claims_tf_rule_action_get_value(PyObject *obj, void *closure)
{
	struct claims_tf_rule_action *object = pytalloc_get_ptr(obj);
	PyObject *py_value;
	py_value = pytalloc_reference_ex(&claims_tf_property_Type, pytalloc_get_mem_ctx(obj), &object->value);
	return py_value;
}

static int py_claims_tf_rule_action_set_value(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_rule_action *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->value");
		return -1;
	}
	PY_CHECK_TYPE(&claims_tf_property_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->value = *(struct claims_tf_property *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_claims_tf_rule_action_get_value_type(PyObject *obj, void *closure)
{
	struct claims_tf_rule_action *object = pytalloc_get_ptr(obj);
	PyObject *py_value_type;
	py_value_type = pytalloc_reference_ex(&claims_tf_property_Type, pytalloc_get_mem_ctx(obj), &object->value_type);
	return py_value_type;
}

static int py_claims_tf_rule_action_set_value_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_rule_action *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->value_type");
		return -1;
	}
	PY_CHECK_TYPE(&claims_tf_property_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->value_type = *(struct claims_tf_property *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_claims_tf_rule_action_getsetters[] = {
	{
		.name = discard_const_p(char, "type"),
		.get = py_claims_tf_rule_action_get_type,
		.set = py_claims_tf_rule_action_set_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type claims_tf_property")
	},
	{
		.name = discard_const_p(char, "value"),
		.get = py_claims_tf_rule_action_get_value,
		.set = py_claims_tf_rule_action_set_value,
		.doc = discard_const_p(char, "PIDL-generated element of base type claims_tf_property")
	},
	{
		.name = discard_const_p(char, "value_type"),
		.get = py_claims_tf_rule_action_get_value_type,
		.set = py_claims_tf_rule_action_set_value_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type claims_tf_property")
	},
	{ .name = NULL }
};

static PyObject *py_claims_tf_rule_action_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct claims_tf_rule_action, type);
}


static PyTypeObject claims_tf_rule_action_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.tf_rule_action",
	.tp_getset = py_claims_tf_rule_action_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_claims_tf_rule_action_new,
};


static PyObject *py_claims_tf_rule_get_num_condition_sets(PyObject *obj, void *closure)
{
	struct claims_tf_rule *object = pytalloc_get_ptr(obj);
	PyObject *py_num_condition_sets;
	py_num_condition_sets = PyLong_FromUnsignedLongLong((uint32_t)(object->num_condition_sets));
	return py_num_condition_sets;
}

static int py_claims_tf_rule_set_num_condition_sets(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_rule *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_condition_sets");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_condition_sets));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_condition_sets = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_claims_tf_rule_get_condition_sets(PyObject *obj, void *closure)
{
	struct claims_tf_rule *object = pytalloc_get_ptr(obj);
	PyObject *py_condition_sets;
	py_condition_sets = PyList_New(object->num_condition_sets);
	if (py_condition_sets == NULL) {
		return NULL;
	}
	{
		int condition_sets_cntr_0;
		for (condition_sets_cntr_0 = 0; condition_sets_cntr_0 < (object->num_condition_sets); condition_sets_cntr_0++) {
			PyObject *py_condition_sets_0;
			py_condition_sets_0 = pytalloc_reference_ex(&claims_tf_condition_set_Type, object->condition_sets, &(object->condition_sets)[condition_sets_cntr_0]);
			PyList_SetItem(py_condition_sets, condition_sets_cntr_0, py_condition_sets_0);
		}
	}
	return py_condition_sets;
}

static int py_claims_tf_rule_set_condition_sets(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_rule *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->condition_sets");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int condition_sets_cntr_0;
		object->condition_sets = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->condition_sets, PyList_GET_SIZE(value));
		if (!object->condition_sets) { return -1; }
		talloc_set_name_const(object->condition_sets, "ARRAY: object->condition_sets");
		for (condition_sets_cntr_0 = 0; condition_sets_cntr_0 < PyList_GET_SIZE(value); condition_sets_cntr_0++) {
			if (PyList_GET_ITEM(value, condition_sets_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->condition_sets)[condition_sets_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&claims_tf_condition_set_Type, PyList_GET_ITEM(value, condition_sets_cntr_0), return -1;);
			if (talloc_reference(object->condition_sets, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, condition_sets_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->condition_sets)[condition_sets_cntr_0] = *(struct claims_tf_condition_set *)pytalloc_get_ptr(PyList_GET_ITEM(value, condition_sets_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_claims_tf_rule_get_action(PyObject *obj, void *closure)
{
	struct claims_tf_rule *object = pytalloc_get_ptr(obj);
	PyObject *py_action;
	py_action = pytalloc_reference_ex(&claims_tf_rule_action_Type, pytalloc_get_mem_ctx(obj), &object->action);
	return py_action;
}

static int py_claims_tf_rule_set_action(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_rule *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->action");
		return -1;
	}
	PY_CHECK_TYPE(&claims_tf_rule_action_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->action = *(struct claims_tf_rule_action *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_claims_tf_rule_getsetters[] = {
	{
		.name = discard_const_p(char, "num_condition_sets"),
		.get = py_claims_tf_rule_get_num_condition_sets,
		.set = py_claims_tf_rule_set_num_condition_sets,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "condition_sets"),
		.get = py_claims_tf_rule_get_condition_sets,
		.set = py_claims_tf_rule_set_condition_sets,
		.doc = discard_const_p(char, "PIDL-generated element of base type claims_tf_condition_set")
	},
	{
		.name = discard_const_p(char, "action"),
		.get = py_claims_tf_rule_get_action,
		.set = py_claims_tf_rule_set_action,
		.doc = discard_const_p(char, "PIDL-generated element of base type claims_tf_rule_action")
	},
	{ .name = NULL }
};

static PyObject *py_claims_tf_rule_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct claims_tf_rule, type);
}


static PyTypeObject claims_tf_rule_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.tf_rule",
	.tp_getset = py_claims_tf_rule_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_claims_tf_rule_new,
};


static PyObject *py_claims_tf_rule_set_get_num_rules(PyObject *obj, void *closure)
{
	struct claims_tf_rule_set *object = pytalloc_get_ptr(obj);
	PyObject *py_num_rules;
	py_num_rules = PyLong_FromUnsignedLongLong((uint32_t)(object->num_rules));
	return py_num_rules;
}

static int py_claims_tf_rule_set_set_num_rules(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_rule_set *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_rules");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_rules));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_rules = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_claims_tf_rule_set_get_rules(PyObject *obj, void *closure)
{
	struct claims_tf_rule_set *object = pytalloc_get_ptr(obj);
	PyObject *py_rules;
	py_rules = PyList_New(object->num_rules);
	if (py_rules == NULL) {
		return NULL;
	}
	{
		int rules_cntr_0;
		for (rules_cntr_0 = 0; rules_cntr_0 < (object->num_rules); rules_cntr_0++) {
			PyObject *py_rules_0;
			py_rules_0 = pytalloc_reference_ex(&claims_tf_rule_Type, object->rules, &(object->rules)[rules_cntr_0]);
			PyList_SetItem(py_rules, rules_cntr_0, py_rules_0);
		}
	}
	return py_rules;
}

static int py_claims_tf_rule_set_set_rules(PyObject *py_obj, PyObject *value, void *closure)
{
	struct claims_tf_rule_set *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rules");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int rules_cntr_0;
		object->rules = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->rules, PyList_GET_SIZE(value));
		if (!object->rules) { return -1; }
		talloc_set_name_const(object->rules, "ARRAY: object->rules");
		for (rules_cntr_0 = 0; rules_cntr_0 < PyList_GET_SIZE(value); rules_cntr_0++) {
			if (PyList_GET_ITEM(value, rules_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->rules)[rules_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&claims_tf_rule_Type, PyList_GET_ITEM(value, rules_cntr_0), return -1;);
			if (talloc_reference(object->rules, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, rules_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->rules)[rules_cntr_0] = *(struct claims_tf_rule *)pytalloc_get_ptr(PyList_GET_ITEM(value, rules_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_claims_tf_rule_set_getsetters[] = {
	{
		.name = discard_const_p(char, "num_rules"),
		.get = py_claims_tf_rule_set_get_num_rules,
		.set = py_claims_tf_rule_set_set_num_rules,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "rules"),
		.get = py_claims_tf_rule_set_get_rules,
		.set = py_claims_tf_rule_set_set_rules,
		.doc = discard_const_p(char, "PIDL-generated element of base type claims_tf_rule")
	},
	{ .name = NULL }
};

static PyObject *py_claims_tf_rule_set_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct claims_tf_rule_set, type);
}

static PyObject *py_claims_tf_rule_set_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct claims_tf_rule_set *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_claims_tf_rule_set);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_claims_tf_rule_set_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct claims_tf_rule_set *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_claims_tf_rule_set);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_claims_tf_rule_set);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_claims_tf_rule_set_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct claims_tf_rule_set *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_claims_tf_rule_set, "claims_tf_rule_set", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_claims_tf_rule_set, "claims_tf_rule_set", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_claims_tf_rule_set_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_claims_tf_rule_set_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_claims_tf_rule_set_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_claims_tf_rule_set_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject claims_tf_rule_set_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.tf_rule_set",
	.tp_getset = py_claims_tf_rule_set_getsetters,
	.tp_methods = py_claims_tf_rule_set_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_claims_tf_rule_set_new,
};


const struct PyNdrRpcMethodDef py_ndr_claims_methods[] = {
	{
		.name = NULL,
	},
};

static PyObject *interface_claims_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_claims);
}

#define PY_DOC_CLAIMS "Active Directory Claims"
static PyTypeObject claims_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.claims",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "claims(binding, lp_ctx=None, credentials=None, basis_connection=None) -> connection\n"
"\n\n"
"Parameters\n"
"----------\n"
"binding : str\n"
"    A DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx : param.LoadParm\n"
"    Should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials : credentials.Credentials, optional\n"
"    A credentials.Credentials object (default is None).\n"
"basis_connection : samba.dcerpc.ClientConnection, optional\n"
"    A claims client connection object (default is None).\n"
"\n\n"
"Returns\n"
"-------\n"
"samba.dcerpc.ClientConnection\n"
"    A ClientConnection object\n"
"\n\n"
"Raises\n"
"------\n"
"samba.NTSTATUSError\n"
"    An NTSTATUS error\n"
"\n"PY_DOC_CLAIMS,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_claims_new,
};

static PyObject *syntax_claims_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_claims.syntax_id);
}

#define PY_DOC_CLAIMS_SYNTAX "Active Directory Claims"
static PyTypeObject claims_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "claims.claims_abstract_syntax",
	.tp_doc = "claims_abstract_syntax()\n"PY_DOC_CLAIMS_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_claims_new,
};

static PyMethodDef claims_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "claims",
	.m_doc = "claims DCE/RPC",
	.m_size = -1,
	.m_methods = claims_methods,
};
MODULE_INIT_FUNC(claims)
{
	PyObject *m = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	CLAIM_INT64_Type.tp_base = BaseObject_Type;
	CLAIM_INT64_Type.tp_basicsize = pytalloc_BaseObject_size();

	CLAIM_UINT64_Type.tp_base = BaseObject_Type;
	CLAIM_UINT64_Type.tp_basicsize = pytalloc_BaseObject_size();

	CLAIM_STRING_Type.tp_base = BaseObject_Type;
	CLAIM_STRING_Type.tp_basicsize = pytalloc_BaseObject_size();

	CLAIM_ENTRY_VALUES_Type.tp_base = BaseObject_Type;
	CLAIM_ENTRY_VALUES_Type.tp_basicsize = pytalloc_BaseObject_size();

	CLAIM_ENTRY_Type.tp_base = BaseObject_Type;
	CLAIM_ENTRY_Type.tp_basicsize = pytalloc_BaseObject_size();

	CLAIMS_ARRAY_Type.tp_base = BaseObject_Type;
	CLAIMS_ARRAY_Type.tp_basicsize = pytalloc_BaseObject_size();

	CLAIMS_SET_METADATA_CTR_Type.tp_base = BaseObject_Type;
	CLAIMS_SET_METADATA_CTR_Type.tp_basicsize = pytalloc_BaseObject_size();

	CLAIMS_SET_CTR_Type.tp_base = BaseObject_Type;
	CLAIMS_SET_CTR_Type.tp_basicsize = pytalloc_BaseObject_size();

	CLAIMS_SET_Type.tp_base = BaseObject_Type;
	CLAIMS_SET_Type.tp_basicsize = pytalloc_BaseObject_size();

	CLAIMS_SET_NDR_Type.tp_base = BaseObject_Type;
	CLAIMS_SET_NDR_Type.tp_basicsize = pytalloc_BaseObject_size();

	CLAIMS_SET_METADATA_NDR_Type.tp_base = BaseObject_Type;
	CLAIMS_SET_METADATA_NDR_Type.tp_basicsize = pytalloc_BaseObject_size();

	CLAIMS_SET_METADATA_Type.tp_base = BaseObject_Type;
	CLAIMS_SET_METADATA_Type.tp_basicsize = pytalloc_BaseObject_size();

	claims_tf_condition_Type.tp_base = BaseObject_Type;
	claims_tf_condition_Type.tp_basicsize = pytalloc_BaseObject_size();

	claims_tf_condition_set_Type.tp_base = BaseObject_Type;
	claims_tf_condition_set_Type.tp_basicsize = pytalloc_BaseObject_size();

	claims_tf_property_ref_Type.tp_base = BaseObject_Type;
	claims_tf_property_ref_Type.tp_basicsize = pytalloc_BaseObject_size();

	claims_tf_property_Type.tp_base = BaseObject_Type;
	claims_tf_property_Type.tp_basicsize = pytalloc_BaseObject_size();

	claims_tf_rule_action_Type.tp_base = BaseObject_Type;
	claims_tf_rule_action_Type.tp_basicsize = pytalloc_BaseObject_size();

	claims_tf_rule_Type.tp_base = BaseObject_Type;
	claims_tf_rule_Type.tp_basicsize = pytalloc_BaseObject_size();

	claims_tf_rule_set_Type.tp_base = BaseObject_Type;
	claims_tf_rule_set_Type.tp_basicsize = pytalloc_BaseObject_size();

	claims_InterfaceType.tp_base = ClientConnection_Type;

	claims_SyntaxType.tp_base = ndr_syntax_id_Type;
	claims_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&CLAIM_INT64_Type) < 0)
		goto out;
	if (PyType_Ready(&CLAIM_UINT64_Type) < 0)
		goto out;
	if (PyType_Ready(&CLAIM_STRING_Type) < 0)
		goto out;
	if (PyType_Ready(&CLAIM_ENTRY_VALUES_Type) < 0)
		goto out;
	if (PyType_Ready(&CLAIM_ENTRY_Type) < 0)
		goto out;
	if (PyType_Ready(&CLAIMS_ARRAY_Type) < 0)
		goto out;
	if (PyType_Ready(&CLAIMS_SET_METADATA_CTR_Type) < 0)
		goto out;
	if (PyType_Ready(&CLAIMS_SET_CTR_Type) < 0)
		goto out;
	if (PyType_Ready(&CLAIMS_SET_Type) < 0)
		goto out;
	if (PyType_Ready(&CLAIMS_SET_NDR_Type) < 0)
		goto out;
	if (PyType_Ready(&CLAIMS_SET_METADATA_NDR_Type) < 0)
		goto out;
	if (PyType_Ready(&CLAIMS_SET_METADATA_Type) < 0)
		goto out;
	if (PyType_Ready(&claims_tf_condition_Type) < 0)
		goto out;
	if (PyType_Ready(&claims_tf_condition_set_Type) < 0)
		goto out;
	if (PyType_Ready(&claims_tf_property_ref_Type) < 0)
		goto out;
	if (PyType_Ready(&claims_tf_property_Type) < 0)
		goto out;
	if (PyType_Ready(&claims_tf_rule_action_Type) < 0)
		goto out;
	if (PyType_Ready(&claims_tf_rule_Type) < 0)
		goto out;
	if (PyType_Ready(&claims_tf_rule_set_Type) < 0)
		goto out;
	if (PyType_Ready(&claims_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&claims_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&claims_InterfaceType, py_ndr_claims_methods))
		return NULL;

#ifdef PY_CLAIM_INT64_PATCH
	PY_CLAIM_INT64_PATCH(&CLAIM_INT64_Type);
#endif
#ifdef PY_CLAIM_UINT64_PATCH
	PY_CLAIM_UINT64_PATCH(&CLAIM_UINT64_Type);
#endif
#ifdef PY_CLAIM_STRING_PATCH
	PY_CLAIM_STRING_PATCH(&CLAIM_STRING_Type);
#endif
#ifdef PY_CLAIM_ENTRY_VALUES_PATCH
	PY_CLAIM_ENTRY_VALUES_PATCH(&CLAIM_ENTRY_VALUES_Type);
#endif
#ifdef PY_CLAIM_ENTRY_PATCH
	PY_CLAIM_ENTRY_PATCH(&CLAIM_ENTRY_Type);
#endif
#ifdef PY_CLAIMS_ARRAY_PATCH
	PY_CLAIMS_ARRAY_PATCH(&CLAIMS_ARRAY_Type);
#endif
#ifdef PY_CLAIMS_SET_METADATA_CTR_PATCH
	PY_CLAIMS_SET_METADATA_CTR_PATCH(&CLAIMS_SET_METADATA_CTR_Type);
#endif
#ifdef PY_CLAIMS_SET_CTR_PATCH
	PY_CLAIMS_SET_CTR_PATCH(&CLAIMS_SET_CTR_Type);
#endif
#ifdef PY_CLAIMS_SET_PATCH
	PY_CLAIMS_SET_PATCH(&CLAIMS_SET_Type);
#endif
#ifdef PY_CLAIMS_SET_NDR_PATCH
	PY_CLAIMS_SET_NDR_PATCH(&CLAIMS_SET_NDR_Type);
#endif
#ifdef PY_CLAIMS_SET_METADATA_NDR_PATCH
	PY_CLAIMS_SET_METADATA_NDR_PATCH(&CLAIMS_SET_METADATA_NDR_Type);
#endif
#ifdef PY_CLAIMS_SET_METADATA_PATCH
	PY_CLAIMS_SET_METADATA_PATCH(&CLAIMS_SET_METADATA_Type);
#endif
#ifdef PY_TF_CONDITION_PATCH
	PY_TF_CONDITION_PATCH(&claims_tf_condition_Type);
#endif
#ifdef PY_TF_CONDITION_SET_PATCH
	PY_TF_CONDITION_SET_PATCH(&claims_tf_condition_set_Type);
#endif
#ifdef PY_TF_PROPERTY_REF_PATCH
	PY_TF_PROPERTY_REF_PATCH(&claims_tf_property_ref_Type);
#endif
#ifdef PY_TF_PROPERTY_PATCH
	PY_TF_PROPERTY_PATCH(&claims_tf_property_Type);
#endif
#ifdef PY_TF_RULE_ACTION_PATCH
	PY_TF_RULE_ACTION_PATCH(&claims_tf_rule_action_Type);
#endif
#ifdef PY_TF_RULE_PATCH
	PY_TF_RULE_PATCH(&claims_tf_rule_Type);
#endif
#ifdef PY_TF_RULE_SET_PATCH
	PY_TF_RULE_SET_PATCH(&claims_tf_rule_set_Type);
#endif
#ifdef PY_CLAIMS_PATCH
	PY_CLAIMS_PATCH(&claims_InterfaceType);
#endif
#ifdef PY_CLAIMS_ABSTRACT_SYNTAX_PATCH
	PY_CLAIMS_ABSTRACT_SYNTAX_PATCH(&claims_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&claims_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "CLAIM_LOWER_COMPRESSION_THRESHOLD", PyLong_FromUnsignedLongLong(368));
	PyModule_AddObject(m, "CLAIM_UPPER_COMPRESSION_THRESHOLD", PyLong_FromUnsignedLongLong(384));
	PyModule_AddObject(m, "CLAIM_TYPE_INT64", PyLong_FromLong((uint16_t)(CLAIM_TYPE_INT64)));
	PyModule_AddObject(m, "CLAIM_TYPE_UINT64", PyLong_FromLong((uint16_t)(CLAIM_TYPE_UINT64)));
	PyModule_AddObject(m, "CLAIM_TYPE_STRING", PyLong_FromLong((uint16_t)(CLAIM_TYPE_STRING)));
	PyModule_AddObject(m, "CLAIM_TYPE_BOOLEAN", PyLong_FromLong((uint16_t)(CLAIM_TYPE_BOOLEAN)));
	PyModule_AddObject(m, "CLAIMS_SOURCE_TYPE_AD", PyLong_FromLong((uint16_t)(CLAIMS_SOURCE_TYPE_AD)));
	PyModule_AddObject(m, "CLAIMS_SOURCE_TYPE_CERTIFICATE", PyLong_FromLong((uint16_t)(CLAIMS_SOURCE_TYPE_CERTIFICATE)));
	PyModule_AddObject(m, "CLAIMS_COMPRESSION_FORMAT_NONE", PyLong_FromLong((uint16_t)(CLAIMS_COMPRESSION_FORMAT_NONE)));
	PyModule_AddObject(m, "CLAIMS_COMPRESSION_FORMAT_LZNT1", PyLong_FromLong((uint16_t)(CLAIMS_COMPRESSION_FORMAT_LZNT1)));
	PyModule_AddObject(m, "CLAIMS_COMPRESSION_FORMAT_XPRESS", PyLong_FromLong((uint16_t)(CLAIMS_COMPRESSION_FORMAT_XPRESS)));
	PyModule_AddObject(m, "CLAIMS_COMPRESSION_FORMAT_XPRESS_HUFF", PyLong_FromLong((uint16_t)(CLAIMS_COMPRESSION_FORMAT_XPRESS_HUFF)));
	PyModule_AddObject(m, "CLAIMS_TF_CONDITION_OPERATOR_INVALID", PyLong_FromLong((uint16_t)(CLAIMS_TF_CONDITION_OPERATOR_INVALID)));
	PyModule_AddObject(m, "CLAIMS_TF_CONDITION_OPERATOR_EQ", PyLong_FromLong((uint16_t)(CLAIMS_TF_CONDITION_OPERATOR_EQ)));
	PyModule_AddObject(m, "CLAIMS_TF_CONDITION_OPERATOR_NEQ", PyLong_FromLong((uint16_t)(CLAIMS_TF_CONDITION_OPERATOR_NEQ)));
	PyModule_AddObject(m, "CLAIMS_TF_CONDITION_OPERATOR_REGEXP_MATCH", PyLong_FromLong((uint16_t)(CLAIMS_TF_CONDITION_OPERATOR_REGEXP_MATCH)));
	PyModule_AddObject(m, "CLAIMS_TF_CONDITION_OPERATOR_REGEXP_NOT_MATCH", PyLong_FromLong((uint16_t)(CLAIMS_TF_CONDITION_OPERATOR_REGEXP_NOT_MATCH)));
	PyModule_AddObject(m, "CLAIMS_TF_PROPERTY_INVALID", PyLong_FromLong((uint16_t)(CLAIMS_TF_PROPERTY_INVALID)));
	PyModule_AddObject(m, "CLAIMS_TF_PROPERTY_TYPE", PyLong_FromLong((uint16_t)(CLAIMS_TF_PROPERTY_TYPE)));
	PyModule_AddObject(m, "CLAIMS_TF_PROPERTY_VALUE", PyLong_FromLong((uint16_t)(CLAIMS_TF_PROPERTY_VALUE)));
	PyModule_AddObject(m, "CLAIMS_TF_PROPERTY_VALUE_TYPE", PyLong_FromLong((uint16_t)(CLAIMS_TF_PROPERTY_VALUE_TYPE)));
	Py_INCREF((PyObject *)(void *)&CLAIM_INT64_Type);
	PyModule_AddObject(m, "CLAIM_INT64", (PyObject *)(void *)&CLAIM_INT64_Type);
	Py_INCREF((PyObject *)(void *)&CLAIM_UINT64_Type);
	PyModule_AddObject(m, "CLAIM_UINT64", (PyObject *)(void *)&CLAIM_UINT64_Type);
	Py_INCREF((PyObject *)(void *)&CLAIM_STRING_Type);
	PyModule_AddObject(m, "CLAIM_STRING", (PyObject *)(void *)&CLAIM_STRING_Type);
	Py_INCREF((PyObject *)(void *)&CLAIM_ENTRY_VALUES_Type);
	PyModule_AddObject(m, "CLAIM_ENTRY_VALUES", (PyObject *)(void *)&CLAIM_ENTRY_VALUES_Type);
	Py_INCREF((PyObject *)(void *)&CLAIM_ENTRY_Type);
	PyModule_AddObject(m, "CLAIM_ENTRY", (PyObject *)(void *)&CLAIM_ENTRY_Type);
	Py_INCREF((PyObject *)(void *)&CLAIMS_ARRAY_Type);
	PyModule_AddObject(m, "CLAIMS_ARRAY", (PyObject *)(void *)&CLAIMS_ARRAY_Type);
	Py_INCREF((PyObject *)(void *)&CLAIMS_SET_METADATA_CTR_Type);
	PyModule_AddObject(m, "CLAIMS_SET_METADATA_CTR", (PyObject *)(void *)&CLAIMS_SET_METADATA_CTR_Type);
	Py_INCREF((PyObject *)(void *)&CLAIMS_SET_CTR_Type);
	PyModule_AddObject(m, "CLAIMS_SET_CTR", (PyObject *)(void *)&CLAIMS_SET_CTR_Type);
	Py_INCREF((PyObject *)(void *)&CLAIMS_SET_Type);
	PyModule_AddObject(m, "CLAIMS_SET", (PyObject *)(void *)&CLAIMS_SET_Type);
	Py_INCREF((PyObject *)(void *)&CLAIMS_SET_NDR_Type);
	PyModule_AddObject(m, "CLAIMS_SET_NDR", (PyObject *)(void *)&CLAIMS_SET_NDR_Type);
	Py_INCREF((PyObject *)(void *)&CLAIMS_SET_METADATA_NDR_Type);
	PyModule_AddObject(m, "CLAIMS_SET_METADATA_NDR", (PyObject *)(void *)&CLAIMS_SET_METADATA_NDR_Type);
	Py_INCREF((PyObject *)(void *)&CLAIMS_SET_METADATA_Type);
	PyModule_AddObject(m, "CLAIMS_SET_METADATA", (PyObject *)(void *)&CLAIMS_SET_METADATA_Type);
	Py_INCREF((PyObject *)(void *)&claims_tf_condition_Type);
	PyModule_AddObject(m, "tf_condition", (PyObject *)(void *)&claims_tf_condition_Type);
	Py_INCREF((PyObject *)(void *)&claims_tf_condition_set_Type);
	PyModule_AddObject(m, "tf_condition_set", (PyObject *)(void *)&claims_tf_condition_set_Type);
	Py_INCREF((PyObject *)(void *)&claims_tf_property_ref_Type);
	PyModule_AddObject(m, "tf_property_ref", (PyObject *)(void *)&claims_tf_property_ref_Type);
	Py_INCREF((PyObject *)(void *)&claims_tf_property_Type);
	PyModule_AddObject(m, "tf_property", (PyObject *)(void *)&claims_tf_property_Type);
	Py_INCREF((PyObject *)(void *)&claims_tf_rule_action_Type);
	PyModule_AddObject(m, "tf_rule_action", (PyObject *)(void *)&claims_tf_rule_action_Type);
	Py_INCREF((PyObject *)(void *)&claims_tf_rule_Type);
	PyModule_AddObject(m, "tf_rule", (PyObject *)(void *)&claims_tf_rule_Type);
	Py_INCREF((PyObject *)(void *)&claims_tf_rule_set_Type);
	PyModule_AddObject(m, "tf_rule_set", (PyObject *)(void *)&claims_tf_rule_set_Type);
	Py_INCREF((PyObject *)(void *)&claims_InterfaceType);
	PyModule_AddObject(m, "claims", (PyObject *)(void *)&claims_InterfaceType);
	Py_INCREF((PyObject *)(void *)&claims_SyntaxType);
	PyModule_AddObject(m, "claims_abstract_syntax", (PyObject *)(void *)&claims_SyntaxType);
	Py_INCREF((PyObject *)(void *)&claims_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&claims_SyntaxType);
#ifdef PY_MOD_CLAIMS_PATCH
	PY_MOD_CLAIMS_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	Py_XDECREF(dep_samba_dcerpc_misc);
	return m;

}
