/**
 *
 * @file cpucblk_spack.h
 *
 * Precision dependent routines to pack and unpack cblks.
 *
 * @copyright 2021-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 6.4.0
 * @author Nolan Bredel
 * @date 2024-07-05
 *
 * @generated from /build/pastix/src/pastix-6.4.0/kernels/cpucblk_zpack.h, normal z -> s, Tue Dec 16 21:22:40 2025
 *
 **/

#ifndef _cpucblk_spack_h_
#define _cpucblk_spack_h_

size_t cpublok_scompute_size_lr( pastix_coefside_t  side,
                                 pastix_int_t       N,
                                 const SolverBlok  *blok );

pastix_uint_t cpucblk_scompute_size_lr( pastix_coefside_t  side,
                                        const SolverCblk  *cblk );

size_t cpucblk_scompute_size( pastix_coefside_t  side,
                              const SolverCblk  *cblk );

char *cpublok_spack_lr( pastix_coefside_t  side,
                        pastix_uint_t      N,
                        const SolverBlok  *blok,
                        char *             buffer );

void *cpucblk_spack_lr( pastix_coefside_t  side,
                        SolverCblk        *cblk,
                        size_t             size );

char *cpublok_sunpack_lr( pastix_coefside_t  side,
                          pastix_int_t       N,
                          SolverBlok        *blok,
                          char              *buffer );

void cpucblk_sunpack_lr( pastix_coefside_t  side,
                         SolverCblk        *cblk,
                         void              *buffer );

void *cpucblk_spack_fr( pastix_coefside_t  side,
                        const SolverCblk  *cblk );

void cpucblk_sunpack_fr( pastix_coefside_t   side,
                         SolverCblk         *cblk,
                         float *buffer );

void *cpucblk_spack( pastix_coefside_t  side,
                     SolverCblk        *cblk,
                     size_t             size );

void cpucblk_sunpack( pastix_coefside_t  side,
                      SolverCblk        *cblk,
                      void              *buffer );

#endif /* _cpucblk_spack_h_ */
