
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kunitconversion_python.h"

// main header
#include "kunitconversion_unitcategory_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <QStringList>
#include <unit.h>
#include <unitcategory.h>
#include <value.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

using namespace KUnitConversion;

extern "C" {
static PyTypeObject *_Sbk_KUnitConversion_UnitCategory_Type = nullptr;
static PyTypeObject *Sbk_KUnitConversion_UnitCategory_TypeF(void)
{
    return _Sbk_KUnitConversion_UnitCategory_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KUnitConversion_UnitCategory_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KUnitConversion::UnitCategory >()))
        return -1;

    ::KUnitConversion::UnitCategory *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "UnitCategory", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: UnitCategory::UnitCategory()
    // 1: UnitCategory::UnitCategory(KUnitConversion::UnitCategory)
    if (numArgs == 0) {
        overloadId = 0; // UnitCategory()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), (pyArgs[0])))) {
        overloadId = 1; // UnitCategory(KUnitConversion::UnitCategory)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // UnitCategory()
        {

            // UnitCategory()
            cptr = new ::KUnitConversion::UnitCategory();
            break;
        }
        case 1: // UnitCategory(const KUnitConversion::UnitCategory &other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KUnitConversion::UnitCategory *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // UnitCategory(KUnitConversion::UnitCategory)
                cptr = new ::KUnitConversion::UnitCategory(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KUnitConversion::UnitCategory >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KUnitConversion_UnitCategoryFunc_allUnits(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::UnitCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // allUnits()const
        QStringList cppResult = const_cast<const ::KUnitConversion::UnitCategory *>(cppSelf)->allUnits();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitCategoryFunc_convert(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::UnitCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "convert", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]);

    if (PyArg_ParseTuple(args, "|OO:convert", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: UnitCategory::convert(KUnitConversion::Value,KUnitConversion::UnitId)const->KUnitConversion::Value
    // 1: UnitCategory::convert(KUnitConversion::Value,KUnitConversion::Unit)const->KUnitConversion::Value
    // 2: UnitCategory::convert(KUnitConversion::Value,const QString&=)const->KUnitConversion::Value
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // convert(KUnitConversion::Value,QString)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 2; // convert(KUnitConversion::Value,QString)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), (pyArgs[1])))) {
            overloadId = 1; // convert(KUnitConversion::Value,KUnitConversion::Unit)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitId_IDX])))->converter, (pyArgs[1])))) {
            overloadId = 0; // convert(KUnitConversion::Value,KUnitConversion::UnitId)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "convert", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // convert(const KUnitConversion::Value &value, KUnitConversion::UnitId toUnit) const
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "convert", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::KUnitConversion::Value *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::KUnitConversion::UnitId cppArg1{KUnitConversion::NoUnit};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // convert(KUnitConversion::Value,KUnitConversion::UnitId)const
                KUnitConversion::Value* cppResult = new KUnitConversion::Value(const_cast<const ::KUnitConversion::UnitCategory *>(cppSelf)->convert(*cppArg0, cppArg1));
                pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), cppResult, true, true);
            }
            break;
        }
        case 1: // convert(const KUnitConversion::Value &value, const KUnitConversion::Unit &toUnit) const
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "convert", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::KUnitConversion::Value *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::KUnitConversion::Unit *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // convert(KUnitConversion::Value,KUnitConversion::Unit)const
                KUnitConversion::Value* cppResult = new KUnitConversion::Value(const_cast<const ::KUnitConversion::UnitCategory *>(cppSelf)->convert(*cppArg0, *cppArg1));
                pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), cppResult, true, true);
            }
            break;
        }
        case 2: // convert(const KUnitConversion::Value &value, const QString &toUnit) const
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"toUnit", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "convert", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::KUnitConversion::Value *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // convert(KUnitConversion::Value,QString)const
                KUnitConversion::Value* cppResult = new KUnitConversion::Value(const_cast<const ::KUnitConversion::UnitCategory *>(cppSelf)->convert(*cppArg0, cppArg1));
                pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Value_IDX]), cppResult, true, true);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitCategoryFunc_defaultUnit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::UnitCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // defaultUnit()const
        KUnitConversion::Unit* cppResult = new KUnitConversion::Unit(const_cast<const ::KUnitConversion::UnitCategory *>(cppSelf)->defaultUnit());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitCategoryFunc_description(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::UnitCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // description()const
        QString cppResult = const_cast<const ::KUnitConversion::UnitCategory *>(cppSelf)->description();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitCategoryFunc_hasOnlineConversionTable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::UnitCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // hasOnlineConversionTable()const
        bool cppResult = const_cast<const ::KUnitConversion::UnitCategory *>(cppSelf)->hasOnlineConversionTable();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitCategoryFunc_hasUnit(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::UnitCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: UnitCategory::hasUnit(QString)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // hasUnit(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "hasUnit", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // hasUnit(QString)const
            bool cppResult = const_cast<const ::KUnitConversion::UnitCategory *>(cppSelf)->hasUnit(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitCategoryFunc_id(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::UnitCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // id()const
        KUnitConversion::CategoryId cppResult = const_cast<const ::KUnitConversion::UnitCategory *>(cppSelf)->id();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_CategoryId_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitCategoryFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::UnitCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isNull()const
        bool cppResult = const_cast<const ::KUnitConversion::UnitCategory *>(cppSelf)->isNull();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitCategoryFunc_mostCommonUnits(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::UnitCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // mostCommonUnits()const
        QList<KUnitConversion::Unit> cppResult = const_cast<const ::KUnitConversion::UnitCategory *>(cppSelf)->mostCommonUnits();
        pyResult = Shiboken::Conversions::copyToPython(SbkKUnitConversionTypeConverters[SBK_KUnitConversion_QList_KUnitConversion_Unit_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitCategoryFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::UnitCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // name()const
        QString cppResult = const_cast<const ::KUnitConversion::UnitCategory *>(cppSelf)->name();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitCategoryFunc_syncConversionTable(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::UnitCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "syncConversionTable", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]);

    if (PyArg_ParseTuple(args, "|O:syncConversionTable", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: UnitCategory::syncConversionTable(std::chrono::seconds=)->KUnitConversion::UpdateJob*
    if (numArgs == 0) {
        overloadId = 0; // syncConversionTable(std::chrono::seconds)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_std_chrono_seconds_IDX], (pyArgs[0])))) {
        overloadId = 0; // syncConversionTable(std::chrono::seconds)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "syncConversionTable", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"updateSkipPeriod", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_std_chrono_seconds_IDX], (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "syncConversionTable", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]);
            }
        }
        std::chrono::seconds cppArg0 = std::chrono::hours(24);
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // syncConversionTable(std::chrono::seconds)
            KUnitConversion::UpdateJob * cppResult = cppSelf->syncConversionTable(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UpdateJob_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitCategoryFunc_unit(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::UnitCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: UnitCategory::unit(KUnitConversion::UnitId)const->KUnitConversion::Unit
    // 1: UnitCategory::unit(QString)const->KUnitConversion::Unit
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 1; // unit(QString)const
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitId_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // unit(KUnitConversion::UnitId)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "unit", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // unit(KUnitConversion::UnitId unitId) const
        {
            ::KUnitConversion::UnitId cppArg0{KUnitConversion::NoUnit};
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // unit(KUnitConversion::UnitId)const
                KUnitConversion::Unit* cppResult = new KUnitConversion::Unit(const_cast<const ::KUnitConversion::UnitCategory *>(cppSelf)->unit(cppArg0));
                pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), cppResult, true, true);
            }
            break;
        }
        case 1: // unit(const QString &s) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // unit(QString)const
                KUnitConversion::Unit* cppResult = new KUnitConversion::Unit(const_cast<const ::KUnitConversion::UnitCategory *>(cppSelf)->unit(cppArg0));
                pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), cppResult, true, true);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitCategoryFunc_units(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::UnitCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // units()const
        QList<KUnitConversion::Unit> cppResult = const_cast<const ::KUnitConversion::UnitCategory *>(cppSelf)->units();
        pyResult = Shiboken::Conversions::copyToPython(SbkKUnitConversionTypeConverters[SBK_KUnitConversion_QList_KUnitConversion_Unit_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KUnitConversion_UnitCategory_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KUnitConversion_UnitCategory_methods[] = {
    {"allUnits", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitCategoryFunc_allUnits), METH_NOARGS, nullptr},
    {"convert", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitCategoryFunc_convert), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"defaultUnit", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitCategoryFunc_defaultUnit), METH_NOARGS, nullptr},
    {"description", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitCategoryFunc_description), METH_NOARGS, nullptr},
    {"hasOnlineConversionTable", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitCategoryFunc_hasOnlineConversionTable), METH_NOARGS, nullptr},
    {"hasUnit", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitCategoryFunc_hasUnit), METH_O, nullptr},
    {"id", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitCategoryFunc_id), METH_NOARGS, nullptr},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitCategoryFunc_isNull), METH_NOARGS, nullptr},
    {"mostCommonUnits", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitCategoryFunc_mostCommonUnits), METH_NOARGS, nullptr},
    {"name", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitCategoryFunc_name), METH_NOARGS, nullptr},
    {"syncConversionTable", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitCategoryFunc_syncConversionTable), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"unit", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitCategoryFunc_unit), METH_O, nullptr},
    {"units", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitCategoryFunc_units), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_KUnitConversion_UnitCategory_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KUnitConversion::UnitCategory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), (pyArg)))) {
                // operator!=(const KUnitConversion::UnitCategory &other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::KUnitConversion::UnitCategory *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf != (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), (pyArg)))) {
                // operator==(const KUnitConversion::UnitCategory &other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::KUnitConversion::UnitCategory *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf == (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
    }

    return Shiboken::returnFromRichCompare(pyResult);
}

} // extern "C"

static int Sbk_KUnitConversion_UnitCategory_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KUnitConversion_UnitCategory_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KUnitConversion_UnitCategory_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KUnitConversion_UnitCategory_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KUnitConversion_UnitCategory_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_KUnitConversion_UnitCategory_richcompare)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KUnitConversion_UnitCategory_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KUnitConversion_UnitCategory_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KUnitConversion_UnitCategory_spec = {
    "1:KUnitConversion.KUnitConversion.UnitCategory",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KUnitConversion_UnitCategory_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void UnitCategory_PythonToCpp_UnitCategory_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KUnitConversion_UnitCategory_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_UnitCategory_PythonToCpp_UnitCategory_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KUnitConversion_UnitCategory_TypeF()))
        return UnitCategory_PythonToCpp_UnitCategory_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *UnitCategory_PTR_CppToPython_UnitCategory(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KUnitConversion_UnitCategory_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KUnitConversion_UnitCategory_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KUnitConversion_UnitCategory_SignatureStrings[] = {
    "1:KUnitConversion.KUnitConversion.UnitCategory(self)",
    "0:KUnitConversion.KUnitConversion.UnitCategory(self,other:KUnitConversion.KUnitConversion.UnitCategory)",
    "KUnitConversion.KUnitConversion.UnitCategory.allUnits(self)->QStringList",
    "2:KUnitConversion.KUnitConversion.UnitCategory.convert(self,value:KUnitConversion.KUnitConversion.Value,toUnit:KUnitConversion.KUnitConversion.UnitId)->KUnitConversion.KUnitConversion.Value",
    "1:KUnitConversion.KUnitConversion.UnitCategory.convert(self,value:KUnitConversion.KUnitConversion.Value,toUnit:KUnitConversion.KUnitConversion.Unit)->KUnitConversion.KUnitConversion.Value",
    "0:KUnitConversion.KUnitConversion.UnitCategory.convert(self,value:KUnitConversion.KUnitConversion.Value,toUnit:QString=QString())->KUnitConversion.KUnitConversion.Value",
    "KUnitConversion.KUnitConversion.UnitCategory.defaultUnit(self)->KUnitConversion.KUnitConversion.Unit",
    "KUnitConversion.KUnitConversion.UnitCategory.description(self)->QString",
    "KUnitConversion.KUnitConversion.UnitCategory.hasOnlineConversionTable(self)->bool",
    "KUnitConversion.KUnitConversion.UnitCategory.hasUnit(self,unit:QString)->bool",
    "KUnitConversion.KUnitConversion.UnitCategory.id(self)->KUnitConversion.KUnitConversion.CategoryId",
    "KUnitConversion.KUnitConversion.UnitCategory.isNull(self)->bool",
    "KUnitConversion.KUnitConversion.UnitCategory.mostCommonUnits(self)->QList[KUnitConversion.KUnitConversion.Unit]",
    "KUnitConversion.KUnitConversion.UnitCategory.name(self)->QString",
    "KUnitConversion.KUnitConversion.UnitCategory.syncConversionTable(self,updateSkipPeriod:std.chrono.seconds=std.chrono.hours(24))->KUnitConversion.KUnitConversion.UpdateJob",
    "1:KUnitConversion.KUnitConversion.UnitCategory.unit(self,unitId:KUnitConversion.KUnitConversion.UnitId)->KUnitConversion.KUnitConversion.Unit",
    "0:KUnitConversion.KUnitConversion.UnitCategory.unit(self,s:QString)->KUnitConversion.KUnitConversion.Unit",
    "KUnitConversion.KUnitConversion.UnitCategory.units(self)->QList[KUnitConversion.KUnitConversion.Unit]",
    "KUnitConversion.KUnitConversion.UnitCategory.__ne__(self,other:KUnitConversion.KUnitConversion.UnitCategory)->bool",
    "KUnitConversion.KUnitConversion.UnitCategory.__eq__(self,other:KUnitConversion.KUnitConversion.UnitCategory)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t KUnitConversion_UnitCategory_SignatureByteSize = 335;
static constexpr uint8_t KUnitConversion_UnitCategory_SignatureBytes[335] = {
    0x78, 0xda, 0xcd, 0x55, 0x4d, 0x6f, 0xc2, 0x30, 0x0c, 0xbd, 0xf7, 0x97, 0x14, 0xa9, 0xab, 0x0a,
    0xda, 0x09, 0x89, 0x5d, 0x76, 0x62, 0x9b, 0xf6, 0x21, 0xc6, 0x2e, 0xd3, 0x54, 0xa5, 0x8d, 0xa1,
    0xd1, 0xd2, 0xb8, 0x8b, 0x13, 0x24, 0xfe, 0xfd, 0xda, 0x02, 0x5b, 0x41, 0x93, 0x48, 0x0a, 0x42,
    0x3b, 0x55, 0x76, 0xec, 0xf7, 0x5e, 0xe2, 0x8f, 0x0e, 0xc7, 0xf7, 0x73, 0x25, 0xcc, 0x2d, 0xaa,
    0x15, 0x68, 0x12, 0xa8, 0xe2, 0x43, 0xbb, 0x35, 0x99, 0x81, 0x25, 0xea, 0x75, 0x48, 0x20, 0x17,
    0x83, 0x20, 0xf1, 0x4f, 0x8a, 0xd0, 0x14, 0xa0, 0xbd, 0xf2, 0x06, 0x81, 0x4f, 0x74, 0xcc, 0xa4,
    0x6c, 0x6c, 0xda, 0x68, 0xbc, 0xba, 0x79, 0x99, 0x19, 0x2d, 0xd4, 0xf2, 0x41, 0x90, 0x09, 0x46,
    0x5e, 0xc4, 0x71, 0xde, 0xfa, 0xcd, 0x46, 0xf8, 0x8a, 0x49, 0x0b, 0x47, 0xf3, 0xdf, 0x9a, 0xa8,
    0xc8, 0x60, 0xe3, 0x76, 0x22, 0x9b, 0xf2, 0x5a, 0xa3, 0x13, 0x6a, 0x30, 0xfc, 0x7f, 0xea, 0x9d,
    0xb5, 0x27, 0x97, 0xd5, 0xbe, 0x2d, 0xfa, 0x64, 0xfb, 0x0d, 0x07, 0xce, 0x42, 0xbd, 0x64, 0x72,
    0x58, 0x30, 0x2b, 0x4d, 0xe3, 0xdb, 0xb5, 0x9b, 0x4b, 0xbe, 0x2f, 0x09, 0xe5, 0x5a, 0x54, 0xa6,
    0x3e, 0x38, 0xe8, 0x69, 0x3f, 0x9c, 0x82, 0xd1, 0x93, 0x92, 0x42, 0xc1, 0x6f, 0xc0, 0x2b, 0xcb,
    0x24, 0xec, 0x40, 0x33, 0x44, 0xe9, 0x8d, 0xf8, 0x73, 0xf5, 0xc8, 0x76, 0xde, 0xbd, 0x17, 0x9a,
    0xe0, 0xae, 0x6f, 0xb8, 0x4b, 0x99, 0x72, 0x4f, 0x06, 0x7a, 0xb4, 0x52, 0xf6, 0xbf, 0x6f, 0x89,
    0x54, 0x9f, 0x95, 0x25, 0xaa, 0xfd, 0x0d, 0xd3, 0xec, 0x96, 0x77, 0x17, 0xa4, 0x0f, 0x3f, 0x3e,
    0xc5, 0x4a, 0x38, 0xa9, 0xe4, 0xb4, 0x56, 0xf9, 0x5f, 0xd5, 0x8e, 0x6c, 0xc5, 0xeb, 0x98, 0xd9,
    0xa7, 0xa8, 0x9e, 0x41, 0x0b, 0xe4, 0x63, 0x32, 0x3c, 0xce, 0x0b, 0x8d, 0x0a, 0x63, 0x82, 0x7a,
    0xfa, 0x38, 0x4d, 0x3a, 0xae, 0x02, 0xad, 0xa6, 0x70, 0x74, 0xed, 0x32, 0x46, 0xf3, 0x16, 0xfa,
    0x0e, 0x33, 0xdf, 0x7d, 0x65, 0xf7, 0x5a, 0x69, 0xca, 0xcf, 0xb7, 0x3e, 0xdb, 0x99, 0x4b, 0xfa,
    0xaa, 0xa1, 0x4e, 0x57, 0x9f, 0x7f, 0xba, 0xed, 0x45, 0x3a, 0x29, 0x4d, 0x15, 0xa4, 0x69, 0xef,
    0x3f, 0x70, 0x9f, 0x61, 0x49, 0x53, 0xf8, 0x3a, 0x9d, 0xf2, 0x1b, 0x1d, 0x09, 0x44, 0xa7
};
#endif

PyTypeObject *init_KUnitConversion_UnitCategory(PyObject *enclosingClass)
{
    if (SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX].type != nullptr)
        return SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX].type;

    Shiboken::AutoDecRef Sbk_KUnitConversion_UnitCategory_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KUnitConversion_UnitCategory_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "UnitCategory",
        "KUnitConversion::UnitCategory*",
        &Sbk_KUnitConversion_UnitCategory_spec,
        &Shiboken::callCppDestructor< ::KUnitConversion::UnitCategory >,
        Sbk_KUnitConversion_UnitCategory_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::InnerClass);
    auto *pyType = _Sbk_KUnitConversion_UnitCategory_Type; // references _Sbk_KUnitConversion_UnitCategory_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KUnitConversion_UnitCategory_SignatureStrings);
#else
    InitSignatureBytes(pyType, KUnitConversion_UnitCategory_SignatureBytes, KUnitConversion_UnitCategory_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KUnitConversion_UnitCategory_PropertyStrings);
    SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        UnitCategory_PythonToCpp_UnitCategory_PTR,
        is_UnitCategory_PythonToCpp_UnitCategory_PTR_Convertible,
        UnitCategory_PTR_CppToPython_UnitCategory);

    Shiboken::Conversions::registerConverterName(converter, "KUnitConversion::UnitCategory");
    Shiboken::Conversions::registerConverterName(converter, "KUnitConversion::UnitCategory*");
    Shiboken::Conversions::registerConverterName(converter, "KUnitConversion::UnitCategory&");
    Shiboken::Conversions::registerConverterAlias(converter, "UnitCategory");
    Shiboken::Conversions::registerConverterAlias(converter, "UnitCategory*");
    Shiboken::Conversions::registerConverterAlias(converter, "UnitCategory&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KUnitConversion::UnitCategory).name());

    qRegisterMetaType< ::KUnitConversion::UnitCategory *>();

    return pyType;
}
