#ifndef itkImageFileWriterSwigInterface_h
#define itkImageFileWriterSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkPhasedArray3DSpecialCoordinatesImage.h"
#include "itkImageFileWriter.h"

using itkImageFileWriterIULL2 = itk::ImageFileWriter< itk::Image< unsigned long long,2 > >;
using itkImageFileWriterIULL2_Pointer = itk::ImageFileWriter< itk::Image< unsigned long long,2 > >::Pointer;
using itkImageFileWriterIULL3 = itk::ImageFileWriter< itk::Image< unsigned long long,3 > >;
using itkImageFileWriterIULL3_Pointer = itk::ImageFileWriter< itk::Image< unsigned long long,3 > >::Pointer;
using itkImageFileWriterIULL4 = itk::ImageFileWriter< itk::Image< unsigned long long,4 > >;
using itkImageFileWriterIULL4_Pointer = itk::ImageFileWriter< itk::Image< unsigned long long,4 > >::Pointer;
using itkImageFileWriterIUI2 = itk::ImageFileWriter< itk::Image< unsigned int,2 > >;
using itkImageFileWriterIUI2_Pointer = itk::ImageFileWriter< itk::Image< unsigned int,2 > >::Pointer;
using itkImageFileWriterIUI3 = itk::ImageFileWriter< itk::Image< unsigned int,3 > >;
using itkImageFileWriterIUI3_Pointer = itk::ImageFileWriter< itk::Image< unsigned int,3 > >::Pointer;
using itkImageFileWriterIUI4 = itk::ImageFileWriter< itk::Image< unsigned int,4 > >;
using itkImageFileWriterIUI4_Pointer = itk::ImageFileWriter< itk::Image< unsigned int,4 > >::Pointer;
using itkImageFileWriterISI2 = itk::ImageFileWriter< itk::Image< signed int,2 > >;
using itkImageFileWriterISI2_Pointer = itk::ImageFileWriter< itk::Image< signed int,2 > >::Pointer;
using itkImageFileWriterISI3 = itk::ImageFileWriter< itk::Image< signed int,3 > >;
using itkImageFileWriterISI3_Pointer = itk::ImageFileWriter< itk::Image< signed int,3 > >::Pointer;
using itkImageFileWriterISI4 = itk::ImageFileWriter< itk::Image< signed int,4 > >;
using itkImageFileWriterISI4_Pointer = itk::ImageFileWriter< itk::Image< signed int,4 > >::Pointer;
using itkImageFileWriterIUC2 = itk::ImageFileWriter< itk::Image< unsigned char,2 > >;
using itkImageFileWriterIUC2_Pointer = itk::ImageFileWriter< itk::Image< unsigned char,2 > >::Pointer;
using itkImageFileWriterIUC3 = itk::ImageFileWriter< itk::Image< unsigned char,3 > >;
using itkImageFileWriterIUC3_Pointer = itk::ImageFileWriter< itk::Image< unsigned char,3 > >::Pointer;
using itkImageFileWriterIUC4 = itk::ImageFileWriter< itk::Image< unsigned char,4 > >;
using itkImageFileWriterIUC4_Pointer = itk::ImageFileWriter< itk::Image< unsigned char,4 > >::Pointer;
using itkImageFileWriterIRGBUC2 = itk::ImageFileWriter< itk::Image< itk::RGBPixel< unsigned char >,2 > >;
using itkImageFileWriterIRGBUC2_Pointer = itk::ImageFileWriter< itk::Image< itk::RGBPixel< unsigned char >,2 > >::Pointer;
using itkImageFileWriterIRGBUC3 = itk::ImageFileWriter< itk::Image< itk::RGBPixel< unsigned char >,3 > >;
using itkImageFileWriterIRGBUC3_Pointer = itk::ImageFileWriter< itk::Image< itk::RGBPixel< unsigned char >,3 > >::Pointer;
using itkImageFileWriterIRGBUC4 = itk::ImageFileWriter< itk::Image< itk::RGBPixel< unsigned char >,4 > >;
using itkImageFileWriterIRGBUC4_Pointer = itk::ImageFileWriter< itk::Image< itk::RGBPixel< unsigned char >,4 > >::Pointer;
using itkImageFileWriterIRGBUS2 = itk::ImageFileWriter< itk::Image< itk::RGBPixel< unsigned short >,2 > >;
using itkImageFileWriterIRGBUS2_Pointer = itk::ImageFileWriter< itk::Image< itk::RGBPixel< unsigned short >,2 > >::Pointer;
using itkImageFileWriterIRGBUS3 = itk::ImageFileWriter< itk::Image< itk::RGBPixel< unsigned short >,3 > >;
using itkImageFileWriterIRGBUS3_Pointer = itk::ImageFileWriter< itk::Image< itk::RGBPixel< unsigned short >,3 > >::Pointer;
using itkImageFileWriterIRGBUS4 = itk::ImageFileWriter< itk::Image< itk::RGBPixel< unsigned short >,4 > >;
using itkImageFileWriterIRGBUS4_Pointer = itk::ImageFileWriter< itk::Image< itk::RGBPixel< unsigned short >,4 > >::Pointer;
using itkImageFileWriterIRGBAUC2 = itk::ImageFileWriter< itk::Image< itk::RGBAPixel< unsigned char >,2 > >;
using itkImageFileWriterIRGBAUC2_Pointer = itk::ImageFileWriter< itk::Image< itk::RGBAPixel< unsigned char >,2 > >::Pointer;
using itkImageFileWriterIRGBAUC3 = itk::ImageFileWriter< itk::Image< itk::RGBAPixel< unsigned char >,3 > >;
using itkImageFileWriterIRGBAUC3_Pointer = itk::ImageFileWriter< itk::Image< itk::RGBAPixel< unsigned char >,3 > >::Pointer;
using itkImageFileWriterIRGBAUC4 = itk::ImageFileWriter< itk::Image< itk::RGBAPixel< unsigned char >,4 > >;
using itkImageFileWriterIRGBAUC4_Pointer = itk::ImageFileWriter< itk::Image< itk::RGBAPixel< unsigned char >,4 > >::Pointer;
using itkImageFileWriterIRGBAUS2 = itk::ImageFileWriter< itk::Image< itk::RGBAPixel< unsigned short >,2 > >;
using itkImageFileWriterIRGBAUS2_Pointer = itk::ImageFileWriter< itk::Image< itk::RGBAPixel< unsigned short >,2 > >::Pointer;
using itkImageFileWriterIRGBAUS3 = itk::ImageFileWriter< itk::Image< itk::RGBAPixel< unsigned short >,3 > >;
using itkImageFileWriterIRGBAUS3_Pointer = itk::ImageFileWriter< itk::Image< itk::RGBAPixel< unsigned short >,3 > >::Pointer;
using itkImageFileWriterIRGBAUS4 = itk::ImageFileWriter< itk::Image< itk::RGBAPixel< unsigned short >,4 > >;
using itkImageFileWriterIRGBAUS4_Pointer = itk::ImageFileWriter< itk::Image< itk::RGBAPixel< unsigned short >,4 > >::Pointer;
using itkImageFileWriterIVD22 = itk::ImageFileWriter< itk::Image< itk::Vector< double,2 >,2 > >;
using itkImageFileWriterIVD22_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< double,2 >,2 > >::Pointer;
using itkImageFileWriterIVD23 = itk::ImageFileWriter< itk::Image< itk::Vector< double,2 >,3 > >;
using itkImageFileWriterIVD23_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< double,2 >,3 > >::Pointer;
using itkImageFileWriterIVD24 = itk::ImageFileWriter< itk::Image< itk::Vector< double,2 >,4 > >;
using itkImageFileWriterIVD24_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< double,2 >,4 > >::Pointer;
using itkImageFileWriterIVD32 = itk::ImageFileWriter< itk::Image< itk::Vector< double,3 >,2 > >;
using itkImageFileWriterIVD32_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< double,3 >,2 > >::Pointer;
using itkImageFileWriterIVD33 = itk::ImageFileWriter< itk::Image< itk::Vector< double,3 >,3 > >;
using itkImageFileWriterIVD33_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< double,3 >,3 > >::Pointer;
using itkImageFileWriterIVD34 = itk::ImageFileWriter< itk::Image< itk::Vector< double,3 >,4 > >;
using itkImageFileWriterIVD34_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< double,3 >,4 > >::Pointer;
using itkImageFileWriterIVD42 = itk::ImageFileWriter< itk::Image< itk::Vector< double,4 >,2 > >;
using itkImageFileWriterIVD42_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< double,4 >,2 > >::Pointer;
using itkImageFileWriterIVD43 = itk::ImageFileWriter< itk::Image< itk::Vector< double,4 >,3 > >;
using itkImageFileWriterIVD43_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< double,4 >,3 > >::Pointer;
using itkImageFileWriterIVD44 = itk::ImageFileWriter< itk::Image< itk::Vector< double,4 >,4 > >;
using itkImageFileWriterIVD44_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< double,4 >,4 > >::Pointer;
using itkImageFileWriterIVF22 = itk::ImageFileWriter< itk::Image< itk::Vector< float,2 >,2 > >;
using itkImageFileWriterIVF22_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< float,2 >,2 > >::Pointer;
using itkImageFileWriterIVF23 = itk::ImageFileWriter< itk::Image< itk::Vector< float,2 >,3 > >;
using itkImageFileWriterIVF23_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< float,2 >,3 > >::Pointer;
using itkImageFileWriterIVF24 = itk::ImageFileWriter< itk::Image< itk::Vector< float,2 >,4 > >;
using itkImageFileWriterIVF24_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< float,2 >,4 > >::Pointer;
using itkImageFileWriterIVF32 = itk::ImageFileWriter< itk::Image< itk::Vector< float,3 >,2 > >;
using itkImageFileWriterIVF32_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< float,3 >,2 > >::Pointer;
using itkImageFileWriterIVF33 = itk::ImageFileWriter< itk::Image< itk::Vector< float,3 >,3 > >;
using itkImageFileWriterIVF33_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< float,3 >,3 > >::Pointer;
using itkImageFileWriterIVF34 = itk::ImageFileWriter< itk::Image< itk::Vector< float,3 >,4 > >;
using itkImageFileWriterIVF34_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< float,3 >,4 > >::Pointer;
using itkImageFileWriterIVF42 = itk::ImageFileWriter< itk::Image< itk::Vector< float,4 >,2 > >;
using itkImageFileWriterIVF42_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< float,4 >,2 > >::Pointer;
using itkImageFileWriterIVF43 = itk::ImageFileWriter< itk::Image< itk::Vector< float,4 >,3 > >;
using itkImageFileWriterIVF43_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< float,4 >,3 > >::Pointer;
using itkImageFileWriterIVF44 = itk::ImageFileWriter< itk::Image< itk::Vector< float,4 >,4 > >;
using itkImageFileWriterIVF44_Pointer = itk::ImageFileWriter< itk::Image< itk::Vector< float,4 >,4 > >::Pointer;
using itkImageFileWriterICVD22 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,2 >,2 > >;
using itkImageFileWriterICVD22_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,2 >,2 > >::Pointer;
using itkImageFileWriterICVD23 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,2 >,3 > >;
using itkImageFileWriterICVD23_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,2 >,3 > >::Pointer;
using itkImageFileWriterICVD24 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,2 >,4 > >;
using itkImageFileWriterICVD24_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,2 >,4 > >::Pointer;
using itkImageFileWriterICVD32 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,3 >,2 > >;
using itkImageFileWriterICVD32_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,3 >,2 > >::Pointer;
using itkImageFileWriterICVD33 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,3 >,3 > >;
using itkImageFileWriterICVD33_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,3 >,3 > >::Pointer;
using itkImageFileWriterICVD34 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,3 >,4 > >;
using itkImageFileWriterICVD34_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,3 >,4 > >::Pointer;
using itkImageFileWriterICVD42 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,4 >,2 > >;
using itkImageFileWriterICVD42_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,4 >,2 > >::Pointer;
using itkImageFileWriterICVD43 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,4 >,3 > >;
using itkImageFileWriterICVD43_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,4 >,3 > >::Pointer;
using itkImageFileWriterICVD44 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,4 >,4 > >;
using itkImageFileWriterICVD44_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< double,4 >,4 > >::Pointer;
using itkImageFileWriterICVF22 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,2 >,2 > >;
using itkImageFileWriterICVF22_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,2 >,2 > >::Pointer;
using itkImageFileWriterICVF23 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,2 >,3 > >;
using itkImageFileWriterICVF23_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,2 >,3 > >::Pointer;
using itkImageFileWriterICVF24 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,2 >,4 > >;
using itkImageFileWriterICVF24_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,2 >,4 > >::Pointer;
using itkImageFileWriterICVF32 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,3 >,2 > >;
using itkImageFileWriterICVF32_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,3 >,2 > >::Pointer;
using itkImageFileWriterICVF33 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,3 >,3 > >;
using itkImageFileWriterICVF33_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,3 >,3 > >::Pointer;
using itkImageFileWriterICVF34 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,3 >,4 > >;
using itkImageFileWriterICVF34_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,3 >,4 > >::Pointer;
using itkImageFileWriterICVF42 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,4 >,2 > >;
using itkImageFileWriterICVF42_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,4 >,2 > >::Pointer;
using itkImageFileWriterICVF43 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,4 >,3 > >;
using itkImageFileWriterICVF43_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,4 >,3 > >::Pointer;
using itkImageFileWriterICVF44 = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,4 >,4 > >;
using itkImageFileWriterICVF44_Pointer = itk::ImageFileWriter< itk::Image< itk::CovariantVector< float,4 >,4 > >::Pointer;
using itkImageFileWriterISC2 = itk::ImageFileWriter< itk::Image< signed char,2 > >;
using itkImageFileWriterISC2_Pointer = itk::ImageFileWriter< itk::Image< signed char,2 > >::Pointer;
using itkImageFileWriterISC3 = itk::ImageFileWriter< itk::Image< signed char,3 > >;
using itkImageFileWriterISC3_Pointer = itk::ImageFileWriter< itk::Image< signed char,3 > >::Pointer;
using itkImageFileWriterISC4 = itk::ImageFileWriter< itk::Image< signed char,4 > >;
using itkImageFileWriterISC4_Pointer = itk::ImageFileWriter< itk::Image< signed char,4 > >::Pointer;
using itkImageFileWriterISS2 = itk::ImageFileWriter< itk::Image< signed short,2 > >;
using itkImageFileWriterISS2_Pointer = itk::ImageFileWriter< itk::Image< signed short,2 > >::Pointer;
using itkImageFileWriterISS3 = itk::ImageFileWriter< itk::Image< signed short,3 > >;
using itkImageFileWriterISS3_Pointer = itk::ImageFileWriter< itk::Image< signed short,3 > >::Pointer;
using itkImageFileWriterISS4 = itk::ImageFileWriter< itk::Image< signed short,4 > >;
using itkImageFileWriterISS4_Pointer = itk::ImageFileWriter< itk::Image< signed short,4 > >::Pointer;
using itkImageFileWriterIUS2 = itk::ImageFileWriter< itk::Image< unsigned short,2 > >;
using itkImageFileWriterIUS2_Pointer = itk::ImageFileWriter< itk::Image< unsigned short,2 > >::Pointer;
using itkImageFileWriterIUS3 = itk::ImageFileWriter< itk::Image< unsigned short,3 > >;
using itkImageFileWriterIUS3_Pointer = itk::ImageFileWriter< itk::Image< unsigned short,3 > >::Pointer;
using itkImageFileWriterIUS4 = itk::ImageFileWriter< itk::Image< unsigned short,4 > >;
using itkImageFileWriterIUS4_Pointer = itk::ImageFileWriter< itk::Image< unsigned short,4 > >::Pointer;
using itkImageFileWriterIF2 = itk::ImageFileWriter< itk::Image< float,2 > >;
using itkImageFileWriterIF2_Pointer = itk::ImageFileWriter< itk::Image< float,2 > >::Pointer;
using itkImageFileWriterIF3 = itk::ImageFileWriter< itk::Image< float,3 > >;
using itkImageFileWriterIF3_Pointer = itk::ImageFileWriter< itk::Image< float,3 > >::Pointer;
using itkImageFileWriterIF4 = itk::ImageFileWriter< itk::Image< float,4 > >;
using itkImageFileWriterIF4_Pointer = itk::ImageFileWriter< itk::Image< float,4 > >::Pointer;
using itkImageFileWriterID2 = itk::ImageFileWriter< itk::Image< double,2 > >;
using itkImageFileWriterID2_Pointer = itk::ImageFileWriter< itk::Image< double,2 > >::Pointer;
using itkImageFileWriterID3 = itk::ImageFileWriter< itk::Image< double,3 > >;
using itkImageFileWriterID3_Pointer = itk::ImageFileWriter< itk::Image< double,3 > >::Pointer;
using itkImageFileWriterID4 = itk::ImageFileWriter< itk::Image< double,4 > >;
using itkImageFileWriterID4_Pointer = itk::ImageFileWriter< itk::Image< double,4 > >::Pointer;
using itkImageFileWriterICD2 = itk::ImageFileWriter< itk::Image< std::complex< double >,2 > >;
using itkImageFileWriterICD2_Pointer = itk::ImageFileWriter< itk::Image< std::complex< double >,2 > >::Pointer;
using itkImageFileWriterICD3 = itk::ImageFileWriter< itk::Image< std::complex< double >,3 > >;
using itkImageFileWriterICD3_Pointer = itk::ImageFileWriter< itk::Image< std::complex< double >,3 > >::Pointer;
using itkImageFileWriterICD4 = itk::ImageFileWriter< itk::Image< std::complex< double >,4 > >;
using itkImageFileWriterICD4_Pointer = itk::ImageFileWriter< itk::Image< std::complex< double >,4 > >::Pointer;
using itkImageFileWriterICF2 = itk::ImageFileWriter< itk::Image< std::complex< float >,2 > >;
using itkImageFileWriterICF2_Pointer = itk::ImageFileWriter< itk::Image< std::complex< float >,2 > >::Pointer;
using itkImageFileWriterICF3 = itk::ImageFileWriter< itk::Image< std::complex< float >,3 > >;
using itkImageFileWriterICF3_Pointer = itk::ImageFileWriter< itk::Image< std::complex< float >,3 > >::Pointer;
using itkImageFileWriterICF4 = itk::ImageFileWriter< itk::Image< std::complex< float >,4 > >;
using itkImageFileWriterICF4_Pointer = itk::ImageFileWriter< itk::Image< std::complex< float >,4 > >::Pointer;
using itkImageFileWriterVISC2 = itk::ImageFileWriter< itk::VectorImage< signed char,2 > >;
using itkImageFileWriterVISC2_Pointer = itk::ImageFileWriter< itk::VectorImage< signed char,2 > >::Pointer;
using itkImageFileWriterVISS2 = itk::ImageFileWriter< itk::VectorImage< signed short,2 > >;
using itkImageFileWriterVISS2_Pointer = itk::ImageFileWriter< itk::VectorImage< signed short,2 > >::Pointer;
using itkImageFileWriterVIUC2 = itk::ImageFileWriter< itk::VectorImage< unsigned char,2 > >;
using itkImageFileWriterVIUC2_Pointer = itk::ImageFileWriter< itk::VectorImage< unsigned char,2 > >::Pointer;
using itkImageFileWriterVIULL2 = itk::ImageFileWriter< itk::VectorImage< unsigned long long,2 > >;
using itkImageFileWriterVIULL2_Pointer = itk::ImageFileWriter< itk::VectorImage< unsigned long long,2 > >::Pointer;
using itkImageFileWriterVIUS2 = itk::ImageFileWriter< itk::VectorImage< unsigned short,2 > >;
using itkImageFileWriterVIUS2_Pointer = itk::ImageFileWriter< itk::VectorImage< unsigned short,2 > >::Pointer;
using itkImageFileWriterVIF2 = itk::ImageFileWriter< itk::VectorImage< float,2 > >;
using itkImageFileWriterVIF2_Pointer = itk::ImageFileWriter< itk::VectorImage< float,2 > >::Pointer;
using itkImageFileWriterVID2 = itk::ImageFileWriter< itk::VectorImage< double,2 > >;
using itkImageFileWriterVID2_Pointer = itk::ImageFileWriter< itk::VectorImage< double,2 > >::Pointer;
using itkImageFileWriterVISC3 = itk::ImageFileWriter< itk::VectorImage< signed char,3 > >;
using itkImageFileWriterVISC3_Pointer = itk::ImageFileWriter< itk::VectorImage< signed char,3 > >::Pointer;
using itkImageFileWriterVISS3 = itk::ImageFileWriter< itk::VectorImage< signed short,3 > >;
using itkImageFileWriterVISS3_Pointer = itk::ImageFileWriter< itk::VectorImage< signed short,3 > >::Pointer;
using itkImageFileWriterVIUC3 = itk::ImageFileWriter< itk::VectorImage< unsigned char,3 > >;
using itkImageFileWriterVIUC3_Pointer = itk::ImageFileWriter< itk::VectorImage< unsigned char,3 > >::Pointer;
using itkImageFileWriterVIULL3 = itk::ImageFileWriter< itk::VectorImage< unsigned long long,3 > >;
using itkImageFileWriterVIULL3_Pointer = itk::ImageFileWriter< itk::VectorImage< unsigned long long,3 > >::Pointer;
using itkImageFileWriterVIUS3 = itk::ImageFileWriter< itk::VectorImage< unsigned short,3 > >;
using itkImageFileWriterVIUS3_Pointer = itk::ImageFileWriter< itk::VectorImage< unsigned short,3 > >::Pointer;
using itkImageFileWriterVIF3 = itk::ImageFileWriter< itk::VectorImage< float,3 > >;
using itkImageFileWriterVIF3_Pointer = itk::ImageFileWriter< itk::VectorImage< float,3 > >::Pointer;
using itkImageFileWriterVID3 = itk::ImageFileWriter< itk::VectorImage< double,3 > >;
using itkImageFileWriterVID3_Pointer = itk::ImageFileWriter< itk::VectorImage< double,3 > >::Pointer;
using itkImageFileWriterVISC4 = itk::ImageFileWriter< itk::VectorImage< signed char,4 > >;
using itkImageFileWriterVISC4_Pointer = itk::ImageFileWriter< itk::VectorImage< signed char,4 > >::Pointer;
using itkImageFileWriterVISS4 = itk::ImageFileWriter< itk::VectorImage< signed short,4 > >;
using itkImageFileWriterVISS4_Pointer = itk::ImageFileWriter< itk::VectorImage< signed short,4 > >::Pointer;
using itkImageFileWriterVIUC4 = itk::ImageFileWriter< itk::VectorImage< unsigned char,4 > >;
using itkImageFileWriterVIUC4_Pointer = itk::ImageFileWriter< itk::VectorImage< unsigned char,4 > >::Pointer;
using itkImageFileWriterVIULL4 = itk::ImageFileWriter< itk::VectorImage< unsigned long long,4 > >;
using itkImageFileWriterVIULL4_Pointer = itk::ImageFileWriter< itk::VectorImage< unsigned long long,4 > >::Pointer;
using itkImageFileWriterVIUS4 = itk::ImageFileWriter< itk::VectorImage< unsigned short,4 > >;
using itkImageFileWriterVIUS4_Pointer = itk::ImageFileWriter< itk::VectorImage< unsigned short,4 > >::Pointer;
using itkImageFileWriterVIF4 = itk::ImageFileWriter< itk::VectorImage< float,4 > >;
using itkImageFileWriterVIF4_Pointer = itk::ImageFileWriter< itk::VectorImage< float,4 > >::Pointer;
using itkImageFileWriterVID4 = itk::ImageFileWriter< itk::VectorImage< double,4 > >;
using itkImageFileWriterVID4_Pointer = itk::ImageFileWriter< itk::VectorImage< double,4 > >::Pointer;
using itkImageFileWriterPA3DSCISC = itk::ImageFileWriter< itk::PhasedArray3DSpecialCoordinatesImage< signed char > >;
using itkImageFileWriterPA3DSCISC_Pointer = itk::ImageFileWriter< itk::PhasedArray3DSpecialCoordinatesImage< signed char > >::Pointer;
using itkImageFileWriterPA3DSCISS = itk::ImageFileWriter< itk::PhasedArray3DSpecialCoordinatesImage< signed short > >;
using itkImageFileWriterPA3DSCISS_Pointer = itk::ImageFileWriter< itk::PhasedArray3DSpecialCoordinatesImage< signed short > >::Pointer;
using itkImageFileWriterPA3DSCIUC = itk::ImageFileWriter< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char > >;
using itkImageFileWriterPA3DSCIUC_Pointer = itk::ImageFileWriter< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char > >::Pointer;
using itkImageFileWriterPA3DSCIULL = itk::ImageFileWriter< itk::PhasedArray3DSpecialCoordinatesImage< unsigned long long > >;
using itkImageFileWriterPA3DSCIULL_Pointer = itk::ImageFileWriter< itk::PhasedArray3DSpecialCoordinatesImage< unsigned long long > >::Pointer;
using itkImageFileWriterPA3DSCIUS = itk::ImageFileWriter< itk::PhasedArray3DSpecialCoordinatesImage< unsigned short > >;
using itkImageFileWriterPA3DSCIUS_Pointer = itk::ImageFileWriter< itk::PhasedArray3DSpecialCoordinatesImage< unsigned short > >::Pointer;
using itkImageFileWriterPA3DSCIF = itk::ImageFileWriter< itk::PhasedArray3DSpecialCoordinatesImage< float > >;
using itkImageFileWriterPA3DSCIF_Pointer = itk::ImageFileWriter< itk::PhasedArray3DSpecialCoordinatesImage< float > >::Pointer;
using itkImageFileWriterPA3DSCID = itk::ImageFileWriter< itk::PhasedArray3DSpecialCoordinatesImage< double > >;
using itkImageFileWriterPA3DSCID_Pointer = itk::ImageFileWriter< itk::PhasedArray3DSpecialCoordinatesImage< double > >::Pointer;


#include "itkPhasedArray3DSpecialCoordinatesImageSwigInterface.h"
#include "ITKCommonBaseSwigInterface.h"
#include "itkImageSwigInterface.h"
#include "itkImageFileWriterSwigInterface.h"
#include "itkVectorImageSwigInterface.h"
#include "ITKIOImageBaseBaseSwigInterface.h"
#endif
