/*
 * Copyright 2021 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, pdu, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_pdu_time_delta = R"doc(Compute system time differences and provide statistics upon completion.

This block computes the difference between the current system time and a defined PDU key previously added (e.g.: by by the add_system_time block). This is useful for benchmarking PDU operations. The block also maintains running estimates of mean and variance, accessible by getters and printed when the flowgraph is stopped.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of pdu::time_delta.

Args:
    delta_key : - key to use for time delta metadata field
    time_key : - key to use as reference time for delta)doc";


static const char* __doc_gr_pdu_time_delta_make = R"doc(Compute system time differences and provide statistics upon completion.

This block computes the difference between the current system time and a defined PDU key previously added (e.g.: by by the add_system_time block). This is useful for benchmarking PDU operations. The block also maintains running estimates of mean and variance, accessible by getters and printed when the flowgraph is stopped.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of pdu::time_delta.

Args:
    delta_key : - key to use for time delta metadata field
    time_key : - key to use as reference time for delta)doc";
