/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_short_to_char = R"doc(Convert stream of shorts to a stream of chars.

This block strips off the least significant byte from the short value.


[0x00ff, 0x0ff0, 0xff00] => [0x00, 0x0f, 0xff]


Converts  length vectors of input short samples to chars, dividing each element by 256.

Constructor Specific Documentation:

Build a short to char block.

Args:
    vlen : vector length of data streams.)doc";


static const char* __doc_gr_blocks_short_to_char_short_to_char = R"doc()doc";


static const char* __doc_gr_blocks_short_to_char_make = R"doc(Convert stream of shorts to a stream of chars.

This block strips off the least significant byte from the short value.


[0x00ff, 0x0ff0, 0xff00] => [0x00, 0x0f, 0xff]


Converts  length vectors of input short samples to chars, dividing each element by 256.

Constructor Specific Documentation:

Build a short to char block.

Args:
    vlen : vector length of data streams.)doc";
